<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C)2005-2015 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Application\Application;
use CB\Database\Table\UserTable;
use CB\Database\Table\TabTable;
use CB\Plugin\ProfileBook\Table\EntryTable;
use CBLib\Language\CBTxt;
use CBLib\Registry\GetterInterface;
use CB\Plugin\ProfileBook\CBProfileBook;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var UserTable  $viewer
 * @var TabTable   $tab
 * @var EntryTable $row
 */

global $_CB_framework, $_PLUGINS;

initToolTip();

$integrations			=	implode( '', $_PLUGINS->trigger( 'pb_onViewBlog', array( &$row, $viewer, $tab ) ) );
$cbUser					=	CBuser::getInstance( $row->get( 'posterid', 0, GetterInterface::INT ), false );
$menu					=	null;

if ( ( $viewer->get( 'id', 0, GetterInterface::INT ) && ( $viewer->get( 'id', 0, GetterInterface::INT ) == $row->get( 'userid', 0, GetterInterface::INT ) ) ) || Application::MyUser()->isGlobalModerator() ) {
	$menuItems			=	'<ul class="list-unstyled dropdown-menu d-block position-relative m-0 pbBlogMenuItems">'
						.		'<li class="pbBlogMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'entry', 'func' => 'edit', 'id' => $row->get( 'id', 0, GetterInterface::INT ) ) ) . '" class="dropdown-item"><span class="fa fa-edit"></span> ' . CBTxt::T( 'Edit' ) . '</a></li>';

	if ( $row->get( 'published' ) == 1 ) {
		$menuItems		.=		'<li class="pbBlogMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to unpublish this blog?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'entry', 'func' => 'unpublish', 'id' => $row->get( 'id', 0, GetterInterface::INT ) ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-times-circle"></span> ' . CBTxt::T( 'Unpublish' ) . '</a></li>';
	} else {
		$menuItems		.=		'<li class="pbBlogMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'entry', 'func' => 'publish', 'id' => $row->get( 'id', 0, GetterInterface::INT ) ) ) . '" class="dropdown-item"><span class="fa fa-check"></span> ' . CBTxt::T( 'Publish' ) . '</a></li>';
	}

	$menuItems			.=		'<li class="pbBlogMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to delete this blog?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'entry', 'func' => 'delete', 'id' => $row->get( 'id', 0, GetterInterface::INT ) ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-trash-o"></span> ' . CBTxt::T( 'Delete' ) . '</a></li>'
						.	'</ul>';

	$menu				=	cbTooltip( null, $menuItems, null, 'auto', null, '<span class="pt-1 pb-1 pl-3 pr-3 text-large fa fa-ellipsis-v"></span>', 'javascript:void(0);', 'class="text-body cbDropdownMenu pbBlogMenuToggle" data-cbtooltip-menu="true" data-cbtooltip-classes="qtip-nostyle" data-cbtooltip-open-classes="active"' );
}
?>
<div class="pbBlog">
	<div class="mb-3 pbBlogHeader">
		<div class="text-center text-large pbBlogTitle">
			<strong><?php echo $row->get( 'postertitle', null, GetterInterface::STRING ); ?></strong>
			<?php if ( $menu ) { ?>
			<div class="float-right pbBlogTitleMenu">
				<?php echo $menu; ?>
			</div>
			<?php } ?>
		</div>
		<div class="text-center text-small text-muted pbBlogDate">
			<?php echo CBuser::getInstance( $row->get( 'userid', 0, GetterInterface::INT ), false )->getField( 'formatname', null, 'html', 'none', 'list', 0, true ); ?>
			-
			<?php echo cbFormatDate( $row->get( 'date', null, GetterInterface::STRING ), true, false, CBTxt::T( 'PROFILEBLOG_DATE_FORMAT', 'M j, Y' ) ); ?>
			<?php if ( $row->get( 'editdate', null, GetterInterface::STRING ) && ( $row->get( 'editdate', null, GetterInterface::STRING ) != '0000-00-00 00:00:00' ) ) { ?>
				<span class="fa fa-edit pbBlogNewEdited" title="<?php echo htmlspecialchars( cbFormatDate( $row->get( 'editdate', null, GetterInterface::STRING ) ) ); ?>"></span>
			<?php } ?>
		</div>
	</div>
	<div class="pbBlogBody">
		<?php echo CBProfileBook::parseMessage( $row->get( 'postercomment', null, GetterInterface::HTML ), $tab ); ?>
	</div>
	<?php if ( $integrations ) { ?>
	<div class="border-top bg-light p-2 mt-3 pbBlogIntegrations">
		<?php echo $integrations; ?>
	</div>
	<?php } ?>
</div>