<?php
/**
 * Community Builder (TM)
 * @version $Id: $
 * @package CommunityBuilder
 * @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
 * @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
 */

use CBLib\Core\AutoLoader;

defined( 'CBLIB') or die();

global $_CB_framework, $_PLUGINS;

AutoLoader::registerExactMap( '%^CB/Plugin/Query/(.+)%i', __DIR__ . '/library/$1.php' );

$_CB_framework->addJQueryPlugin( 'cbqueryautocomplete', '/components/com_comprofiler/plugin/user/plug_cbqueryfield/js/jquery.cbqueryautocomplete.js', [ -1 => [ 'ui-all' ] ] );

$_PLUGINS->registerFunction( 'onBeforefieldClass', 'getResponse', '\CB\Plugin\Query\Trigger\FieldTrigger' );
$_PLUGINS->registerFunction( 'onBeforegetFieldRow', 'getDisplay', '\CB\Plugin\Query\Trigger\FieldTrigger' );
$_PLUGINS->registerFunction( 'onBeforeprepareFieldDataSave', 'checkValidation', '\CB\Plugin\Query\Trigger\FieldTrigger' );

$_PLUGINS->registerUserFieldParams();
$_PLUGINS->registerUserFieldTypes( [	'query'					=>	'\CB\Plugin\Query\Field\QueryField',
										'querymulticheckbox'	=>	'\CB\Plugin\Query\Field\QuerySelectField',
										'querymultiselect'		=>	'\CB\Plugin\Query\Field\QuerySelectField',
										'queryselect'			=>	'\CB\Plugin\Query\Field\QuerySelectField',
										'queryradio'			=>	'\CB\Plugin\Query\Field\QuerySelectField',
										'querytag'				=>	'\CB\Plugin\Query\Field\QuerySelectField'
									]);