<?php
/**
 * Community Builder (TM)
 * @version $Id: $
 * @package CommunityBuilder
 * @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
 * @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
 */

use CB\Database\Table\UserTable;
use CB\Database\Table\FieldTable;
use CBLib\Language\CBTxt;
use CB\Plugin\FieldGroups\CBFieldGroups;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var array        $fieldGroups
 * @var string       $fieldName
 * @var string       $repeatLabel
 * @var bool         $repeatOrdering
 * @var bool         $repeatCount
 * @var int          $repeatMax
 * @var array        $rows
 * @var int          $row
 * @var array        $titles
 * @var array        $descriptions
 * @var array        $fields
 * @var FieldTable[] $groupedFields
 *
 * @var FieldTable   $field
 * @var UserTable    $user
 * @var string       $output
 * @var string       $reason
 * @var int          $list_compare_types
 */
?>
<tr class="cbRepeatRow">
	<?php if ( $repeatOrdering ) { ?>
	<td class="align-middle text-center text-nowrap" style="width: 1%;">
		<span class="cbRepeatRowSort">
			<span class="cbRepeatRowMove" title="<?php echo htmlspecialchars( CBTxt::T( 'Click and drag to move this row.' ) ); ?>"><span class="fa fa-sort"></span></span>
		</span>
		<span class="cbRepeatRowIndex"></span>
		<input type="hidden" name="<?php echo CBFieldGroups::getGroupedName( $fieldName, $row, 'index' ); ?>" value="<?php echo (int) $row; ?>" />
	</td>
	<?php } else { ?>
	<td class="align-middle text-center cbRepeatRowIndex" style="width: 1%;"></td>
	<?php } ?>
	<td class="cbRepeatRowParams">
		<?php echo implode( '</td><td class="cbRepeatRowParams">', $fields ); ?>
	</td>
	<td class="align-middle text-center cbRepeatRowIncrement">
		<div class="btn btn-sm btn-danger d-block d-sm-inline-block cbRepeatRowRemove" title="<?php echo htmlspecialchars( CBTxt::T( 'Click to remove this row.' ) ); ?>"><span class="fa fa-minus"></span></div>
	</td>
</tr>