<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */
namespace OSSolution\HelpdeskPro\Admin\Model;

use OSL\Model\ListModel;

defined('_JEXEC') or die;

class Articles extends ListModel
{
	/**
	 * Initialize the model, add new states
	 */
	protected function initialize()
	{
		$this->state->insert('filter_category_id', 'int', 0);
	}

	/**
	 * Build the query object which is used to get list of records from database
	 *
	 * @return \JDatabaseQuery
	 */
	protected function buildListQuery()
	{
		$query = parent::buildListQuery();

		$query->select('b.title AS category_title')
			->leftJoin('#__helpdeskpro_categories AS b ON tbl.category_id = b.id');

		if ($this->state->filter_category_id)
		{
			$query->where('tbl.category_id = ' . (int) $this->state->filter_category_id);
		}

		return $query;
	}
}