<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Admin\View\Language;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use OSL\View\HtmlView;

defined('_JEXEC') or die;

class Html extends HtmlView
{

	protected function beforeRender()
	{
		/* @var \Ossolution\Helpdeskpro\Admin\Model\Language $model */
		$model = $this->getModel();
		$state = $model->getState();
		$trans = $model->getTrans();

		$languages = $model->getSiteLanguages();

		$options   = [];
		$options[] = HTMLHelper::_('select.option', '', Text::_('Select Language'));

		foreach ($languages as $language)
		{
			$options[] = HTMLHelper::_('select.option', $language, $language);
		}

		$lists['filter_language'] = HTMLHelper::_('select.genericlist', $options, 'filter_language', ' class="form-select"  onchange="submit();"', 'value', 'text', $state->filter_language);

		$this->trans = $trans;
		$this->lists = $lists;
		$this->lang  = $state->filter_language;
		$this->item  = 'com_helpdeskpro';
	}
}