<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Router\Route;

$imageFileTypes = array('gif', 'jpg', 'jpeg', 'png', 'csv', 'bmp', 'txt');
$attachmentsPath = JPATH_ROOT . '/media/com_helpdeskpro/attachments';
?>
<div class="hdp_ticket_description-body">
	<?php
	if ($config->process_bb_code)
	{
		echo HelpdeskproHelper::processBBCode($item->message);
	}
	else
	{
		if ($config->use_html_editor)
		{
			echo $item->message;
		}
		else
		{
			echo nl2br($item->message);
		}
	}
	if ($item->attachments)
	{
		$originalFileNames = explode('|', $item->original_filenames);
		$attachments = explode('|', $item->attachments);;
		?>
		<div class="hdp_ticket_description-file">
			<ul>
				<?php
				$i = 0 ;
				foreach($originalFileNames as $fileName)
				{
					$actualFileName = $attachments[$i++];

					if (!file_exists($attachmentsPath . '/' . $actualFileName))
					{
						continue;
					}

					$icon = substr($fileName, strrpos($fileName, '.') + 1);
					$icon = strtolower($icon);

					if (!file_exists(JPATH_SITE."/media/com_helpdeskpro/assets/images/icons/$icon.png"))
					{
						$icon="default";
					}

					if (in_array($icon, $imageFileTypes))
					{
					?>
						<li><a class="hdp-modal" href="<?php echo Route::_('index.php?option=com_helpdeskpro&task=ticket.download_attachment&filename='.$actualFileName.'&original_filename='.$fileName); ?>"><img height="16" width="16" src="<?php echo $rootUri . "/media/com_helpdeskpro/assets/images/icons/$icon.png"; ?>" ><?php echo $fileName ?></a></li>
					<?php
					}
					else
					{
					?>
						<li><a href="<?php echo Route::_('index.php?option=com_helpdeskpro&task=ticket.download_attachment&filename='.$actualFileName.'&original_filename='.$fileName); ?>"><img height="16" width="16" src="<?php echo $rootUri . "/media/com_helpdeskpro/assets/images/icons/$icon.png"; ?>" ><?php echo $fileName ?></a></li>
					<?php
					}
				}
				?>
			</ul>
		</div>
		<?php
	}
	?>
</div>
