<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

class CurrenciesControllerCurrency extends CurrenciesController
{

	function __construct()
	{
		parent::__construct();

		// Register Extra tasks
		$this->registerTask( 'add'  , 	'edit' );
		$this->registerTask( 'apply',	'save' );
	}

	function edit()
	{
		$this->input->set( 'view', 'currency' );
		$this->input->set( 'layout', 'form'  );
		$this->input->set('hidemainmenu', 1);

		parent::display();
	}

	function save()
	{
		$model = $this->getModel('currency');

		if ($model->store($post)) {
			$msg = JText::_( 'CURRENCY_SAVED' );
		} else {
			$msg = JText::_( 'ERROR_SAVING_CURRENCY' );
		}

		$task = $this->input->getCmd( 'task' );
		$id = $this->input->getInt('id');

		switch ($task)
		{
			case 'apply':
				$link = 'index.php?option=com_invoices&controller=currency&task=edit&cid[]='. $id ;
				break;

			case 'save':
			default:
				$link = 'index.php?option=com_invoices&controller=currencies';
				break;
		}

		$this->setRedirect($link, $msg);
	}

	function remove()
	{
		//this function is called only from the album form template
		$album_id = $this->input->getVar('id');

		$model = $this->getModel('currency');

		if(!$model->delete()) {
			$msg = JText::_( 'ERROR_DELETING_CURRENCY' );
		} else {
			$msg = JText::_( 'CURRENCY_DELETED' );
		}

		$this->setRedirect( 'index.php?option=com_invoices&controller=currencies', $msg );
	}

	function cancel()
	{
		$msg = JText::_( 'OPERATION_CANCELLED' );
		$this->setRedirect( 'index.php?option=com_invoices&controller=currencies', $msg );
	}

	function publish()
	{
		$model = $this->getModel('currency');
		if(!$model->publish()) {
			$msg = JText::_( 'ERROR_PUBLISHING_CURRENCY' );
		} else {
			$msg = JText::_( 'CURRENCY_PUBLISHED' );
		}

		$this->setRedirect( 'index.php?option=com_invoices&controller=currencies', $msg );
	}

	function unpublish()
	{
		$model = $this->getModel('currency');
		if(!$model->unpublish()) {
			$msg = JText::_( 'ERROR_UNPUBLISHING_CURRENCY' );
		} else {
			$msg = JText::_( 'CURRENCY_UNPUBLISHED' );
		}

		$this->setRedirect( 'index.php?option=com_invoices&controller=currencies', $msg );
	}

}
