<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

jimport( 'joomla.application.component.view');
jimport( 'joomla.html.html');

class InvoicesViewInvoice extends JViewLegacy
{
	function display($tpl = null)
	{
		require_once(JPATH_SITE.DS.'components'.DS.'com_invoices'.DS.'helpers'.DS.'dompdf'.DS.'dompdf_config.inc.php');
		
		if(file_exists(JPATH_SITE.DS.'libraries'.DS.'joomla'.DS.'html'.DS.'html.php')) require_once(JPATH_SITE.DS.'libraries'.DS.'joomla'.DS.'html'.DS.'html.php');
		elseif(file_exists(JPATH_SITE.DS.'libraries'.DS.'cms'.DS.'html'.DS.'html.php')) require_once(JPATH_SITE.DS.'libraries'.DS.'cms'.DS.'html'.DS.'html.php');
		
		if(file_exists(JPATH_SITE.DS.'libraries'.DS.'joomla'.DS.'date'.DS.'date.php')) require_once(JPATH_SITE.DS.'libraries'.DS.'joomla'.DS.'date'.DS.'date.php');
		elseif(file_exists(JPATH_SITE.DS.'libraries'.DS.'cms'.DS.'html'.DS.'date.php')) require_once(JPATH_SITE.DS.'libraries'.DS.'cms'.DS.'html'.DS.'date.php');
		
		$mainframe = JFactory::getApplication();
		
		
		$document	= JFactory::getDocument();
		$uri	= JFactory::getURI();
		
		$invoice		= $this->get( 'Data');
		$template		= $this->get( 'Template');
		$items		= $this->get( 'Items');
		$taxes		= $this->get( 'TaxesInvoice');
		$payments		= $this->get( 'PaymentsInvoice');
		$payments2		= $this->get( 'PaymentsInvoice2');
		
		$params = JComponentHelper::getParams( 'com_invoices' );
		
		if($template->content_pdf) $template->content = $template->content_pdf ;
		
		$this->assignRef('invoice',		$invoice);
		$this->assignRef('template',		$template);
		$this->assignRef('items',		$items);
		$this->assignRef('taxes',		$taxes);
		$this->assignRef('payments',		$payments);
		$this->assignRef('payments2',		$payments2);
		
		$this->assignRef('params',		$params);
		
		$plantilla = 'email' ;
		
		$html = $this->loadTemplate($plantilla);
		
		$search = array("€", "¢", "£", "¤", "¥");
		$replace = array("&euro;", "&cent;", "&pound;", "&curren;", "&yen;");
		
		$html = str_replace($search, $replace, $html);
		
		$html = mb_convert_encoding($html, 'HTML-ENTITIES', 'UTF-8');
		
		$html = utf8_decode($html);
		
		$html = '<!DOCTYPE HTML>
				<html>
				<head>
				<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
				<style>
				'.$template->styles.'
				</style>
				</head>
				<body>' 
				. $html .
				'</body></html>';
		
		$dompdf = new DOMPDF();
		$dompdf->load_html($html);
		$dompdf->render();
		$dompdf->stream($invoice->invoice_num . ".pdf");	
		
		exit();
	}

	function storepdf($location)
	{
		require_once(JPATH_SITE.DS.'components'.DS.'com_invoices'.DS.'helpers'.DS.'dompdf'.DS.'dompdf_config.inc.php');
		
		if(file_exists(JPATH_SITE.DS.'libraries'.DS.'joomla'.DS.'html'.DS.'html.php')) require_once(JPATH_SITE.DS.'libraries'.DS.'joomla'.DS.'html'.DS.'html.php');
		elseif(file_exists(JPATH_SITE.DS.'libraries'.DS.'cms'.DS.'html'.DS.'html.php')) require_once(JPATH_SITE.DS.'libraries'.DS.'cms'.DS.'html'.DS.'html.php');
		
		if(file_exists(JPATH_SITE.DS.'libraries'.DS.'joomla'.DS.'date'.DS.'date.php')) require_once(JPATH_SITE.DS.'libraries'.DS.'joomla'.DS.'date'.DS.'date.php');
		elseif(file_exists(JPATH_SITE.DS.'libraries'.DS.'cms'.DS.'html'.DS.'date.php')) require_once(JPATH_SITE.DS.'libraries'.DS.'cms'.DS.'html'.DS.'date.php');
		
		$mainframe = JFactory::getApplication();
		
		$plantilla = 'email' ;
		
		$html = $this->loadTemplate($plantilla);
		
		$search = array("€", "¢", "£", "¤", "¥");
		$replace = array("&euro;", "&cent;", "&pound;", "&curren;", "&yen;");
		
		$html = str_replace($search, $replace, $html);
		
		$html = mb_convert_encoding($html, 'HTML-ENTITIES', 'UTF-8');
		
		$html = utf8_decode($html);
		
		$html = '<!DOCTYPE HTML>
				<html>
				<head>
				<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
				<style>
				'.$this->template->styles.'
				</style>
				</head>
				<body>' 
				. $html .
				'</body></html>';
		
		$dompdf = new DOMPDF();
		$dompdf->load_html($html);
		$dompdf->render();

		$pdf = $dompdf->output();

		return file_put_contents($location, $pdf);
	}
	
}
?>
