/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				Lmskaran 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.77
	@build			6th April, 2022
	@created		22nd July, 2020
	@package		Moojla
	@subpackage		coursedetail.js
	@author			Lmskaran <http://Lmskaran.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

/* JS Document */

/***[JCBGUI.site_view.javascript_file.38.$$$$]***/
var token = 0;
jQuery(document).ready(function($){

  token= Joomla.getOptions('token');
  var rate= Joomla.getOptions('rate');

  if (rate.length)
  {
    $.each($('.rate'), function (index, value){
      var _this= $(this)
      var remoteid= _this.data('id');

      rate.find(function (item){
        if (remoteid== item.courseid)
          _this.find(':radio[value='+item.rate+']').prop('checked', true);
      });

    });
  }

  $(document).on('click', '.rate :radio', function (e){
    var rate= $(this).val();
    var courseid= $(this).parent('div.rate').data('id');

    $.ajax({
      url: 'index.php?option=com_moojla',
      method: 'post',
      dataType: 'json',
      data:{[token]:1, format: 'json', raw: true, task: 'ajax.rate', courseid: courseid, rate:rate},
      success: function (msg) {
      },
      error: function (msg) {
        console.log(msg);
      }
    });
  });



  var videoAttr = {'loop': true, 'playsinline': true, class: 'renderedvideo'};
  var imgMP4s = Array.prototype.map.call(
    $('img[src*=".mp4"]'),
    function(img){
      var src = img.src;
      img.src = null;

      img.addEventListener('error', function(e){
        // console.log('MP4 in image not supported. Replacing with video', e); 
        var video = document.createElement('video');

        for (var key in videoAttr) { video.setAttribute(key, videoAttr[key]); }

        for (
          var imgAttr = img.attributes, 
          len = imgAttr.length,
          i = 0; 
          i < len; 
          i++
        ) { 
          video.setAttribute(imgAttr[i].name,  imgAttr[i].value); 
        }
        // img.parentNode.insertAdjacentHTML('beforeend', '<div class="lmskaran_dark_video_before_hover"></div>');

        img.parentNode.insertAdjacentHTML('beforeend', '<div id="overlay"><div class="play-video video-launch video-play-button" ><span></span></div></div>');
        img.parentNode.insertBefore(video, img);
        img.parentNode.removeChild(img);
        video.muted = 'muted';
        modalbody = $('.modal-body');
        modalbody.html('');
        video = $("video.renderedvideo");
        videocloned = video.clone();
        videocloned.appendTo(modalbody);
        videocloned.attr('id', 'modalvideobody')
        videocloned = document.getElementById('modalvideobody');
        videocloned.muted = false;
        videocloned.controls = true;
        video.wrap("<a href='#' id='lmskaran_modal_video_course' data-toggle='modal' data-target='#video-modal'></a>");
        video.on("mouseover", function(event) {
          this.play();
          $("#overlay").hide();
        }).on('mouseout', function(event) {
          this.pause();
          $("#overlay").show();
        });

        var overlay = document.getElementById('overlay');


      });

      img.src = src;
    });


  window.onclick = function(event){
    target = event.target;
    cList = target.classList;

    if(cList.contains('modal-backdrop') || cList.contains('close-video')) {
      modalback = document.getElementsByClassName('modal-backdrop')[0];
      modalback.hidden = true;
    }
    else if(cList.contains('moojla-login-modal') ){
      moojlamodal = document.getElementById('moojla-modal')
      moojlamodal.setAttribute('style', 'display:"none";')
    }
  }


})

function viewActivity(userid, moduleid){
  jQuery.ajax({
    url: 'index.php?option=com_moojla',
    method: 'post',
    dataType: 'json',
    data:{[token]:1, format: 'json', raw: true, task: 'ajax.viewActivity', userid: userid, moduleid: moduleid},
    success: function (msg) {
      //console.log(msg);
    },
    error: function (msg) {
      console.log(msg);
    }
  });
}/***[/JCBGUI$$$$]***/
