<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				Lmskaran 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.77
	@build			6th April, 2022
	@created		22nd July, 2020
	@package		Moojla
	@subpackage		default.php
	@author			Lmskaran <http://Lmskaran.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('JPATH_BASE') or die('Restricted access');



?>
<!--[JCBGUI.layout.layout.3.$$$$]-->
<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" integrity="sha384-wvfXpqpZZVQGK6TAh5PVlGOfQNHSoD2xbE+QkPxCAFlNEevoEH3Sl0sibVcOQVnN" crossorigin="anonymous">
<?php ?>
<div class="container">
  <header>
    <!-- این دایو برای مستطیل نوک مدادی هست -->
    <div id="header-landscape">
      <!-- تمام متن ها در این دایو قرار میگیره -->
      <div id="header-text-course">
        <!-- عنوان درس -->
        <div id="title">
          <h1><?php echo $displayData->fullname; ?></h1>
        </div>
        <!-- ستاره های درس -->
        <div id="star">
          <span id="icont-star-1" class="icon-star"></span>
          <span id="icont-star-2" class="icon-star"></span>
          <span id="icont-star-3" class="icon-star"></span>
          <span id="icont-star-4" class="icon-star"></span>
          <span id="icont-star-5" class="icon-star"></span>
        </div>
        <!-- توضیحات مختصر درس -->
        <div id="header-Description">
          <p class="header-Description-p"><?php echo $displayData->summary; ?></p>
        </div>
      </div>
    </div>
  </header>
  <nav>
    <div id="box-course" class="box-width-course">
      <div id="details-course">
        <img class="image-course" src="<?php echo $displayData->summary_files; ?>" alt="image">
        <div id="course-button">
          <?php echo $displayData->htmlButton;?>
        </div>
        <div id="details">
          <hr class="line-style">
          <div id="details-Description">
            <span class="list-Description list"><i class="fas fa-list"></i>تعداد مراحل:</span>
            <span class="list-Description file"><i class="far fa-file"></i>تعداد فایل:</span>
            <span class="list-Description all-list"><i class="far fa-list-alt"></i>صدور گواهی نامه:</span>
            <span class="list-Description certificate"><i class="fas fa-certificate"></i>مهلت دسترسی:</span>
            <span class="list-Description phone"><i class="fas fa-mobile"></i>قابل دسترس در:</span>
            <span class="list-Description globe"><i class="fas fa-globe"></i>مرورگر توصیه شده:</span>
          </div>
        </div>
      </div>
    </div>
    <!-- ------------------------------------------------------------------------------------------------------------------------ -->
    <?php foreach($displayData->teachersFromMoodle as $teacher): ?>
      <?php
        try{
          $date = new DateTime($teacher->firstaccess);
        }
        catch (Exception $e) {
          $date = new DateTime(date('m/d/Y H:i:s', $teacher->firstaccess));
        }
        
        $interval = $date->diff(new DateTime());
        
        $firstaccess_date = "";
        if (($interval->y) && ($interval->m))
        echo $date->diff(new DateTime())->format("%y سال و %m ماه");

        elseif (($interval->y) && ($interval->m == 0))
          $firstaccess_date = $date->diff(new DateTime())->format("%y سال");

        elseif (($interval->m) && ($interval->d))
          $firstaccess_date = $date->diff(new DateTime())->format("%m ماه و %d روز");

        elseif (($interval->m) && ($interval->d == 0))
          $firstaccess_date = $date->diff(new DateTime())->format("%m ماه");

        elseif (($interval->d) && ($interval->h))
          $firstaccess_date = $date->diff(new DateTime())->format("%d روز و %h ساعت");

        elseif (($interval->d) && ($interval->h == 0))
          $firstaccess_date = $date->diff(new DateTime())->format("%d روز");

        elseif (($interval->h) && ($interval->i))
          $firstaccess_date = $date->diff(new DateTime())->format("%h ساعت و %i دقیقه");

        elseif (($interval->h) && ($interval->i == 0))
          $firstaccess_date = $date->diff(new DateTime())->format("%h ساعت");

        elseif ($interval->i)
          $firstaccess_date = $date->diff(new DateTime())->format("%i دقیقه");

        else
          $firstaccess_date = "جدید";
      ?>
      <div id="box-course-techear" class="box-width-course">
        <div id="tiket"><i class="fas fa-birthday-cake"></i><span><?php echo $firstaccess_date; ?></span></div>
        <div class="img-course"><img src="<?php echo $teacher->profileimageurl; ?>" alt="image"></div>
        <h1 id="title-course"><?php echo $teacher->fullname; ?></h1>
        <div id="all">
          <div class="faaliat"><span>فعالیت مدرس</span></div>
          <div id="modares">
            <div id="sidebar-film"><span>تعداد دوره ها</span></div>
            <div id="sidebar-star"><span>میانگین امتیاز ها</span></div>
            <div id="sidebar-message"><span>تماس با کاربران</span></div>
          </div>
          <div id="number-Description">
            <div><span id="number-course">11</span></div>
            <div><span id="number-techear">33,4</span></div>
            <div><span id="number-message">387 نظر</span></div>
          </div>
          <div id="content">
            <span>381,156 دانشجو</span>
          </div>
        </div>
        <div class="faaliat spacing-faaliat"><span>درباره مدرس</span></div>
        <div id="social">
          <a href="https://daneh.ir/"><i class="fab fa-linkedin"></i></a>
          <a href="https://daneh.ir/"><i class="fas fa-envelope"></i></a>
          <a href="https://daneh.ir/"><i class="fab fa-twitter"></i></a>
          <a href="https://daneh.ir/"><i class="fab fa-facebook-f"></i></a>
        </div>
      </div>
    <?php endforeach; ?>
  </nav>
  <main>
    <div class="accordi">
      <?php if(is_array($displayData->sections)): ?>
      <?php foreach ($displayData->sections as $section_key => $section_value): ?>
      <button class="accordion"><?php echo $section_value->name; ?></button>
      <div class="panel">
        <p><?php echo $section_value->summary; ?></p>
        
        <?php foreach ($section_value->modules as $module_key => $module_value): ?>
        <p><?php echo '<img src="'.$module_value->modicon.'" > '; ?> 
          <?php echo $module_value->name; ?>
        </p>
        <?php endforeach; ?>
        
      </div>
      <?php endforeach; ?>
      <?php endif; ?>
    </div>
  </main>
  <footer>
    <div><span>پشتیبانی و پاسخگویی به سوالات:</span><span class="color-footer-text"> ۰٩١٩۴١۰٨۴٣٣</span></div>
    <div>ارائه شده توسط <a class="color-footer-text" href="https://lmskaran.com">تیم lmskaran</a></div>
    <div>© <?php echo date("Y"); ?> Lmskaran</div>
  </footer>
</div>
<script>
  //accordion
  var acc = document.getElementsByClassName("accordion");
  var i;

  for (i = 0; i < acc.length; i++) {
    acc[i].addEventListener("click", function() {
      this.classList.toggle("active");
      var panel = this.nextElementSibling;
      if (panel.style.display === "block") {
        panel.style.display = "none";
      } else {
        panel.style.display = "block";
      }
    });
  }
</script>
