<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				Lmskaran 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.77
	@build			6th April, 2022
	@created		22nd July, 2020
	@package		Moojla
	@subpackage		default_video_modal.php
	@author			Lmskaran <http://Lmskaran.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

?>

<!--[JCBGUI.template.template.15.$$$$]-->
<div class="container">
  <!-- Modal -->
  <div class="modal fade" id="video-modal" role="dialog">
    <div class="modal-dialog">
      <!-- Modal content-->
      <div class="modal-content">
        <div class="modal-body">
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-default close-video" onclick="pauseAudio()" data-dismiss="modal">بستن ویدیو</button>
        </div>
      </div>
    </div>
  </div>  
</div>

<script>
  jQuery(document).ready(function ($)
  {
    var videoAttr = {'loop': true, 'playsinline': true, class: 'renderedvideo'};
    var imgMP4s = Array.prototype.map.call(
    $('img[src*=".mp4"]'),
    function(img){
      var src = img.src;
      img.src = null;

      img.addEventListener('error', function(e){
        // console.log('MP4 in image not supported. Replacing with video', e); 
        var video = document.createElement('video');

        for (var key in videoAttr) { video.setAttribute(key, videoAttr[key]); }

        for (
            var imgAttr = img.attributes, 
            len = imgAttr.length,
            i = 0; 
            i < len; 
            i++
        ) { 
            video.setAttribute(imgAttr[i].name,  imgAttr[i].value); 
        }
        // img.parentNode.insertAdjacentHTML('beforeend', '<div class="lmskaran_dark_video_before_hover"></div>');
      
        img.parentNode.insertAdjacentHTML('beforeend', '<div id="overlay"><div class="play-video video-launch video-play-button" ><span></span></div></div>');
        img.parentNode.insertBefore(video, img);
        img.parentNode.removeChild(img);
        video.muted = 'muted';
        modalbody = $('.modal-body');
        modalbody.html('');
        video = $("video.renderedvideo");
        videocloned = video.clone();
        videocloned.appendTo(modalbody);
        videocloned.attr('id', 'modalvideobody')
        videocloned = document.getElementById('modalvideobody');
        videocloned.muted = false;
        videocloned.controls = true;
        video.wrap("<a href='#' id='lmskaran_modal_video_course' data-toggle='modal' data-target='#video-modal'></a>");
        video.on("mouseover", function(event) {
          this.play();
          $("#overlay").hide();
        }).on('mouseout', function(event) {
          this.pause();
          $("#overlay").show();
        });
        var overlay = document.getElementById('overlay');
      });

      img.src = src;
    });
      
      
    window.onclick = function(event) {
      target = event.target;
      cList = target.classList;
      
      if(cList.contains('modal-backdrop') || cList.contains('close-video')) {
        modalback = document.getElementsByClassName('modal-backdrop')[0];
        modalback.hidden = true;
      }
      else if(cList.contains('moojla-login-modal') ){
        moojlamodal = document.getElementById('moojla-modal')
        moojlamodal.setAttribute('style', 'display:"none";')
      }
    }
  });

  function pauseAudio() { 
    videocloned.pause();
    body = jQuery('body');
    body.removeClass('modal-open');
  } 

</script>
<style>

#lmskaran_modal_video_course{
	width: 100%;
    height: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
}

#lmskaran_modal_video_course video{
	width:100%;
	height:100%;
	filter: brightness(0.4);
	transition: 0.5s;
}

#lmskaran_modal_video_course:hover video{
	filter: brightness(1);
}


#overlay {
  position: absolute; 
  color: #FFF; 
  text-align: center;
  font-size: 20px;
  width: inherit;
  padding: 10px 0;
  z-index: 2;
}

video.renderedvideo {
  z-index: 1;
}

div.modal {
	background: none;
	border: none;
	box-shadow: none;
	-webkit-box-shadow: none;
}

#modalvideobody {
	width: 100%;
	/* height: fit-content; */
	margin: 0 auto;
}


div.modal{
	left:0;
	width:100%;
	margin-left:unset;
}


.modal-dialog {
    max-width: 1000px;
}


div.modal.fade.in {
    padding-top:5%;
	top:0px;
}



.modal-footer {
    display: flex;
    justify-content: flex-start;
    align-items: center;
	
}


.modal-footer button.btn.btn-default.close-video {
    padding: 10px 20px;
    font-size: 1.1rem;
    background: linear-gradient( 45deg, red, #810000);
    color: white;
	margin: unset;
}


.video-play-button {
	position: relative;
	z-index: 10;
	box-sizing: content-box;
	display: block;
	width: 32px;
	height: 44px;
	margin: 40px auto 20px auto;
	border-radius: 50%;
	box-shadow: 0 0px 30px rgba(22 8 91 / 42%);
	border: 1px solid black;
}

  .video-play-button:before {
    content: "";
    position: absolute;
    z-index: 0;
    left: 50%;
    top: 50%;
    transform: translateX(-50%) translateY(-50%);
    display: block;
    width: 80px;
    height: 80px;
    background: white;
    border-radius: 50%;
    animation: pulse-border 1500ms ease-out infinite;
  }
  
  .video-play-button:after {
    content: "";
    position: absolute;
    z-index: 1;
    left: 50%;
    top: 50%;
    transform: translateX(-50%) translateY(-50%);
    display: block;
    width: 80px;
    height: 80px;
    background: white;
    border-radius: 50%;
    transition: all 200ms;
    transition: all 0.55s cubic-bezier(0.645, 0.045, 0.355, 1);
  }
  

    .video-play-button:after {
      background: white;
      transition: all 0.55s cubic-bezier(0.645, 0.045, 0.355, 1);
    }
	
    .video-play-button span {
      border-left: 32px solid white;
    }
  
  .video-play-button img {
    position: relative;
    z-index: 3;
    max-width: 100%;
    width: auto;
    height: auto;
  }
  
  .video-play-button span {
    display: block;
    position: relative;
	left: 3px;
    z-index: 3;
    width: 0;
    height: 0;
    transform: scale(0.8);
    border-left: 32px solid black;
    border-top: 22px solid transparent;
    border-bottom: 22px solid transparent;
    transition: all 0.55s cubic-bezier(0.645, 0.045, 0.355, 1);
  }
  
@keyframes pulse-border {
  0% {
    transform: translateX(-50%) translateY(-50%) translateZ(0) scale(1);
    opacity: 1;
  }

  100% {
    transform: translateX(-50%) translateY(-50%) translateZ(0) scale(1.5);
    opacity: 0;
  }
}

</style>
<!--[/JCBGUI$$$$]-->

