<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				Lmskaran 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.77
	@build			6th April, 2022
	@created		22nd July, 2020
	@package		Moojla
	@subpackage		default.php
	@author			Lmskaran <http://Lmskaran.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.formvalidation');
JHtml::_('formbehavior.chosen', 'select');
JHtml::_('behavior.keepalive');
?>
<?php if ($this->canDo->get('healthcheck.access')): ?>
<script type="text/javascript">
	Joomla.submitbutton = function(task) {
		if (task === 'healthcheck.back') {
			parent.history.back();
			return false;
		} else {
			var form = document.getElementById('adminForm');
			form.task.value = task;
			form.submit();
		}
	}
</script>
<?php $urlId = (isset($this->item->id)) ? '&id='. (int) $this->item->id : ''; ?>
<form action="<?php echo JRoute::_('index.php?option=com_moojla&view=healthcheck' . $urlId); ?>" method="post" name="adminForm" id="adminForm" class="form-validate" enctype="multipart/form-data">


<!--[JCBGUI.custom_admin_view.default.1.$$$$]-->
<h2>General</h2>


<?php
$cmp = $this->item['component'];
$moodleusersdiff = $this->item['moodleusersdiff'];
$joomlausersdiff = $this->item['joomlausersdiff'];
$coursedif = $this->item['coursedif'];
$catdif = $this->item['catdif'];
?>
<ul class="nav nav-tabs">
  <li class="active"><a data-toggle="tab" href="#connectivity"><?= JText::_('COM_MOOJLA_CONNECTIVITY') ?></a></li>
  <li><a data-toggle="tab" href="#joomla-plugins"><?= JText::_('COM_MOOJLA_JOOMLA_PLUGINS') ?></a></li>
  <li><a data-toggle="tab" href="#thirdparty-plugin"><?= JText::_('COM_MOOJLA_THIRDPARTY_PLUGINS') ?></a></li>
  <li><a data-toggle="tab" href="#synchronization-report"><?= JText::_('COM_MOOJLA_SYNCHRONIZATION_REPORT') ?></a></li>
</ul>

<div class="tab-content">
  <div id="connectivity" class="tab-pane fade in active">
    <h3><?= JText::_('COM_MOOJLA_CONNECTIVITY') ?></h3>
    <table width="100%" class="table table-striped">
      <thead>
        <tr>
          <th width="30%"><?= JText::_('COM_MOOJLA_CHECK') ?></th>
          <th width="10%"><?= JText::_('COM_MOOJLA_STATUS') ?></th>
          <th><?= JText::_('COM_MOOJLA_ERROR') ?></th>
        </tr>
      </thead>
      <tbody>

        <tr class="row0">
          <td><?= JText::_('COM_MOOJLA_MOODLE_URL') ?></td>
          <td align="center">
            <?php echo (count((array)$cmp) == 2) ? '<div class="alert alert-danger" role="alert">'.JText::_("COM_MOOJLA_FAILED").'</div>' : '<div class="alert alert-success" role="alert">'.JText::_("OK").'</div>';?>
          </td>
          <td align="center"><?php echo (count((array)$cmp) == 2) ? JText::_("COM_MOOJLA_ENTER_MOODLE_URL_CORRECTLY_BE_SURE_THAT_ENDING_SLASH_ENTERED") : ""; ?></td>
        </tr>
        <?php if(count((array)$cmp) != 2):?>
          <tr class="row0">
            <td><?= JText::_('COM_MOOJLA_CURL') ?></td>
            <td align="center">
              <?php echo !$cmp->curlEnabled ? '<div class="alert alert-danger" role="alert">'.JText::_("COM_MOOJLA_FAILED").'</div>' : '<div class="alert alert-success" role="alert">'.JText::_("OK").'</div>';?>
            </td>
            <td align="center"><?php echo !$cmp->curlEnabled ? $cmp->error->curlEnabled: ""; ?></td>
          </tr>

          <?php if($cmp->curlEnabled):?>
            <tr class="row0">
              <td><?= JText::_('COM_MOOJLA_WEBSERVICES_ENABLED') ?></td>
              <td align="center">
                <?php echo !$cmp->webservicesEnabled ? '<div class="alert alert-danger" role="alert">'.JText::_("COM_MOOJLA_FAILED").'</div>' : '<div class="alert alert-success" role="alert">'.JText::_("OK").'</div>';?>
              </td>
              <td align="center"><?php echo !$cmp->webservicesEnabled ? $cmp->error->webservicesEnabled: ""; ?></td>
            </tr>

            <?php if($cmp->webservicesEnabled):?>
              <tr class="row0">
                <td><?= JText::_('COM_MOOJLA_REST') ?></td>
                <td align="center">
                  <?php echo !$cmp->restEnabled ? '<div class="alert alert-danger" role="alert">'.JText::_("COM_MOOJLA_FAILED").'</div>' : '<div class="alert alert-success" role="alert">'.JText::_("OK").'</div>';?>
                </td>
                <td align="center"><?php echo !$cmp->restEnabled ? $cmp->error->restEnabled: ""; ?></td>
              </tr>

              <?php if($cmp->restEnabled):?>
                <tr class="row0">
                  <td><?= JText::_('COM_MOOJLA_MOOJLA_INSTALLED') ?></td>
                  <td align="center">
                    <?php echo !$cmp->moojlaInstalled ? '<div class="alert alert-danger" role="alert">'.JText::_("COM_MOOJLA_FAILED").'</div>' : '<div class="alert alert-success" role="alert">'.JText::_("OK").'</div>';?>
                  </td>
                  <td align="center"><?php echo !$cmp->moojlaInstalled ? $cmp->error->moojlaInstalled: ""; ?></td>
                </tr>

                <?php if($cmp->moojlaInstalled):?>
                  <tr class="row0">
                    <td><?= JText::_('COM_MOOJLA_MOOJLA_ENABLED') ?></td>
                    <td align="center">
                      <?php echo !$cmp->moojlaEnabled ? '<div class="alert alert-danger" role="alert">'.JText::_("COM_MOOJLA_FAILED").'</div>' : '<div class="alert alert-success" role="alert">'.JText::_("OK").'</div>';?>
                    </td>
                    <td align="center"><?php echo !$cmp->moojlaEnabled ? $cmp->error->moojlaEnabled: ""; ?></td>
                  </tr>

                  <?php if($cmp->moojlaEnabled):?>
                    <tr class="row0">
                      <td><?= JText::_('COM_MOOJLA_JOOMLA_URL') ?></td>
                      <td align="center">
                        <?php echo !$cmp->joomlaUrlCorrect ? '<div class="alert alert-danger" role="alert">'.JText::_("COM_MOOJLA_FAILED").'</div>' : '<div class="alert alert-success" role="alert">'.JText::_("OK").'</div>';?>
                      </td>
                      <td align="center"><?php echo !$cmp->joomlaUrlCorrect ? $cmp->error->joomlaUrlCorrect: ""; ?></td>
                    </tr>

                    <?php if($cmp->joomlaUrlCorrect):?>
                      <tr class="row0">
                        <td><?= JText::_('COM_MOOJLA_JOOMLA_TOKEN') ?></td>
                        <td align="center">
                          <?php echo !$cmp->joomlaTokenCorrect ? '<div class="alert alert-danger" role="alert">'.JText::_("COM_MOOJLA_FAILED").'</div>' : '<div class="alert alert-success" role="alert">'.JText::_("OK").'</div>';?>
                        </td>
                        <td align="center"><?php echo !$cmp->joomlaTokenCorrect ? $cmp->error->joomlaTokenCorrect: ""; ?></td>
                      </tr>

                      <?php if($cmp->joomlaUrlCorrect):?>
                      <tr class="row0">
                        <td><?= JText::_('COM_MOOJLA_MOODLE_TOKEN') ?></td>
                        <td align="center">
                          <?php echo !$cmp->moodleToken ? '<div class="alert alert-danger" role="alert">'.JText::_("COM_MOOJLA_FAILED").'</div>' : '<div class="alert alert-success" role="alert">'.JText::_("OK").'</div>';?>
                        </td>
                        <td align="center"><?php echo !$cmp->moodleToken ? $cmp->error->moodleToken: ""; ?></td>
                      </tr>
                      <?php endif;?>
                    <?php endif;?>
                  <?php endif;?>
                <?php endif;?>
              <?php endif;?>
            <?php endif;?>
          <?php endif;?>
        <?php endif;?>
      </tbody>
    </table>
  </div>
  <div id="joomla-plugins" class="tab-pane fade">
    <h3><?= JText::_('COM_MOOJLA_JOOMLA_PLUGINS') ?></h3>  
    <table width="100%" class="table table-striped">
      <thead>
        <tr>
          <th width="30%"><?= JText::_('COM_MOOJLA_PLUGINS_NAME') ?></th>
          <th width="10%"><?= JText::_('COM_MOOJLA_STATUS') ?></th>
          <th><?= JText::_('COM_MOOJLA_IMPORTANCE') ?></th>
        </tr>
      </thead>
      <tbody>
      <?php foreach($this->item['plugins']->joomla as $plg_name => $plugin): ?>
        <tr class="row0">
          <td><?php echo $plg_name; ?></td>
          <td align="center">
            <?php echo !$plugin->installed ? '<div class="alert alert-danger" role="alert">'.JText::_("COM_MOOJLA_NOT_INSTALLED").'</div>' : ($plugin->enabled? '<a type="button" href="javascript:void(0);" onclick="return jpluginAction('."'".$plg_name."'".', 0)" class="btn btn-success">'.JText::_("COM_MOOJLA_ENABLED").'</button>' : '<a type="button" href="javascript:void(0);" onclick="return jpluginAction('."'".$plg_name."'".', 1)" class="btn btn-danger">'.JText::_("COM_MOOJLA_DISABLED").'</a>')?>
            </td>
          <td align="center"><?php echo $plugin->importancy; ?></td>
        </tr>
      <?php endforeach;?>
      </tbody>
    </table>
  </div>
  <div id="thirdparty-plugin" class="tab-pane fade">
    
      <?php foreach($this->item['plugins']->thirdparties as $tplg_name => $tplugin): ?>
        <?php if($tplugin):?>
          <?php
            echo '<h3>' . $tplg_name . " Plugins<h3></h3>";
          ?>
          <table width="100%" class="table table-striped">
            <thead>
              <tr>
                <th width="30%"><?= JText::_('COM_MOOJLA_PLUGINS_NAME') ?></th>
                <th width="10%"><?= JText::_('COM_MOOJLA_STATUS') ?></th>
                <th><?= JText::_('COM_MOOJLA_IMPORTANCE') ?></th>
              </tr>
            </thead>
            <tbody>
            <?php foreach($tplugin as $plg_name => $plugin): ?>
              <tr class="row0">
                <td><?php echo $plg_name; ?></td>
                <td align="center">
                  <?php echo !$plugin->installed ? '<div class="alert alert-danger" role="alert">'.JText::_("COM_MOOJLA_NOT_INSTALLED").'</div>' : ($plugin->enabled? '<a type="button" href="javascript:void(0);" onclick="return jpluginAction(this, 0)" class="btn btn-success">'.JText::_("COM_MOOJLA_ENABLED").'</a>' : '<a type="button" href="javascript:void(0);" onclick="return jpluginAction(this, 1)" class="btn btn-danger">'.JText::_("COM_MOOJLA_DISABLED").'</a>')?>
                  </td>
                <td align="center"><?php echo $plugin->importancy; ?></td>
              </tr>
            <?php endforeach;?>
            </tbody>
          </table>
        <?php else:?>
          <strong><?php echo $tplg_name." " .JText::_("COM_MOOJLA_NOT_INSTALLED"); ?></strong>
        <?php endif;?>
      <?php endforeach;?>
    </div>
  <div id="synchronization-report" class="tab-pane fade">
    <ul class="nav nav-tabs">
      <li class="active"><a data-toggle="tab" href="#users"><?= JText::_('COM_MOOJLA_USERS') ?></a></li>
      <li><a data-toggle="tab" href="#courses"><?= JText::_('COM_MOOJLA_COURSES') ?></a></li>
      <li><a data-toggle="tab" href="#category"><?= JText::_('COM_MOOJLA_CATEGORIES') ?></a></li>
    </ul>
    <div class="tab-content">
      <div id="users" class="tab-pane fade">
        <h3><?= JText::_('COM_MOOJLA_USERS') ?></h3>
        <?php $diffnum = count($moodleusersdiff);
		echo JText::sprintf('COM_MOOJLA_S_MOODLE_USERS_NOT_MAPPED_IN_MOOJLA_JOOMLA_SIDE_MOODLE_IDS_LISTED_IN_BOTTOM', $diffnum);?>
        <ul class='users' id='moodle-users'>
          <?php foreach($moodleusersdiff as $id):?>
          <li><?php echo $id;?></li>
          <?php endforeach;?>
        </ul>
        <?php if($diffnum > 5):?>
        <span onclick="showMore('moodle-users', this)" class="showmore-btn"><?= JText::_('COM_MOOJLA_SHOW_MORE') ?></span>
        <?php endif;?>

        

      <?php $jdiffnum = count($joomlausersdiff);
		echo JText::sprintf('COM_MOOJLA_S_JOOMLA_USERS_NOT_MAPPED_IN_MOOJLA_MOODLE_SIDE_JOOMLA_IDS_LISTED_IN_BOTTOM', $jdiffnum); ?>
      <ul class='users' id='joomla-users'>
        <?php foreach($joomlausersdiff as $id):?>
        <li><?php echo $id;?></li>
        <?php endforeach;?>
      </ul>
      <?php if($jdiffnum > 5):?>
      <span onclick="showMore('joomla-users', this)" class="showmore-btn"><?= JText::_('COM_MOOJLA_SHOW_MORE') ?></span>
      <?php endif;?>

      </div>
      <div id="courses" class="tab-pane fade">
        <h3><?= JText::_('COM_MOOJLA_COURSES') ?></h3>
        <?php $cdiffnum = count($coursedif);
			echo JText::sprintf('COM_MOOJLA_S_MOODLE_COURSES_NOT_MAPPED_IN_MOOJLA_JOOMLA_SIDE_MOODLE_COURSE_IDS_LISTED_IN_BOTTOM', $cdiffnum); ?>
        <ul class='users' id='moodle-courses'>
          <?php foreach($coursedif as $id):?>
          <li><?php echo $id;?></li>
          <?php endforeach;?>
        </ul>
        <?php if($cdiffnum > 5):?>
        <span onclick="showMore('moodle-courses', this)" class="showmore-btn"><?= JText::_('COM_MOOJLA_SHOW_MORE') ?></span>
        <?php endif;?>
      </div>
      <div id="category" class="tab-pane fade">
        <h3><?= JText::_('COM_MOOJLA_CATEGORIES') ?></h3>

        <?php $catdifnum = count($catdif);
			
			echo $catdifnum . ' moodle ' . ($catdifnum > 1 ? 'categories' : 'category') . ' not mapped in moojla (joomla side), moodle category ids listed in bottom:' ?>
        <ul class='users' id='moodle-categories'>
          <?php foreach($catdif as $id):?>
          <li><?php echo $id;?></li>
          <?php endforeach;?>
        </ul>
        <?php if($catdifnum > 5):?>
        <span onclick="showMore('moodle-categories', this)" class="showmore-btn"><?= JText::_('COM_MOOJLA_SHOW_MORE') ?></span>
        <?php endif;?>
      </div>
    </div>
  </div>
</div><!--[/JCBGUI$$$$]-->

<input type="hidden" name="task" value="" />
<?php echo JHtml::_('form.token'); ?>
</form>
<?php else: ?>
        <h1><?php echo JText::_('COM_MOOJLA_NO_ACCESS_GRANTED'); ?></h1>
<?php endif; ?>

