<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_notifly
 *
 * @copyright   Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');

JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
JHtml::_('formbehavior.chosen', '.multipleAccessLevels', null, array('placeholder_text_multiple' => JText::_('JOPTION_SELECT_ACCESS')));
JHtml::_('formbehavior.chosen', '.multipleAuthors', null, array('placeholder_text_multiple' => JText::_('JOPTION_SELECT_AUTHOR')));
JHtml::_('formbehavior.chosen', '.multipleCategories', null, array('placeholder_text_multiple' => JText::_('JOPTION_SELECT_CATEGORY')));
JHtml::_('formbehavior.chosen', '.multipleTags', null, array('placeholder_text_multiple' => JText::_('JOPTION_SELECT_TAG')));
JHtml::_('formbehavior.chosen', 'select');

// Chart JS
JHtml::_('script', 'com_notifly/chart.min.js', array('version' => 'auto', 'relative' => true));

$user      = JFactory::getUser();
$userId    = $user->get('id');

?>

<form action="<?php echo JRoute::_('index.php?option=com_notifly&view=dashboard'); ?>" method="post" name="adminForm" id="adminForm">
	<div id="cf" class="dashboard tx-flex">
		<?php if (!empty( $this->sidebar)) : ?>
		<div class="tx-sidebar">
			<?php echo $this->sidebar; ?>
		</div>
		<div class="tx-main">
		<?php else : ?>
		<div class="tx-main">
		<?php endif; ?>
			<div class="page-header">
				<div class="row">
					<div class="col-md-9">
						<h1>Dashboard</h1>
					</div>
					<div class="col-md-3">
						<?php 
						$update = NotiflyHelper::getUpdateStatus(); 
						$link = JRoute::_('index.php?option=com_installer&view=update&task=update.find&'.JSession::getFormToken() . '=1');
						?>

						<!-- 
						// comment due to design reason
						<div class="media well well-sm" style="margin: 0;">
							<div class="media-left">
								<i class="cfi-download-cloud text-success" style="font-size: 40px;"></i>
							</div>
							<div class="media-body">
								<p>
									<span class="muted">Installed Version:</span> 
									<span class="label label-success"><?php echo $update['old']; ?></span>
								</p>
				  				<p>
				  					<span class="muted">Lateset Version</span> 
				  					<span class="label label-info"><?php echo $update['new']; ?></span>
				  				</p>
							</div>
		  					<a href="<?php echo $link ?>" class="btn btn-default btn-xs">
		  						<i class="cfi-refresh-cw"></i> Update Now
		  					</a>
						</div> -->

					</div>
				</div>
			</div>
			<div class="page-content">
				<div class="row">
					<div class="col-md-12">
						<?php echo NotiflyHelper::showWarning(); ?>
						<?php echo $this->loadTemplate('update'); ?>
						
						<h4><?php echo date('M 01, Y') ?> to <?php echo date('M d, Y') ?> be like:</h4>
						<div class="panel panel-default">
							<div class="panel-body">
								<div style="width:100%;">
						        <canvas id="nf-chart"></canvas>
						    </div>
						    <script>
						    	// console.log('<?php //echo json_encode($this->items); ?>');
						    	// console.log('<?php //echo date("Y-m-".sprintf("%02d", 22)." 00:00:00"); ?>');
						    	var ctx = document.getElementById("nf-chart");
						    	var data = {
						    		labels: [<?php for($i=1; $i <= date("d"); $i++) {
						    			echo "$i" . ($i!=(date("d")) ? "," : "");
					    			} ?>],
							        datasets: [
										{
											label: 'Clicks',
											data: [<?php for($i=1; $i <= date("d"); $i++) {
												$date = date("Y-m-".sprintf("%02d", $i)." 00:00:00");
						    					echo (isset($this->items[$date]->click) ? $this->items[$date]->click : "0") . ($i!=date("d") ? "," : "");
							    			} ?>],
							    			fill: false,
								    		borderColor: 'rgb(255, 99, 132)', backgroundColor: 'rgb(255, 99, 132)'
								        }
										,
								        {
											label: 'Shown',
											data: [<?php for($i=1; $i <= date("d"); $i++) {
												$date = date("Y-m-".sprintf("%02d", $i)." 00:00:00");
							    				echo (isset($this->items[$date]->view) ? $this->items[$date]->view : "0") . ($i!=date("d") ? "," : "");
								    		} ?>],
								    		fill: false,
								    		borderColor: 'rgb(54, 162, 235)', backgroundColor: 'rgb(54, 162, 235)'
								        }
						        	]
						        };
						    	var myLineChart = new Chart(ctx, {
									    type: 'line',
									    data: data,
									    options: {
							                responsive: true,
							                title:{
							                    display:true,
							                    text:'Notifly monthly reports'
							                },
							                tooltips: {
							                    mode: 'index',
							                    intersect: false,
							                },
							                hover: {
							                    mode: 'nearest',
							                    intersect: true
							                },
							                scales: {
							                    xAxes: [{
							                        display: true,
							                        scaleLabel: {
							                            display: true,
							                            labelString: 'Day of month'
							                        }
							                    }],
							                    yAxes: [{
							                        display: true,
							                        scaleLabel: {
							                            display: true,
							                            labelString: 'Counts'
							                        }
							                    }]
							                }
							            }
									});
						    </script>
							</div>
						</div>
					</div>
					<!--
					<div class="col-md-12">
						<h4><?php echo JText::_('COM_NOTIFLY_ENABLED_INTEGRATIONS'); ?></h4>
						<?php $plugins = NotiflyHelper::getGroupPlugins(); ?>
						<div class="panel panel-default">
							<ul class="list-group" style="margin-left: 0;">
							<?php foreach ($plugins as $key => $plugin) { ?>
								<li class="list-group-item">
									<p style="color:<?php echo ($plugin->enabled ? 'green' : 'red'); ?>">
										<i class="<?php echo ($plugin->enabled ? 'cfi-check-circle' : 'cfi-x-circle'); ?>"></i>
										<?php echo JText::_(ucfirst($plugin->element)); ?></p>
								</li>
							<?php } ?>
							</ul>
						</div>
					</div>
					-->
				</div>
			</div>

			<input type="hidden" name="task" value="" />
			<input type="hidden" name="dashboard" value="1" />
			<input type="hidden" name="boxchecked" value="0" />
			<?php echo JHtml::_('form.token'); ?>
			</div>
	</div>
</form>
