<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				fdsh 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.39
	@build			4th April, 2023
	@created		17th December, 2020
	@package		Reservation
	@subpackage		consultant.php
	@author			farhad shahbazi <http://farhad.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

// import the list field type
jimport('joomla.form.helper');
JFormHelper::loadFieldClass('list');

/**
 * Consultant Form Field class for the Reservation component
 */
class JFormFieldConsultant extends JFormFieldList
{
	/**
	 * The consultant field type.
	 *
	 * @var		string
	 */
	public $type = 'consultant';

	/**
	 * Method to get a list of options for a list input.
	 *
	 * @return	array    An array of JHtml options.
	 */
	protected function getOptions()
	{
		// Get the user object.
		$user = JFactory::getUser();
		// Get the databse object.
		$db = JFactory::getDBO();
		$query = $db->getQuery(true);
		$query->select($db->quoteName(array('a.id','b.name','c.title'),array('id','name','specialty')));
		$query->from($db->quoteName('#__reservation_consultant', 'a'));
                $query->join('INNER', $db->quoteName('#__users', 'b') . ' ON ' . $db->quoteName('a.userId') . ' = ' . $db->quoteName('b.id'));
                $query->join('INNER', $db->quoteName('#__categories', 'c') . ' ON ' . $db->quoteName('a.catid') . ' = ' . $db->quoteName('c.id'));

                
		$query->where('('.$db->quoteName('a.account') . ' = '.$db->quote('consultant').' or '.$db->quoteName('a.account') . ' = '.$db->quote('both').')');
                $query->where($db->quoteName('a.published') . ' = 1');
		$query->order('b.name ASC');
		// Implement View Level Access (if set in table)
		if (!$user->authorise('core.options', 'com_reservation'))
		{
			$columns = $db->getTableColumns('#__reservation_consultant');
			if(isset($columns['access']))
			{
				$groups = implode(',', $user->getAuthorisedViewLevels());
				$query->where('a.access IN (' . $groups . ')');
			}
		}
		$db->setQuery((string)$query);
		$items = $db->loadObjectList();
		$options = array();
		if ($items)
		{
			if ($this->multiple === false)
			{
				$options[] = JHtml::_('select.option', '', JText::_('COM_RESERVATION_SELECT_AN_OPTION'));
			}
			foreach($items as $item)
			{
				$options[] = JHtml::_('select.option', $item->id, $item->name."(".$item->specialty.")");
			}
		}
		return $options;
	}
}
