<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				fdsh 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.32
	@build			14th June, 2021
	@created		17th December, 2020
	@package		Reservation
	@subpackage		view.html.php
	@author			farhad shahbazi <http://farhad.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

/**
 * Reservation View class for the Reserve
 */
class ReservationViewReserve extends JViewLegacy
{
	// Overwriting JView display method
	function display($tpl = null)
	{
		// get combined params of both component and menu
		$this->app = JFactory::getApplication();
		$this->params = $this->app->getParams();
		$this->menu = $this->app->getMenu()->getActive();
		// get the user object
		$this->user = JFactory::getUser();
		// Initialise variables.
		$this->item = $this->get('Item');

		/***[JCBGUI.site_view.php_jview_display.36.$$$$]***/
		$this->preprocess();/***[/JCBGUI$$$$]***/

		// Set the toolbar
		$this->addToolBar();

		// set the document
		$this->_prepareDocument();

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			throw new Exception(implode(PHP_EOL, $errors), 500);
		}
		

		parent::display($tpl);
	}


/***[JCBGUI.site_view.php_jview.36.$$$$]***/
 public function preprocess()
    {

        $result= ReservationHelper::checkAccount();
        $user= JFactory::getUser();

        if (!$user->guest)
        {
            if (!$result['sick'])
            {
                $this->app->enqueueMessage('تنها افراد با حساب کاربری بیمار اجازه رزرو نوبت حضوری دارند' , 'danger');
                $this->app->redirect(JUri::root());
            }

        }
        else
        {
            $this->app->enqueueMessage('برای رزرو نوبت حضوری ابتدا وارد حساب کاربری خود شوید' , 'danger');
            $this->app->redirect(JUri::root());
        }


        require_once JPATH_SITE . '/components/com_reservation/controllers/reserve.php';
       $controller = new ReservationControllerReserve;

        $payment_method= $this->app->input->get->get('payment_method');
        if ($payment_method)
        {
            $controller->reserve();
        }
       
       
       $params = JComponentHelper::getParams('com_reservation');
       $chekout = $params->get('checkout');
       $chekout = $controller->reordering($chekout);

       $this->item->checkout= $chekout;
       $layout = $controller->getLayout();
       $this->setLayout($layout);
	}/***[/JCBGUI$$$$]***/


	/**
	 * Prepares the document
	 */
	protected function _prepareDocument()
	{

		// always make sure jquery is loaded.
		JHtml::_('jquery.framework');
		// Load the header checker class.
		require_once( JPATH_COMPONENT_SITE.'/helpers/headercheck.php' );
		// Initialize the header checker.
		$HeaderCheck = new reservationHeaderCheck;

		// always load these files.
		$this->document->addStyleSheet(JURI::root(true) . "/media/com_reservation/bootstrapv45/css/bootstrap.min.css", (ReservationHelper::jVersion()->isCompatible("3.8.0")) ? array("version" => "auto") : "text/css");
		$this->document->addScript(JURI::root(true) . "/media/com_reservation/bootstrapv45/js/bootstrap.bundle.min.js", (ReservationHelper::jVersion()->isCompatible("3.8.0")) ? array("version" => "auto") : "text/javascript");
		
		/***[JCBGUI.site_view.php_document.36.$$$$]***/
		JHtml::_('script', 'media/system/js/core.js');/***[/JCBGUI$$$$]***/
		 
		// add the document default css file
		$this->document->addStyleSheet(JURI::root(true) .'/components/com_reservation/assets/css/reserve.css', (ReservationHelper::jVersion()->isCompatible('3.8.0')) ? array('version' => 'auto') : 'text/css');
	}

	/**
	 * Setting the toolbar
	 */
	protected function addToolBar()
	{

		// set help url for this view if found
		$help_url = ReservationHelper::getHelpUrl('reserve');
		if (ReservationHelper::checkString($help_url))
		{
			JToolbarHelper::help('COM_RESERVATION_HELP_MANAGER', false, $help_url);
		}
		// now initiate the toolbar
		$this->toolbar = JToolbar::getInstance();
	}

	/**
	 * Escapes a value for output in a view script.
	 *
	 * @param   mixed  $var  The output to escape.
	 *
	 * @return  mixed  The escaped value.
	 */
	public function escape($var, $sorten = false, $length = 40)
	{
		// use the helper htmlEscape method instead.
		return ReservationHelper::htmlEscape($var, $this->_charset, $sorten, $length);
	}
}
