<?php
/**
 * @package	RSMembership!
 * @copyright	(c) 2009 - 2016 RSJoomla!
 * @link		https://www.rsjoomla.com
 * @license	GNU General Public License http://www.gnu.org/licenses/gpl-3.0.en.html
 */

defined('_JEXEC') or die('Restricted access');
?>
<div id="rsm_subscribe_preview" class="item-page">
	<?php if ($this->params->get('show_page_heading', 1)) { ?>
		<div class="page-header">
			<h1><?php echo $this->escape($this->params->get('page_heading', $this->membership->name)); ?></h1>
		</div>
	<?php } ?>

	<form method="post" class="rsmembership_form" action="<?php echo JRoute::_('index.php?option=com_rsmembership&task=paymentredirect'); ?>" name="membershipForm" id="rsm_subscribe_preview_form">
	<div class="item-page">
		<h3 class="page-header"><?php echo JText::_('COM_RSMEMBERSHIP_PURCHASE_INFORMATION'); ?></h3>

			<div class="rsmemgrid-form-group rsmemgrid-row">
				<div class="rsmemgrid-col-sm-4 rsmemgrid-col-form-label"><label><?php echo JText::_('COM_RSMEMBERSHIP_MEMBERSHIP'); ?>:</label></div>
				<div class="rsmemgrid-col-sm-8"><div class="rsmemgrid-form-control-plaintext"><?php echo $this->escape($this->membership->name); ?> - <?php echo RSMembershipHelper::getPriceFormat($this->membership->price); ?></div></div>
			</div>
			<?php if (isset($this->data->coupon) && strlen($this->data->coupon)) { ?>
			<div class="rsmemgrid-form-group rsmemgrid-row">
				<div class="rsmemgrid-col-sm-4 rsmemgrid-col-form-label"><label><?php echo JText::_('COM_RSMEMBERSHIP_COUPON'); ?>:</label></div>
				<div class="rsmemgrid-col-sm-8"><div class="rsmemgrid-form-control-plaintext"><?php echo $this->escape($this->data->coupon); ?></div></div>
			</div>
			<?php } ?>
			<?php if ($this->extras) { ?>
				<?php foreach ($this->extras as $extra) { ?>
					<div class="rsmemgrid-form-group rsmemgrid-row">
						<div class="rsmemgrid-col-sm-4 rsmemgrid-col-form-label"><label><?php echo $this->escape($extra->getParentName()); ?>:</label></div>
						<div class="rsmemgrid-col-sm-8"><div class="rsmemgrid-form-control-plaintext"><?php echo $this->escape($extra->name); ?> - <?php echo RSMembershipHelper::getPriceFormat($extra->price); ?></div></div>
					</div>
				<?php } ?>
			<?php } ?>
			<?php if ($this->membership->use_renewal_price) { ?>
			<div class="rsmemgrid-form-group rsmemgrid-row">
				<div class="rsmemgrid-col-sm-4 rsmemgrid-col-form-label"><label><?php echo JText::_('COM_RSMEMBERSHIP_RENEWAL_PRICE'); ?>:</label></div>
				<div class="rsmemgrid-col-sm-8"><div class="rsmemgrid-form-control-plaintext"><?php echo RSMembershipHelper::getPriceFormat($this->total - $this->membership->price + $this->membership->renewal_price); ?></div></div>
			</div>
			<?php } ?>
			<div class="rsmemgrid-form-group rsmemgrid-row">
				<div class="rsmemgrid-col-12"><hr /></div>
			</div>
			<div class="rsmemgrid-form-group rsmemgrid-row">
				<div class="rsmemgrid-col-sm-4 rsmemgrid-col-form-label"><label><?php echo JText::_('COM_RSMEMBERSHIP_TOTAL_COST'); ?>:</label></div>
				<div class="rsmemgrid-col-sm-8"><div class="rsmemgrid-form-control-plaintext"><?php echo RSMembershipHelper::getPriceFormat($this->total); ?></div></div>
			</div>

	</div>

	<div class="item-page">
		<h3 class="page-header"><?php echo JText::_('COM_RSMEMBERSHIP_ACCOUNT_INFORMATION'); ?></h3>
		<?php if ($this->choose_username) { ?>
		<div class="rsmemgrid-form-group rsmemgrid-row">
			<div class="rsmemgrid-col-sm-4 rsmemgrid-col-form-label"><label><?php echo JText::_('COM_RSMEMBERSHIP_USERNAME'); ?>:</label></div>
			<?php if (!$this->logged) { ?>
			<div class="rsmemgrid-col-sm-8"><div class="rsmemgrid-form-control-plaintext"><?php echo $this->escape($this->data->username); ?></div></div>
			<?php } else { ?>
			<div class="rsmemgrid-col-sm-8"><div class="rsmemgrid-form-control-plaintext"><?php echo $this->escape($this->user->get('username')); ?></div></div>
			<?php } ?>
		</div>
		<?php } ?>
		<?php if ($this->choose_password) { ?>
		<div class="rsmemgrid-form-group rsmemgrid-row">
			<div class="rsmemgrid-col-sm-4 rsmemgrid-col-form-label"><label><?php echo JText::_('COM_RSMEMBERSHIP_PASSWORD'); ?>:</label></div>
			<div class="rsmemgrid-col-sm-8"><div class="rsmemgrid-form-control-plaintext">**********</div></div>
		</div>
		<?php } ?>
		<div class="rsmemgrid-form-group rsmemgrid-row">
			<div class="rsmemgrid-col-sm-4 rsmemgrid-col-form-label"><label><?php echo JText::_('COM_RSMEMBERSHIP_NAME'); ?>:</label></div>
			<?php if (!$this->logged) { ?>
			<div class="rsmemgrid-col-sm-8"><div class="rsmemgrid-form-control-plaintext"><?php echo $this->escape($this->data->name); ?></div></div>
			<?php } else { ?>
			<div class="rsmemgrid-col-sm-8"><div class="rsmemgrid-form-control-plaintext"><?php echo $this->escape($this->user->get('name')); ?></div></div>
			<?php } ?>
		</div>
		<div class="rsmemgrid-form-group rsmemgrid-row">
			<div class="rsmemgrid-col-sm-4 rsmemgrid-col-form-label"><label><?php echo JText::_( 'COM_RSMEMBERSHIP_EMAIL' ); ?>:</label></div>
			<?php if (!$this->logged) { ?>
			<div class="rsmemgrid-col-sm-8"><div class="rsmemgrid-form-control-plaintext"><?php echo $this->escape($this->data->email); ?></div></div>
			<?php } else { ?>
			<div class="rsmemgrid-col-sm-8"><div class="rsmemgrid-form-control-plaintext"><?php echo $this->escape($this->user->get('email')); ?></div></div>
			<?php } ?>
		</div>
		<?php foreach ($this->fields as $field) { ?>
		<div class="rsmemgrid-form-group rsmemgrid-row">
			<div class="rsmemgrid-col-sm-4 rsmemgrid-col-form-label"><?php echo $field[0]; ?></div>
			<div class="rsmemgrid-col-sm-8"><?php echo $field[1]; ?></div>
		</div>
		<?php } ?>
	</div>

	<?php if (count($this->membership_fields)>0) {?>
	<div class="item-page">
		<h3 class="page-header"><?php echo JText::_('COM_RSMEMBERSHIP_MEMBERSHIP_INFORMATION'); ?></h3>
		<?php foreach ($this->membership_fields as $field) { ?>
		<div class="rsmemgrid-form-group rsmemgrid-row">
			<div class="rsmemgrid-col-sm-4 rsmemgrid-col-form-label"><?php echo $field[0]; ?></div>
			<div class="rsmemgrid-col-sm-8"><?php echo (trim($field[1])=='' ? '-' : $field[1]); ?></div>
		</div>
		<?php } ?>
	</div>
	<?php } ?>

	<?php if ($this->showPayments) { ?>
	<div class="item-page">
		<h3 class="page-header"><?php echo JText::_('COM_RSMEMBERSHIP_PAYMENT_INFORMATION'); ?></h3>
		<div class="rsmemgrid-form-group rsmemgrid-row">
			<div class="rsmemgrid-col-sm-4 rsmemgrid-d-flex rsmemgrid-align-items-center rsmemgrid-col-form-label"><label><?php echo  JText::_('COM_RSMEMBERSHIP_PAY_WITH'); ?>:</label></div>
			<div class="rsmemgrid-col-sm-8">
				<?php
					$i = 0;
					if ( !empty($this->payments) )
					{
						foreach ($this->payments as $plugin => $paymentdetails) {
							$i++;
							$tax_value = '';
							$paymentname = '';
							if (is_array($paymentdetails))
							{
								if ($paymentdetails['tax_details'])
								{
									if ($paymentdetails['tax_details']['tax_type'] == 0)
									{
										$tax_value = $this->total * ($paymentdetails['tax_details']['tax_value'] / 100);
										$tax_value = JText::sprintf('COM_RSMEMBERSHIP_PAY_TAX_VALUE_PERCENT', $tax_value, RSMembershipHelper::getPriceFormat($tax_value), $paymentdetails['tax_details']['tax_value']);
									}
									else
									{
										$tax_value = JText::sprintf('COM_RSMEMBERSHIP_PAY_TAX_VALUE_FIXED', $paymentdetails['tax_details']['tax_value'], RSMembershipHelper::getPriceFormat($paymentdetails['tax_details']['tax_value']));
									}
								}
								$paymentname = $paymentdetails['name'];
							}
							else
							{
								$paymentname = $paymentdetails;
							}
						?>
						<div class="rsmemgrid-form-group rsmemgrid-form-check">
							<input <?php echo $i == 1 ? 'checked="checked"' : ''; ?> type="radio" name="payment" value="<?php echo $this->escape($plugin); ?>" id="payment<?php echo $i; ?>" class="rsmemgrid-form-check-input" />
							<label for="payment<?php echo $i; ?>" class="rsmemgrid-form-check-label"><?php echo $this->escape($paymentname).$tax_value; ?></label>
						</div>
					<?php } ?>
				<?php } ?>
			</div>
		</div>
	</div>
	<?php } ?>
	<div class="item-page">
		<div class="rsmemgrid-form-group rsmemgrid-row rsmemgrid-mb-3">
			<div class="rsmemgrid-col-sm-4 rsmemgrid-col-form-label"><label><strong><?php echo JText::_('COM_RSMEMBERSHIP_GRAND_TOTAL'); ?></strong>:</label></div>
			<div class="rsmemgrid-col-sm-8"><div class="rsmemgrid-form-control-plaintext"><span id="rsm_grand_total" data-fixedvalue="<?php echo $this->total;?>"><?php echo RSMembershipHelper::getPriceFormat($this->total); ?></span></div></div>
		</div>
	</div>
	<div class="form-actions">
		<button type="button" class="btn rsmemgrid-btn" onclick="document.location='<?php echo JRoute::_('index.php?option=com_rsmembership&view=subscribe&cid='.$this->membership->id.'&task=back'); ?>'" name="Cancel"><?php echo JText::_('COM_RSMEMBERSHIP_BACK'); ?></button>
		<button type="submit" class="btn btn-success rsmemgrid-btn rsmemgrid-float-right"><?php echo JText::_('COM_RSMEMBERSHIP_SUBSCRIBE'); ?></button>
	</div>
	<?php echo JHtml::_('form.token');?>
	<input type="hidden" name="option" value="com_rsmembership" />
	<input type="hidden" name="view" value="subscribe" />
	<input type="hidden" name="task" value="paymentredirect" />
	<input type="hidden" name="cid" value="<?php echo $this->membership->id; ?>" />
</form>
</div>