<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\Privacy\Field;

use CB\Database\Table\UserTable;
use CB\Database\Table\FieldTable;
use CBLib\Registry\GetterInterface;
use CBLib\Language\CBTxt;

defined('CBLIB') or die();

class ExportField extends \cbFieldHandler
{

	/**
	 * @param FieldTable $field
	 * @param UserTable  $user
	 * @param string     $output
	 * @param string     $formatting
	 * @param string     $reason
	 * @param int        $list_compare_types
	 * @return mixed|null
	 */
	public function getFieldRow( &$field, &$user, $output, $formatting, $reason, $list_compare_types )
	{
		$return			=	null;

		if ( ( $output == 'htmledit' ) && ( $reason == 'edit' ) && $user->get( 'id', 0, GetterInterface::INT ) ) {
			$field->set( 'registration', 0 );
			$field->set( 'profile', 0 );
			$field->set( 'required', 0 );
			$field->set( 'readonly', 0 );

			$return		=	parent::getFieldRow( $field, $user, $output, $formatting, $reason, $list_compare_types );
		}

		return $return;
	}

	/**
	 * @param FieldTable $field
	 * @param UserTable  $user
	 * @param string     $output
	 * @param string     $reason
	 * @param int        $list_compare_types
	 * @return mixed|null|string
	 */
	public function getField( &$field, &$user, $output, $reason, $list_compare_types )
	{
		global $_CB_framework;

		$return			=	null;

		if ( ( $output == 'htmledit' ) && ( $reason == 'edit' ) && $user->get( 'id', 0, GetterInterface::INT ) ) {
			initToolTip();

			$value		=	'<a href="' . $_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'export', 'id' => $user->get( 'id', 0, GetterInterface::INT ) ), 'raw', 0, true ) . '">'
						.		CBTxt::T( 'PRIVACY_EXPORT_PROFILE_DATA', 'Export profile data.' )
						.	'</a>';

			$return		=	$this->formatFieldValueLayout( $value, $reason, $field, $user, false )
						.	$this->_fieldIconsHtml( $field, $user, $output, $reason, null, 'html', $value, null, null, true, 0 );
		}

		return $return;
	}
}