<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\AutoActions\Action;

use CB\Database\Table\UserTable;
use CBLib\Database\Driver\CmsDatabaseDriver;
use CBLib\Language\CBTxt;
use CBLib\Registry\ParamsInterface;

\defined( 'CBLIB' ) or die();

class QueryAction extends Action
{

	/**
	 * @param UserTable $user
	 * @return null|array|string|int
	 */
	public function execute( UserTable $user )
	{
		global $_CB_framework, $_CB_database;

		$return							=	null;

		foreach ( $this->autoaction()->getParams()->subTree( 'query' ) as $row ) {
			/** @var ParamsInterface $row */
			if ( $row->getBool( 'mode', false ) ) {
				$host					=	$row->getString( 'host', '' );

				if ( ! $host ) {
					$this->error( CBTxt::T( 'AUTO_ACTION_QUERY_NO_HOST', ':: Action [action] :: Query skipped due to missing host', [ '[action]' => $this->autoaction()->getId() ] ) );
					continue;
				}

				$username				=	$row->getString( 'username', '' );

				if ( ! $username ) {
					$this->error( CBTxt::T( 'AUTO_ACTION_QUERY_NO_USERNAME', ':: Action [action] :: Query skipped due to missing username', [ '[action]' => $this->autoaction()->getId() ] ) );
					continue;
				}

				$password				=	$row->getString( 'password', '' );

				if ( ! $password ) {
					$this->error( CBTxt::T( 'AUTO_ACTION_QUERY_NO_PSWD', ':: Action [action] :: Query skipped due to missing password', [ '[action]' => $this->autoaction()->getId() ] ) );
					continue;
				}

				$database				=	$row->getString( 'database', '' );

				if ( ! $database ) {
					$this->error( CBTxt::T( 'AUTO_ACTION_QUERY_NO_DB', ':: Action [action] :: Query skipped due to missing database', [ '[action]' => $this->autoaction()->getId() ] ) );
					continue;
				}

				$charset				=	$row->getString( 'charset', '' );
				$prefix					=	$row->getString( 'prefix', '' );

				if ( ! $prefix ) {
					$prefix				=	$_CB_framework->getCfg( 'dbprefix' );
				}

				$driver					=	$_CB_framework->getCfg( 'dbtype' );
				$options				=	[ 'driver' => $driver, 'host' => $host, 'user' => $username, 'password' => $password, 'database' => $database, 'prefix' => $prefix ];

				if ( \is_callable( [ 'JDatabaseDriver', 'getInstance' ] ) ) {
					try {
						$_J_database	=	\JDatabaseDriver::getInstance( $options );
					} catch ( \RuntimeException $e ) {
						$this->error( CBTxt::T( 'AUTO_ACTION_QUERY_EXT_DB_FAILED', ':: Action [action] :: Query external database failed. Error: [error]', [ '[action]' => $this->autoaction()->getId(), '[error]' => $e->getMessage() ] ) );
						continue;
					}
				} else {
					try {
						$_J_database	=	\JDatabase::getInstance( $options );
					} catch ( \RuntimeException $e ) {
						$this->error( CBTxt::T( 'AUTO_ACTION_QUERY_EXT_DB_FAILED', ':: Action [action] :: Query external database failed. Error: [error]', [ '[action]' => $this->autoaction()->getId(), '[error]' => $e->getMessage() ] ) );
						continue;
					}
				}

				$_SQL_database			=	new CmsDatabaseDriver( $_J_database, $prefix, checkJversion( 'release' ) );

				if ( $charset ) {
					$_SQL_database->setQuery( 'SET NAMES ' . $_SQL_database->Quote( $charset ) );
					$_SQL_database->query();
				}
			} else {
				$_SQL_database			=	$_CB_database;
			}

			if ( $_SQL_database ) {
				$queries				=	preg_split( '/(;\s*[\r\n])/', trim( $this->string( $user, $row->getRaw( 'sql', '' ), [ '\CB\Plugin\AutoActions\CBAutoActions', 'escapeSQL' ] ) ) );

				if ( ! $queries ) {
					$this->error( CBTxt::T( 'AUTO_ACTION_QUERY_NO_QUERY', ':: Action [action] :: Query skipped due to missing query', [ '[action]' => $this->autoaction()->getId() ] ) );
					continue;
				}

				foreach ( $queries as $query ) {
					if ( $query ) {
						$_SQL_database->setQuery( $query );

						try {
							if ( stripos( trim( $query ), 'SELECT' ) === 0 ) {
								if ( stripos( trim( $query ), 'SELECT COUNT' ) === 0  ) {
									// Count
									$return			=	(int) $_SQL_database->loadResult();
								} elseif ( preg_match( '/LIMIT (?:0,\s*1|1)/i', trim( $query ) ) ) {
									// Single Row
									if ( preg_match( '/SELECT\s(?:.+,.+|\*)\sFROM/si', trim( $query ) ) ) {
										// Multiple Columns
										$return		=	$_SQL_database->loadAssoc();
									} else {
										// Single Column
										$result		=	$_SQL_database->loadResult();

										if ( ( ! \is_object( $return ) ) && ( ! \is_array( $return ) ) ) {
											$return	.=	$result;
										} else {
											$return	=	$result;
										}
									}
								} elseif ( preg_match( '/SELECT\s(?:.+,.+|\*)\sFROM/si', trim( $query ) ) ) {
									// Multiple Columns
									$return			=	$_SQL_database->loadAssocList();
								} else {
									// Single Column
									$results		=	implode( ', ', $_SQL_database->loadResultArray() );

									if ( ( ! \is_object( $return ) ) && ( ! \is_array( $return ) ) ) {
										$return		.=	$results;
									} else {
										$return		=	$results;
									}
								}
							} else {
								$_SQL_database->query();
							}
						} catch ( \ErrorException $e ) {
							$this->error( CBTxt::T( 'AUTO_ACTION_QUERY_FAILED', ':: Action [action] :: Query failed. Error: [error]', [ '[action]' => $this->autoaction()->getId(), '[error]' => $e->getMessage() ] ) );
							continue;
						}
					}
				}
			}
		}

		return $return;
	}
}