<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Application\Application;
use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\Gallery\Gallery;
use CB\Plugin\Gallery\Table\FolderTable;
use CB\Plugin\Gallery\CBGallery;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_cbgalleryFolderEdit
{

	/**
	 * @param FolderTable      $row
	 * @param array            $items
	 * @param cbPageNav        $itemsPageNav
	 * @param array            $input
	 * @param UserTable        $viewer
	 * @param Gallery          $gallery
	 * @param CBplug_cbgallery $plugin
	 */
	public static function showFolderEdit( $row, $items, $itemsPageNav, $input, $viewer, $gallery, $plugin )
	{
		global $_CB_framework, $_PLUGINS;

		$integrations				=	$_PLUGINS->trigger( 'gallery_onBeforeFolderEdit', array( &$row, &$input, $viewer, $gallery ) );

		static $JS_LOADED			=	0;

		if ( ! $JS_LOADED++ ) {
			initToolTip();
			cbValidator::loadValidation();
		}

		$canModerate				=	CBGallery::canModerate( $gallery );

		if ( $row->getInt( 'id', 0 ) ) {
			$pageTitle				=	CBTxt::T( 'EDIT_ALBUM_NAME', 'Edit Album: [name]', array( '[name]' => ( $row->getString( 'title' ) ? $row->getString( 'title' ) : cbFormatDate( $row->getString( 'date' ), true, false, CBTxt::T( 'GALLERY_LONG_DATE_FORMAT', 'F j, Y' ) ) ) ) );
		} else {
			$pageTitle				=	CBTxt::T( 'Create New Album' );
		}

		$returnUrl					=	CBGallery::getReturn( true, true );

		if ( ! $returnUrl ) {
			$returnUrl				=	$gallery->location();
		}

		if ( $pageTitle ) {
			$_CB_framework->setPageTitle( $pageTitle );
		}

		$return						=	'<div class="galleryFolderEdit">'
									.		'<form action="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'folder', 'func' => 'save', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id(), 'return' => CBGallery::getReturn( true ) ) ) . '" method="post" enctype="multipart/form-data" name="galleryFolderForm" id="galleryFolderForm" class="form-auto m-0 cb_form galleryFolderForm cbValidation">'
									.			( $pageTitle ? '<div class="mb-3 border-bottom cb-page-header galleryFolderTitle"><h3 class="m-0 p-0 mb-2 cb-page-header-title">' . $pageTitle . '</h3></div>' : null )
									.			HTML_cbgalleryIntegrationEdit::showIntegrationEdit( $integrations );

		if ( $canModerate || ( ! $gallery->getBool( 'folders_create_approval', false ) ) || ( $row->getInt( 'id', 0 ) && ( $row->getInt( 'published', 0 ) !== -1 ) ) ) {
			$return					.=			'<div class="cbft_select cbtt_select form-group row no-gutters cb_form_line">'
									.				'<label for="published" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Published' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$input['published']
									.					getFieldIcons( 1, 0, null, CBTxt::T( 'Select publish status of the album. If unpublished the album will not be visible to the public.' ) )
									.				'</div>'
									.			'</div>';
		}

		$return						.=			'<div class="cbft_text cbtt_input form-group row no-gutters cb_form_line">'
									.				'<label for="title" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Title' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$input['title']
									.					getFieldIcons( 1, 0, null, CBTxt::T( 'Optionally input a title. If no title is provided the date will be displayed as the title.' ) )
									.				'</div>'
									.			'</div>'
									.			'<div class="cbft_textarea cbtt_textarea form-group row no-gutters cb_form_line">'
									.				'<label for="description" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Description' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$input['description']
									.					getFieldIcons( 1, 0, null, CBTxt::T( 'Optionally input a description.' ) )
									.				'</div>'
									.			'</div>'
									.			HTML_cbgalleryIntegrationEdit::showIntegrationEdit( $_PLUGINS->trigger( 'gallery_onAfterFolderEdit', array( $row, $input, $viewer, $gallery ) ) );

		if ( Application::MyUser()->isGlobalModerator() ) {
			$return					.=			'<div class="cbft_text cbtt_input form-group row no-gutters cb_form_line">'
									.				'<label for="user_id" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Owner' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$input['user_id']
									.					getFieldIcons( 1, 1, null, CBTxt::T( 'Input owner as single integer user_id.' ) )
									.				'</div>'
									.			'</div>';
		}

		if ( $gallery->getBool( 'folders_create_captcha', false ) && ( ! $canModerate ) ) {
			$_PLUGINS->loadPluginGroup( 'user' );

			$captcha				=	$_PLUGINS->trigger( 'onGetCaptchaHtmlElements', array( false ) );

			if ( ! empty( $captcha ) ) {
				$captcha			=	$captcha[0];

				$return				.=			'<div class="cbft_delimiter form-group row no-gutters cb_form_line">'
									.				'<label class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Captcha' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					( isset( $captcha[0] ) ? $captcha[0] : null )
									.				'</div>'
									.			'</div>'
									.			'<div class="cbft_text cbtt_input form-group row no-gutters cb_form_line">'
									.				'<div class="cb_field offset-sm-3 col-sm-9">'
									.					str_replace( 'inputbox', 'form-control', ( isset( $captcha[1] ) ? $captcha[1] : null ) )
									.					getFieldIcons( null, 1, null )
									.				'</div>'
									.			'</div>';
			}
		}

		$return						.=			'<div class="row no-gutters">'
									.				'<div class="offset-sm-3 col-sm-9">'
									.					'<button type="submit" class="btn btn-primary btn-sm-block galleryButton galleryButtonSubmit" ' . cbValidator::getSubmitBtnHtmlAttributes() . '>' . ( $row->getInt( 'id', 0 ) ? CBTxt::T( 'Update Album' ) : CBTxt::T( 'Create Album' ) ) . '</button>'
									.					' <button type="button" class="btn btn-secondary btn-sm-block galleryButton galleryButtonCancel" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to cancel? All unsaved data will be lost!' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( htmlspecialchars( $returnUrl ) ) . '\'; })">' . CBTxt::T( 'Cancel' ) . '</button>'
									.				'</div>'
									.			'</div>'
									.			cbGetSpoofInputTag( 'plugin' )
									.		'</form>';

		if ( $items ) {
			$return					.=		'<hr class="mt-3 mb-3" />'
									.		'<div class="galleryFolderEditItems">'
									.			implode( '', $items );

			if ( $gallery->getBool( 'folders_items_paging', true ) && ( $itemsPageNav->total > $itemsPageNav->limit ) ) {
				$return				.=			'<div class="mt-3 galleryFolderEditItemsPaging">'
									.				$itemsPageNav->getListLinks()
									.			'</div>';
			}

			$return					.=		'</div>';
		}

		$return						.=	'</div>';

		echo $return;
	}
}