<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\UserTable;
use CB\Plugin\Activity\Table\ActivityTable;
use CB\Plugin\Activity\Table\NotificationTable;
use CB\Plugin\Activity\Table\CommentTable;
use CB\Plugin\Activity\Activity;
use CB\Plugin\Activity\Notifications;
use CB\Plugin\Activity\Comments;
use CBLib\Registry\ParamsInterface;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var ActivityTable|CommentTable|NotificationTable $row
 * @var UserTable                                    $viewer
 * @var Activity|Comments|Notifications              $stream
 * @var CBplug_cbactivity                            $this
 * @var string                                       $output
 *
 * @var ParamsInterface                              $link
 * @var ParamsInterface                              $media
 */
?>
<?php if ( in_array( $media->getString( 'mimetype' ), array( 'video/youtube', 'video/x-youtube' ), true ) ) { ?>
	<?php if ( preg_match( '%(?:(?:watch\?v=)|(?:embed/)|(?:be/))([A-Za-z0-9_-]+)%', $media->getString( 'url' ), $matches ) ) { ?>
	<div class="position-relative w-100 mh-100 streamItemVideo streamToggleMedia streamToggleMediaVideo" data-cbgallery-video="https://www.youtube.com/embed/<?php echo htmlspecialchars( $matches[1] ); ?>?autoplay=1">
		<div class="d-flex flex-column justify-content-center position-absolute w-100 h-100 streamToggleMediaPreview">
			<div class="position-absolute display-1 align-middle text-white text-center w-100 streamToggleMediaPlay">
				<span class="fa fa-play streamToggleMediaIcon"></span>
			</div>
			<img src="https://img.youtube.com/vi/<?php echo ( isset( $matches[1] ) ? htmlspecialchars( $matches[1] ) : 'unknown' ); ?>/0.jpg" loading="lazy" class="flex-auto mh-100 mw-none img-fluid streamItemImage" />
		</div>
		<iframe loading="lazy" width="100%" height="100%" style="width: 100%; height: 100%;" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" allowfullscreen class="position-absolute streamItemVideoPlayer"></iframe>
	</div>
	<?php } ?>
<?php } elseif ( in_array( $media->getString( 'mimetype' ), array( 'video/vimeo', 'video/x-vimeo' ), true ) ) { ?>
	<?php if ( preg_match( '%/(\d+)$%', $media->getString( 'url' ), $matches ) ) { ?>
		<?php if ( $link->getRaw( 'thumbnails' ) !== false ) { ?>
		<div class="position-relative w-100 mh-100 streamItemVideo streamToggleMedia streamToggleMediaVideo" data-cbgallery-video="https://player.vimeo.com/video/<?php echo htmlspecialchars( $matches[1] ); ?>?autoplay=1">
			<div class="d-flex flex-column justify-content-center position-absolute w-100 h-100 streamToggleMediaPreview">
				<div class="position-absolute display-1 align-middle text-white text-center w-100 streamToggleMediaPlay">
					<span class="fa fa-play streamToggleMediaIcon"></span>
				</div>
				<img src="<?php echo $link->subTree( 'thumbnails' )->subTree( 0 )->getString( 'url' ); ?>" loading="lazy" class="flex-auto mh-100 mw-none img-fluid streamItemImage" />
			</div>
			<iframe loading="lazy" width="100%" height="100%" style="width: 100%; height: 100%;" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" allowfullscreen class="position-absolute streamItemVideoPlayer"></iframe>
		</div>
		<?php } else { ?>
		<div class="position-relative w-100 mh-100 streamItemVideo">
			<iframe loading="lazy" width="100%" height="100%" style="width: 100%; height: 100%;" src="https://player.vimeo.com/video/<?php echo htmlspecialchars( $matches[1] ); ?>" frameborder="0" allow="fullscreen; picture-in-picture" allowfullscreen class="position-absolute streamItemVideoPlayer"></iframe>
		</div>
		<?php } ?>
	<?php } ?>
<?php } else { ?>
<div class="position-relative w-100 mh-100 streamItemVideo">
	<video width="100%" height="100%" style="width: 100%; height: 100%;" src="<?php echo htmlspecialchars( $media->getString( 'url' ) ); ?>" type="<?php echo htmlspecialchars( $media->getString( 'mimetype' ) ); ?>" controls preload="auto" class="streamItemVideoPlayer"></video>
</div>
<?php } ?>