<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\UserTable;
use CBLib\Language\CBTxt;
use CB\Plugin\Activity\CBActivity;
use CB\Plugin\Activity\Table\LikeTable;
use CB\Plugin\Activity\Likes;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var LikeTable[]       $rows
 * @var cbPageNav         $pageNav
 * @var UserTable         $viewer
 * @var Likes             $stream
 * @var CBplug_cbactivity $this
 * @var string            $output
 *
 * @var array             $integrations
 * @var int               $count
 */
?>
<div class="<?php echo ( $output === 'modal' ? 'p-2 ' : null ); ?>likesStream streamBind streamContainer stream<?php echo htmlspecialchars( $stream->id() ); ?>" data-cbactivity-stream="<?php echo htmlspecialchars( $stream->id() ); ?>">
	<?php echo implode( '', $integrations ); ?>
	<?php if ( $output !== 'modal' ) { ?>
	<div class="row no-gutters mb-2 likesStreamToolbar streamToolbar">
		<?php if ( $stream->getBool( 'count', true ) ) { ?>
		<div class="col-6"><span class="badge badge-light border font-weight-normal likesStreamCount streamCount"><?php echo CBTxt::T( 'LIKES_COUNT', '[likes] Like|[likes] Likes|%%COUNT%%', array( '%%COUNT%%' => $pageNav->total, '[likes]' => CBActivity::getFormattedTotal( $pageNav->total ) ) ); ?></span></div>
		<?php } ?>
		<div class="col text-right"><?php echo $stream->likes( 'button', 0, array( 'inline' => true, 'count' => false ) ); ?> </div>
	</div>
	<?php } ?>
	<div class="row no-gutters likesStreamItems streamItems">
		<?php require CBActivity::getTemplate( $stream->getString( 'template' ), 'likes/rows', false ); ?>
	</div>
	<?php if ( $stream->getBool( 'paging', true ) && ( $pageNav->total > $pageNav->limit ) ) { ?>
	<a href="javascript: void(0);" data-cbactivity-more-url="<?php echo $pageNav->limitstartUrl( $pageNav->limitstart ); ?>" class="btn btn-info btn-sm btn-block mt-2 likesButton likesButtonMore streamMore"><?php echo CBTxt::T( 'More' ); ?></a>
	<?php } ?>
	<?php echo implode( '', $_PLUGINS->trigger( 'activity_onAfterDisplayLikesStream', array( $rows, $pageNav, $viewer, $stream, $output ) ) ); ?>
	<?php echo ( $output === 'modal' ? CBActivity::reloadHeaders() : null ); ?>
</div>