<?php
/**
 * @package    Joomla.Component.Builder
 *
 * @created    30th April, 2015
 * @author     Llewellyn van der Merwe <https://dev.vdm.io>
 * @git        Joomla Component Builder <https://git.vdm.dev/joomla/Component-Builder>
 * @copyright  Copyright (C) 2015 Vast Development Method. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

JLoader::register('ComponentbuilderHelper', JPATH_ADMINISTRATOR . '/components/com_componentbuilder/helpers/componentbuilder.php');

use Joomla\CMS\Application\CMSApplication;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Registry\Registry;
use VDM\Joomla\Componentbuilder\Compiler\Factory as CFactory;
use VDM\Joomla\Utilities\JsonHelper;
use VDM\Joomla\Utilities\ArrayHelper;
use VDM\Joomla\Utilities\StringHelper;

/**
 * Extension - Componentbuilder Field Ordering Compiler plugin.
 *
 * @package   ComponentbuilderFieldOrderingCompiler
 * @since     1.1.0
 */
class PlgExtensionComponentbuilderFieldOrderingCompiler extends CMSPlugin
{
	/**
	 * Event Triggered in the compiler [on Before Model View Data]
	 *
	 * @return  void
	 *
	 * @since   1.0
	 */
	public function jcb_ce_onBeforeModelViewData(&$view)
	{
		// add the privacy
		$view->params = (isset($view->params) && JsonHelper::check($view->params)) ? json_decode($view->params, true) : $view->params;
		if (ArrayHelper::check($view->params) && isset($view->params['fieldordering']) && ArrayHelper::check($view->params['fieldordering']))
		{
			if ($view->params['fieldordering']['add_admin_ordering'] == 1
				|| $view->params['fieldordering']['add_linked_ordering'] == 1)
			{
				// setup the view key name
				$name_list   = StringHelper::safe($view->name_list);
				// load the admin view details
				CFactory::_('Compiler.Builder.Views.Default.Ordering')->set($name_list, $view->params['fieldordering']);
			}
		}
	}
}
