<?php
/**
 * @package    Joomla.Component.Builder
 *
 * @created    30th April, 2015
 * @author     Llewellyn van der Merwe <https://dev.vdm.io>
 * @git        Joomla Component Builder <https://git.vdm.dev/joomla/Component-Builder>
 * @copyright  Copyright (C) 2015 Vast Development Method. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Filesystem\File;
use Joomla\CMS\Filesystem\Folder;

/**
 * Extension - Componentbuilder ActionLog Compiler script file.
 *
 * @package PlgExtensionComponentbuilderActionLogCompiler
 */
class plgExtensionComponentbuilderActionLogCompilerInstallerScript
{

	/**
	 * Called before any type of action
	 *
	 * @param   string  $route  Which action is happening (install|uninstall|discover_install|update)
	 * @param   Joomla\CMS\Installer\InstallerAdapter  $adapter  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
	public function preflight($route, $adapter)
	{
		// get application
		$app = Factory::getApplication();

		// the default for both install and update
		$jversion = new JVersion();
		if (!$jversion->isCompatible('3.8.0'))
		{
			$app->enqueueMessage('Please upgrade to at least Joomla! 3.8.0 before continuing!', 'error');
			return false;
		}

		if ('install' === $route)
		{
			// check that componentbuilder is installed
			$pathToCore = JPATH_ADMINISTRATOR . '/components/com_componentbuilder/helpers/componentbuilder.php';
			if (!JFile::exists($pathToCore))
			{
				$app->enqueueMessage('Joomla Component Builder must first be installed from <a href="https://www.joomlacomponentbuilder.com/ " target="_blank">Joomla Component Builder</a>.', 'error');
				return false;
			}
		}

		return true;
	}
}
