<?php
return [
    '@class' => 'Gantry\\Component\\File\\CompiledYamlFile',
    'filename' => '/home/lmsyaran/public_html/templates/g5_hydrogen/custom/particles/jlslideshow.yaml',
    'modified' => 1589206690,
    'data' => [
        'name' => 'JL Slideshow',
        'description' => 'Display an image slideshow.',
        'type' => 'particle',
        'icon' => 'fa-picture-o',
        'configuration' => [
            'caching' => [
                'type' => 'static'
            ]
        ],
        'form' => [
            'overrideable' => false,
            'fields' => [
                'enabled' => [
                    'type' => 'input.checkbox',
                    'label' => 'Enabled',
                    'description' => 'Globally enable to the particles.',
                    'default' => true
                ],
                '_tabs' => [
                    'type' => 'container.tabs',
                    'fields' => [
                        '_tab_content' => [
                            'label' => 'Content',
                            'overridable' => false,
                            'fields' => [
                                'items' => [
                                    'type' => 'collection.list',
                                    'array' => true,
                                    'label' => 'Items',
                                    'overridable' => false,
                                    'description' => 'Create each item to appear in the slideshow.',
                                    'value' => 'title',
                                    'ajax' => true,
                                    'fields' => [
                                        '.image' => [
                                            'type' => 'input.imagepicker',
                                            'label' => 'Image',
                                            'description' => 'An image field with an image picker.',
                                            'placeholder' => 'Pick an image'
                                        ],
                                        '.slideshow_title' => [
                                            'type' => 'input.text',
                                            'label' => 'Title',
                                            'description' => 'Customize the title.',
                                            'placeholder' => 'Enter Title'
                                        ],
                                        '.slideshow_meta' => [
                                            'type' => 'input.text',
                                            'label' => 'Meta',
                                            'description' => 'Customize the meta.',
                                            'placeholder' => 'Enter Meta'
                                        ],
                                        '.slideshow_content' => [
                                            'type' => 'textarea.textarea',
                                            'label' => 'Content',
                                            'description' => 'Customize the content.',
                                            'placeholder' => 'Enter Content'
                                        ],
                                        '.slideshow_link' => [
                                            'type' => 'input.text',
                                            'label' => 'Link',
                                            'description' => 'Enter the image\'s link if needed.',
                                            'placeholder' => 'http://'
                                        ],
                                        '.slideshow_link_text' => [
                                            'type' => 'input.text',
                                            'label' => 'Link Text',
                                            'description' => 'Set a different link text for this item.',
                                            'placeholder' => 'Read more'
                                        ],
                                        '.slideshow_item_text_color' => [
                                            'type' => 'select.select',
                                            'label' => 'Text Color',
                                            'description' => 'Set a different text color for this item.',
                                            'default' => 'default',
                                            'options' => [
                                                'default' => 'None',
                                                'light' => 'Light',
                                                'dark' => 'Dark'
                                            ]
                                        ],
                                        '.slideshow_navigation_image' => [
                                            'type' => 'input.imagepicker',
                                            'label' => 'Navigation Thumbnail',
                                            'description' => 'This option is only used if the thumbnail navigation is set.',
                                            'placeholder' => 'Pick an image'
                                        ],
                                        '.bg_color' => [
                                            'type' => 'input.colorpicker',
                                            'label' => 'Background Color',
                                            'description' => 'Use the background color in combination with blend modes.'
                                        ],
                                        '.blend_mode' => [
                                            'type' => 'select.select',
                                            'label' => 'Blend Mode',
                                            'description' => 'Determine how the image will blend with the background color.',
                                            'default' => 'inherit',
                                            'options' => [
                                                'inherit' => 'Normal',
                                                'multiply' => 'Multiply',
                                                'screen' => 'Screen',
                                                'overlay' => 'Overlay',
                                                'darken' => 'Darken',
                                                'lighten' => 'Lighten',
                                                'color-dodge' => 'Color-dodge',
                                                'color-burn' => 'Color-burn',
                                                'hard-light' => 'Hard-light',
                                                'soft-light' => 'Soft-light',
                                                'difference' => 'Difference',
                                                'exclusion' => 'Exclusion',
                                                'hue' => 'Hue',
                                                'saturation' => 'Saturation',
                                                'color' => 'Color',
                                                'luminosity' => 'Luminosity'
                                            ]
                                        ],
                                        '.bg_overlay' => [
                                            'type' => 'input.colorpicker',
                                            'label' => 'Overlay Color',
                                            'description' => 'Set an additional transparent overlay to soften the image.'
                                        ],
                                        '.item_class' => [
                                            'type' => 'input.selectize',
                                            'label' => 'CSS Classes',
                                            'description' => 'Specify the CSS class name for item.'
                                        ]
                                    ]
                                ],
                                'note_slideshow' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Slideshow'
                                ],
                                'slideshow_height' => [
                                    'type' => 'select.select',
                                    'label' => 'Height',
                                    'description' => 'The slideshow always takes up fullwidth and the height will adapt automatically based on the defined ratio. Alternatively, the height can adapt to the height or the viewport. Make sure, no height is set in the section settings when using on of the viewport options.',
                                    'default' => 'auto',
                                    'options' => [
                                        'auto' => 'Auto',
                                        'full' => 'Viewport',
                                        'percent' => 'Viewport (Minus 20%)',
                                        'section' => 'Viewport (Minus the following section)'
                                    ]
                                ],
                                'slideshow_ratio' => [
                                    'type' => 'input.text',
                                    'label' => 'Ratio',
                                    'description' => 'Set a ratio. It\'s recommended to use the same ratio of the background image. Just use its width and height, like 1600:900.',
                                    'placeholder' => '16:9'
                                ],
                                'slideshow_min_height' => [
                                    'type' => 'input.number',
                                    'label' => 'Min Height',
                                    'description' => 'Use an optional minimum height to prevent the slideshow from becoming smaller than its content on small devices. Min 200 Max 800',
                                    'min' => 200,
                                    'max' => 800,
                                    'default' => 300
                                ],
                                'slideshow_max_height' => [
                                    'type' => 'input.number',
                                    'label' => 'Max Height',
                                    'description' => 'Set the maximum height.',
                                    'min' => 500,
                                    'max' => 1600
                                ],
                                'slideshow_text_color' => [
                                    'type' => 'select.select',
                                    'label' => 'Text Color',
                                    'description' => 'Set light or dark color mode for text, buttons and controls.',
                                    'default' => 'default',
                                    'options' => [
                                        'default' => 'None',
                                        'light' => 'Light',
                                        'dark' => 'Dark'
                                    ]
                                ],
                                'box_shadow' => [
                                    'type' => 'select.select',
                                    'label' => 'Box Shadow',
                                    'description' => 'Select the image\'s box shadow size.',
                                    'default' => 'none',
                                    'options' => [
                                        'none' => 'None',
                                        'small' => 'Small',
                                        'medium' => 'Medium',
                                        'large' => 'Large',
                                        'xlarge' => 'X-Large'
                                    ]
                                ],
                                'extra_shadow' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Extra Bottom Shadow',
                                    'default' => false
                                ],
                                'class' => [
                                    'type' => 'input.selectize',
                                    'label' => 'CSS Classes',
                                    'description' => 'CSS class name for the particle.'
                                ]
                            ]
                        ],
                        '_tab_slideshow' => [
                            'label' => 'Control',
                            'overridable' => false,
                            'fields' => [
                                'slideshow_info' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Animation'
                                ],
                                'image_transition' => [
                                    'type' => 'select.select',
                                    'label' => 'Transition',
                                    'description' => 'Select the transition between slideshow items.',
                                    'default' => 'default',
                                    'options' => [
                                        'default' => 'Slide',
                                        'pull' => 'Pull',
                                        'push' => 'Push',
                                        'fade' => 'Fade',
                                        'scale' => 'Scale'
                                    ]
                                ],
                                'velocity' => [
                                    'type' => 'input.number',
                                    'label' => 'Velocity',
                                    'description' => 'Set the velocity in pixels per milisecond. Min 20 Max 300.',
                                    'min' => 20,
                                    'max' => 300,
                                    'placeholder' => 100
                                ],
                                'slideshow_autoplay' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Autoplay',
                                    'description' => 'Enable autoplay for slideshow items.',
                                    'default' => false
                                ],
                                'slideshow_interval' => [
                                    'type' => 'input.number',
                                    'label' => 'Interval',
                                    'description' => 'Set the autoplay interval in seconds. Min 5 Max 15.',
                                    'min' => 5,
                                    'max' => 15,
                                    'placeholder' => 7
                                ],
                                'slideshow_pause_onhover' => [
                                    'type' => 'select.select',
                                    'label' => 'Pause On Hover',
                                    'description' => 'Pause autoplay on hover.',
                                    'default' => 'enabled',
                                    'options' => [
                                        'enabled' => 'Enable',
                                        'disabled' => 'Disable'
                                    ]
                                ],
                                'image_kenburns' => [
                                    'type' => 'select.select',
                                    'label' => 'Ken Burns Effect',
                                    'description' => 'Select the transformation origin for the Ken Burns animation.',
                                    'default' => 'none',
                                    'options' => [
                                        'none' => 'None',
                                        'top-left' => 'Top Left',
                                        'top-center' => 'Top Center',
                                        'top-right' => 'Top Right',
                                        'center-left' => 'Center Left',
                                        'center-center' => 'Center Center',
                                        'center-right' => 'Center Right',
                                        'bottom-left' => 'Bottom Left',
                                        'bottom-center' => 'Bottom Center',
                                        'bottom-right' => 'Bottom Right'
                                    ]
                                ],
                                'image_kenburns_duration' => [
                                    'type' => 'input.number',
                                    'label' => 'Duration',
                                    'description' => 'Set the duration for the Ken Burns effect in seconds.',
                                    'min' => 10,
                                    'max' => 30,
                                    'placeholder' => 15
                                ],
                                'navigation_info' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Navigation'
                                ],
                                'navigation' => [
                                    'type' => 'select.select',
                                    'label' => 'Navigation',
                                    'description' => 'Select the navigation type.',
                                    'default' => 'dotnav',
                                    'options' => [
                                        'none' => 'None',
                                        'dotnav' => 'Dotnav',
                                        'thumbnav' => 'Thumbnav'
                                    ]
                                ],
                                'navigation_below' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Show Below Slideshow',
                                    'description' => 'Display the navigation below slideshow.',
                                    'default' => false
                                ],
                                'vertical_navigation' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Vertical Navigation',
                                    'default' => false
                                ],
                                'navigation_position' => [
                                    'type' => 'select.select',
                                    'label' => 'Position',
                                    'description' => 'Select the position of the navigation (if \'Show below slideshow\' is not selected.)',
                                    'default' => 'bottom-center',
                                    'options' => [
                                        'top-left' => 'Top Left',
                                        'top-right' => 'Top Right',
                                        'center-left' => 'Center Left',
                                        'center-right' => 'Center Right',
                                        'bottom-left' => 'Bottom Left',
                                        'bottom-center' => 'Bottom Center',
                                        'bottom-right' => 'Bottom Right'
                                    ]
                                ],
                                'navigation_margin' => [
                                    'type' => 'select.select',
                                    'label' => 'Margin',
                                    'description' => 'Apply a margin between the navigation and the slideshow container.',
                                    'default' => 'medium',
                                    'options' => [
                                        'none' => 'None',
                                        'small' => 'Small',
                                        'medium' => 'Medium',
                                        'large' => 'Large'
                                    ]
                                ],
                                'navigation_position_below' => [
                                    'type' => 'select.select',
                                    'label' => 'Position Below',
                                    'description' => 'Align the navigation\'s items if the navigation is below the slideshow.',
                                    'default' => 'center',
                                    'options' => [
                                        'left' => 'Left',
                                        'center' => 'Center',
                                        'right' => 'Right'
                                    ]
                                ],
                                'navigation_margin_below' => [
                                    'type' => 'select.select',
                                    'label' => 'Margin Below',
                                    'description' => 'Apply a margin between the navigation and the slideshow container if the navigation is below the slideshow.',
                                    'default' => 'default',
                                    'options' => [
                                        'small' => 'Small',
                                        'default' => 'Default',
                                        'medium' => 'Medium'
                                    ]
                                ],
                                'navigation_breakpoint' => [
                                    'type' => 'select.select',
                                    'label' => 'Breakpoint',
                                    'description' => 'Display the navigation only on this device width and larger.',
                                    'default' => 's',
                                    'options' => [
                                        'always' => 'Always',
                                        's' => 'Small (Phone Landscape)',
                                        'm' => 'Medium (Tablet Landscape)',
                                        'l' => 'Large (Desktop)',
                                        'xl' => 'X-Large (Large Screens)'
                                    ]
                                ],
                                'navigation_color' => [
                                    'type' => 'select.select',
                                    'label' => 'Color',
                                    'description' => 'Set light or dark color if the navigation is below the slideshow.',
                                    'default' => 'default',
                                    'options' => [
                                        'default' => 'None',
                                        'light' => 'Light',
                                        'dark' => 'Dark'
                                    ]
                                ],
                                'thumbnail_width' => [
                                    'type' => 'input.number',
                                    'label' => 'Thumbnail Width',
                                    'description' => 'Set the width of the thumbnail image.',
                                    'default' => 100,
                                    'min' => 0,
                                    'placeholder' => 100
                                ],
                                'thumbnail_height' => [
                                    'type' => 'input.number',
                                    'label' => 'Thumbnail Height',
                                    'description' => 'Set the height of the thumbnail image.',
                                    'default' => 75,
                                    'min' => 0,
                                    'placeholder' => 75
                                ],
                                'slidenav_info' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Slidenav'
                                ],
                                'slidenav_position' => [
                                    'type' => 'select.select',
                                    'label' => 'Position',
                                    'description' => 'Select the position of the slidenav.',
                                    'default' => 'default',
                                    'options' => [
                                        'none' => 'None',
                                        'default' => 'Default',
                                        'outside' => 'Outside',
                                        'top-left' => 'Top Left',
                                        'top-right' => 'Top Right',
                                        'center-left' => 'Center Left',
                                        'center-right' => 'Center Right',
                                        'bottom-left' => 'Bottom Left',
                                        'bottom-center' => 'Bottom Center',
                                        'bottom-right' => 'Bottom Right'
                                    ]
                                ],
                                'slidenav_hover' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Show On Hover',
                                    'description' => 'Show the slide nav on hover only.',
                                    'default' => false
                                ],
                                'slidenav_large_style' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Larger Style',
                                    'description' => 'To increase the size of the slidenav icons.',
                                    'default' => false
                                ],
                                'slidenav_margin' => [
                                    'type' => 'select.select',
                                    'label' => 'Margin',
                                    'description' => 'Apply a margin between the slidenav and the slideshow container.',
                                    'default' => 'medium',
                                    'options' => [
                                        'none' => 'None',
                                        'small' => 'Small',
                                        'medium' => 'Medium',
                                        'large' => 'Large'
                                    ]
                                ],
                                'slidenav_breakpoint' => [
                                    'type' => 'select.select',
                                    'label' => 'Breakpoint',
                                    'description' => 'Display the slidenav only on this device width and larger.',
                                    'default' => 's',
                                    'options' => [
                                        'always' => 'Always',
                                        's' => 'Small (Phone Landscape)',
                                        'm' => 'Medium (Tablet Landscape)',
                                        'l' => 'Large (Desktop)',
                                        'xl' => 'X-Large (Large Screens)'
                                    ]
                                ],
                                'slidenav_outside_breakpoint' => [
                                    'type' => 'select.select',
                                    'label' => 'Outside Breakpoint',
                                    'description' => 'Display the slidenav only outside on this device width and larger. Otherwise it will be displayed inside.',
                                    'default' => 'xl',
                                    'options' => [
                                        's' => 'Small (Phone Landscape)',
                                        'm' => 'Medium (Tablet Landscape)',
                                        'l' => 'Large (Desktop)',
                                        'xl' => 'X-Large (Large Screens)'
                                    ]
                                ],
                                'slidenav_outside_color' => [
                                    'type' => 'select.select',
                                    'label' => 'Outside Color',
                                    'description' => 'Set light or dark color if the slidenav is outside of the slideshow.',
                                    'default' => 'default',
                                    'options' => [
                                        'default' => 'None',
                                        'light' => 'Light',
                                        'dark' => 'Dark'
                                    ]
                                ],
                                'slidenav_icon_info' => [
                                    'type' => 'separator.note',
                                    'content' => 'Custom previous/next icons (replace default Slidenav navigation)'
                                ],
                                'slidenav_icon_left' => [
                                    'type' => 'input.icon',
                                    'label' => 'Previous Icon'
                                ],
                                'slidenav_icon_right' => [
                                    'type' => 'input.icon',
                                    'label' => 'Next Icon'
                                ]
                            ]
                        ],
                        '_tab_style' => [
                            'label' => 'Style',
                            'overridable' => false,
                            'fields' => [
                                'title_info' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Title Style'
                                ],
                                'title_style' => [
                                    'type' => 'select.select',
                                    'label' => 'Style',
                                    'description' => 'Title styles differ in font-size but may also come with a predefined color, size and font.',
                                    'default' => 'default',
                                    'options' => [
                                        'default' => 'None',
                                        'heading-2xlarge' => '2XLarge',
                                        'heading-xlarge' => 'XLarge',
                                        'heading-large' => 'Large',
                                        'heading-medium' => 'Medium',
                                        'heading-small' => 'Small',
                                        'h1' => 'H1',
                                        'h2' => 'H2',
                                        'h3' => 'H3',
                                        'h4' => 'H4',
                                        'h5' => 'H5',
                                        'h6' => 'H6'
                                    ]
                                ],
                                'title_decoration' => [
                                    'type' => 'select.select',
                                    'label' => 'Decoration',
                                    'description' => 'Decorate the headline with a divider, bullet or a line that is vertically centered to the heading.',
                                    'default' => 'none',
                                    'options' => [
                                        'none' => 'None',
                                        'divider' => 'Divider',
                                        'bullet' => 'Bullet',
                                        'line' => 'Line'
                                    ]
                                ],
                                'pre_title_color' => [
                                    'type' => 'select.select',
                                    'label' => 'Predefined Color',
                                    'description' => 'Select the text color.',
                                    'default' => 'default',
                                    'options' => [
                                        'default' => 'None',
                                        'muted' => 'Muted',
                                        'emphasis' => 'Emphasis',
                                        'primary' => 'Primary',
                                        'secondary' => 'Secondary',
                                        'success' => 'Success',
                                        'warning' => 'Warning',
                                        'danger' => 'Danger',
                                        'background' => 'Background'
                                    ]
                                ],
                                'title_color' => [
                                    'type' => 'input.colorpicker',
                                    'label' => 'Custom Color',
                                    'description' => 'Customize the title color instead using predefined title color mode. You need to set the Predefined color to None before using the color customization.'
                                ],
                                'title_fontsize' => [
                                    'type' => 'input.number',
                                    'label' => 'Font Size',
                                    'min' => 0,
                                    'description' => 'Customize the title text font size'
                                ],
                                'title_text_transform' => [
                                    'type' => 'select.select',
                                    'label' => 'Transform',
                                    'description' => 'The following options will transform text into uppercased, capitalized or lowercased characters.',
                                    'default' => '',
                                    'options' => [
                                        '' => 'Inherit',
                                        'uppercase' => 'Uppercase',
                                        'capitalize' => 'Capitalize',
                                        'lowercase' => 'Lowercase'
                                    ]
                                ],
                                'title_element' => [
                                    'type' => 'select.select',
                                    'label' => 'HTML Element',
                                    'description' => 'Choose one of the elements to fit your semantic structure.',
                                    'default' => 'h3',
                                    'options' => [
                                        'h1' => 'H1',
                                        'h2' => 'H2',
                                        'h3' => 'H3',
                                        'h4' => 'H4',
                                        'h5' => 'H5',
                                        'h6' => 'H6',
                                        'div' => 'div'
                                    ]
                                ],
                                'title_margin_top' => [
                                    'type' => 'select.select',
                                    'label' => 'Margin Top',
                                    'description' => 'Set the top margin. Note that the margin will only apply if the content field immediately follows another content field.',
                                    'default' => 'default',
                                    'options' => [
                                        'small' => 'Small',
                                        'default' => 'Default',
                                        'medium' => 'Medium',
                                        'large' => 'Large',
                                        'xlarge' => 'X-Large',
                                        'remove' => 'None'
                                    ]
                                ],
                                'title_parallax' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Title Parallax',
                                    'description' => 'Add a parallax effect for Title. This option won\'t have any effect unless the Parallax animation for Overlay is selected.',
                                    'default' => false
                                ],
                                'meta_info' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Meta Style'
                                ],
                                'meta_style' => [
                                    'type' => 'select.select',
                                    'label' => 'Style',
                                    'description' => 'Select a predefined meta text style, including color, size and font-family.',
                                    'default' => 'text-meta',
                                    'options' => [
                                        'default' => 'None',
                                        'text-meta' => 'Meta',
                                        'heading-2xlarge' => '2XLarge',
                                        'heading-xlarge' => 'XLarge',
                                        'heading-large' => 'Large',
                                        'heading-medium' => 'Medium',
                                        'heading-small' => 'Small',
                                        'h1' => 'H1',
                                        'h2' => 'H2',
                                        'h3' => 'H3',
                                        'h4' => 'H4',
                                        'h5' => 'H5',
                                        'h6' => 'H6'
                                    ]
                                ],
                                'pre_meta_color' => [
                                    'type' => 'select.select',
                                    'label' => 'Predefined Color',
                                    'description' => 'Select the text color.',
                                    'default' => 'default',
                                    'options' => [
                                        'default' => 'None',
                                        'muted' => 'Muted',
                                        'emphasis' => 'Emphasis',
                                        'primary' => 'Primary',
                                        'secondary' => 'Secondary',
                                        'success' => 'Success',
                                        'warning' => 'Warning',
                                        'danger' => 'Danger'
                                    ]
                                ],
                                'meta_color' => [
                                    'type' => 'input.colorpicker',
                                    'label' => 'Custom Color',
                                    'description' => 'Customize the Meta color instead using predefined Meta color mode. You need to set the Predefined color to None before using the color customization.'
                                ],
                                'meta_fontsize' => [
                                    'type' => 'input.number',
                                    'label' => 'Font Size',
                                    'min' => 0,
                                    'description' => 'Customize the meta text font size.'
                                ],
                                'meta_text_transform' => [
                                    'type' => 'select.select',
                                    'label' => 'Transform',
                                    'description' => 'The following options will transform text into uppercased, capitalized or lowercased characters.',
                                    'default' => '',
                                    'options' => [
                                        '' => 'Inherit',
                                        'uppercase' => 'Uppercase',
                                        'capitalize' => 'Capitalize',
                                        'lowercase' => 'Lowercase'
                                    ]
                                ],
                                'meta_alignment' => [
                                    'type' => 'select.select',
                                    'label' => 'Alignment',
                                    'description' => 'Align the meta text.',
                                    'default' => 'bottom',
                                    'options' => [
                                        'top' => 'Above Title',
                                        'bottom' => 'Below Title',
                                        'content' => 'Below Content'
                                    ]
                                ],
                                'meta_margin_top' => [
                                    'type' => 'select.select',
                                    'label' => 'Margin Top',
                                    'description' => 'Set the top margin. Note that the margin will only apply if the content field immediately follows another content field.',
                                    'default' => 'default',
                                    'options' => [
                                        'small' => 'Small',
                                        'default' => 'Default',
                                        'medium' => 'Medium',
                                        'large' => 'Large',
                                        'xlarge' => 'X-Large',
                                        'remove' => 'None'
                                    ]
                                ],
                                'meta_parallax' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Meta Parallax',
                                    'description' => 'Add a parallax effect for Meta. This option won\'t have any effect unless the Parallax animation for Overlay is selected.',
                                    'default' => false
                                ],
                                'content_info' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Content Style'
                                ],
                                'content_style' => [
                                    'type' => 'select.select',
                                    'label' => 'Style',
                                    'description' => 'Select a predefined text style, including color, size and font-family.',
                                    'default' => 'default',
                                    'options' => [
                                        'default' => 'None',
                                        'lead' => 'Lead'
                                    ]
                                ],
                                'content_text_color' => [
                                    'type' => 'select.select',
                                    'label' => 'Predefined Color',
                                    'description' => 'Select the text color.',
                                    'default' => 'default',
                                    'options' => [
                                        'default' => 'None',
                                        'muted' => 'Muted',
                                        'emphasis' => 'Emphasis',
                                        'primary' => 'Primary',
                                        'secondary' => 'Secondary',
                                        'success' => 'Success',
                                        'warning' => 'Warning',
                                        'danger' => 'Danger',
                                        'background' => 'Background'
                                    ]
                                ],
                                'customize_content_color' => [
                                    'type' => 'input.colorpicker',
                                    'label' => 'Customize Color',
                                    'description' => 'Customize the content color instead using predefined text color. You need to set the Predefined color to None before using the color customization.'
                                ],
                                'customize_content_fontsize' => [
                                    'type' => 'input.number',
                                    'label' => 'Font Size',
                                    'min' => 0,
                                    'description' => 'Customize the content text font size'
                                ],
                                'content_text_transform' => [
                                    'type' => 'select.select',
                                    'label' => 'Transform',
                                    'description' => 'The following options will transform text into uppercased, capitalized or lowercased characters.',
                                    'default' => '',
                                    'options' => [
                                        '' => 'Inherit',
                                        'uppercase' => 'Uppercase',
                                        'capitalize' => 'Capitalize',
                                        'lowercase' => 'Lowercase'
                                    ]
                                ],
                                'content_margin_top' => [
                                    'type' => 'select.select',
                                    'label' => 'Margin Top',
                                    'description' => 'Set the top margin. Note that the margin will only apply if the content field immediately follows another content field.',
                                    'default' => 'default',
                                    'options' => [
                                        'small' => 'Small',
                                        'default' => 'Default',
                                        'medium' => 'Medium',
                                        'large' => 'Large',
                                        'xlarge' => 'X-Large',
                                        'remove' => 'None'
                                    ]
                                ],
                                'content_parallax' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Content Parallax',
                                    'description' => 'Add a parallax effect for Content. Enable this option first then you can custom the settings via parallax tab.',
                                    'default' => false
                                ],
                                'link_info' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Link'
                                ],
                                'buttontarget' => [
                                    'type' => 'select.selectize',
                                    'label' => 'Target',
                                    'description' => 'Open the link in a same or new window.',
                                    'placeholder' => 'Select...',
                                    'default' => '_self',
                                    'options' => [
                                        '_self' => 'Self',
                                        '_blank' => 'New Window'
                                    ]
                                ],
                                'link_text' => [
                                    'type' => 'input.text',
                                    'label' => 'Text',
                                    'description' => 'Specify the button label.',
                                    'placeholder' => 'Read more'
                                ],
                                'link_style' => [
                                    'type' => 'select.select',
                                    'label' => 'Style',
                                    'description' => 'Set the link style',
                                    'default' => 'default',
                                    'options' => [
                                        'default' => 'Button Default',
                                        'primary' => 'Button Primary',
                                        'secondary' => 'Button Secondary',
                                        'danger' => 'Button Danger',
                                        'text' => 'Button Text',
                                        'link' => 'Link',
                                        'link-muted' => 'Link Muted',
                                        'link-text' => 'Link Text'
                                    ]
                                ],
                                'link_button_size' => [
                                    'type' => 'select.select',
                                    'label' => 'Button Size',
                                    'description' => 'Set the button size.',
                                    'default' => 'default',
                                    'options' => [
                                        'small' => 'Small',
                                        'default' => 'Default',
                                        'large' => 'Large'
                                    ]
                                ],
                                'link_margin_top' => [
                                    'type' => 'select.select',
                                    'label' => 'Margin Top',
                                    'description' => 'Set the top margin. Note that the margin will only apply if the content field immediately follows another content field.',
                                    'default' => 'default',
                                    'options' => [
                                        'small' => 'Small',
                                        'default' => 'Default',
                                        'medium' => 'Medium',
                                        'large' => 'Large',
                                        'xlarge' => 'X-Large',
                                        'remove' => 'None'
                                    ]
                                ],
                                'link_parallax' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Button Parallax',
                                    'description' => 'Add a parallax effect for Link. This option won\'t have any effect unless the Parallax animation for Overlay is selected.',
                                    'default' => false
                                ],
                                'thumbnav_color_info' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Thumbnav Style'
                                ],
                                'thumbnav_border_width' => [
                                    'type' => 'input.number',
                                    'label' => 'Border Width',
                                    'placeholder' => '5'
                                ],
                                'thumbnav_border_color' => [
                                    'type' => 'input.colorpicker',
                                    'label' => 'Border Color'
                                ],
                                'thumbnav_border_color_hover' => [
                                    'type' => 'input.colorpicker',
                                    'label' => 'Border Hover Color'
                                ],
                                'slidenav_color_info' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Slidenav Style'
                                ],
                                'slide_background' => [
                                    'type' => 'input.colorpicker',
                                    'label' => 'Background'
                                ],
                                'slide_color' => [
                                    'type' => 'input.colorpicker',
                                    'label' => 'Color'
                                ],
                                'padding_horizontal' => [
                                    'type' => 'input.number',
                                    'label' => 'Padding Horizontal',
                                    'placeholder' => '17'
                                ],
                                'padding_vertical' => [
                                    'type' => 'input.number',
                                    'label' => 'Padding Vertical',
                                    'placeholder' => '14'
                                ],
                                'slide_hover_background' => [
                                    'type' => 'input.colorpicker',
                                    'label' => 'Hover Background'
                                ],
                                'slide_hover_color' => [
                                    'type' => 'input.colorpicker',
                                    'label' => 'Hover Color'
                                ]
                            ]
                        ],
                        '_tab_overlay' => [
                            'label' => 'Overlay',
                            'overridable' => false,
                            'fields' => [
                                'overlay_container_width' => [
                                    'type' => 'select.select',
                                    'label' => 'Container Width',
                                    'description' => 'Set the maximum content width. Note:The section may already have a maximum width, which you cannot exceed.',
                                    'default' => 'none',
                                    'options' => [
                                        'none' => 'None',
                                        'default' => 'Default',
                                        'small' => 'Small',
                                        'large' => 'Large',
                                        'xlarge' => 'XLarge',
                                        'expand' => 'Expand'
                                    ]
                                ],
                                'overlay_container_padding' => [
                                    'type' => 'select.select',
                                    'label' => 'Container Padding',
                                    'description' => 'Set the vertical container padding to position the overlay.',
                                    'default' => 'default',
                                    'options' => [
                                        'default' => 'Default',
                                        'xsmall' => 'X-Small',
                                        'small' => 'Small',
                                        'large' => 'Large',
                                        'xlarge' => 'X-Large'
                                    ]
                                ],
                                'overlay_margin' => [
                                    'type' => 'select.select',
                                    'label' => 'Margin',
                                    'description' => 'Apply a margin between the overlay and the slideshow container.',
                                    'default' => 'default',
                                    'options' => [
                                        'default' => 'Default',
                                        'small' => 'Small',
                                        'large' => 'Large',
                                        'none' => 'None'
                                    ]
                                ],
                                'overlay_position' => [
                                    'type' => 'select.select',
                                    'label' => 'Position',
                                    'description' => 'Set the content position.',
                                    'default' => 'center-left',
                                    'options' => [
                                        'top' => 'Top',
                                        'bottom' => 'Bottom',
                                        'left' => 'Left',
                                        'right' => 'Right',
                                        'top-left' => 'Top Left',
                                        'top-center' => 'Top Center',
                                        'top-right' => 'Top Right',
                                        'center' => 'Center Center',
                                        'center-left' => 'Center Left',
                                        'center-right' => 'Center Right',
                                        'bottom-left' => 'Bottom Left',
                                        'bottom-center' => 'Bottom Center',
                                        'bottom-right' => 'Bottom Right'
                                    ]
                                ],
                                'overlay_style' => [
                                    'type' => 'select.select',
                                    'label' => 'Style',
                                    'description' => 'Select the style for the overlay.',
                                    'default' => 'none',
                                    'options' => [
                                        'none' => 'None',
                                        'jl-overlay-default' => 'Overlay Default',
                                        'jl-overlay-primary' => 'Overlay Primary',
                                        'jl-tile-default' => 'Tile Default',
                                        'jl-tile-muted' => 'Tile Muted',
                                        'jl-tile-primary' => 'Tile Primary',
                                        'jl-tile-secondary' => 'Tile Secondary'
                                    ]
                                ],
                                'overlay_padding' => [
                                    'type' => 'select.select',
                                    'label' => 'Padding',
                                    'description' => 'Set the padding between the overlay and its content. This option won\'t have any effect unless Overlay Style is enabled.',
                                    'default' => 'default',
                                    'options' => [
                                        'default' => 'Default',
                                        'small' => 'Small',
                                        'large' => 'Large'
                                    ]
                                ],
                                'overlay_width' => [
                                    'type' => 'select.select',
                                    'label' => 'Width',
                                    'description' => 'Set a fixed width.',
                                    'default' => 'none',
                                    'options' => [
                                        'none' => 'None',
                                        'small' => 'Small',
                                        'medium' => 'Medium',
                                        'large' => 'Large',
                                        'xlarge' => 'X-Large',
                                        'xxlarge' => 'XX-Large'
                                    ]
                                ],
                                'overlay_transition' => [
                                    'type' => 'select.select',
                                    'label' => 'Animation',
                                    'description' => 'Choose between a parallax depending on the scroll position or an animation, which is applied once the slide is active.',
                                    'default' => 'parallax',
                                    'options' => [
                                        'parallax' => 'Parallax',
                                        'fade' => 'Fade',
                                        'scale-up' => 'Scale Up',
                                        'scale-down' => 'Scale Down',
                                        'slide-top-small' => 'Slide Top Small',
                                        'slide-bottom-small' => 'Slide Bottom Small',
                                        'slide-left-small' => 'Slide Left Small',
                                        'slide-right-small' => 'Slide Right Small',
                                        'slide-top-medium' => 'Slide Top Medium',
                                        'slide-bottom-medium' => 'Slide Bottom Medium',
                                        'slide-left-medium' => 'Slide Left Medium',
                                        'slide-right-medium' => 'Slide Right Medium',
                                        'slide-top' => 'Slide Top 100%',
                                        'slide-bottom' => 'Slide Bottom 100%',
                                        'slide-left' => 'Slide Left 100%',
                                        'slide-right' => 'Slide Right 100%'
                                    ]
                                ]
                            ]
                        ],
                        '_tab_general' => [
                            'label' => 'General',
                            'overridable' => false,
                            'fields' => [
                                'particle_title_info' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Particle Title Style'
                                ],
                                'particle_title' => [
                                    'type' => 'input.text',
                                    'label' => 'Title',
                                    'description' => 'Add an optional particle title.',
                                    'placeholder' => 'Enter particle title'
                                ],
                                'particle_title_style' => [
                                    'type' => 'select.select',
                                    'label' => 'Style',
                                    'description' => 'Title styles differ in font-size but may also come with a predefined color, size and font.',
                                    'default' => 'h3',
                                    'options' => [
                                        'default' => 'None',
                                        'heading-2xlarge' => '2XLarge',
                                        'heading-xlarge' => 'XLarge',
                                        'heading-large' => 'Large',
                                        'heading-medium' => 'Medium',
                                        'heading-small' => 'Small',
                                        'h1' => 'H1',
                                        'h2' => 'H2',
                                        'h3' => 'H3',
                                        'h4' => 'H4',
                                        'h5' => 'H5',
                                        'h6' => 'H6'
                                    ]
                                ],
                                'particle_title_decoration' => [
                                    'type' => 'select.select',
                                    'label' => 'Decoration',
                                    'description' => 'Decorate the headline with a divider, bullet or a line that is vertically centered to the heading.',
                                    'default' => 'none',
                                    'options' => [
                                        'none' => 'None',
                                        'divider' => 'Divider',
                                        'bullet' => 'Bullet',
                                        'line' => 'Line'
                                    ]
                                ],
                                'particle_title_align' => [
                                    'type' => 'select.select',
                                    'label' => 'Alignment',
                                    'description' => 'Center, left and right alignment for Particle title.',
                                    'default' => 'inherit',
                                    'options' => [
                                        'inherit' => 'Inherit',
                                        'left' => 'Left',
                                        'center' => 'Center',
                                        'right' => 'Right',
                                        'justify' => 'Justify'
                                    ]
                                ],
                                'particle_predefined_color' => [
                                    'type' => 'select.select',
                                    'label' => 'Predefined Color',
                                    'description' => 'Select the text color. If the Background option is selected, styles that don\'t apply a background image use the primary color instead.',
                                    'default' => 'default',
                                    'options' => [
                                        'default' => 'None',
                                        'muted' => 'Muted',
                                        'emphasis' => 'Emphasis',
                                        'primary' => 'Primary',
                                        'secondary' => 'Secondary',
                                        'success' => 'Success',
                                        'warning' => 'Warning',
                                        'danger' => 'Danger'
                                    ]
                                ],
                                'particle_title_color' => [
                                    'type' => 'input.colorpicker',
                                    'label' => 'Custom Color',
                                    'description' => 'Customize the title color instead using predefined color mode. Note:Set the Predefined color to None before using this color customization mode.'
                                ],
                                'particle_title_fontsize' => [
                                    'type' => 'input.number',
                                    'label' => 'Font Size',
                                    'description' => 'Customize the particle title font size.',
                                    'min' => 0
                                ],
                                'particle_title_element' => [
                                    'type' => 'select.select',
                                    'label' => 'HTML Element',
                                    'description' => 'Choose one of the elements to fit your semantic structure.',
                                    'default' => 'h3',
                                    'options' => [
                                        'h1' => 'H1',
                                        'h2' => 'H2',
                                        'h3' => 'H3',
                                        'h4' => 'H4',
                                        'h5' => 'H5',
                                        'h6' => 'H6',
                                        'div' => 'div'
                                    ]
                                ],
                                'general_content_info' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'General Settings'
                                ],
                                'align' => [
                                    'type' => 'select.select',
                                    'label' => 'Text Alignment',
                                    'description' => 'Center, left and right alignment may depend on a breakpoint and require a fallback.',
                                    'default' => 'inherit',
                                    'options' => [
                                        'inherit' => 'None',
                                        'left' => 'Left',
                                        'center' => 'Center',
                                        'right' => 'Right',
                                        'justify' => 'Justify'
                                    ]
                                ],
                                'breakpoint' => [
                                    'type' => 'select.select',
                                    'label' => 'Alignment Breakpoint',
                                    'description' => 'Define the device width from which the alignment will apply.',
                                    'default' => 'always',
                                    'options' => [
                                        'always' => 'Always',
                                        's' => 'Small (Phone Landscape)',
                                        'm' => 'Medium (Tablet Landscape)',
                                        'l' => 'Large (Desktop)',
                                        'xl' => 'X-Large (Large Screens)'
                                    ]
                                ],
                                'fallback' => [
                                    'type' => 'select.select',
                                    'label' => 'Alignment Fallback',
                                    'description' => 'Define an alignment fallback for device widths below the breakpoint.',
                                    'default' => 'inherit',
                                    'options' => [
                                        'inherit' => 'None',
                                        'left' => 'Left',
                                        'center' => 'Center',
                                        'right' => 'Right',
                                        'justify' => 'Justify'
                                    ]
                                ],
                                'g_maxwidth' => [
                                    'type' => 'select.select',
                                    'label' => 'Max Width',
                                    'description' => 'Set the maximum content width.',
                                    'default' => 'inherit',
                                    'options' => [
                                        'inherit' => 'None',
                                        'small' => 'Small',
                                        'medium' => 'Medium',
                                        'large' => 'Large',
                                        'xlarge' => 'X-Large',
                                        'xxlarge' => 'XX-Large'
                                    ]
                                ],
                                'g_maxwidth_alignment' => [
                                    'type' => 'select.select',
                                    'label' => 'Max Width Alignment',
                                    'description' => 'Define the alignment in case the container exceeds the element\'s max-width.',
                                    'default' => 'left',
                                    'options' => [
                                        'left' => 'Left',
                                        'center' => 'Center',
                                        'right' => 'Right'
                                    ]
                                ],
                                'g_maxwidth_breakpoint' => [
                                    'type' => 'select.select',
                                    'label' => 'Max Width Breakpoint',
                                    'description' => 'Define the device width from which the element\'s max-width will apply.',
                                    'default' => 'always',
                                    'options' => [
                                        'always' => 'Always',
                                        's' => 'Small (Phone Landscape)',
                                        'm' => 'Medium (Tablet Landscape)',
                                        'l' => 'Large (Desktop)',
                                        'xl' => 'X-Large (Large Screens)'
                                    ]
                                ],
                                'margin' => [
                                    'type' => 'select.select',
                                    'label' => 'Margin',
                                    'description' => 'Set the vertical margin.',
                                    'default' => 'inherit',
                                    'options' => [
                                        'inherit' => 'Keep existing',
                                        'small' => 'Small',
                                        'default' => 'Default',
                                        'medium' => 'Medium',
                                        'large' => 'Large',
                                        'xlarge' => 'X-Large',
                                        'remove-vertical' => 'None'
                                    ]
                                ],
                                'visibility' => [
                                    'type' => 'select.select',
                                    'label' => 'Visibility',
                                    'description' => 'Display the element only on this device width and larger.',
                                    'default' => 'inherit',
                                    'options' => [
                                        'inherit' => 'Always',
                                        's' => 'Small (Phone Landscape)',
                                        'm' => 'Medium (Tablet Landscape)',
                                        'l' => 'Large (Desktop)',
                                        'xl' => 'X-Large (Large Screens)'
                                    ]
                                ],
                                'general_animation_info' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Animation Settings'
                                ],
                                'animation' => [
                                    'type' => 'select.select',
                                    'label' => 'Animation',
                                    'description' => 'Apply an animation to particles once they enter the viewport. This will animate all particles inside the section.',
                                    'default' => 'inherit',
                                    'options' => [
                                        'inherit' => 'None',
                                        'fade' => 'Fade',
                                        'scale-up' => 'Scale Up',
                                        'scale-down' => 'Scale Down',
                                        'slide-top-small' => 'Slide Top Small',
                                        'slide-bottom-small' => 'Slide Bottom Small',
                                        'slide-left-small' => 'Slide Left Small',
                                        'slide-right-small' => 'Slide Right Small',
                                        'slide-top-medium' => 'Slide Top Medium',
                                        'slide-bottom-medium' => 'Slide Bottom Medium',
                                        'slide-left-medium' => 'Slide Left Medium',
                                        'slide-right-medium' => 'Slide Right Medium',
                                        'slide-top' => 'Slide Top 100%',
                                        'slide-bottom' => 'Slide Bottom 100%',
                                        'slide-left' => 'Slide Left 100%',
                                        'slide-right' => 'Slide Right 100%',
                                        'parallax' => 'Parallax'
                                    ]
                                ],
                                'animation_delay' => [
                                    'type' => 'input.number',
                                    'label' => 'Animation Delay',
                                    'description' => 'Set the delay animations for particle. Delay time in ms.',
                                    'min' => 0,
                                    'placeholder' => 200
                                ],
                                'animation_repeat' => [
                                    'type' => 'select.select',
                                    'label' => 'Animation Repeat',
                                    'description' => 'Repeat an animation to particle once it enter the viewport.',
                                    'default' => 'disabled',
                                    'options' => [
                                        'enabled' => 'Enable',
                                        'disabled' => 'Disable'
                                    ]
                                ]
                            ]
                        ],
                        '_tab_parallax_animation' => [
                            'label' => 'Parallax',
                            'overridable' => false,
                            'fields' => [
                                'pa_overlay_info' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Overlay Parallax Settings'
                                ],
                                'pa_overlay_horizontal_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Horizontal Start',
                                    'description' => 'Animate the horizontal position (translateX) in pixels. Min:-600 and Max:600.',
                                    'min' => -600,
                                    'max' => 600,
                                    'placeholder' => 0
                                ],
                                'pa_overlay_horizontal_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Horizontal End',
                                    'description' => 'Animate the horizontal position (translateX) in pixels. Min:-600 and Max:600.',
                                    'min' => -600,
                                    'max' => 600,
                                    'placeholder' => 0
                                ],
                                'pa_overlay_vertical_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Vertical Start',
                                    'description' => 'Animate the vertical position (translateY) in pixels. Min:-600 and Max:600.',
                                    'min' => -600,
                                    'max' => 600,
                                    'placeholder' => 0
                                ],
                                'pa_overlay_vertical_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Vertical End',
                                    'description' => 'Animate the vertical position (translateY) in pixels. Min:-600 and Max:600.',
                                    'min' => -600,
                                    'max' => 600,
                                    'placeholder' => 0
                                ],
                                'pa_overlay_scale_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Scale Start',
                                    'description' => 'Animate the scaling. 100 means 100% scale, 200 means 200% scale, and 50 means 50% scale. NOTE:Min 30 and Max 400',
                                    'min' => 30,
                                    'max' => 400,
                                    'placeholder' => 100
                                ],
                                'pa_overlay_scale_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Scale End',
                                    'description' => 'Animate the scaling. 100 means 100% scale, 200 means 200% scale, and 50 means 50% scale. NOTE:Min 30 and Max 400',
                                    'min' => 30,
                                    'max' => 400,
                                    'placeholder' => 100
                                ],
                                'pa_overlay_rotate_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Rotate Start',
                                    'description' => 'Animate the rotation clockwise in degrees. NOTE:Min 0 and Max 360',
                                    'min' => 0,
                                    'max' => 360,
                                    'placeholder' => 0
                                ],
                                'pa_overlay_rotate_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Rotate End',
                                    'description' => 'Animate the rotation clockwise in degrees. NOTE:Min 0 and Max 360',
                                    'min' => 0,
                                    'max' => 360,
                                    'placeholder' => 0
                                ],
                                'pa_overlay_opacity_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Opacity Start',
                                    'description' => 'Animate the opacity. 100 means 100% opacity, 0 means 0% opacity and 50 means 50%. NOTE:Min 0 and Max 100',
                                    'min' => 0,
                                    'max' => 100,
                                    'placeholder' => 100
                                ],
                                'pa_overlay_opacity_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Opacity End',
                                    'description' => 'Animate the opacity. 100 means 100% opacity, 0 means 0% opacity and 50 means 50%. NOTE:Min 0 and Max 100',
                                    'min' => 0,
                                    'max' => 100,
                                    'placeholder' => 100
                                ],
                                'pa_title_info' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Title Parallax Settings'
                                ],
                                'pa_title_horizontal_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Horizontal Start',
                                    'description' => 'Animate the horizontal position (translateX) in pixels. Min:-600 and Max:600.',
                                    'min' => -600,
                                    'max' => 600,
                                    'placeholder' => 0
                                ],
                                'pa_title_horizontal_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Horizontal End',
                                    'description' => 'Animate the horizontal position (translateX) in pixels. Min:-600 and Max:600.',
                                    'min' => -600,
                                    'max' => 600,
                                    'placeholder' => 0
                                ],
                                'pa_title_vertical_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Vertical Start',
                                    'description' => 'Animate the vertical position (translateY) in pixels. Min:-600 and Max:600.',
                                    'min' => -600,
                                    'max' => 600,
                                    'placeholder' => 0
                                ],
                                'pa_title_vertical_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Vertical End',
                                    'description' => 'Animate the vertical position (translateY) in pixels. Min:-600 and Max:600.',
                                    'min' => -600,
                                    'max' => 600,
                                    'placeholder' => 0
                                ],
                                'pa_title_scale_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Scale Start',
                                    'description' => 'Animate the scaling. 100 means 100% scale, 200 means 200% scale, and 50 means 50% scale. NOTE:Min 30 and Max 400',
                                    'min' => 30,
                                    'max' => 400,
                                    'placeholder' => 100
                                ],
                                'pa_title_scale_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Scale End',
                                    'description' => 'Animate the scaling. 100 means 100% scale, 200 means 200% scale, and 50 means 50% scale. NOTE:Min 30 and Max 400',
                                    'min' => 30,
                                    'max' => 400,
                                    'placeholder' => 100
                                ],
                                'pa_title_rotate_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Rotate Start',
                                    'description' => 'Animate the rotation clockwise in degrees. NOTE:Min 0 and Max 360',
                                    'min' => 0,
                                    'max' => 360,
                                    'placeholder' => 0
                                ],
                                'pa_title_rotate_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Rotate End',
                                    'description' => 'Animate the rotation clockwise in degrees. NOTE:Min 0 and Max 360',
                                    'min' => 0,
                                    'max' => 360,
                                    'placeholder' => 0
                                ],
                                'pa_title_opacity_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Opacity Start',
                                    'description' => 'Animate the opacity. 100 means 100% opacity, 0 means 0% opacity and 50 means 50%. NOTE:Min 0 and Max 100',
                                    'min' => 0,
                                    'max' => 100,
                                    'placeholder' => 100
                                ],
                                'pa_title_opacity_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Opacity End',
                                    'description' => 'Animate the opacity. 100 means 100% opacity, 0 means 0% opacity and 50 means 50%. NOTE:Min 0 and Max 100',
                                    'min' => 0,
                                    'max' => 100
                                ],
                                'pa_meta_info' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Meta Parallax Settings'
                                ],
                                'pa_meta_horizontal_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Horizontal Start',
                                    'description' => 'Animate the horizontal position (translateX) in pixels. Min:-600 and Max:600.',
                                    'min' => -600,
                                    'max' => 600,
                                    'placeholder' => 0
                                ],
                                'pa_meta_horizontal_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Horizontal End',
                                    'description' => 'Animate the horizontal position (translateX) in pixels. Min:-600 and Max:600.',
                                    'min' => -600,
                                    'max' => 600,
                                    'placeholder' => 0
                                ],
                                'pa_meta_vertical_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Vertical Start',
                                    'description' => 'Animate the vertical position (translateY) in pixels. Min:-600 and Max:600.',
                                    'min' => -600,
                                    'max' => 600,
                                    'placeholder' => 0
                                ],
                                'pa_meta_vertical_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Vertical End',
                                    'description' => 'Animate the vertical position (translateY) in pixels. Min:-600 and Max:600.',
                                    'min' => -600,
                                    'max' => 600,
                                    'placeholder' => 0
                                ],
                                'pa_meta_scale_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Scale Start',
                                    'description' => 'Animate the scaling. 100 means 100% scale, 200 means 200% scale, and 50 means 50% scale. NOTE:Min 30 and Max 400',
                                    'min' => 30,
                                    'max' => 400,
                                    'placeholder' => 100
                                ],
                                'pa_meta_scale_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Scale End',
                                    'description' => 'Animate the scaling. 100 means 100% scale, 200 means 200% scale, and 50 means 50% scale. NOTE:Min 30 and Max 400',
                                    'min' => 30,
                                    'max' => 400,
                                    'placeholder' => 100
                                ],
                                'pa_meta_rotate_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Rotate Start',
                                    'description' => 'Animate the rotation clockwise in degrees. NOTE:Min 0 and Max 360',
                                    'min' => 0,
                                    'max' => 360,
                                    'placeholder' => 0
                                ],
                                'pa_meta_rotate_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Rotate End',
                                    'description' => 'Animate the rotation clockwise in degrees. NOTE:Min 0 and Max 360',
                                    'min' => 0,
                                    'max' => 360,
                                    'placeholder' => 0
                                ],
                                'pa_meta_opacity_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Opacity Start',
                                    'description' => 'Animate the opacity. 100 means 100% opacity, 0 means 0% opacity and 50 means 50%. NOTE:Min 0 and Max 100',
                                    'min' => 0,
                                    'max' => 100,
                                    'placeholder' => 100
                                ],
                                'pa_meta_opacity_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Opacity End',
                                    'description' => 'Animate the opacity. 100 means 100% opacity, 0 means 0% opacity and 50 means 50%. NOTE:Min 0 and Max 100',
                                    'min' => 0,
                                    'max' => 100,
                                    'placeholder' => 100
                                ],
                                'pa_content_info' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Content Parallax Settings'
                                ],
                                'pa_content_horizontal_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Horizontal Start',
                                    'description' => 'Animate the horizontal position (translateX) in pixels. Min:-600 and Max:600.',
                                    'min' => -600,
                                    'max' => 600,
                                    'placeholder' => 0
                                ],
                                'pa_content_horizontal_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Horizontal End',
                                    'description' => 'Animate the horizontal position (translateX) in pixels. Min:-600 and Max:600.',
                                    'min' => -600,
                                    'max' => 600,
                                    'placeholder' => 0
                                ],
                                'pa_content_vertical_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Vertical Start',
                                    'description' => 'Animate the vertical position (translateY) in pixels. Min:-600 and Max:600.',
                                    'min' => -600,
                                    'max' => 600,
                                    'placeholder' => 0
                                ],
                                'pa_content_vertical_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Vertical End',
                                    'description' => 'Animate the vertical position (translateY) in pixels. Min:-600 and Max:600.',
                                    'min' => -600,
                                    'max' => 600,
                                    'placeholder' => 0
                                ],
                                'pa_content_scale_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Scale Start',
                                    'description' => 'Animate the scaling. 100 means 100% scale, 200 means 200% scale, and 50 means 50% scale. NOTE:Min 30 and Max 400',
                                    'min' => 30,
                                    'max' => 400,
                                    'placeholder' => 100
                                ],
                                'pa_content_scale_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Scale End',
                                    'description' => 'Animate the scaling. 100 means 100% scale, 200 means 200% scale, and 50 means 50% scale. NOTE:Min 30 and Max 400',
                                    'min' => 30,
                                    'max' => 400,
                                    'placeholder' => 100
                                ],
                                'pa_content_rotate_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Rotate Start',
                                    'description' => 'Animate the rotation clockwise in degrees. NOTE:Min 0 and Max 360',
                                    'min' => 0,
                                    'max' => 360,
                                    'placeholder' => 0
                                ],
                                'pa_content_rotate_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Rotate End',
                                    'description' => 'Animate the rotation clockwise in degrees. NOTE:Min 0 and Max 360',
                                    'min' => 0,
                                    'max' => 360,
                                    'placeholder' => 0
                                ],
                                'pa_content_opacity_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Opacity Start',
                                    'description' => 'Animate the opacity. 100 means 100% opacity, 0 means 0% opacity and 50 means 50%. NOTE:Min 0 and Max 100',
                                    'min' => 0,
                                    'max' => 100,
                                    'placeholder' => 100
                                ],
                                'pa_content_opacity_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Opacity End',
                                    'description' => 'Animate the opacity. 100 means 100% opacity, 0 means 0% opacity and 50 means 50%. NOTE:Min 0 and Max 100',
                                    'min' => 0,
                                    'max' => 100,
                                    'placeholder' => 100
                                ],
                                'pa_link_info' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Button Parallax Settings'
                                ],
                                'pa_link_horizontal_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Horizontal Start',
                                    'description' => 'Animate the horizontal position (translateX) in pixels. Min:-600 and Max:600.',
                                    'min' => -600,
                                    'max' => 600,
                                    'placeholder' => 0
                                ],
                                'pa_link_horizontal_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Horizontal End',
                                    'description' => 'Animate the horizontal position (translateX) in pixels. Min:-600 and Max:600.',
                                    'min' => -600,
                                    'max' => 600,
                                    'placeholder' => 0
                                ],
                                'pa_link_vertical_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Vertical Start',
                                    'description' => 'Animate the vertical position (translateY) in pixels. Min:-600 and Max:600.',
                                    'min' => -600,
                                    'max' => 600,
                                    'placeholder' => 0
                                ],
                                'pa_link_vertical_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Vertical End',
                                    'description' => 'Animate the vertical position (translateY) in pixels. Min:-600 and Max:600.',
                                    'min' => -600,
                                    'max' => 600,
                                    'placeholder' => 0
                                ],
                                'pa_link_scale_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Scale Start',
                                    'description' => 'Animate the scaling. 100 means 100% scale, 200 means 200% scale, and 50 means 50% scale. NOTE:Min 30 and Max 400',
                                    'min' => 30,
                                    'max' => 400,
                                    'placeholder' => 100
                                ],
                                'pa_link_scale_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Scale End',
                                    'description' => 'Animate the scaling. 100 means 100% scale, 200 means 200% scale, and 50 means 50% scale. NOTE:Min 30 and Max 400',
                                    'min' => 30,
                                    'max' => 400,
                                    'placeholder' => 100
                                ],
                                'pa_link_rotate_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Rotate Start',
                                    'description' => 'Animate the rotation clockwise in degrees. NOTE:Min 0 and Max 360',
                                    'min' => 0,
                                    'max' => 360,
                                    'placeholder' => 0
                                ],
                                'pa_link_rotate_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Rotate End',
                                    'description' => 'Animate the rotation clockwise in degrees. NOTE:Min 0 and Max 360',
                                    'min' => 0,
                                    'max' => 360,
                                    'placeholder' => 0
                                ],
                                'pa_link_opacity_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Opacity Start',
                                    'description' => 'Animate the opacity. 100 means 100% opacity, 0 means 0% opacity and 50 means 50%. NOTE:Min 0 and Max 100',
                                    'min' => 0,
                                    'max' => 100,
                                    'placeholder' => 100
                                ],
                                'pa_link_opacity_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Opacity End',
                                    'description' => 'Animate the opacity. 100 means 100% opacity, 0 means 0% opacity and 50 means 50%. NOTE:Min 0 and Max 100',
                                    'min' => 0,
                                    'max' => 100,
                                    'placeholder' => 100
                                ],
                                'general_parallax_info' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Global Parallax Settings'
                                ],
                                'pa_horizontal_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Horizontal Start',
                                    'description' => 'Animate the horizontal position (translateX) in pixels. Min:-600 and Max:600.',
                                    'min' => -600,
                                    'max' => 600,
                                    'placeholder' => 0
                                ],
                                'pa_horizontal_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Horizontal End',
                                    'description' => 'Animate the horizontal position (translateX) in pixels. Min:-600 and Max:600.',
                                    'min' => -600,
                                    'max' => 600,
                                    'placeholder' => 0
                                ],
                                'pa_vertical_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Vertical Start',
                                    'description' => 'Animate the vertical position (translateY) in pixels. Min:-600 and Max:600.',
                                    'min' => -600,
                                    'max' => 600,
                                    'placeholder' => 0
                                ],
                                'pa_vertical_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Vertical End',
                                    'description' => 'Animate the vertical position (translateY) in pixels. Min:-600 and Max:600.',
                                    'min' => -600,
                                    'max' => 600,
                                    'placeholder' => 0
                                ],
                                'scale_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Scale Start',
                                    'description' => 'Animate the scaling. 100 means 100% scale, 200 means 200% scale, and 50 means 50% scale. NOTE:Min 30 and Max 400',
                                    'min' => 30,
                                    'max' => 400,
                                    'placeholder' => 100
                                ],
                                'scale_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Scale End',
                                    'description' => 'Animate the scaling. 100 means 100% scale, 200 means 200% scale, and 50 means 50% scale. NOTE:Min 30 and Max 400',
                                    'min' => 30,
                                    'max' => 400,
                                    'placeholder' => 100
                                ],
                                'rotate_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Rotate Start',
                                    'description' => 'Animate the rotation clockwise in degrees. NOTE:Min 0 and Max 360',
                                    'min' => 0,
                                    'max' => 360,
                                    'placeholder' => 0
                                ],
                                'rotate_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Rotate End',
                                    'description' => 'Animate the rotation clockwise in degrees. NOTE:Min 0 and Max 360',
                                    'min' => 0,
                                    'max' => 360,
                                    'placeholder' => 0
                                ],
                                'opacity_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Opacity Start',
                                    'description' => 'Animate the opacity. 100 means 100% opacity, 0 means 0% opacity and 50 means 50%. NOTE:Min 0 and Max 100',
                                    'min' => 0,
                                    'max' => 100,
                                    'placeholder' => 100
                                ],
                                'opacity_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Opacity End',
                                    'description' => 'Animate the opacity. 100 means 100% opacity, 0 means 0% opacity and 50 means 50%. NOTE:Min 0 and Max 100',
                                    'min' => 0,
                                    'max' => 100,
                                    'placeholder' => 100
                                ],
                                'easing' => [
                                    'type' => 'input.number',
                                    'label' => 'Easing',
                                    'description' => 'Determine how the speed of the animation behaves over time. A value below 100 is faster in the beginning and slower towards the end while a value above 100 behaves inversely. Min 10 and Max 200',
                                    'min' => 10,
                                    'max' => 200,
                                    'placeholder' => 10
                                ],
                                'pa_viewport' => [
                                    'type' => 'input.number',
                                    'label' => 'Viewport',
                                    'description' => 'Set the animation end point relative to viewport height, e.g. 50 for 50% of the viewport. Min 10 and Max 100',
                                    'min' => 10,
                                    'max' => 100,
                                    'placeholder' => 50
                                ],
                                'pa_breakpoint' => [
                                    'type' => 'select.select',
                                    'label' => 'Breakpoint',
                                    'description' => 'Display the parallax effect only on this device width and larger.',
                                    'default' => 'always',
                                    'options' => [
                                        'always' => 'Always',
                                        's' => 'Small (Phone Landscape)',
                                        'm' => 'Medium (Tablet Landscape)',
                                        'l' => 'Large (Desktop)',
                                        'xl' => 'X-Large (Large Screens)'
                                    ]
                                ]
                            ]
                        ]
                    ]
                ],
                'copyright' => [
                    'type' => 'separator.note',
                    'class' => 'alert alert-success',
                    'content' => 'JL Slideshow <strong>Version: 2.1.3</strong> Copyright (C) <a href="https://joomlead.com/" target="_blank">https://joomlead.com</a> | <a href="https://joomlead.com/g5/docs/slideshow-particle/" target="_blank">Documentation</a>'
                ]
            ]
        ]
    ]
];
