<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				fdsh 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.36
	@build			28th March, 2023
	@created		17th December, 2020
	@package		Reservation
	@subpackage		helpdesk_bale_sms.php
	@author			farhad shahbazi <http://farhad.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');


/***[JCBGUI.class_extends.head.1.$$$$]***/

use Joomla\CMS\Application\CMSApplication;
use Joomla\CMS\Plugin\CMSPlugin;
/***[/JCBGUI$$$$]***/


/***[JCBGUI.class_extends.comment.1.$$$$]***/
/**
 * Helpdeskpro - Helpdesk_bale_sms plugin.
 *
 * @package   Helpdesk_bale_sms
 * @since     1.0.0
 *//***[/JCBGUI$$$$]***/

class PlgHelpdeskproHelpdesk_bale_sms extends CMSPlugin
{

/***[JCBGUI.joomla_plugin.main_class_code.1.$$$$]***/
public function onAfterStoreTicket($row)
{
    require_once __DIR__.'/classes/send.php';
    $bale_id= $this->params->get('bale_id',0);
    $params= [
        'bale_id'=> $bale_id,
        'id'=> $row->get('id'),
        'subject'=> $row->get('subject'),
        'message'=> $row->get('message'),
        'name'=> $row->get('name'),
        'created_date'=> $row->get('created_date'),
        'status_id'=> $row->get('status_id'),
        'priority_id'=> $row->get('priority_id'),
        'category_id'=> $row->get('category_id'),
        'user_id'=> $row->get('user_id')
    ];


    $db = JFactory::getDbo();

    $query = $db->getQuery(true);
    $query->select('title');
    $query->from($db->quoteName('#__helpdeskpro_statuses'));
    $query->where($db->quoteName('id').'='.$db->quote($params['status_id']));
    $db->setQuery($query);
    $params['status_title'] = $db->loadResult();


    $query = $db->getQuery(true);
    $query->select('title');
    $query->from($db->quoteName('#__helpdeskpro_priorities'));
    $query->where($db->quoteName('id').'='.$db->quote($params['priority_id']));
    $db->setQuery($query);
    $params['priority_title'] = $db->loadResult();


    $query = $db->getQuery(true);
    $query->select('title');
    $query->from($db->quoteName('#__helpdeskpro_categories'));
    $query->where($db->quoteName('id').'='.$db->quote($params['category_id']));
    $db->setQuery($query);
    $params['category_title'] = $db->loadResult();

//    echo '<pre>';
//    var_dump($row);
//    echo '</pre>';
//    exit();
    $text= "
    شناسه تیکت : {$params['id']}
    نام فرستنده : {$params['name']}
    مجموعه : {$params['category_title']}
    وضعیت : {$params['status_title']}
    اولویت : {$params['priority_title']}
    تاریخ ایجاد : {$params['created_date']}
    موضوع : {$params['subject']}
    متن : {$params['message']} ";


    $send= new send;

    foreach (explode(',',$params['bale_id']) as $item) {
        $data[]= ['chat_id'=> $item, 'text'=>$text];
    }

    $send->send_bale_message($data);
    
    $mobile_number_source = $this->params->get('mobile_number_source');
    $mobile_number_source_field = $this->params->get('mobile_number_source_field');
    $smsService_input_data = array(
        "username" => 'تیکت شما',
        "password" => 'ثبت شد',
        "link" => 'https://www.daneh.ir'
    );
    $smsService_pattern_code = $this->params->get('sms_pattern', 0);
    $smsService_username =  $this->params->get('sms_username', 0);
    $smsService_password =  $this->params->get('sms_password', 0);

    $mobile= $send->getMobile($mobile_number_source, $mobile_number_source_field, $params['user_id']);
    $send->send_sms($mobile, $smsService_input_data, $smsService_pattern_code, $smsService_username, $smsService_password);
}


public function onAfterStoreComment($row, $ticket)
{
    require_once __DIR__.'/classes/send.php';
    $bale_id= $this->params->get('bale_id',0);
    $params= [
        'bale_id'=> $bale_id,
        'id'=> $row->get('id'),
        'ticket_id'=> $row->get('ticket_id'),
        'user_id'=> $row->get('user_id'),
        'message'=> $row->get('message'),
        'name'=> $row->get('name'),
        'date_added'=> $row->get('date_added'),
    ];
    $user= JFactory::getUser($params['user_id']);
    $text= "
    #پاسخ
    شناسه تیکت : {$params['ticket_id']}
    شناسه تیکت پاسخ : {$params['id']}
    نام فرستنده : {$user->get('name')}
    تاریخ ایجاد : {$params['date_added']}
    متن : {$params['message']} ";

    $send= new send;

    foreach (explode(',',$params['bale_id']) as $item) {
        $data[]= ['chat_id'=> $item, 'text'=>$text];
    }

    $send->send_bale_message($data);

    $mobile_number_source = $this->params->get('mobile_number_source');
    $mobile_number_source_field = $this->params->get('mobile_number_source_field');
    $smsService_input_data = array(
        "username" => 'تیکت شما',
        "password" => 'پاسخ داده شد',
        "link" => 'https://www.daneh.ir'
    );
    $smsService_pattern_code = $this->params->get('sms_pattern', 0);
    $smsService_username =  $this->params->get('sms_username', 0);
    $smsService_password =  $this->params->get('sms_password', 0);

    $mobile= $send->getMobile($mobile_number_source, $mobile_number_source_field, $params['user_id']);
    $send->send_sms($mobile, $smsService_input_data, $smsService_pattern_code, $smsService_username, $smsService_password);

}

    public function onViewTicket($row)
    {
//        echo '<pre>';
//        var_dump($row);
//        echo '</pre>';
//        exit();
    }

}/***[/JCBGUI$$$$]***/

}
