<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Filesystem\File;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Router\Route;

class plgHelpdeskProAttachments extends CMSPlugin
{
	/**
	 * Display list of attachments for this ticket
	 *
	 * @param $row
	 *
	 * @return null|string
	 */
	public function onViewTicket($row)
	{
		$db    = JFactory::getDbo();
		$query = $db->getQuery(true);

		$query->select('attachments, original_filenames')
			->from('#__helpdeskpro_messages')
			->where('ticket_id = ' . $row->id);
		$db->setQuery($query);
		$rowAttachments = array_merge(array($row), $db->loadObjectList());
		$hasAttachment  = false;

		foreach ($rowAttachments As $rowAttachment)
		{
			if ($rowAttachment->original_filenames)
			{
				$hasAttachment = true;
				break;
			}
		}


		if ($hasAttachment)
		{
			ob_start();
			?>
			<tr>
				<th colspan="2"><?php echo Text::_('HDP_TICKET_ATTACHMENTS'); ?></th>
			</tr>
			<?php
			$imageFileTypes  = array('gif', 'jpg', 'jpeg', 'png');
			$attachmentsPath = JPATH_ROOT . '/media/com_helpdeskpro/attachments/';

			foreach ($rowAttachments as $rowAttachment)
			{
				if ($rowAttachment->original_filenames)
				{
					$originalFileNames = explode('|', $rowAttachment->original_filenames);
					$attachments       = explode('|', $rowAttachment->attachments);

					for ($i = 0, $n = count($originalFileNames); $i < $n; $i++)
					{
						$filename = $attachments[$i];
						$filePath = $attachmentsPath . $filename;

						if (file_exists($attachmentsPath . $filename))
						{
							$fileExt = strtolower(File::getExt($filename));

							if (in_array($fileExt, $imageFileTypes))
							{
								$linkClass = 'class="hdp-modal"';
							}
							else
							{
								$linkClass = '';
							}
							?>
							<tr>
								<td colspan="2">
									<a <?php echo $linkClass; ?>
										href="<?php echo Route::_('index.php?option=com_helpdeskpro&task=ticket.download_attachment&filename=' . $filename . '&original_filename=' . $originalFileNames[$i]); ?>"><?php echo $originalFileNames[$i]; ?></a>
									(<?php echo HelpdeskproHelper::getSize($filePath); ?>)
								</td>
							</tr>
							<?php
						}
					}
				}
			}

			return ob_get_clean();
		}

		return null;
	}
}	