<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Plugin\PluginHelper;

class plgHelpdeskProTicketHistory extends CMSPlugin
{
	public function onViewTicket($row)
	{
		$limit      = (int) $this->params->get('limit', 10);
		$dateFormat = $this->params->get('date_format', 'm-d-Y');
		$db         = JFactory::getDbo();
		$query      = $db->getQuery(true);

		$query->select('id, subject, created_date')
			->from('#__helpdeskpro_tickets')
			->where('(user_id = ' . (int) $row->user_id . ' OR email = ' . $db->quote($row->email) . ')')
			->order('id DESC');
		$db->setQuery($query, 0, $limit);
		$rows = $db->loadObjectList();

		if (count($rows))
		{
			// Get the path for the layout file
			$path = PluginHelper::getLayoutPath('helpdeskpro', 'tickethistory');

			// Render the layout
			ob_start();
			include $path;
			return ob_get_clean();
		}

		return null;
	}
}	