<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				Vast Development Method 
/-------------------------------------------------------------------------------------------------------/

	@version		2.0.3
	@build			2nd September, 2023
	@created		18th October, 2016
	@package		Demo
	@subpackage		default.php
	@author			Llewellyn van der Merwe <https://www.vdm.io/>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

?>

<style>
    .select-category label {
        width: 89%;
    }

    .color-0,
    .color-4,
    .color-9 {
        background: #99dbd4;
        border: #99dbd4;
    }

    .color-1,
    .color-5,
    .color-8 {
        background: rgba(167, 159, 231, 1);
        border: rgba(167, 159, 231, 1);
    }

    .color-2,
    .color-6,
    .color-10 {
        background: #9fc3e3;
        border: #9fc3e3;
    }

    .color-3,
    .color-7 {
        background: #e9a6aa;
        border: #e9a6aa;
    }

    .select-category label {
        color: black;
    }

    .button-eram {
        padding: 10px;
        border-radius: 10px;
        margin-top: 40px
    }

    .button-eram-next {
        background: #63b2c5;
        color: #fff;
    }

    .button-eram-next-disabled {
        background: #c6c6c6;
        color: #fff;
    }

    .card-body {
        box-shadow: 0 0 5px #00000038;
        padding: 20px;
        border-radius: 10px;
    }

    .button-eram {
        padding: 10px;
        border-radius: 10px;
        margin-top: 0px;
        vertical-align: text-bottom;
    }

    .countdown {
        display: inline-block;
    }

    .countdown-text {
        vertical-align: text-bottom;
        display: inline-block;
        padding: 10px;
    }
</style>
<div class="container">
    <div class="row">
        <div class="col-md-6 offset-md-3">
            <?php if ($user->guest): ?>
                <div class="">
                    <div class="card-body">
                        <div class="text-center">
                            <div class="card-title mb-2">برای ثبت درخواست اورژانسی ابتدا باید وارد شوید</div>
                            <?php
                            $returnUrl = (string)juri::getinstance();
                            $returnUrl = urlencode($returnUrl);
                            ?>
                            <a rel="nofollow"
                               href="<?= JRoute::_('index.php?option=com_reservation&view=login&returnUrl=' . $returnUrl, false); ?>">ورود
                                سریع</a>
                        </div>
                    </div>
                </div>
            <?php else: ?>
                <form action="" method="post">
                    <div class="card">
                        <div class="card-body">
                            <h6 class="card-subtitle text-muted">مشاوره اورژانسی</h6>
                            <h5 class="card-title mb-2">در کدام زمینه مشاوره میخواهید؟</h5>
                            <div class="select-category" style="text-align: center">

                                <?php foreach ($topics as $index => $topic): ?>

                                    <?php if ($index % 2 == 0): ?>
                                        <div style="height: 5px"></div>
                                    <?php endif; ?>
                                    <div class="mb-2">
                                        <input type="radio" id="input_<?= $index; ?>" name="topic"
                                               value="<?= $topic->fieldlabel; ?>"/>
                                        <label for="input_<?= $index; ?>"
                                               class="btn btn-primary color-<?= $index; ?>"><?= $topic->fieldlabel; ?></label>
                                    </div>


                                <?php endforeach; ?>

                            </div>

                            <input type="hidden" name="step_0" value="true">
                            <button type="submit"
                                    class="button-eram <?php echo $nextStepButtonCssClass; ?>"
                            <?php if (!$is15MinPastSinceUserLastEmrgReq) { echo 'disabled="disabled"'; } ?>
                            >مرحله بعد</button>
                            <?php
                            if (!$is15MinPastSinceUserLastEmrgReq) {
                                ?>
                                <div class="countdown-text">
                                    زمان انتظار جهت ثبت درخواست مجدد:
                                </div>
                                <div style="direction: ltr" class="countdown"
                                     data-date="<?php echo $cb_user_emrg_creat_date_plus_15min ?>"
                                     data-time="<?php echo $cb_user_emrg_creat_time_plus_15min ?>"></div>
                                <?php
                            }
                            ?>
                        </div>
                    </div>
                </form>
            <?php endif; ?>


        </div>
    </div>
</div>



