<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				Lmskaran 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.63
	@build			10th May, 2021
	@created		22nd July, 2020
	@package		Moojla
	@subpackage		fulllanguage.php
	@author			Lmskaran <http://Lmskaran.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

// import the list field type
jimport('joomla.form.helper');
JFormHelper::loadFieldClass('list');

/**
 * Fulllanguage Form Field class for the Moojla component
 */
class JFormFieldFulllanguage extends JFormFieldList
{
	/**
	 * The fulllanguage field type.
	 *
	 * @var		string
	 */
	public $type = 'fulllanguage';

	/**
	 * Method to get a list of options for a list input.
	 *
	 * @return	array    An array of JHtml options.
	 */
	protected function getOptions()
	{
		
		$script = '
jQuery(document).ready(function($){
	langselector = $("#myform_language");
	langselector.change(function(e){
		lang = $(this).val();
		originalTextArea = $("#myform_original_translation");
		overrideTextArea = $("#myform_override");
		if(lang){
			isAdmin = lang.substr(-1) == 1 ? true : false;
			code = lang.substr(0, lang.length - 1);
			url = `/${isAdmin ? "administrator/" : ""}language/overrides/${code}.override.ini`;
			// console.log(url);
			jQuery.ajax({
				url: url,
				cache: false,
				beforeSend: function(){
					// console.log("beforeSend");
					overrideTextArea.val("Wait please ...");
				},
				success: function(data, textStatus, xhr){
					ct = xhr.getResponseHeader("content-type") || "";
					// console.log("success");
					// console.log(ct);
					if(ct != "text/html; charset=utf-8")
						overrideTextArea.val(data);
					else
						overrideTextArea.val("");
				},
				error: function(data, textStatus, xhr){
					overrideTextArea.val("");
					// ct = xhr.getResponseHeader("content-type") || "";
					// console.log("error");
					// console.log(ct);
				},
			});

			url = `/${isAdmin ? "administrator/" : ""}language/${code}/${code}.com_moojla.ini`;
			// console.log(url);
			jQuery.ajax({
				url: url,
				cache: false,
				beforeSend: function(){
					// console.log("beforeSend");
					originalTextArea.val("Wait please ...");
				},
				success: function(data, textStatus, xhr){
					ct = xhr.getResponseHeader("content-type") || "";
					// console.log("success");
					// console.log(ct);
					if(ct != "text/html; charset=utf-8")
						originalTextArea.val(data);
					else
						originalTextArea.val("");
				},
				error: function(data, textStatus, xhr){
					ct = xhr.getResponseHeader("content-type") || "";
					// console.log("error");
					// console.log(ct);
				},
			});
		}
		else{
			overrideTextArea.val("");
			originalTextArea.val("");
		}
	});
})';
		$document = JFactory::getDocument();
		$document->addScriptDeclaration($script);

		$languages       = array();
		$languages[] = JHtml::_('select.option', '', 'Select an option');
		$site_languages  = JLanguageHelper::getKnownLanguages(JPATH_SITE);
		$admin_languages = JLanguageHelper::getKnownLanguages(JPATH_ADMINISTRATOR);
		// Create a single array of them.
		foreach ($site_languages as $tag => $language)
		{
			$languages[$tag . '0'] = $language['name'] . ' - ' . JText::_('JSITE');
		}

		foreach ($admin_languages as $tag => $language)
		{
			$languages[$tag . '1'] = $language['name'] . ' - ' . JText::_('JADMINISTRATOR');
		}

		// Sort it by language tag and by client after that.
		ksort($languages);

		return array_merge(parent::getOptions(), $languages);

	}
}
