<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				Lmskaran 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.77
	@build			6th April, 2022
	@created		22nd July, 2020
	@package		Moojla
	@subpackage		shopintegration.php
	@author			Lmskaran <http://Lmskaran.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

// import the list field type
jimport('joomla.form.helper');
JFormHelper::loadFieldClass('list');

/**
 * Shopintegration Form Field class for the Moojla component
 */
class JFormFieldShopintegration extends JFormFieldList
{
	/**
	 * The shopintegration field type.
	 *
	 * @var		string
	 */
	public $type = 'shopintegration';

	/**
	 * Method to get a list of options for a list input.
	 *
	 * @return	array    An array of JHtml options.
	 */
	protected function getOptions()
	{
		// Get the user object.

	    ?>
        <script>
            jQuery(document).ready(function($){
                
                var shop_integration_val= $('#jform_shop_integration').val();
                $('#jform_shop_integration').on('change', function() {
                    var val= $(this).val()
                    $('#shop_integration_message').remove();
                    $.ajax({
                        url: 'index.php?option=com_moojla',
                        method: 'post',
                        data: {'shop_name': val,'task':'ajax.shop_requirement','format':'json','raw':'true', 'token': '<?= JSession::getFormToken()?>'},
                        success: function(msg){
                            if (msg)
                            {
                                $('#jform_shop_integration').parents('.control-group').append('<div style="padding: 10px 0;" id="shop_integration_message"></div>')
                                msg.messages.each(function(value, index){
                                    $('#shop_integration_message').append('<div style="margin: 0;" class="alert alert-'+value.class+'">'+value.message+'</div>');
                                })
                            }
                        }
                    })
                });
            })
        </script>
<?php
		$user = JFactory::getUser();
		// Get the databse object.
		
		JPluginHelper::importPlugin("moojlashopintegration");
		$dispatcher = JEventDispatcher::getInstance();
		$items = $dispatcher->trigger("getShopIntegrationName", array());
		$options = array();
		$options[] = JHtml::_('select.option', '', 'Select an option');
		if ($items)
		{
			
			foreach($items as $item)
			{
				$options[] = JHtml::_('select.option', $item->id, $item->shop_integration_name);
			}
		}
		return $options;
	}
}
