<div class="container mt-5 mb-3">
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <h6 class="card-subtitle text-muted mt-1 me-1">مشاوره اورژانسی،
                        زمینه: <?= $cb_user->get('cb_emergency_topic'); ?></h6>
                    <img src="/modules/mod_emergencyconsultant/tmpl/assets/img/robot-searching.gif"
                         alt="robot searching for consultant image"
                         class="mt-3 mx-auto d-block">
                    <h5 class="card-title text-center pb-2">داریم برای شما دنبال مشاور میگردیم.</h5>
                    <div class="mt-4 text-center">
                        <p>
                            حداکثر زمان انتظار:
                        </p>
                    </div>
                    <div class="text-center mb-4">
                        <div style="direction: ltr;" class="countdown px-4 py-3 pb-4 d-inline-block"
                             data-date=""
                             data-time=""></div>
                    </div>
                </div>
            </div>


        </div>
    </div>
</div>

<script>

    jQuery(document).ready(function ($) {

        let token = Joomla.getOptions('csrf.token')

        function loadInformation() {
            let intervId= setInterval(function () {

                $.ajax({
                    url: 'index.php?option=com_ajax&module=emergencyconsultant&format=json',
                    method: 'get',
                    data: {token: token},
                    success: function (msg) {

                        if (msg.data)
                        {
                            clearInterval(intervId);
                            window.location.href = window.location.href
                        }

                    }
                })
            }, 1000);
        }

        loadInformation();

        function getDateAndTimeStr(datetimeObj) {
            const dateStr = datetimeObj.toISOString().split('T')[0];
            const timeStr = datetimeObj.toTimeString().slice(0, 8);
            return {dateStr: dateStr, timeStr: timeStr};
        }

        function setDateTimeOfCountdownTimer(datetimeObj) {
            const {dateStr, timeStr} = getDateAndTimeStr(datetimeObj);
            const countdownEl = $('.countdown');
            countdownEl.data('date', dateStr);
            countdownEl.data('time', timeStr);
        }

        const newCountdownDateTime = "<?php echo $countdownDateTime; ?>";
        const oldCountdownDateTime = localStorage.getItem('countdownDateTime');
        if (!oldCountdownDateTime) {
            localStorage.setItem('countdownDateTime', newCountdownDateTime);
        } else {
            const oldCdDate = new Date(oldCountdownDateTime);
            const newCdDate = new Date(newCountdownDateTime);
            const timeDiff = (newCdDate - oldCdDate) / 1000 / 60; // Convert to minutes
            if (timeDiff < 15) { // if oldCdDate is still valid (hasn't passed 15 min since)
                setDateTimeOfCountdownTimer(oldCdDate);
            } else {
                localStorage.setItem('countdownDateTime', newCountdownDateTime);
                setDateTimeOfCountdownTimer(newCdDate);
            }
        }

    })
    
</script>