<?php
/**
 * @package 	JF Login Pro
 * @author		JoomForest.com
 * @email		support@joomforest.com
 * @website		http://www.joomforest.com
 * @copyright	Copyright (C) 2011-2016 JoomForest.com, All rights reserved.
 * @license		http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
**/
// no direct access
defined('_JEXEC') or die('Restricted access');
require_once JPATH_SITE . '/components/com_users/helpers/route.php';
JHtml::_('behavior.keepalive');
?>
<div id="<?php echo $jf_l_pro_ID; ?>" class="jf_l_pro jf_l_pro_guest <?php echo $moduleclass_sfx; ?>">
	<a id="<?php echo $jf_l_pro_ID; ?>_btn" class="jf_l_pro_open_btn" title="<?php echo JText::_('MOD_JF_LOGIN_PRO_CLICK_TO_LOGIN'); ?>"><span></span></a>
	<div id="<?php echo $jf_l_pro_ID; ?>_backout" class="jf_l_pro_backout"></div>
	<div id="<?php echo $jf_l_pro_ID; ?>_popup" class="jf_l_pro_popup">
		<form action="<?php echo JRoute::_(htmlspecialchars(JUri::getInstance()->toString()), true, $params->get('usesecure')); ?>" method="post" id="jf_l_pro_login_form">
			<div class="jf_l_pro_title"><?php echo JText::_('MOD_JF_LOGIN_PRO_AUTHORIZATION') ?></div>
			<div class="jf_l_pro_inputwrapper">
				<label class="jf_l_pro_icon" for="jf_l_pro_input_username"><span class="jf_user"></span></label>
				<input id="jf_l_pro_input_username" type="text" name="username" class="jf_l_pro_input" tabindex="0" size="18" placeholder="<?php echo JText::_('MOD_JF_LOGIN_PRO_VALUE_USERNAME') ?>" />
			</div>
			<div class="jf_l_pro_inputwrapper">
				<label class="jf_l_pro_icon" for="jf_l_pro_input_passwd"><span class="jf_pass"></span></label>
				<input id="jf_l_pro_input_passwd" type="password" name="password" class="jf_l_pro_input" tabindex="0" size="18" placeholder="<?php echo JText::_('JGLOBAL_PASSWORD') ?>" />
			</div>
			<?php if (count($twofactormethods) > 1): ?>
			<div class="jf_l_pro_inputwrapper">
				<label class="jf_l_pro_icon" for="jf_l_pro_secretkey"><span class="jf_secret"></span></label>
				<input id="jf_l_pro_secretkey" autocomplete="off" type="text" name="secretkey" class="jf_l_pro_input" tabindex="0" size="18" placeholder="<?php echo JText::_('JGLOBAL_SECRETKEY') ?>" />
			</div>
			<?php endif; ?>
			
			<div style="clear:both;height:10px"></div>
			
			<?php if (JPluginHelper::isEnabled('system', 'remember')) : ?>
			<div class="jf_l_pro_rememberwrap">
				<label for="jf_l_pro_remember"><?php echo JText::_('MOD_JF_LOGIN_PRO_VALUE_REMEMBER_ME') ?></label>
				<label class="jf_l_pro_checkbox"><input id="jf_l_pro_remember" type="checkbox" name="remember" class="jf_l_pro_checkbox_input" value="yes"/><i></i></label>
			</div>
			<?php endif; ?>
		
			<button type="submit" tabindex="0" name="Submit" class="jf_l_pro_authoriz_btn"><?php echo JText::_('JLOGIN') ?></button>
			<input type="hidden" name="option" value="com_users" />
			<input type="hidden" name="task" value="user.login" />
			<input type="hidden" name="return" value="<?php echo $return; ?>" />
			<?php echo JHtml::_('form.token'); ?>
			<div style="clear:both"></div>
			
			<div class="jf_l_pro_pos_wrapper"></div>
			<div style="clear:both"></div>
			
			<ul class="jf_l_pro_forgot">
				<li class="first">
					<a href="<?php echo JRoute::_('index.php?option=com_users&view=reset&Itemid=' . UsersHelperRoute::getResetRoute()); ?>">
						<?php echo JText::_('MOD_JF_LOGIN_PRO_VALUE_FORGOT_YOUR_PASSWORD'); ?>
					</a>
				</li>
				<li class="last">
					<a href="<?php echo JRoute::_('index.php?option=com_users&view=remind&Itemid=' . UsersHelperRoute::getRemindRoute()); ?>">
						<?php echo JText::_('MOD_JF_LOGIN_PRO_VALUE_FORGOT_YOUR_USERNAME'); ?>
					</a>
				</li>
				<div style="clear:both"></div>
			</ul>
			
			<?php $usersConfig = JComponentHelper::getParams('com_users'); ?>
			<?php if ($usersConfig->get('allowUserRegistration')) : ?>
				<div class="jf_l_pro_register">
					<a href="<?php echo JRoute::_('index.php?option=com_users&view=registration&Itemid=' . UsersHelperRoute::getRegistrationRoute()); ?>">
						<?php echo JText::_('MOD_JF_LOGIN_PRO_VALUE_REGISTER'); ?>
					</a>
				</div>
			<?php endif; ?>
		</form>
		<?php if($jf_l_pro_preloader) { ?><div class="jf_l_pro_loader"><div class="blue"></div><div class="red"></div><div class="yellow"></div><div class="green"></div></div><?php } ?>
		<div class="jf_close"></div>
	</div>
</div>