<?php

	$document = JFactory::getDocument();
	$document->addStyleSheet('/modules/mod_moojlacourseslider/assets/css/table/table.css');
	$document->addStyleSheet('/modules/mod_moojlacourseslider/assets/css/table/jquery.dataTables.min.css');
	$document->addScript('/modules/mod_moojlacourseslider/assets/js/table/jquery.dataTables.min.js');
	$document->addScript('/modules/mod_moojlacourseslider/assets/js/table/dataTables.buttons.min.js');
	$document->addScript('/modules/mod_moojlacourseslider/assets/js/table/jszip.min.js');
	$document->addScript('/modules/mod_moojlacourseslider/assets/js/table/buttons.html5.min.js');
?>


    <table id="example" class="display" cellspacing="0" width="100%">
	
        <thead>
            <tr>
                <th>id</th>
                <th>دوره ها</th>
                <th>تاریخ ثبت نام</th>
                <th>درصد پیشرفت</th>
                <th>هزینه</th>
            </tr>
        </thead>
        <tbody>
		<?php $numberId=1; ?>
		<?php foreach($courses as $course): ?>
            <tr>
                <td><?php echo $numberId++; ?></td>
                <td>
					<a class="lmskaran_lay-table-go_course" href="<?php echo JRoute::_('index.php?option=com_moojla&view=coursedetail&id='.$course->remoteid); ?>">		<?php echo $course->shortname; ?>
					</a>
				</td>
                <td>1400/01/25</td>
                <td>
					<div class="lmskaran_progress_in_card">
						<div class="progress lmskaran_progress">
							<div class="progress-bar lmskaran_navar_progress_bar" role="progressbar" aria-valuenow="70"
								aria-valuemin="0" aria-valuemax="100" style="width:<?php echo round($course->percentage) != -1? round($course->percentage) : 100; ?>%;">
								<?php //dump($course->percentage); ?>
							</div>
						</div>
						<div class="lmskaran_amount_progress_bar"><?php echo round($course->percentage) != -1? round($course->percentage).'%' : '<div class="lmskaran_progress_no_criteria">بدون معیار</div>'; ?></div>
					</div>
				</td>
                <td
					<?php if($course->cost == 0):?>
						<div>
						<a href="<?php echo JRoute::_('index.php?option=com_moojla&view=coursedetail&id='.$course->remoteid); ?>">رایگان</a>
					</div>
					<?php else: ?>
						<div>
						<a href="<?php echo JRoute::_('index.php?option=com_moojla&view=coursedetail&id='.$course->remoteid); ?>">
						<?php echo $course->cost; ?></a></div>
					<?php endif; ?>
				</td>
            </tr>
		<?php endforeach; ?>

        </tbody>
    </table>

<style>


.tableparent > table{
	
	
	min-width: 700px !important;
}

</style>

    <script>
        jQuery(document).ready(function() {

            var $ = jQuery;
            var tables = $('#example').DataTable({
                dom: 'Blfrtip',
                "scrollX": 500,

                "language": {
                    "lengthMenu": "<p class='lmskaran-search-title'>تعداد نمایش در هر صفحه</p>_MENU_",
                    "zeroRecords": "متاسفانه چیزی پیدا نشد !",
                    "info": "نمایش _PAGE_ از _PAGES_",
                    "infoEmpty": "هیچ سوابقی در دسترس نیست",
                    "infoFiltered": "(فیلتر شده از _MAX_ کل سوابق)",
                    "search": "<p class='lmskaran-search-title'>جستجو</p>",
                    "paginate": {
                        "next": "بعدی",
                        "previous": 'قبلی'
                    }
                },
                buttons: [
                    //     {
                    //     text: 'خروجی گرفتن فایل اکسل',
                    //     extend: 'excelHtml5',
                    //     exportOptions: {
                    //         modifier: {
                    //             selected: true
                    //         },
                    //         columns: [0, 1, 2, 3],
                    //         format: {
                    //             header: function(data, columnIdx) {
                    //                 return data;
                    //             },
                    //             body: function(data, column, row) {
                    //                 // Strip $ from salary column to make it numeric
                    //                 debugger;
                    //                 return column === 4 ? "" : data;
                    //             }
                    //         }
                    //     },
                    //     footer: false,
                    //     customize: function(xlsx) {
                    //         var sheet = xlsx.xl.worksheets['sheet1.xml'];
                    //         //$('c[r=A1] t', sheet).text( 'Custom text' );
                    //         //$('row c[r^="C"]', sheet).attr('s', '2');
                    //     }
                    // }
                ]
            });

            // tables.page('next').draw(false);

            // tables.search('ایمان').draw();
            // table.draw();
		

        });
    </script>