<?php
/**
 * @package 	JF Login Pro
 * @author		JoomForest.com
 * @email		support@joomforest.com
 * @website		http://www.joomforest.com
 * @copyright	Copyright (C) 2011-2016 JoomForest.com, All rights reserved.
 * @license		http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
**/
// no direct access
defined('_JEXEC') or die('Restricted access');

// ini_set('display_errors', 'On');
// error_reporting(E_ALL | E_STRICT);

JHtml::_('jquery.framework');

/* START - JOOMLA LOGIN ==================================================================================================== */
	// Include the functions only once
	require_once __DIR__ . '/helper.php';
	$type	          = modJFLoginProHelper::getType();
	$return	          = modJFLoginProHelper::getReturnUrl($params, $type);
	$twofactormethods = modJFLoginProHelper::getTwoFactorMethods();
	$user	          = JFactory::getUser();
	$layout           = $params->get('layout', 'default');

	// Logged users must load the logout sublayout
	if (!$user->guest){
		$layout .= '_logout';
	}
/* END   - JOOMLA LOGIN ==================================================================================================== */

/* START - JF FUNCTIONS ==================================================================================================== */
	// Main Variables
	$base = JURI::base();
	$assets_path = $base.'modules/mod_jf_login_pro/assets/';
	$jf_doc = JFactory::getDocument();
	// Params
		$jf_l_pro_ID							= $params->get('jf_l_pro_ID','');
		$jf_l_pro_integration					= $params->get('jf_l_pro_integration','');
		$jf_l_pro_preloader						= $params->get('jf_l_pro_preloader','');
		$jf_l_pro_dr_btn_type					= $params->get('jf_l_pro_dr_btn_type','');
		$jf_l_pro_dr_btn_type					= $params->get('jf_l_pro_dr_btn_type','');
		$jf_l_pro_pop_name						= $params->get('jf_l_pro_pop_name','');
		$jf_l_pro_pop_username					= $params->get('jf_l_pro_pop_username','');
		$jf_l_pro_pop_email						= $params->get('jf_l_pro_pop_email','');
		$jf_l_pro_pop_html						= $params->get('jf_l_pro_pop_html','');
		// Slide LOOP Params
		$jf_list_count	= 8;
		for ($loop = 1; $loop <= $jf_list_count; $loop += 1) {	$link[$loop] 					= $params->get('jf_l_pro_pop_link_'.$loop.'','');						}
		for ($loop = 1; $loop <= $jf_list_count; $loop += 1) {	$link_text[$loop] 				= $params->get('jf_l_pro_pop_link_'.$loop.'_text','');				}
		for ($loop = 1; $loop <= $jf_list_count; $loop += 1) {	$link_menuid[$loop] 			= $params->get('jf_l_pro_pop_link_'.$loop.'_menu','');				}
		
	// STYLES
		$jf_l_pro_styles						= $params->get('jf_l_pro_styles','');
		$jf_l_pro_googleFont					= $params->get('jf_l_pro_googleFont','');
		$jf_l_pro_stylesheet					= $params->get('jf_l_pro_stylesheet','');
		$jf_l_pro_fontname						= $params->get('jf_l_pro_fontname','');
		
		$jf_UC_login_btn_bg						= $params->get('jf_UC_login_btn_bg','');
		$jf_UC_login_btn_bghover				= $params->get('jf_UC_login_btn_bghover','');
		$jf_UC_login_checkbox					= $params->get('jf_UC_login_checkbox','');
		$jf_UC_login_btn_txt					= $params->get('jf_UC_login_btn_txt','');
		$jf_UC_register_txt						= $params->get('jf_UC_register_txt','');
		
		$jf_l_pro_btn_style						= $params->get('jf_l_pro_btn_style','');
		$jf_UC_dr_btn_gr_top					= $params->get('jf_UC_dr_btn_gr_top','');
		$jf_UC_dr_btn_gr_bottom					= $params->get('jf_UC_dr_btn_gr_bottom','');
		$jf_UC_dr_btn_gr_border					= $params->get('jf_UC_dr_btn_gr_border','');
		$jf_UC_dr_btn_gr_txt					= $params->get('jf_UC_dr_btn_gr_txt','');
		$jf_UC_dr_logout_bg						= $params->get('jf_UC_dr_logout_bg','');
		$jf_UC_dr_links							= $params->get('jf_UC_dr_links','');

	// Calling
		// CSS
			$jf_doc->addStyleSheet($assets_path.'jf_login_pro.min.css');
			$jf_doc->addStyleDeclaration(''.$jf_l_pro_styles.'');
			if($jf_l_pro_googleFont){
				if($jf_l_pro_stylesheet){
					$jf_doc->addStyleSheet($jf_l_pro_stylesheet);
				}
				if($jf_l_pro_fontname){
					$jf_doc->addStyleDeclaration('.jf_l_pro,.jf_l_pro input,.jf_l_pro a,.jf_l_pro div,.jf_l_pro_popup,.jf_l_pro_popup input,.jf_l_pro_popup button,.jf_l_pro_popup .jf_l_pro_rememberwrap label{font-family:"'.$jf_l_pro_fontname.'",arial,tahoma!important}');
				}
			}
			$jf_doc->addStyleDeclaration('
				.jf_l_pro .jf_l_pro_authoriz_btn{background:'.$jf_UC_login_btn_bg.';color:'.$jf_UC_login_btn_txt.'}
				.jf_l_pro .jf_l_pro_authoriz_btn:hover{background:'.$jf_UC_login_btn_bghover.'}
				.jf_l_pro .jf_l_pro_checkbox input[type="checkbox"]:checked+i{background-color:'.$jf_UC_login_checkbox.'}
				.jf_l_pro .jf_l_pro_register a{color:'.$jf_UC_register_txt.'}
				.jf_l_pro .jf_greeting{
				    background-color:'.$jf_UC_dr_btn_gr_top.'
					background-image:-webkit-gradient(linear,left top,left bottom,from('.$jf_UC_dr_btn_gr_top.'),to('.$jf_UC_dr_btn_gr_bottom.'));
					background-image:-webkit-linear-gradient(top,'.$jf_UC_dr_btn_gr_top.','.$jf_UC_dr_btn_gr_bottom.');
					background-image:-moz-linear-gradient(top,'.$jf_UC_dr_btn_gr_top.','.$jf_UC_dr_btn_gr_bottom.');
					background-image:-ms-linear-gradient(top,'.$jf_UC_dr_btn_gr_top.','.$jf_UC_dr_btn_gr_bottom.');
					background-image:-o-linear-gradient(top,'.$jf_UC_dr_btn_gr_top.','.$jf_UC_dr_btn_gr_bottom.');
					background-image:linear-gradient(top,'.$jf_UC_dr_btn_gr_top.','.$jf_UC_dr_btn_gr_bottom.');
					border:1px solid '.$jf_UC_dr_btn_gr_border.';
					color:'.$jf_UC_dr_btn_gr_txt.';
				}
				.jf_l_pro .jf_logged_cont .jf_logout_btn input[type="submit"]:hover{background:'.$jf_UC_dr_logout_bg.'}
				.jf_l_pro table tr td .section2 .jf_l_pro_links>a{color:'.$jf_UC_dr_links.'}
			');
		// JS
			$jf_doc->addScript($assets_path.'jf_login_pro.min.js');
			$jf_doc->addScriptDeclaration('
				jQuery(document).ready(function($){
					$("#'.$jf_l_pro_ID.' .jf_l_pro_pos_wrapper").append($(".jf-login-pro-position,.customjf-login-pro-position"));
					$("#'.$jf_l_pro_ID.'").jf_l_pro();
				});
			');
/* END   - JF FUNCTIONS ==================================================================================================== */
if (!$user->guest){
	if ($jf_l_pro_integration == 'js') {
		/* START - API: JOMSOCIAL ==================================================================================================== */
			$jomsocial				= JPATH_SITE.'/components/com_community/libraries/core.php';
			$jomsocial_installed	= file_exists($jomsocial);
			if ($jomsocial_installed) {
				require_once JPATH_BASE.'/components/com_community/libraries/core.php';
				CWindow::load();
				$config = CFactory::getConfig();
				$js_user     = CFactory::getUser();
				
				if ($js_user->isOnline() && $js_user->id != 0) {
					$inboxModel 	= CFactory::getModel('inbox');
					$notifModel 	= CFactory::getModel('notification');
					$friendModel 	= CFactory::getModel('friends');

					$toolbar 				= CToolbarLibrary::getInstance();
					$newMessageCount 		= $toolbar->getTotalNotifications('inbox');
					$newEventInviteCount	= $toolbar->getTotalNotifications('events');
					$newFriendInviteCount 	= $toolbar->getTotalNotifications('friends');
					$newGroupInviteCount 	= $toolbar->getTotalNotifications('groups');

					$js_userParams 			= $js_user->getParams();
					$newNotificationCount	= $notifModel->getNotificationCount($js_user->id, '0', $js_userParams->get('lastnotificationlist', ''));
					$newEventInviteCount 	= $newEventInviteCount + $newNotificationCount + $newGroupInviteCount;

					$js_user_Id 		= $js_user->id;
					$js_user_Username 	= $js_user->username;
					$js_user_Email 		= $js_user->email;
					$js_user_Name 		= $js_user->getDisplayName();
					$js_user_Avatar 	= $js_user->getAvatar();
					
					
					$badge = new CBadge($js_user);
					$badge = $badge->getBadge();
					
					// from module
					$jf_l_pro_api_js_avatar			= $params->get('jf_l_pro_api_js_avatar','');
					$jf_l_pro_api_js_avatar_change	= $params->get('jf_l_pro_api_js_avatar_change','');
					$jf_l_pro_api_js_karma			= $params->get('jf_l_pro_api_js_karma','');
					$jf_l_pro_api_js_notifs			= $params->get('jf_l_pro_api_js_notifs','');
					$jf_l_pro_api_js_notifs_sys		= $params->get('jf_l_pro_api_js_notifs_sys','');
					$jf_l_pro_api_js_notifs_fr		= $params->get('jf_l_pro_api_js_notifs_fr','');
					$jf_l_pro_api_js_notifs_msg		= $params->get('jf_l_pro_api_js_notifs_msg','');
				}
			}
		/* END   - API: JOMSOCIAL ==================================================================================================== */
	} elseif ($jf_l_pro_integration == 'ku') {
		/* START - API: KUNENA ==================================================================================================== */
			$kunena				= JPATH_SITE.'/libraries/kunena/forum/forum.php';
			$kunena_installed	= file_exists($kunena);
			if ($kunena_installed) {
				$minKunenaVersion = '3.0';
				$kunena_class 		= class_exists('KunenaForum') || KunenaForum::isCompatible($minKunenaVersion);
				if ($kunena_class) {
					if (KunenaForum::enabled()) {
						$ku_user 		= KunenaFactory::getUser($user->id);
						$ku_name		= $ku_user->getName();
						$ku_avatar		= $ku_user->getAvatarImage('kavatar',200);
						$ku_rank		= $ku_user->getRank(0, 'image');
						
						$jf_l_pro_api_ku_avatar		= $params->get('jf_l_pro_api_ku_avatar','');
						$jf_l_pro_api_ku_rank		= $params->get('jf_l_pro_api_ku_rank','');
					}
				}
			}

		/* END   - API: KUNENA ==================================================================================================== */
	} elseif ($jf_l_pro_integration == 'es') {
		/* START - API: EASYSOCIAL ==================================================================================================== */
			$easysocial 			= JPATH_ADMINISTRATOR . '/components/com_easysocial/includes/foundry.php';
			$easysocial_installed	= file_exists($easysocial);
			if ($easysocial_installed) {
				require_once($easysocial);
				if (!FD::exists()) {
					FD::language()->loadSite();
					echo JText::_( 'COM_EASYSOCIAL_FOUNDRY_DEPENDENCY_MISSING' );
					return;
				}
				// Determines if EasyBlog exists
				$eblogFile = JPATH_ROOT . '/administrator/components/com_easyblog/includes/easyblog.php';
				$eblogExists = JFile::exists($eblogFile);
				if ($eblogExists) {
					require_once($eblogFile);
				}
				// main api
				$es_user 		= FD::user();
				$es_name		= $es_user->getName();
				$es_username	= $es_user->getUsername();
				$es_avatar		= $es_user->getAvatar(SOCIAL_AVATAR_SQUARE);
				$es_points		= $es_user->getPoints();
					
				$jf_l_pro_api_es_avatar			= $params->get('jf_l_pro_api_es_avatar','');
				$jf_l_pro_api_es_points			= $params->get('jf_l_pro_api_es_points','');
				$jf_l_pro_api_es_notifs			= $params->get('jf_l_pro_api_es_notifs','');
				$jf_l_pro_api_es_notifs_sys		= $params->get('jf_l_pro_api_es_notifs_sys','');
				$jf_l_pro_api_es_notifs_sys_int	= $params->get('jf_l_pro_api_es_notifs_sys_int',60);
				$jf_l_pro_api_es_notifs_fr		= $params->get('jf_l_pro_api_es_notifs_fr','');
				$jf_l_pro_api_es_notifs_fr_int	= $params->get('jf_l_pro_api_es_notifs_fr_int',60);
				$jf_l_pro_api_es_notifs_con		= $params->get('jf_l_pro_api_es_notifs_con','');
				$jf_l_pro_api_es_notifs_con_int	= $params->get('jf_l_pro_api_es_notifs_con_int',60);
				
				if ($jf_l_pro_api_es_notifs) {
					$jf_doc->addScriptDeclaration('
						jQuery(document).ready(function($){
							EasySocial.require()
							.script("site/toolbar/friends","site/toolbar/conversations","site/toolbar/system")
							.done(function($) {
								var intervalSystem = $("[data-module-jf_l_pro-system]").data("interval"),
									intervalFriends = $("[data-module-jf_l_pro-friends]").data("interval"),
									intervalConversations = $("[data-module-jf_l_pro-conversations]").data("interval");

								$("[data-module-jf_l_pro-system]").implement(EasySocial.Controller.Notifications.System, {
									"interval": intervalSystem
								});

								$("[data-module-jf_l_pro-friends]").implement(EasySocial.Controller.Notifications.Friends, {
									"interval": intervalFriends
								});

								$("[data-module-jf_l_pro-conversations]").implement(EasySocial.Controller.Notifications.Conversations, {
									"interval": intervalConversations
								});

							});
						});
					');
				}
			}
		/* END   - API: EASYSOCIAL ==================================================================================================== */
	}
}
$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx'));
require JModuleHelper::getLayoutPath('mod_jf_login_pro', $layout);