<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				fdsh 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.40
	@build			28th May, 2023
	@created		17th December, 2020
	@package		Reservation
	@subpackage		data.php
	@author			farhad shahbazi <http://farhad.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

/**
 * Module Plan Display Data
 */
class ModPlan_displayData extends \JObject
{

	/**
	 * Custom Method
	 *
	 * @return mixed  An array of objects on success, false on failure.
	 *
	 */
	public function get_plans()
	{

		if (!isset($this->initSet) || !$this->initSet)
		{
			$this->user = JFactory::getUser();
			$this->userId = $this->user->get('id');
			$this->guest = $this->user->get('guest');
			$this->groups = $this->user->get('groups');
			$this->authorisedGroups = $this->user->getAuthorisedGroups();
			$this->levels = $this->user->getAuthorisedViewLevels();
			$this->initSet = true;
		}

		// Get the global params
		$globalParams = JComponentHelper::getParams('com_reservation', true);
		// Get a db connection.
		$db = JFactory::getDbo();

		// Create a new query object.
		$query = $db->getQuery(true);

		// Get from #__reservation_plan as a
		$query->select($db->quoteName(
			array('a.id','a.asset_id','a.plantype','a.consultantid','a.price','a.time','a.waitingtime','a.published'),
			array('id','asset_id','plantype','consultantid','price','time','waitingtime','published')));
		$query->from($db->quoteName('#__reservation_plan', 'a'));

		// Get from #__reservation_consultant as c
		$query->select($db->quoteName(
			array('c.id','c.userid','c.nationalnumber','c.phonenumber','c.officephone','c.capitalid','c.cityid','c.account','c.introduction','c.msn','c.catid','c.experience','c.image','c.alt','c.video','c.presence','c.address','c.shortlink','c.published'),
			array('consultant_id','consultant_userid','consultant_nationalnumber','consultant_phonenumber','consultant_officephone','consultant_capitalid','consultant_cityid','consultant_account','consultant_introduction','consultant_msn','consultant_catid','consultant_experience','consultant_image','consultant_alt','consultant_video','consultant_presence','consultant_address','consultant_shortlink','consultant_published')));
		$query->join('INNER', ($db->quoteName('#__reservation_consultant', 'c')) . ' ON (' . $db->quoteName('a.consultantid') . ' = ' . $db->quoteName('b.id') . ')');

		// Reset the query using our newly populated query object.
		$db->setQuery($query);
		$items = $db->loadObjectList();

		if (empty($items))
		{
			return false;
		}

		// Insure all item fields are adapted where needed.
		if (ReservationHelper::checkArray($items))
		{
			foreach ($items as $nr => &$item)
			{
				// Always create a slug for sef URL's
				$item->slug = (isset($item->alias) && isset($item->id)) ? $item->id.':'.$item->alias : $item->id;
			}
		}
		// return items
		return $items;
	}}
