dojo.require("dojo.window");

dojo.declare("MiniFontConfigurator", null, {
	constructor: function(args) {
    dojo.mixin(this,args);
    window.loadedFont = window.loadedFont || {};
    this.init();
  },


  init: function() {
    this.btn = dojo.byId(this.id+'change');
    dojo.connect(this.btn, 'onclick', this, 'showWindow');
    this.settings = dojo.clone(this.origsettings);
    this.hidden = dojo.byId(this.id);
    dojo.connect(this.hidden, 'onchange', this, 'reset');
    this.reset();
  },

  reset: function(){
    if(this.hidden.value == '') this.hidden.value = dojo.toJson(this.settings);
    if(this.hidden.value != dojo.toJson(this.settings)){
      var newsettings = {};
      try{
        newsettings = dojo.fromJson(this.hidden.value.replace(/\\"/g, '"'));
        if(dojo.isArray(newsettings)){
          newsettings = {};
        }
      }catch(e){
        this.hidden.value = dojo.toJson(newsettings);
      }
      for(var s in this.origsettings){
        if(!newsettings[s]){
          newsettings[s] = this.origsettings[s];
        }
      }
      this.settings = this.origsettings = newsettings;
    }
  },

  showOverlay: function(){
    if(!this.overlayBG){
      this.overlayBG = dojo.create('div',{'class': 'blackBg'}, dojo.body());
    }
    dojo.removeClass(this.overlayBG, 'hide');
    dojo.style(this.overlayBG,{
      'opacity': 0.3
    });
  },

  showWindow: function(e){
    dojo.stopEvent(e);
    this.showOverlay();
    if(!this.window){
      this.window = dojo.create('div', {'class': 'OfflajnWindowFont mini'}, dojo.body());
      var closeBtn = dojo.create('div', {'class': 'OfflajnWindowClose'}, this.window);
      dojo.connect(closeBtn, 'onclick', this, 'closeWindow');
      var inner = dojo.create('div', {'class': 'OfflajnWindowInner'}, this.window);
      var h3 = dojo.create('h3', {'innerHTML': 'Font selector'+this.elements.tab['html']}, inner);

      this.reset = dojo.create('div', {'class': 'offlajnfont_reset hasOfflajnTip', 'tooltippos': 'T','title' : 'It will clear the settings on the current tab.', 'innerHTML': '<div class="offlajnfont_reset_img"></div>'}, h3);
      dojo.global.toolTips.connectToolTips(h3);
      dojo.connect(this.reset, 'onclick', this, 'resetValues');

      this.tab = dojo.byId(this.id+'tab');

      dojo.connect(this.tab, 'change', this, 'changeTab');

      dojo.create('div', {'class': 'OfflajnWindowLine'}, inner);
      var fields = dojo.create('div', {'class': 'OfflajnWindowFields'}, inner);


      dojo.create('div', {'class': 'OfflajnWindowField', 'innerHTML': 'Type<br />'+this.elements.type['html']}, fields);
      this.type = dojo.byId(this.elements.type.id);

      this.familyc = dojo.create('div', {'class': 'OfflajnWindowField'}, fields);

      dojo.create('div', {'class': 'OfflajnWindowField', 'innerHTML': 'Size<br />'+this.elements.size['html']}, fields);
      this.size = dojo.byId(this.elements.size['id']);

      dojo.create('div', {'class': 'OfflajnWindowField', 'innerHTML': 'Color<br />'+this.elements.color['html']}, fields);
      this.color = dojo.byId(this.elements.color['id']);

      dojo.create('div', {'class': 'OfflajnWindowField', 'innerHTML': 'Weight<br />'+this.elements.textdecor['html']}, fields);
      this.weight = dojo.byId(this.elements.textdecor.id);

			jQuery(this.weight.parentNode.parentNode)
				.on("mouseenter", ".listelement", jQuery.proxy(function(e) {
					var weight = (jQuery(e.target).index() + 1) * 100;
					this.tester.style.fontWeight = weight;
				}, this))
				.on("mouseleave", ".offlajnlistelements", jQuery.proxy(this, "changeWeight"));

      dojo.create('div', {'class': 'OfflajnWindowField', 'innerHTML': 'Decoration<br />'
				+this.elements.italic['html']+this.elements.underline['html']+this.elements.linethrough['html']+this.elements.uppercase['html']}, fields);
      this.italic = dojo.byId(this.elements.italic['id']);
      this.underline = dojo.byId(this.elements.underline['id']);
			this.linethrough = dojo.byId(this.elements.linethrough['id']);
			this.uppercase = dojo.byId(this.elements.uppercase['id']);

      dojo.create('div', {'class': 'OfflajnWindowField', 'innerHTML': 'Align<br />'+this.elements.align['html']}, fields);
      this.align = dojo.byId(this.elements.align['id']);

      dojo.create('div', {'class': 'OfflajnWindowField', 'innerHTML': 'Alternative font<br />'+this.elements.afont['html']}, fields);
      this.afont = dojo.byId(this.elements.afont['id']);

      dojo.create('div', {'class': 'OfflajnWindowField', 'innerHTML': 'Text shadow<br />'+this.elements.tshadow['html']}, fields);
      this.tshadow = dojo.byId(this.elements.tshadow['id']);

      dojo.create('div', {'class': 'OfflajnWindowField', 'innerHTML': 'Line height<br />'+this.elements.lineheight['html']}, fields);
      this.lineheight = dojo.byId(this.elements.lineheight['id']);

      dojo.create('div', {'class': 'OfflajnWindowTester', 'innerHTML': '<span>Grumpy wizards make toxic brew for the evil Queen and Jack.</span>'}, inner);
      this.tester = dojo.query('.OfflajnWindowTester span', inner)[0];
      var saveCont = dojo.create('div', {'class': 'OfflajnWindowSaveContainer'}, inner);
      var savebtn = dojo.create('div', {'class': 'OfflajnWindowSave', 'innerHTML': 'SAVE'}, saveCont);
      dojo.connect(savebtn, 'onclick', this, 'save');

      eval(this.script);


      dojo.connect(this.type, 'change', this, 'changeType');
      dojo.connect(this.size, 'change', dojo.hitch(this, 'changeSet', 'size'));
      dojo.connect(this.size, 'change', this, 'changeSize');
      dojo.connect(this.color, 'change', dojo.hitch(this, 'changeSet', 'color'));
      dojo.connect(this.color, 'change', this, 'changeColor');
      dojo.connect(this.weight, 'change', dojo.hitch(this, 'changeSet', 'textdecor'));
      dojo.connect(this.weight, 'change', this, 'changeWeight');
      dojo.connect(this.italic, 'change', dojo.hitch(this, 'changeSet', 'italic'));
      dojo.connect(this.italic, 'change', this, 'changeItalic');
      dojo.connect(this.underline, 'change', dojo.hitch(this, 'changeSet', 'underline'));
      dojo.connect(this.underline, 'change', this, 'changeUnderline');
      dojo.connect(this.linethrough, 'change', dojo.hitch(this, 'changeSet', 'linethrough'));
      dojo.connect(this.linethrough, 'change', this, 'changeLinethrough');
      dojo.connect(this.uppercase, 'change', dojo.hitch(this, 'changeSet', 'uppercase'));
      dojo.connect(this.uppercase, 'change', this, 'changeUppercase');
      dojo.connect(this.afont, 'change', dojo.hitch(this, 'changeSet', 'afont'));
      dojo.connect(this.afont, 'change', this, 'changeFamily');
      dojo.connect(this.align, 'change', dojo.hitch(this, 'changeSet', 'align'));
      dojo.connect(this.align, 'change', this, 'changeAlign');
      dojo.connect(this.tshadow, 'change', dojo.hitch(this, 'changeSet', 'tshadow'));
      dojo.connect(this.tshadow, 'change', this, 'changeTshadow');
      dojo.connect(this.lineheight, 'change', dojo.hitch(this, 'changeSet', 'lineheight'));
      dojo.connect(this.lineheight, 'change', this, 'changeLineheight');

      dojo.addOnLoad(this, function(){
        this.changeTab();
        this.changeType();
      });
      this.changeType();
      this.refreshFont();
			/*
			//family preview on hover
			jQuery(this.type).parents(".OfflajnWindowField").next()
				.on("mouseenter", ".listelement", jQuery.proxy(function(e) {
					this.changeFamily(e.target.firstChild.nodeValue);
				}, this))
				.on("mouseleave", ".offlajnlistelements", jQuery.proxy(this, "changeFamily"));
			*/
    }else{
      this.settings = dojo.fromJson(this.hidden.value.replace(/\\"/g, '"'));
      this.loadSettings();
    }
    dojo.removeClass(this.window, 'hide');
    this.exit = dojo.connect(document, "onkeypress", this, "keyPressed");
  },

  closeWindow: function(){
    dojo.addClass(this.window, 'hide');
    dojo.addClass(this.overlayBG, 'hide');
  },

  save: function(){
    this.hidden.value = dojo.toJson(this.settings);
    this.closeWindow();
  },

  loadSettings: function(){
    if(this.defaultTab!=this.t){
      this._loadSettings(this.defaultTab, true);
    }
    this._loadSettings(this.t, false);
    this.refreshFont();
  },

  _loadSettings: function(tab, def){
    var set = this.settings[tab];
    for(s in set){
      if(this[s] && (!def || def && !this.settings[this.t][s])){
        this.changeHidden(this[s], set[s]);
      }
    }
  },

  resetValues: function() {
    if(this.t != this.defaultTab) {
      this.settings[this.t] = {};
      this.loadSettings();
    }
  },

  loadFamily: function(e){
    dojo.stopEvent(e);
    var list = this.family.listobj;

    this.maxIteminWindow = parseInt(list.scrollbar.windowHeight/list.lineHeight)+1;
//    this.loadFamilyScroll();
//    list.scrollbar.onScroll = dojo.hitch(this, 'loadFamilyScroll');
  },

  loadFamilyScroll: function(){
    var set = this.settings[this.t];
    var list = this.family.listobj;
    var start = parseInt(list.scrollbar.curr*-1/list.lineHeight);
    for(var i = start; i <= start+this.maxIteminWindow && i < list.list.length; i++){
      var item = list.list[i];
      var option = list.options[i].value;
      this.loadGoogleFont(set.subset, option);
      dojo.style(item, 'fontFamily', "'"+option+"'");
    }
  },

  loadGoogleFont: function(subset, family){
    var hash = subset + family;
    if (!window.loadedFont[hash]) {
      window.loadedFont[hash] = true;
			dojo.create('link', {
				rel: 'stylesheet',
				type: 'text/css',
				href: '//fonts.googleapis.com/css?family='+family+':100,200,300,400,500,600,700,800,900&subset='+subset
			}, dojo.body());
			/*
      setTimeout(function(){
        dojo.create('link', {rel:'stylesheet', type: 'text/css', href: 'http://fonts.googleapis.com/css?family='+family+':100,200,300,400,500,600,700,800,900&subset='+subset}, dojo.body())
      },300);
			*/
    }
  },

  changeType: function(e){
    if(e){
      var obj = e.target.listobj;
      if(obj.map[obj.hidden.value] != obj.hidden.selectedIndex) return;
    }
    var set = this.settings[this.t];
    set.type = this.type.value;
    if(!this.elements.type[set.type]){
      if(!this.family){
        this.familyc.innerHTML = 'Family<br />'+this.elements.type['latin']['html'];
        this.family = dojo.byId(this.elements.type['latin']['id']);
        eval(this.elements.type['latin']['script']);
      }
      dojo.addOnLoad(this, function(){
        dojo.style(this.family.listobj.container,'visibility', 'hidden');
      });
      set.family = '';
      this.changeFamily();
      return;
    }
    this.familyc.innerHTML = 'Family<br />'+this.elements.type[set.type]['html'];
    this.family = dojo.byId(this.elements.type[set.type]['id']);

    dojo.connect(this.family, 'change', dojo.hitch(this, 'changeSet', 'family'));
    dojo.connect(this.family, 'click', this, 'loadFamily');
    dojo.connect(this.family, 'change', this, 'refreshFont');
    eval(this.elements.type[set.type]['script']);
    if(set.family){
      dojo.addOnLoad(this, function(){
        var set = this.settings[this.t];
        this.changeHidden(this.family, set.family);
      });
    }

		this.changeFamily();
		set.subset = this.type.value
  },

  changeSet: function(name, e){
    var set = this.settings[this.t];
    set[name] = e.target.value;
  },

  refreshFont: function(){
    var set = this.settings[this.t];
    if(this.weight) this.changeWeight();
    if(this.italic) this.changeItalic();
    if(this.underline) this.changeUnderline();
		if(this.linethrough) this.changeLinethrough();
		if(this.uppercase) this.changeUppercase();
    this.changeFamily();
    if(this.size) this.changeSize();
    if(this.color) this.changeColor();
    if(this.align) this.changeAlign();
    if(this.tshadow) this.changeTshadow();
    if(this.lineheight) this.changeLineheight();
  },

  changeWeight: function(e){
    dojo.style(this.tester, 'fontWeight', this.weight.value);
  },

  changeItalic: function(){
    dojo.style(this.tester, 'fontStyle', (parseInt(this.italic.value) ? 'italic' : 'normal'));
  },

  changeUnderline: function(){
		if (parseInt(this.linethrough.value) && parseInt(this.underline.value)) {
			jQuery(this.linethrough).prev()[0].click();
		}
    dojo.style(this.tester, 'textDecoration', (parseInt(this.underline.value) ? 'underline' : 'none'));
  },

  changeLinethrough: function(){
		if (parseInt(this.linethrough.value) && parseInt(this.underline.value)) {
			jQuery(this.underline).prev()[0].click();
		}
    dojo.style(this.tester, 'textDecoration', (parseInt(this.linethrough.value) ? 'line-through' : 'none'));
  },

  changeUppercase: function(){
    dojo.style(this.tester, 'textTransform', (parseInt(this.uppercase.value) ? 'uppercase' : 'none'));
  },

	prevFamily: '',

  changeFamily: function(family){
    var set = this.settings[this.t];
    var f = '';
    if(this.family && set.type != '0'){
      if (family === undefined) family = this.family.value;
      f = "'"+family+"'" + this.prevFamily;
      family && this.loadGoogleFont(set.subset, family);
    }

    if(this.afont){
      var afont = this.afont.value.split('||');
      if(afont[0] != '' && parseInt(afont[1])){
        if(f != '') f+=',';
        f+=afont[0];
      }
    }

		this.updateWeight();

    dojo.style(this.tester, 'fontFamily', f);
		if (this.family) this.prevFamily = ",'"+this.family.value+"'";
  },

	updateWeight: function() {
		this.weight.listobj.initSelectBox();
    var index = (this.settings[this.t].textdecor || this.settings[this.defaultTab].textdecor) / 100 - 1;

		if (!this.type.selectedIndex) {
			jQuery(".listelement", this.weight.listobj.selectbox).css('display', '');
			this.weight.listobj.selectbox.h = this.weight.listobj.lineHeight * this.weight.options.length;
		} else if (this.family && this.family.options) {
			var b = this.family.options[this.family.selectedIndex].text.match(/>(.+)</);
			if (b) {
				var $option = jQuery(".listelement", this.weight.listobj.selectbox).css('display', 'none');
				var i, map = this.weight.listobj.map, weight = b[1].split(',');
				for (i = 0; i < weight.length; i++)
					$option[ map[ weight[i] ] ].style.display = '';
				this.weight.listobj.selectbox.h = this.weight.listobj.lineHeight * weight.length;
        if ($option[index].style.display == 'none') index = 3; // set to normal if weight not exists
			}
		}
    this.weight.listobj.setSelected(index);
    this.weight.listobj.selectbox.style.overflow = 'hidden';
	},

  changeSize: function(){
    dojo.style(this.tester, 'fontSize', this.size.value.replace('||', '') );
  },

  changeColor: function(){
    dojo.style(this.tester, 'color', this.color.value);
		var rgb = this.color.value.match(/^#([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})|rgba\((\d+),\s*(\d+),\s*(\d+),\s*\d\.?\d*\)$/i);
		if (!rgb) return;
    var brightness = rgb[1] === undefined ? Math.round((rgb[4] * 299 + rgb[5] * 587 + rgb[6] * 114) / 1000) :
			Math.round((parseInt(rgb[1],16) * 299 + parseInt(rgb[2],16) * 587 + parseInt(rgb[3],16) * 114) / 1000);
    (brightness > 125) ? dojo.style(this.tester.parentNode, 'backgroundColor', '#555555') : dojo.style(this.tester.parentNode, 'backgroundColor', '#fdfdfd');
  },

  changeAlign: function(){
    dojo.style(this.tester.parentNode, 'textAlign', this.align.value );
  },

  changeTshadow: function(){
    var s = this.tshadow.value.replace(/\|\|/g, '').split('|*|');
    var shadow = 'none';
    if(parseInt(s[4])){
      s[4] = '';
      shadow = s.join(' ');
    }
    dojo.style(this.tester, 'textShadow', shadow);
  },

  changeLineheight: function(){
    dojo.style(this.tester, 'lineHeight', this.lineheight.value);
  },

  changeTab: function(){
    var radio = this.tab.radioobj;
    this.t = this.tab.value;
    if(this.t != this.defaultTab){
      dojo.style(this.reset,'display','block');
    }else{
      dojo.style(this.reset,'display','none');
    }
    this.loadSettings();
  },

  changeHidden: function(el, value){
    if(el.value == value) return;
    el.value = value;
    OfflajnFireEvent(el, 'change');
  },

  keyPressed: function(e) {
    if(e.keyCode == 27) {
      this.closeWindow();
      dojo.disconnect(this.exit);
    }
  }
});

OfflajnFont_arabic = [{"value":"Amiri","text":"Amiri<b>400,700<\/b>"},{"value":"Lateef","text":"Lateef<b>400<\/b>"},{"value":"Scheherazade","text":"Scheherazade<b>400,700<\/b>"}];
OfflajnFont_bengali = [{"value":"Hind Siliguri","text":"Hind Siliguri<b>300,400,500,600,700<\/b>"}];
OfflajnFont_cyrillic = [{"value":"Andika","text":"Andika<b>400<\/b>"},{"value":"Anonymous Pro","text":"Anonymous Pro<b>400,700<\/b>"},{"value":"Arimo","text":"Arimo<b>400,700<\/b>"},{"value":"Bad Script","text":"Bad Script<b>400<\/b>"},{"value":"Comfortaa","text":"Comfortaa<b>300,400,700<\/b>"},{"value":"Cousine","text":"Cousine<b>400,700<\/b>"},{"value":"Cuprum","text":"Cuprum<b>400,700<\/b>"},{"value":"Didact Gothic","text":"Didact Gothic<b>400<\/b>"},{"value":"EB Garamond","text":"EB Garamond<b>400<\/b>"},{"value":"Exo 2","text":"Exo 2<b>100,200,300,400,500,600,700,800,900<\/b>"},{"value":"Fira Mono","text":"Fira Mono<b>400,700<\/b>"},{"value":"Fira Sans","text":"Fira Sans<b>300,400,500,700<\/b>"},{"value":"Forum","text":"Forum<b>400<\/b>"},{"value":"Istok Web","text":"Istok Web<b>400,700<\/b>"},{"value":"Jura","text":"Jura<b>300,400,500,600<\/b>"},{"value":"Kelly Slab","text":"Kelly Slab<b>400<\/b>"},{"value":"Kurale","text":"Kurale<b>400<\/b>"},{"value":"Ledger","text":"Ledger<b>400<\/b>"},{"value":"Lobster","text":"Lobster<b>400<\/b>"},{"value":"Lora","text":"Lora<b>400,700<\/b>"},{"value":"Marck Script","text":"Marck Script<b>400<\/b>"},{"value":"Marmelad","text":"Marmelad<b>400<\/b>"},{"value":"Merriweather","text":"Merriweather<b>300,400,700,900<\/b>"},{"value":"Neucha","text":"Neucha<b>400<\/b>"},{"value":"Noto Sans","text":"Noto Sans<b>400,700<\/b>"},{"value":"Noto Serif","text":"Noto Serif<b>400,700<\/b>"},{"value":"Open Sans","text":"Open Sans<b>300,400,600,700,800<\/b>"},{"value":"Open Sans Condensed","text":"Open Sans Condensed<b>300,700<\/b>"},{"value":"Oranienbaum","text":"Oranienbaum<b>400<\/b>"},{"value":"PT Mono","text":"PT Mono<b>400<\/b>"},{"value":"PT Sans","text":"PT Sans<b>400,700<\/b>"},{"value":"PT Sans Caption","text":"PT Sans Caption<b>400,700<\/b>"},{"value":"PT Sans Narrow","text":"PT Sans Narrow<b>400,700<\/b>"},{"value":"PT Serif","text":"PT Serif<b>400,700<\/b>"},{"value":"PT Serif Caption","text":"PT Serif Caption<b>400<\/b>"},{"value":"Philosopher","text":"Philosopher<b>400,700<\/b>"},{"value":"Play","text":"Play<b>400,700<\/b>"},{"value":"Playfair Display","text":"Playfair Display<b>400,700,900<\/b>"},{"value":"Playfair Display SC","text":"Playfair Display SC<b>400,700,900<\/b>"},{"value":"Poiret One","text":"Poiret One<b>400<\/b>"},{"value":"Press Start 2P","text":"Press Start 2P<b>400<\/b>"},{"value":"Prosto One","text":"Prosto One<b>400<\/b>"},{"value":"Roboto","text":"Roboto<b>100,300,400,500,700,900<\/b>"},{"value":"Roboto Condensed","text":"Roboto Condensed<b>300,400,700<\/b>"},{"value":"Roboto Mono","text":"Roboto Mono<b>100,300,400,500,700<\/b>"},{"value":"Roboto Slab","text":"Roboto Slab<b>100,300,400,700<\/b>"},{"value":"Rubik","text":"Rubik<b>300,400,500,700,900<\/b>"},{"value":"Rubik Mono One","text":"Rubik Mono One<b>400<\/b>"},{"value":"Rubik One","text":"Rubik One<b>400<\/b>"},{"value":"Ruslan Display","text":"Ruslan Display<b>400<\/b>"},{"value":"Russo One","text":"Russo One<b>400<\/b>"},{"value":"Scada","text":"Scada<b>400,700<\/b>"},{"value":"Seymour One","text":"Seymour One<b>400<\/b>"},{"value":"Stalinist One","text":"Stalinist One<b>400<\/b>"},{"value":"Tenor Sans","text":"Tenor Sans<b>400<\/b>"},{"value":"Tinos","text":"Tinos<b>400,700<\/b>"},{"value":"Ubuntu","text":"Ubuntu<b>300,400,500,700<\/b>"},{"value":"Ubuntu Condensed","text":"Ubuntu Condensed<b>400<\/b>"},{"value":"Ubuntu Mono","text":"Ubuntu Mono<b>400,700<\/b>"},{"value":"Underdog","text":"Underdog<b>400<\/b>"},{"value":"Yeseva One","text":"Yeseva One<b>400<\/b>"}];
OfflajnFont_cyrillic_ext = [{"value":"Andika","text":"Andika<b>400<\/b>"},{"value":"Arimo","text":"Arimo<b>400,700<\/b>"},{"value":"Comfortaa","text":"Comfortaa<b>300,400,700<\/b>"},{"value":"Cousine","text":"Cousine<b>400,700<\/b>"},{"value":"Didact Gothic","text":"Didact Gothic<b>400<\/b>"},{"value":"EB Garamond","text":"EB Garamond<b>400<\/b>"},{"value":"Fira Mono","text":"Fira Mono<b>400,700<\/b>"},{"value":"Fira Sans","text":"Fira Sans<b>300,400,500,700<\/b>"},{"value":"Forum","text":"Forum<b>400<\/b>"},{"value":"Istok Web","text":"Istok Web<b>400,700<\/b>"},{"value":"Jura","text":"Jura<b>300,400,500,600<\/b>"},{"value":"Noto Sans","text":"Noto Sans<b>400,700<\/b>"},{"value":"Noto Serif","text":"Noto Serif<b>400,700<\/b>"},{"value":"Open Sans","text":"Open Sans<b>300,400,600,700,800<\/b>"},{"value":"Open Sans Condensed","text":"Open Sans Condensed<b>300,700<\/b>"},{"value":"Oranienbaum","text":"Oranienbaum<b>400<\/b>"},{"value":"PT Mono","text":"PT Mono<b>400<\/b>"},{"value":"PT Sans","text":"PT Sans<b>400,700<\/b>"},{"value":"PT Sans Caption","text":"PT Sans Caption<b>400,700<\/b>"},{"value":"PT Sans Narrow","text":"PT Sans Narrow<b>400,700<\/b>"},{"value":"PT Serif","text":"PT Serif<b>400,700<\/b>"},{"value":"PT Serif Caption","text":"PT Serif Caption<b>400<\/b>"},{"value":"Play","text":"Play<b>400,700<\/b>"},{"value":"Roboto","text":"Roboto<b>100,300,400,500,700,900<\/b>"},{"value":"Roboto Condensed","text":"Roboto Condensed<b>300,400,700<\/b>"},{"value":"Roboto Mono","text":"Roboto Mono<b>100,300,400,500,700<\/b>"},{"value":"Roboto Slab","text":"Roboto Slab<b>100,300,400,700<\/b>"},{"value":"Tinos","text":"Tinos<b>400,700<\/b>"},{"value":"Ubuntu","text":"Ubuntu<b>300,400,500,700<\/b>"},{"value":"Ubuntu Condensed","text":"Ubuntu Condensed<b>400<\/b>"},{"value":"Ubuntu Mono","text":"Ubuntu Mono<b>400,700<\/b>"}];
OfflajnFont_devanagari = [{"value":"Amita","text":"Amita<b>400,700<\/b>"},{"value":"Arya","text":"Arya<b>400,700<\/b>"},{"value":"Asar","text":"Asar<b>400<\/b>"},{"value":"Biryani","text":"Biryani<b>200,300,400,600,700,800,900<\/b>"},{"value":"Cambay","text":"Cambay<b>400,700<\/b>"},{"value":"Dekko","text":"Dekko<b>400<\/b>"},{"value":"Eczar","text":"Eczar<b>400,500,600,700,800<\/b>"},{"value":"Ek Mukta","text":"Ek Mukta<b>200,300,400,500,600,700,800<\/b>"},{"value":"Glegoo","text":"Glegoo<b>400,700<\/b>"},{"value":"Halant","text":"Halant<b>300,400,500,600,700<\/b>"},{"value":"Hind","text":"Hind<b>300,400,500,600,700<\/b>"},{"value":"Inknut Antiqua","text":"Inknut Antiqua<b>300,400,500,600,700,800,900<\/b>"},{"value":"Jaldi","text":"Jaldi<b>400,700<\/b>"},{"value":"Kadwa","text":"Kadwa<b>400,700<\/b>"},{"value":"Kalam","text":"Kalam<b>300,400,700<\/b>"},{"value":"Karma","text":"Karma<b>300,400,500,600,700<\/b>"},{"value":"Khand","text":"Khand<b>300,400,500,600,700<\/b>"},{"value":"Khula","text":"Khula<b>300,400,600,700,800<\/b>"},{"value":"Kurale","text":"Kurale<b>400<\/b>"},{"value":"Laila","text":"Laila<b>300,400,500,600,700<\/b>"},{"value":"Martel","text":"Martel<b>200,300,400,600,700,800,900<\/b>"},{"value":"Martel Sans","text":"Martel Sans<b>200,300,400,600,700,800,900<\/b>"},{"value":"Modak","text":"Modak<b>400<\/b>"},{"value":"Noto Sans","text":"Noto Sans<b>400,700<\/b>"},{"value":"Palanquin","text":"Palanquin<b>100,200,300,400,500,600,700<\/b>"},{"value":"Palanquin Dark","text":"Palanquin Dark<b>400,500,600,700<\/b>"},{"value":"Poppins","text":"Poppins<b>300,400,500,600,700<\/b>"},{"value":"Pragati Narrow","text":"Pragati Narrow<b>400,700<\/b>"},{"value":"Rajdhani","text":"Rajdhani<b>300,400,500,600,700<\/b>"},{"value":"Ranga","text":"Ranga<b>400,700<\/b>"},{"value":"Rhodium Libre","text":"Rhodium Libre<b>400<\/b>"},{"value":"Rozha One","text":"Rozha One<b>400<\/b>"},{"value":"Sahitya","text":"Sahitya<b>400,700<\/b>"},{"value":"Sarala","text":"Sarala<b>400,700<\/b>"},{"value":"Sarpanch","text":"Sarpanch<b>400,500,600,700,800,900<\/b>"},{"value":"Sumana","text":"Sumana<b>400,700<\/b>"},{"value":"Sura","text":"Sura<b>400,700<\/b>"},{"value":"Teko","text":"Teko<b>300,400,500,600,700<\/b>"},{"value":"Tillana","text":"Tillana<b>400,500,600,700,800<\/b>"},{"value":"Vesper Libre","text":"Vesper Libre<b>400,500,700,900<\/b>"},{"value":"Yantramanav","text":"Yantramanav<b>100,300,400,500,700,900<\/b>"}];
OfflajnFont_greek = [{"value":"Advent Pro","text":"Advent Pro<b>100,200,300,400,500,600,700<\/b>"},{"value":"Anonymous Pro","text":"Anonymous Pro<b>400,700<\/b>"},{"value":"Arimo","text":"Arimo<b>400,700<\/b>"},{"value":"Cardo","text":"Cardo<b>400,700<\/b>"},{"value":"Caudex","text":"Caudex<b>400,700<\/b>"},{"value":"Comfortaa","text":"Comfortaa<b>300,400,700<\/b>"},{"value":"Cousine","text":"Cousine<b>400,700<\/b>"},{"value":"Didact Gothic","text":"Didact Gothic<b>400<\/b>"},{"value":"Fira Mono","text":"Fira Mono<b>400,700<\/b>"},{"value":"Fira Sans","text":"Fira Sans<b>300,400,500,700<\/b>"},{"value":"GFS Didot","text":"GFS Didot<b>400<\/b>"},{"value":"GFS Neohellenic","text":"GFS Neohellenic<b>400,700<\/b>"},{"value":"Jura","text":"Jura<b>300,400,500,600<\/b>"},{"value":"Noto Sans","text":"Noto Sans<b>400,700<\/b>"},{"value":"Noto Serif","text":"Noto Serif<b>400,700<\/b>"},{"value":"Nova Mono","text":"Nova Mono<b>400<\/b>"},{"value":"Open Sans","text":"Open Sans<b>300,400,600,700,800<\/b>"},{"value":"Open Sans Condensed","text":"Open Sans Condensed<b>300,700<\/b>"},{"value":"Play","text":"Play<b>400,700<\/b>"},{"value":"Press Start 2P","text":"Press Start 2P<b>400<\/b>"},{"value":"Roboto","text":"Roboto<b>100,300,400,500,700,900<\/b>"},{"value":"Roboto Condensed","text":"Roboto Condensed<b>300,400,700<\/b>"},{"value":"Roboto Mono","text":"Roboto Mono<b>100,300,400,500,700<\/b>"},{"value":"Roboto Slab","text":"Roboto Slab<b>100,300,400,700<\/b>"},{"value":"Tinos","text":"Tinos<b>400,700<\/b>"},{"value":"Ubuntu","text":"Ubuntu<b>300,400,500,700<\/b>"},{"value":"Ubuntu Condensed","text":"Ubuntu Condensed<b>400<\/b>"},{"value":"Ubuntu Mono","text":"Ubuntu Mono<b>400,700<\/b>"}];
OfflajnFont_greek_ext = [{"value":"Arimo","text":"Arimo<b>400,700<\/b>"},{"value":"Cardo","text":"Cardo<b>400,700<\/b>"},{"value":"Caudex","text":"Caudex<b>400,700<\/b>"},{"value":"Cousine","text":"Cousine<b>400,700<\/b>"},{"value":"Didact Gothic","text":"Didact Gothic<b>400<\/b>"},{"value":"Noto Sans","text":"Noto Sans<b>400,700<\/b>"},{"value":"Noto Serif","text":"Noto Serif<b>400,700<\/b>"},{"value":"Open Sans","text":"Open Sans<b>300,400,600,700,800<\/b>"},{"value":"Open Sans Condensed","text":"Open Sans Condensed<b>300,700<\/b>"},{"value":"Roboto","text":"Roboto<b>100,300,400,500,700,900<\/b>"},{"value":"Roboto Condensed","text":"Roboto Condensed<b>300,400,700<\/b>"},{"value":"Roboto Mono","text":"Roboto Mono<b>100,300,400,500,700<\/b>"},{"value":"Roboto Slab","text":"Roboto Slab<b>100,300,400,700<\/b>"},{"value":"Tinos","text":"Tinos<b>400,700<\/b>"},{"value":"Ubuntu","text":"Ubuntu<b>300,400,500,700<\/b>"},{"value":"Ubuntu Condensed","text":"Ubuntu Condensed<b>400<\/b>"},{"value":"Ubuntu Mono","text":"Ubuntu Mono<b>400,700<\/b>"}];
OfflajnFont_gujarati = [{"value":"Hind Vadodara","text":"Hind Vadodara<b>300,400,500,600,700<\/b>"}];
OfflajnFont_hebrew = [{"value":"Alef","text":"Alef<b>400,700<\/b>"},{"value":"Arimo","text":"Arimo<b>400,700<\/b>"},{"value":"Cousine","text":"Cousine<b>400,700<\/b>"},{"value":"Tinos","text":"Tinos<b>400,700<\/b>"}];
OfflajnFont_khmer = [{"value":"Angkor","text":"Angkor<b>400<\/b>"},{"value":"Battambang","text":"Battambang<b>400,700<\/b>"},{"value":"Bayon","text":"Bayon<b>400<\/b>"},{"value":"Bokor","text":"Bokor<b>400<\/b>"},{"value":"Chenla","text":"Chenla<b>400<\/b>"},{"value":"Content","text":"Content<b>400,700<\/b>"},{"value":"Dangrek","text":"Dangrek<b>400<\/b>"},{"value":"Fasthand","text":"Fasthand<b>400<\/b>"},{"value":"Freehand","text":"Freehand<b>400<\/b>"},{"value":"Hanuman","text":"Hanuman<b>400,700<\/b>"},{"value":"Kantumruy","text":"Kantumruy<b>300,400,700<\/b>"},{"value":"Kdam Thmor","text":"Kdam Thmor<b>400<\/b>"},{"value":"Khmer","text":"Khmer<b>400<\/b>"},{"value":"Koulen","text":"Koulen<b>400<\/b>"},{"value":"Metal","text":"Metal<b>400<\/b>"},{"value":"Moul","text":"Moul<b>400<\/b>"},{"value":"Moulpali","text":"Moulpali<b>400<\/b>"},{"value":"Nokora","text":"Nokora<b>400,700<\/b>"},{"value":"Odor Mean Chey","text":"Odor Mean Chey<b>400<\/b>"},{"value":"Preahvihear","text":"Preahvihear<b>400<\/b>"},{"value":"Siemreap","text":"Siemreap<b>400<\/b>"},{"value":"Suwannaphum","text":"Suwannaphum<b>400<\/b>"},{"value":"Taprom","text":"Taprom<b>400<\/b>"}];
OfflajnFont_latin = [{"value":"ABeeZee","text":"ABeeZee<b>400<\/b>"},{"value":"Abel","text":"Abel<b>400<\/b>"},{"value":"Abril Fatface","text":"Abril Fatface<b>400<\/b>"},{"value":"Aclonica","text":"Aclonica<b>400<\/b>"},{"value":"Acme","text":"Acme<b>400<\/b>"},{"value":"Actor","text":"Actor<b>400<\/b>"},{"value":"Adamina","text":"Adamina<b>400<\/b>"},{"value":"Advent Pro","text":"Advent Pro<b>100,200,300,400,500,600,700<\/b>"},{"value":"Aguafina Script","text":"Aguafina Script<b>400<\/b>"},{"value":"Akronim","text":"Akronim<b>400<\/b>"},{"value":"Aladin","text":"Aladin<b>400<\/b>"},{"value":"Aldrich","text":"Aldrich<b>400<\/b>"},{"value":"Alef","text":"Alef<b>400,700<\/b>"},{"value":"Alegreya","text":"Alegreya<b>400,700,900<\/b>"},{"value":"Alegreya SC","text":"Alegreya SC<b>400,700,900<\/b>"},{"value":"Alegreya Sans","text":"Alegreya Sans<b>100,300,400,500,700,800,900<\/b>"},{"value":"Alegreya Sans SC","text":"Alegreya Sans SC<b>100,300,400,500,700,800,900<\/b>"},{"value":"Alex Brush","text":"Alex Brush<b>400<\/b>"},{"value":"Alfa Slab One","text":"Alfa Slab One<b>400<\/b>"},{"value":"Alice","text":"Alice<b>400<\/b>"},{"value":"Alike","text":"Alike<b>400<\/b>"},{"value":"Alike Angular","text":"Alike Angular<b>400<\/b>"},{"value":"Allan","text":"Allan<b>400,700<\/b>"},{"value":"Allerta","text":"Allerta<b>400<\/b>"},{"value":"Allerta Stencil","text":"Allerta Stencil<b>400<\/b>"},{"value":"Allura","text":"Allura<b>400<\/b>"},{"value":"Almendra","text":"Almendra<b>400,700<\/b>"},{"value":"Almendra Display","text":"Almendra Display<b>400<\/b>"},{"value":"Almendra SC","text":"Almendra SC<b>400<\/b>"},{"value":"Amarante","text":"Amarante<b>400<\/b>"},{"value":"Amaranth","text":"Amaranth<b>400,700<\/b>"},{"value":"Amatic SC","text":"Amatic SC<b>400,700<\/b>"},{"value":"Amethysta","text":"Amethysta<b>400<\/b>"},{"value":"Amiri","text":"Amiri<b>400,700<\/b>"},{"value":"Amita","text":"Amita<b>400,700<\/b>"},{"value":"Anaheim","text":"Anaheim<b>400<\/b>"},{"value":"Andada","text":"Andada<b>400<\/b>"},{"value":"Andika","text":"Andika<b>400<\/b>"},{"value":"Annie Use Your Telescope","text":"Annie Use Your Telescope<b>400<\/b>"},{"value":"Anonymous Pro","text":"Anonymous Pro<b>400,700<\/b>"},{"value":"Antic","text":"Antic<b>400<\/b>"},{"value":"Antic Didone","text":"Antic Didone<b>400<\/b>"},{"value":"Antic Slab","text":"Antic Slab<b>400<\/b>"},{"value":"Anton","text":"Anton<b>400<\/b>"},{"value":"Arapey","text":"Arapey<b>400<\/b>"},{"value":"Arbutus","text":"Arbutus<b>400<\/b>"},{"value":"Arbutus Slab","text":"Arbutus Slab<b>400<\/b>"},{"value":"Architects Daughter","text":"Architects Daughter<b>400<\/b>"},{"value":"Archivo Black","text":"Archivo Black<b>400<\/b>"},{"value":"Archivo Narrow","text":"Archivo Narrow<b>400,700<\/b>"},{"value":"Arimo","text":"Arimo<b>400,700<\/b>"},{"value":"Arizonia","text":"Arizonia<b>400<\/b>"},{"value":"Armata","text":"Armata<b>400<\/b>"},{"value":"Artifika","text":"Artifika<b>400<\/b>"},{"value":"Arvo","text":"Arvo<b>400,700<\/b>"},{"value":"Arya","text":"Arya<b>400,700<\/b>"},{"value":"Asap","text":"Asap<b>400,700<\/b>"},{"value":"Asar","text":"Asar<b>400<\/b>"},{"value":"Asset","text":"Asset<b>400<\/b>"},{"value":"Astloch","text":"Astloch<b>400,700<\/b>"},{"value":"Asul","text":"Asul<b>400,700<\/b>"},{"value":"Atomic Age","text":"Atomic Age<b>400<\/b>"},{"value":"Aubrey","text":"Aubrey<b>400<\/b>"},{"value":"Audiowide","text":"Audiowide<b>400<\/b>"},{"value":"Autour One","text":"Autour One<b>400<\/b>"},{"value":"Average","text":"Average<b>400<\/b>"},{"value":"Average Sans","text":"Average Sans<b>400<\/b>"},{"value":"Averia Gruesa Libre","text":"Averia Gruesa Libre<b>400<\/b>"},{"value":"Averia Libre","text":"Averia Libre<b>300,400,700<\/b>"},{"value":"Averia Sans Libre","text":"Averia Sans Libre<b>300,400,700<\/b>"},{"value":"Averia Serif Libre","text":"Averia Serif Libre<b>300,400,700<\/b>"},{"value":"Bad Script","text":"Bad Script<b>400<\/b>"},{"value":"Balthazar","text":"Balthazar<b>400<\/b>"},{"value":"Bangers","text":"Bangers<b>400<\/b>"},{"value":"Basic","text":"Basic<b>400<\/b>"},{"value":"Baumans","text":"Baumans<b>400<\/b>"},{"value":"Belgrano","text":"Belgrano<b>400<\/b>"},{"value":"Belleza","text":"Belleza<b>400<\/b>"},{"value":"BenchNine","text":"BenchNine<b>300,400,700<\/b>"},{"value":"Bentham","text":"Bentham<b>400<\/b>"},{"value":"Berkshire Swash","text":"Berkshire Swash<b>400<\/b>"},{"value":"Bevan","text":"Bevan<b>400<\/b>"},{"value":"Bigelow Rules","text":"Bigelow Rules<b>400<\/b>"},{"value":"Bigshot One","text":"Bigshot One<b>400<\/b>"},{"value":"Bilbo","text":"Bilbo<b>400<\/b>"},{"value":"Bilbo Swash Caps","text":"Bilbo Swash Caps<b>400<\/b>"},{"value":"Biryani","text":"Biryani<b>200,300,400,600,700,800,900<\/b>"},{"value":"Bitter","text":"Bitter<b>400,700<\/b>"},{"value":"Black Ops One","text":"Black Ops One<b>400<\/b>"},{"value":"Bonbon","text":"Bonbon<b>400<\/b>"},{"value":"Boogaloo","text":"Boogaloo<b>400<\/b>"},{"value":"Bowlby One","text":"Bowlby One<b>400<\/b>"},{"value":"Bowlby One SC","text":"Bowlby One SC<b>400<\/b>"},{"value":"Brawler","text":"Brawler<b>400<\/b>"},{"value":"Bree Serif","text":"Bree Serif<b>400<\/b>"},{"value":"Bubblegum Sans","text":"Bubblegum Sans<b>400<\/b>"},{"value":"Bubbler One","text":"Bubbler One<b>400<\/b>"},{"value":"Buda","text":"Buda<b>300<\/b>"},{"value":"Buenard","text":"Buenard<b>400,700<\/b>"},{"value":"Butcherman","text":"Butcherman<b>400<\/b>"},{"value":"Butterfly Kids","text":"Butterfly Kids<b>400<\/b>"},{"value":"Cabin","text":"Cabin<b>400,500,600,700<\/b>"},{"value":"Cabin Condensed","text":"Cabin Condensed<b>400,500,600,700<\/b>"},{"value":"Cabin Sketch","text":"Cabin Sketch<b>400,700<\/b>"},{"value":"Caesar Dressing","text":"Caesar Dressing<b>400<\/b>"},{"value":"Cagliostro","text":"Cagliostro<b>400<\/b>"},{"value":"Calligraffitti","text":"Calligraffitti<b>400<\/b>"},{"value":"Cambay","text":"Cambay<b>400,700<\/b>"},{"value":"Cambo","text":"Cambo<b>400<\/b>"},{"value":"Candal","text":"Candal<b>400<\/b>"},{"value":"Cantarell","text":"Cantarell<b>400,700<\/b>"},{"value":"Cantata One","text":"Cantata One<b>400<\/b>"},{"value":"Cantora One","text":"Cantora One<b>400<\/b>"},{"value":"Capriola","text":"Capriola<b>400<\/b>"},{"value":"Cardo","text":"Cardo<b>400,700<\/b>"},{"value":"Carme","text":"Carme<b>400<\/b>"},{"value":"Carrois Gothic","text":"Carrois Gothic<b>400<\/b>"},{"value":"Carrois Gothic SC","text":"Carrois Gothic SC<b>400<\/b>"},{"value":"Carter One","text":"Carter One<b>400<\/b>"},{"value":"Catamaran","text":"Catamaran<b>100,200,300,400,500,600,700,800,900<\/b>"},{"value":"Caudex","text":"Caudex<b>400,700<\/b>"},{"value":"Caveat","text":"Caveat<b>400,700<\/b>"},{"value":"Caveat Brush","text":"Caveat Brush<b>400<\/b>"},{"value":"Cedarville Cursive","text":"Cedarville Cursive<b>400<\/b>"},{"value":"Ceviche One","text":"Ceviche One<b>400<\/b>"},{"value":"Changa One","text":"Changa One<b>400<\/b>"},{"value":"Chango","text":"Chango<b>400<\/b>"},{"value":"Chau Philomene One","text":"Chau Philomene One<b>400<\/b>"},{"value":"Chela One","text":"Chela One<b>400<\/b>"},{"value":"Chelsea Market","text":"Chelsea Market<b>400<\/b>"},{"value":"Cherry Cream Soda","text":"Cherry Cream Soda<b>400<\/b>"},{"value":"Cherry Swash","text":"Cherry Swash<b>400,700<\/b>"},{"value":"Chewy","text":"Chewy<b>400<\/b>"},{"value":"Chicle","text":"Chicle<b>400<\/b>"},{"value":"Chivo","text":"Chivo<b>400,900<\/b>"},{"value":"Chonburi","text":"Chonburi<b>400<\/b>"},{"value":"Cinzel","text":"Cinzel<b>400,700,900<\/b>"},{"value":"Cinzel Decorative","text":"Cinzel Decorative<b>400,700,900<\/b>"},{"value":"Clicker Script","text":"Clicker Script<b>400<\/b>"},{"value":"Coda","text":"Coda<b>400,800<\/b>"},{"value":"Coda Caption","text":"Coda Caption<b>800<\/b>"},{"value":"Codystar","text":"Codystar<b>300,400<\/b>"},{"value":"Combo","text":"Combo<b>400<\/b>"},{"value":"Comfortaa","text":"Comfortaa<b>300,400,700<\/b>"},{"value":"Coming Soon","text":"Coming Soon<b>400<\/b>"},{"value":"Concert One","text":"Concert One<b>400<\/b>"},{"value":"Condiment","text":"Condiment<b>400<\/b>"},{"value":"Contrail One","text":"Contrail One<b>400<\/b>"},{"value":"Convergence","text":"Convergence<b>400<\/b>"},{"value":"Cookie","text":"Cookie<b>400<\/b>"},{"value":"Copse","text":"Copse<b>400<\/b>"},{"value":"Corben","text":"Corben<b>400,700<\/b>"},{"value":"Courgette","text":"Courgette<b>400<\/b>"},{"value":"Cousine","text":"Cousine<b>400,700<\/b>"},{"value":"Coustard","text":"Coustard<b>400,900<\/b>"},{"value":"Covered By Your Grace","text":"Covered By Your Grace<b>400<\/b>"},{"value":"Crafty Girls","text":"Crafty Girls<b>400<\/b>"},{"value":"Creepster","text":"Creepster<b>400<\/b>"},{"value":"Crete Round","text":"Crete Round<b>400<\/b>"},{"value":"Crimson Text","text":"Crimson Text<b>400,600,700<\/b>"},{"value":"Croissant One","text":"Croissant One<b>400<\/b>"},{"value":"Crushed","text":"Crushed<b>400<\/b>"},{"value":"Cuprum","text":"Cuprum<b>400,700<\/b>"},{"value":"Cutive","text":"Cutive<b>400<\/b>"},{"value":"Cutive Mono","text":"Cutive Mono<b>400<\/b>"},{"value":"Damion","text":"Damion<b>400<\/b>"},{"value":"Dancing Script","text":"Dancing Script<b>400,700<\/b>"},{"value":"Dawning of a New Day","text":"Dawning of a New Day<b>400<\/b>"},{"value":"Days One","text":"Days One<b>400<\/b>"},{"value":"Dekko","text":"Dekko<b>400<\/b>"},{"value":"Delius","text":"Delius<b>400<\/b>"},{"value":"Delius Swash Caps","text":"Delius Swash Caps<b>400<\/b>"},{"value":"Delius Unicase","text":"Delius Unicase<b>400,700<\/b>"},{"value":"Della Respira","text":"Della Respira<b>400<\/b>"},{"value":"Denk One","text":"Denk One<b>400<\/b>"},{"value":"Devonshire","text":"Devonshire<b>400<\/b>"},{"value":"Dhurjati","text":"Dhurjati<b>400<\/b>"},{"value":"Didact Gothic","text":"Didact Gothic<b>400<\/b>"},{"value":"Diplomata","text":"Diplomata<b>400<\/b>"},{"value":"Diplomata SC","text":"Diplomata SC<b>400<\/b>"},{"value":"Domine","text":"Domine<b>400,700<\/b>"},{"value":"Donegal One","text":"Donegal One<b>400<\/b>"},{"value":"Doppio One","text":"Doppio One<b>400<\/b>"},{"value":"Dorsa","text":"Dorsa<b>400<\/b>"},{"value":"Dosis","text":"Dosis<b>200,300,400,500,600,700,800<\/b>"},{"value":"Dr Sugiyama","text":"Dr Sugiyama<b>400<\/b>"},{"value":"Droid Sans","text":"Droid Sans<b>400,700<\/b>"},{"value":"Droid Sans Mono","text":"Droid Sans Mono<b>400<\/b>"},{"value":"Droid Serif","text":"Droid Serif<b>400,700<\/b>"},{"value":"Duru Sans","text":"Duru Sans<b>400<\/b>"},{"value":"Dynalight","text":"Dynalight<b>400<\/b>"},{"value":"EB Garamond","text":"EB Garamond<b>400<\/b>"},{"value":"Eagle Lake","text":"Eagle Lake<b>400<\/b>"},{"value":"Eater","text":"Eater<b>400<\/b>"},{"value":"Economica","text":"Economica<b>400,700<\/b>"},{"value":"Eczar","text":"Eczar<b>400,500,600,700,800<\/b>"},{"value":"Ek Mukta","text":"Ek Mukta<b>200,300,400,500,600,700,800<\/b>"},{"value":"Electrolize","text":"Electrolize<b>400<\/b>"},{"value":"Elsie","text":"Elsie<b>400,900<\/b>"},{"value":"Elsie Swash Caps","text":"Elsie Swash Caps<b>400,900<\/b>"},{"value":"Emblema One","text":"Emblema One<b>400<\/b>"},{"value":"Emilys Candy","text":"Emilys Candy<b>400<\/b>"},{"value":"Engagement","text":"Engagement<b>400<\/b>"},{"value":"Englebert","text":"Englebert<b>400<\/b>"},{"value":"Enriqueta","text":"Enriqueta<b>400,700<\/b>"},{"value":"Erica One","text":"Erica One<b>400<\/b>"},{"value":"Esteban","text":"Esteban<b>400<\/b>"},{"value":"Euphoria Script","text":"Euphoria Script<b>400<\/b>"},{"value":"Ewert","text":"Ewert<b>400<\/b>"},{"value":"Exo","text":"Exo<b>100,200,300,400,500,600,700,800,900<\/b>"},{"value":"Exo 2","text":"Exo 2<b>100,200,300,400,500,600,700,800,900<\/b>"},{"value":"Expletus Sans","text":"Expletus Sans<b>400,500,600,700<\/b>"},{"value":"Fanwood Text","text":"Fanwood Text<b>400<\/b>"},{"value":"Fascinate","text":"Fascinate<b>400<\/b>"},{"value":"Fascinate Inline","text":"Fascinate Inline<b>400<\/b>"},{"value":"Faster One","text":"Faster One<b>400<\/b>"},{"value":"Fauna One","text":"Fauna One<b>400<\/b>"},{"value":"Federant","text":"Federant<b>400<\/b>"},{"value":"Federo","text":"Federo<b>400<\/b>"},{"value":"Felipa","text":"Felipa<b>400<\/b>"},{"value":"Fenix","text":"Fenix<b>400<\/b>"},{"value":"Finger Paint","text":"Finger Paint<b>400<\/b>"},{"value":"Fira Mono","text":"Fira Mono<b>400,700<\/b>"},{"value":"Fira Sans","text":"Fira Sans<b>300,400,500,700<\/b>"},{"value":"Fjalla One","text":"Fjalla One<b>400<\/b>"},{"value":"Fjord One","text":"Fjord One<b>400<\/b>"},{"value":"Flamenco","text":"Flamenco<b>300,400<\/b>"},{"value":"Flavors","text":"Flavors<b>400<\/b>"},{"value":"Fondamento","text":"Fondamento<b>400<\/b>"},{"value":"Fontdiner Swanky","text":"Fontdiner Swanky<b>400<\/b>"},{"value":"Forum","text":"Forum<b>400<\/b>"},{"value":"Francois One","text":"Francois One<b>400<\/b>"},{"value":"Freckle Face","text":"Freckle Face<b>400<\/b>"},{"value":"Fredericka the Great","text":"Fredericka the Great<b>400<\/b>"},{"value":"Fredoka One","text":"Fredoka One<b>400<\/b>"},{"value":"Fresca","text":"Fresca<b>400<\/b>"},{"value":"Frijole","text":"Frijole<b>400<\/b>"},{"value":"Fruktur","text":"Fruktur<b>400<\/b>"},{"value":"Fugaz One","text":"Fugaz One<b>400<\/b>"},{"value":"Gabriela","text":"Gabriela<b>400<\/b>"},{"value":"Gafata","text":"Gafata<b>400<\/b>"},{"value":"Galdeano","text":"Galdeano<b>400<\/b>"},{"value":"Galindo","text":"Galindo<b>400<\/b>"},{"value":"Gentium Basic","text":"Gentium Basic<b>400,700<\/b>"},{"value":"Gentium Book Basic","text":"Gentium Book Basic<b>400,700<\/b>"},{"value":"Geo","text":"Geo<b>400<\/b>"},{"value":"Geostar","text":"Geostar<b>400<\/b>"},{"value":"Geostar Fill","text":"Geostar Fill<b>400<\/b>"},{"value":"Germania One","text":"Germania One<b>400<\/b>"},{"value":"Gidugu","text":"Gidugu<b>400<\/b>"},{"value":"Gilda Display","text":"Gilda Display<b>400<\/b>"},{"value":"Give You Glory","text":"Give You Glory<b>400<\/b>"},{"value":"Glass Antiqua","text":"Glass Antiqua<b>400<\/b>"},{"value":"Glegoo","text":"Glegoo<b>400,700<\/b>"},{"value":"Gloria Hallelujah","text":"Gloria Hallelujah<b>400<\/b>"},{"value":"Goblin One","text":"Goblin One<b>400<\/b>"},{"value":"Gochi Hand","text":"Gochi Hand<b>400<\/b>"},{"value":"Gorditas","text":"Gorditas<b>400,700<\/b>"},{"value":"Goudy Bookletter 1911","text":"Goudy Bookletter 1911<b>400<\/b>"},{"value":"Graduate","text":"Graduate<b>400<\/b>"},{"value":"Grand Hotel","text":"Grand Hotel<b>400<\/b>"},{"value":"Gravitas One","text":"Gravitas One<b>400<\/b>"},{"value":"Great Vibes","text":"Great Vibes<b>400<\/b>"},{"value":"Griffy","text":"Griffy<b>400<\/b>"},{"value":"Gruppo","text":"Gruppo<b>400<\/b>"},{"value":"Gudea","text":"Gudea<b>400,700<\/b>"},{"value":"Gurajada","text":"Gurajada<b>400<\/b>"},{"value":"Habibi","text":"Habibi<b>400<\/b>"},{"value":"Halant","text":"Halant<b>300,400,500,600,700<\/b>"},{"value":"Hammersmith One","text":"Hammersmith One<b>400<\/b>"},{"value":"Hanalei","text":"Hanalei<b>400<\/b>"},{"value":"Hanalei Fill","text":"Hanalei Fill<b>400<\/b>"},{"value":"Handlee","text":"Handlee<b>400<\/b>"},{"value":"Happy Monkey","text":"Happy Monkey<b>400<\/b>"},{"value":"Headland One","text":"Headland One<b>400<\/b>"},{"value":"Henny Penny","text":"Henny Penny<b>400<\/b>"},{"value":"Herr Von Muellerhoff","text":"Herr Von Muellerhoff<b>400<\/b>"},{"value":"Hind","text":"Hind<b>300,400,500,600,700<\/b>"},{"value":"Hind Siliguri","text":"Hind Siliguri<b>300,400,500,600,700<\/b>"},{"value":"Hind Vadodara","text":"Hind Vadodara<b>300,400,500,600,700<\/b>"},{"value":"Holtwood One SC","text":"Holtwood One SC<b>400<\/b>"},{"value":"Homemade Apple","text":"Homemade Apple<b>400<\/b>"},{"value":"Homenaje","text":"Homenaje<b>400<\/b>"},{"value":"IM Fell DW Pica","text":"IM Fell DW Pica<b>400<\/b>"},{"value":"IM Fell DW Pica SC","text":"IM Fell DW Pica SC<b>400<\/b>"},{"value":"IM Fell Double Pica","text":"IM Fell Double Pica<b>400<\/b>"},{"value":"IM Fell Double Pica SC","text":"IM Fell Double Pica SC<b>400<\/b>"},{"value":"IM Fell English","text":"IM Fell English<b>400<\/b>"},{"value":"IM Fell English SC","text":"IM Fell English SC<b>400<\/b>"},{"value":"IM Fell French Canon","text":"IM Fell French Canon<b>400<\/b>"},{"value":"IM Fell French Canon SC","text":"IM Fell French Canon SC<b>400<\/b>"},{"value":"IM Fell Great Primer","text":"IM Fell Great Primer<b>400<\/b>"},{"value":"IM Fell Great Primer SC","text":"IM Fell Great Primer SC<b>400<\/b>"},{"value":"Iceberg","text":"Iceberg<b>400<\/b>"},{"value":"Iceland","text":"Iceland<b>400<\/b>"},{"value":"Imprima","text":"Imprima<b>400<\/b>"},{"value":"Inconsolata","text":"Inconsolata<b>400,700<\/b>"},{"value":"Inder","text":"Inder<b>400<\/b>"},{"value":"Indie Flower","text":"Indie Flower<b>400<\/b>"},{"value":"Inika","text":"Inika<b>400,700<\/b>"},{"value":"Inknut Antiqua","text":"Inknut Antiqua<b>300,400,500,600,700,800,900<\/b>"},{"value":"Irish Grover","text":"Irish Grover<b>400<\/b>"},{"value":"Istok Web","text":"Istok Web<b>400,700<\/b>"},{"value":"Italiana","text":"Italiana<b>400<\/b>"},{"value":"Italianno","text":"Italianno<b>400<\/b>"},{"value":"Itim","text":"Itim<b>400<\/b>"},{"value":"Jacques Francois","text":"Jacques Francois<b>400<\/b>"},{"value":"Jacques Francois Shadow","text":"Jacques Francois Shadow<b>400<\/b>"},{"value":"Jaldi","text":"Jaldi<b>400,700<\/b>"},{"value":"Jim Nightshade","text":"Jim Nightshade<b>400<\/b>"},{"value":"Jockey One","text":"Jockey One<b>400<\/b>"},{"value":"Jolly Lodger","text":"Jolly Lodger<b>400<\/b>"},{"value":"Josefin Sans","text":"Josefin Sans<b>100,300,400,600,700<\/b>"},{"value":"Josefin Slab","text":"Josefin Slab<b>100,300,400,600,700<\/b>"},{"value":"Joti One","text":"Joti One<b>400<\/b>"},{"value":"Judson","text":"Judson<b>400,700<\/b>"},{"value":"Julee","text":"Julee<b>400<\/b>"},{"value":"Julius Sans One","text":"Julius Sans One<b>400<\/b>"},{"value":"Junge","text":"Junge<b>400<\/b>"},{"value":"Jura","text":"Jura<b>300,400,500,600<\/b>"},{"value":"Just Another Hand","text":"Just Another Hand<b>400<\/b>"},{"value":"Just Me Again Down Here","text":"Just Me Again Down Here<b>400<\/b>"},{"value":"Kadwa","text":"Kadwa<b>400,700<\/b>"},{"value":"Kalam","text":"Kalam<b>300,400,700<\/b>"},{"value":"Kameron","text":"Kameron<b>400,700<\/b>"},{"value":"Kanit","text":"Kanit<b>100,200,300,400,500,600,700,800,900<\/b>"},{"value":"Karla","text":"Karla<b>400,700<\/b>"},{"value":"Karma","text":"Karma<b>300,400,500,600,700<\/b>"},{"value":"Kaushan Script","text":"Kaushan Script<b>400<\/b>"},{"value":"Kavoon","text":"Kavoon<b>400<\/b>"},{"value":"Keania One","text":"Keania One<b>400<\/b>"},{"value":"Kelly Slab","text":"Kelly Slab<b>400<\/b>"},{"value":"Kenia","text":"Kenia<b>400<\/b>"},{"value":"Khand","text":"Khand<b>300,400,500,600,700<\/b>"},{"value":"Khula","text":"Khula<b>300,400,600,700,800<\/b>"},{"value":"Kite One","text":"Kite One<b>400<\/b>"},{"value":"Knewave","text":"Knewave<b>400<\/b>"},{"value":"Kotta One","text":"Kotta One<b>400<\/b>"},{"value":"Kranky","text":"Kranky<b>400<\/b>"},{"value":"Kreon","text":"Kreon<b>300,400,700<\/b>"},{"value":"Kristi","text":"Kristi<b>400<\/b>"},{"value":"Krona One","text":"Krona One<b>400<\/b>"},{"value":"Kurale","text":"Kurale<b>400<\/b>"},{"value":"La Belle Aurore","text":"La Belle Aurore<b>400<\/b>"},{"value":"Laila","text":"Laila<b>300,400,500,600,700<\/b>"},{"value":"Lakki Reddy","text":"Lakki Reddy<b>400<\/b>"},{"value":"Lancelot","text":"Lancelot<b>400<\/b>"},{"value":"Lateef","text":"Lateef<b>400<\/b>"},{"value":"Lato","text":"Lato<b>100,300,400,700,900<\/b>"},{"value":"League Script","text":"League Script<b>400<\/b>"},{"value":"Leckerli One","text":"Leckerli One<b>400<\/b>"},{"value":"Ledger","text":"Ledger<b>400<\/b>"},{"value":"Lekton","text":"Lekton<b>400,700<\/b>"},{"value":"Lemon","text":"Lemon<b>400<\/b>"},{"value":"Libre Baskerville","text":"Libre Baskerville<b>400,700<\/b>"},{"value":"Life Savers","text":"Life Savers<b>400,700<\/b>"},{"value":"Lilita One","text":"Lilita One<b>400<\/b>"},{"value":"Lily Script One","text":"Lily Script One<b>400<\/b>"},{"value":"Limelight","text":"Limelight<b>400<\/b>"},{"value":"Linden Hill","text":"Linden Hill<b>400<\/b>"},{"value":"Lobster","text":"Lobster<b>400<\/b>"},{"value":"Lobster Two","text":"Lobster Two<b>400,700<\/b>"},{"value":"Londrina Outline","text":"Londrina Outline<b>400<\/b>"},{"value":"Londrina Shadow","text":"Londrina Shadow<b>400<\/b>"},{"value":"Londrina Sketch","text":"Londrina Sketch<b>400<\/b>"},{"value":"Londrina Solid","text":"Londrina Solid<b>400<\/b>"},{"value":"Lora","text":"Lora<b>400,700<\/b>"},{"value":"Love Ya Like A Sister","text":"Love Ya Like A Sister<b>400<\/b>"},{"value":"Loved by the King","text":"Loved by the King<b>400<\/b>"},{"value":"Lovers Quarrel","text":"Lovers Quarrel<b>400<\/b>"},{"value":"Luckiest Guy","text":"Luckiest Guy<b>400<\/b>"},{"value":"Lusitana","text":"Lusitana<b>400,700<\/b>"},{"value":"Lustria","text":"Lustria<b>400<\/b>"},{"value":"Macondo","text":"Macondo<b>400<\/b>"},{"value":"Macondo Swash Caps","text":"Macondo Swash Caps<b>400<\/b>"},{"value":"Magra","text":"Magra<b>400,700<\/b>"},{"value":"Maiden Orange","text":"Maiden Orange<b>400<\/b>"},{"value":"Mako","text":"Mako<b>400<\/b>"},{"value":"Mallanna","text":"Mallanna<b>400<\/b>"},{"value":"Mandali","text":"Mandali<b>400<\/b>"},{"value":"Marcellus","text":"Marcellus<b>400<\/b>"},{"value":"Marcellus SC","text":"Marcellus SC<b>400<\/b>"},{"value":"Marck Script","text":"Marck Script<b>400<\/b>"},{"value":"Margarine","text":"Margarine<b>400<\/b>"},{"value":"Marko One","text":"Marko One<b>400<\/b>"},{"value":"Marmelad","text":"Marmelad<b>400<\/b>"},{"value":"Martel","text":"Martel<b>200,300,400,600,700,800,900<\/b>"},{"value":"Martel Sans","text":"Martel Sans<b>200,300,400,600,700,800,900<\/b>"},{"value":"Marvel","text":"Marvel<b>400,700<\/b>"},{"value":"Mate","text":"Mate<b>400<\/b>"},{"value":"Mate SC","text":"Mate SC<b>400<\/b>"},{"value":"Maven Pro","text":"Maven Pro<b>400,500,700,900<\/b>"},{"value":"McLaren","text":"McLaren<b>400<\/b>"},{"value":"Meddon","text":"Meddon<b>400<\/b>"},{"value":"MedievalSharp","text":"MedievalSharp<b>400<\/b>"},{"value":"Medula One","text":"Medula One<b>400<\/b>"},{"value":"Megrim","text":"Megrim<b>400<\/b>"},{"value":"Meie Script","text":"Meie Script<b>400<\/b>"},{"value":"Merienda","text":"Merienda<b>400,700<\/b>"},{"value":"Merienda One","text":"Merienda One<b>400<\/b>"},{"value":"Merriweather","text":"Merriweather<b>300,400,700,900<\/b>"},{"value":"Merriweather Sans","text":"Merriweather Sans<b>300,400,700,800<\/b>"},{"value":"Metal Mania","text":"Metal Mania<b>400<\/b>"},{"value":"Metamorphous","text":"Metamorphous<b>400<\/b>"},{"value":"Metrophobic","text":"Metrophobic<b>400<\/b>"},{"value":"Michroma","text":"Michroma<b>400<\/b>"},{"value":"Milonga","text":"Milonga<b>400<\/b>"},{"value":"Miltonian","text":"Miltonian<b>400<\/b>"},{"value":"Miltonian Tattoo","text":"Miltonian Tattoo<b>400<\/b>"},{"value":"Miniver","text":"Miniver<b>400<\/b>"},{"value":"Miss Fajardose","text":"Miss Fajardose<b>400<\/b>"},{"value":"Modak","text":"Modak<b>400<\/b>"},{"value":"Modern Antiqua","text":"Modern Antiqua<b>400<\/b>"},{"value":"Molengo","text":"Molengo<b>400<\/b>"},{"value":"Molle","text":"Molle<b><\/b>"},{"value":"Monda","text":"Monda<b>400,700<\/b>"},{"value":"Monofett","text":"Monofett<b>400<\/b>"},{"value":"Monoton","text":"Monoton<b>400<\/b>"},{"value":"Monsieur La Doulaise","text":"Monsieur La Doulaise<b>400<\/b>"},{"value":"Montaga","text":"Montaga<b>400<\/b>"},{"value":"Montez","text":"Montez<b>400<\/b>"},{"value":"Montserrat","text":"Montserrat<b>400,700<\/b>"},{"value":"Montserrat Alternates","text":"Montserrat Alternates<b>400,700<\/b>"},{"value":"Montserrat Subrayada","text":"Montserrat Subrayada<b>400,700<\/b>"},{"value":"Mountains of Christmas","text":"Mountains of Christmas<b>400,700<\/b>"},{"value":"Mouse Memoirs","text":"Mouse Memoirs<b>400<\/b>"},{"value":"Mr Bedfort","text":"Mr Bedfort<b>400<\/b>"},{"value":"Mr Dafoe","text":"Mr Dafoe<b>400<\/b>"},{"value":"Mr De Haviland","text":"Mr De Haviland<b>400<\/b>"},{"value":"Mrs Saint Delafield","text":"Mrs Saint Delafield<b>400<\/b>"},{"value":"Mrs Sheppards","text":"Mrs Sheppards<b>400<\/b>"},{"value":"Muli","text":"Muli<b>300,400<\/b>"},{"value":"Mystery Quest","text":"Mystery Quest<b>400<\/b>"},{"value":"NTR","text":"NTR<b>400<\/b>"},{"value":"Neucha","text":"Neucha<b>400<\/b>"},{"value":"Neuton","text":"Neuton<b>200,300,400,700,800<\/b>"},{"value":"New Rocker","text":"New Rocker<b>400<\/b>"},{"value":"News Cycle","text":"News Cycle<b>400,700<\/b>"},{"value":"Niconne","text":"Niconne<b>400<\/b>"},{"value":"Nixie One","text":"Nixie One<b>400<\/b>"},{"value":"Nobile","text":"Nobile<b>400,700<\/b>"},{"value":"Norican","text":"Norican<b>400<\/b>"},{"value":"Nosifer","text":"Nosifer<b>400<\/b>"},{"value":"Nothing You Could Do","text":"Nothing You Could Do<b>400<\/b>"},{"value":"Noticia Text","text":"Noticia Text<b>400,700<\/b>"},{"value":"Noto Sans","text":"Noto Sans<b>400,700<\/b>"},{"value":"Noto Serif","text":"Noto Serif<b>400,700<\/b>"},{"value":"Nova Cut","text":"Nova Cut<b>400<\/b>"},{"value":"Nova Flat","text":"Nova Flat<b>400<\/b>"},{"value":"Nova Mono","text":"Nova Mono<b>400<\/b>"},{"value":"Nova Oval","text":"Nova Oval<b>400<\/b>"},{"value":"Nova Round","text":"Nova Round<b>400<\/b>"},{"value":"Nova Script","text":"Nova Script<b>400<\/b>"},{"value":"Nova Slim","text":"Nova Slim<b>400<\/b>"},{"value":"Nova Square","text":"Nova Square<b>400<\/b>"},{"value":"Numans","text":"Numans<b>400<\/b>"},{"value":"Nunito","text":"Nunito<b>300,400,700<\/b>"},{"value":"Offside","text":"Offside<b>400<\/b>"},{"value":"Old Standard TT","text":"Old Standard TT<b>400,700<\/b>"},{"value":"Oldenburg","text":"Oldenburg<b>400<\/b>"},{"value":"Oleo Script","text":"Oleo Script<b>400,700<\/b>"},{"value":"Oleo Script Swash Caps","text":"Oleo Script Swash Caps<b>400,700<\/b>"},{"value":"Open Sans","text":"Open Sans<b>300,400,600,700,800<\/b>"},{"value":"Open Sans Condensed","text":"Open Sans Condensed<b>300,700<\/b>"},{"value":"Oranienbaum","text":"Oranienbaum<b>400<\/b>"},{"value":"Orbitron","text":"Orbitron<b>400,500,700,900<\/b>"},{"value":"Oregano","text":"Oregano<b>400<\/b>"},{"value":"Orienta","text":"Orienta<b>400<\/b>"},{"value":"Original Surfer","text":"Original Surfer<b>400<\/b>"},{"value":"Oswald","text":"Oswald<b>300,400,700<\/b>"},{"value":"Over the Rainbow","text":"Over the Rainbow<b>400<\/b>"},{"value":"Overlock","text":"Overlock<b>400,700,900<\/b>"},{"value":"Overlock SC","text":"Overlock SC<b>400<\/b>"},{"value":"Ovo","text":"Ovo<b>400<\/b>"},{"value":"Oxygen","text":"Oxygen<b>300,400,700<\/b>"},{"value":"Oxygen Mono","text":"Oxygen Mono<b>400<\/b>"},{"value":"PT Mono","text":"PT Mono<b>400<\/b>"},{"value":"PT Sans","text":"PT Sans<b>400,700<\/b>"},{"value":"PT Sans Caption","text":"PT Sans Caption<b>400,700<\/b>"},{"value":"PT Sans Narrow","text":"PT Sans Narrow<b>400,700<\/b>"},{"value":"PT Serif","text":"PT Serif<b>400,700<\/b>"},{"value":"PT Serif Caption","text":"PT Serif Caption<b>400<\/b>"},{"value":"Pacifico","text":"Pacifico<b>400<\/b>"},{"value":"Palanquin","text":"Palanquin<b>100,200,300,400,500,600,700<\/b>"},{"value":"Palanquin Dark","text":"Palanquin Dark<b>400,500,600,700<\/b>"},{"value":"Paprika","text":"Paprika<b>400<\/b>"},{"value":"Parisienne","text":"Parisienne<b>400<\/b>"},{"value":"Passero One","text":"Passero One<b>400<\/b>"},{"value":"Passion One","text":"Passion One<b>400,700,900<\/b>"},{"value":"Pathway Gothic One","text":"Pathway Gothic One<b>400<\/b>"},{"value":"Patrick Hand","text":"Patrick Hand<b>400<\/b>"},{"value":"Patrick Hand SC","text":"Patrick Hand SC<b>400<\/b>"},{"value":"Patua One","text":"Patua One<b>400<\/b>"},{"value":"Paytone One","text":"Paytone One<b>400<\/b>"},{"value":"Peddana","text":"Peddana<b>400<\/b>"},{"value":"Peralta","text":"Peralta<b>400<\/b>"},{"value":"Permanent Marker","text":"Permanent Marker<b>400<\/b>"},{"value":"Petit Formal Script","text":"Petit Formal Script<b>400<\/b>"},{"value":"Petrona","text":"Petrona<b>400<\/b>"},{"value":"Philosopher","text":"Philosopher<b>400,700<\/b>"},{"value":"Piedra","text":"Piedra<b>400<\/b>"},{"value":"Pinyon Script","text":"Pinyon Script<b>400<\/b>"},{"value":"Pirata One","text":"Pirata One<b>400<\/b>"},{"value":"Plaster","text":"Plaster<b>400<\/b>"},{"value":"Play","text":"Play<b>400,700<\/b>"},{"value":"Playball","text":"Playball<b>400<\/b>"},{"value":"Playfair Display","text":"Playfair Display<b>400,700,900<\/b>"},{"value":"Playfair Display SC","text":"Playfair Display SC<b>400,700,900<\/b>"},{"value":"Podkova","text":"Podkova<b>400,700<\/b>"},{"value":"Poiret One","text":"Poiret One<b>400<\/b>"},{"value":"Poller One","text":"Poller One<b>400<\/b>"},{"value":"Poly","text":"Poly<b>400<\/b>"},{"value":"Pompiere","text":"Pompiere<b>400<\/b>"},{"value":"Pontano Sans","text":"Pontano Sans<b>400<\/b>"},{"value":"Poppins","text":"Poppins<b>300,400,500,600,700<\/b>"},{"value":"Port Lligat Sans","text":"Port Lligat Sans<b>400<\/b>"},{"value":"Port Lligat Slab","text":"Port Lligat Slab<b>400<\/b>"},{"value":"Pragati Narrow","text":"Pragati Narrow<b>400,700<\/b>"},{"value":"Prata","text":"Prata<b>400<\/b>"},{"value":"Press Start 2P","text":"Press Start 2P<b>400<\/b>"},{"value":"Princess Sofia","text":"Princess Sofia<b>400<\/b>"},{"value":"Prociono","text":"Prociono<b>400<\/b>"},{"value":"Prosto One","text":"Prosto One<b>400<\/b>"},{"value":"Puritan","text":"Puritan<b>400,700<\/b>"},{"value":"Purple Purse","text":"Purple Purse<b>400<\/b>"},{"value":"Quando","text":"Quando<b>400<\/b>"},{"value":"Quantico","text":"Quantico<b>400,700<\/b>"},{"value":"Quattrocento","text":"Quattrocento<b>400,700<\/b>"},{"value":"Quattrocento Sans","text":"Quattrocento Sans<b>400,700<\/b>"},{"value":"Questrial","text":"Questrial<b>400<\/b>"},{"value":"Quicksand","text":"Quicksand<b>300,400,700<\/b>"},{"value":"Quintessential","text":"Quintessential<b>400<\/b>"},{"value":"Qwigley","text":"Qwigley<b>400<\/b>"},{"value":"Racing Sans One","text":"Racing Sans One<b>400<\/b>"},{"value":"Radley","text":"Radley<b>400<\/b>"},{"value":"Rajdhani","text":"Rajdhani<b>300,400,500,600,700<\/b>"},{"value":"Raleway","text":"Raleway<b>100,200,300,400,500,600,700,800,900<\/b>"},{"value":"Raleway Dots","text":"Raleway Dots<b>400<\/b>"},{"value":"Ramabhadra","text":"Ramabhadra<b>400<\/b>"},{"value":"Ramaraja","text":"Ramaraja<b>400<\/b>"},{"value":"Rambla","text":"Rambla<b>400,700<\/b>"},{"value":"Rammetto One","text":"Rammetto One<b>400<\/b>"},{"value":"Ranchers","text":"Ranchers<b>400<\/b>"},{"value":"Rancho","text":"Rancho<b>400<\/b>"},{"value":"Ranga","text":"Ranga<b>400,700<\/b>"},{"value":"Rationale","text":"Rationale<b>400<\/b>"},{"value":"Ravi Prakash","text":"Ravi Prakash<b>400<\/b>"},{"value":"Redressed","text":"Redressed<b>400<\/b>"},{"value":"Reenie Beanie","text":"Reenie Beanie<b>400<\/b>"},{"value":"Revalia","text":"Revalia<b>400<\/b>"},{"value":"Rhodium Libre","text":"Rhodium Libre<b>400<\/b>"},{"value":"Ribeye","text":"Ribeye<b>400<\/b>"},{"value":"Ribeye Marrow","text":"Ribeye Marrow<b>400<\/b>"},{"value":"Righteous","text":"Righteous<b>400<\/b>"},{"value":"Risque","text":"Risque<b>400<\/b>"},{"value":"Roboto","text":"Roboto<b>100,300,400,500,700,900<\/b>"},{"value":"Roboto Condensed","text":"Roboto Condensed<b>300,400,700<\/b>"},{"value":"Roboto Mono","text":"Roboto Mono<b>100,300,400,500,700<\/b>"},{"value":"Roboto Slab","text":"Roboto Slab<b>100,300,400,700<\/b>"},{"value":"Rochester","text":"Rochester<b>400<\/b>"},{"value":"Rock Salt","text":"Rock Salt<b>400<\/b>"},{"value":"Rokkitt","text":"Rokkitt<b>400,700<\/b>"},{"value":"Romanesco","text":"Romanesco<b>400<\/b>"},{"value":"Ropa Sans","text":"Ropa Sans<b>400<\/b>"},{"value":"Rosario","text":"Rosario<b>400,700<\/b>"},{"value":"Rosarivo","text":"Rosarivo<b>400<\/b>"},{"value":"Rouge Script","text":"Rouge Script<b>400<\/b>"},{"value":"Rozha One","text":"Rozha One<b>400<\/b>"},{"value":"Rubik","text":"Rubik<b>300,400,500,700,900<\/b>"},{"value":"Rubik Mono One","text":"Rubik Mono One<b>400<\/b>"},{"value":"Rubik One","text":"Rubik One<b>400<\/b>"},{"value":"Ruda","text":"Ruda<b>400,700,900<\/b>"},{"value":"Rufina","text":"Rufina<b>400,700<\/b>"},{"value":"Ruge Boogie","text":"Ruge Boogie<b>400<\/b>"},{"value":"Ruluko","text":"Ruluko<b>400<\/b>"},{"value":"Rum Raisin","text":"Rum Raisin<b>400<\/b>"},{"value":"Ruslan Display","text":"Ruslan Display<b>400<\/b>"},{"value":"Russo One","text":"Russo One<b>400<\/b>"},{"value":"Ruthie","text":"Ruthie<b>400<\/b>"},{"value":"Rye","text":"Rye<b>400<\/b>"},{"value":"Sacramento","text":"Sacramento<b>400<\/b>"},{"value":"Sahitya","text":"Sahitya<b>400,700<\/b>"},{"value":"Sail","text":"Sail<b>400<\/b>"},{"value":"Salsa","text":"Salsa<b>400<\/b>"},{"value":"Sanchez","text":"Sanchez<b>400<\/b>"},{"value":"Sancreek","text":"Sancreek<b>400<\/b>"},{"value":"Sansita One","text":"Sansita One<b>400<\/b>"},{"value":"Sarala","text":"Sarala<b>400,700<\/b>"},{"value":"Sarina","text":"Sarina<b>400<\/b>"},{"value":"Sarpanch","text":"Sarpanch<b>400,500,600,700,800,900<\/b>"},{"value":"Satisfy","text":"Satisfy<b>400<\/b>"},{"value":"Scada","text":"Scada<b>400,700<\/b>"},{"value":"Scheherazade","text":"Scheherazade<b>400,700<\/b>"},{"value":"Schoolbell","text":"Schoolbell<b>400<\/b>"},{"value":"Seaweed Script","text":"Seaweed Script<b>400<\/b>"},{"value":"Sevillana","text":"Sevillana<b>400<\/b>"},{"value":"Seymour One","text":"Seymour One<b>400<\/b>"},{"value":"Shadows Into Light","text":"Shadows Into Light<b>400<\/b>"},{"value":"Shadows Into Light Two","text":"Shadows Into Light Two<b>400<\/b>"},{"value":"Shanti","text":"Shanti<b>400<\/b>"},{"value":"Share","text":"Share<b>400,700<\/b>"},{"value":"Share Tech","text":"Share Tech<b>400<\/b>"},{"value":"Share Tech Mono","text":"Share Tech Mono<b>400<\/b>"},{"value":"Shojumaru","text":"Shojumaru<b>400<\/b>"},{"value":"Short Stack","text":"Short Stack<b>400<\/b>"},{"value":"Sigmar One","text":"Sigmar One<b>400<\/b>"},{"value":"Signika","text":"Signika<b>300,400,600,700<\/b>"},{"value":"Signika Negative","text":"Signika Negative<b>300,400,600,700<\/b>"},{"value":"Simonetta","text":"Simonetta<b>400,900<\/b>"},{"value":"Sintony","text":"Sintony<b>400,700<\/b>"},{"value":"Sirin Stencil","text":"Sirin Stencil<b>400<\/b>"},{"value":"Six Caps","text":"Six Caps<b>400<\/b>"},{"value":"Skranji","text":"Skranji<b>400,700<\/b>"},{"value":"Slabo 13px","text":"Slabo 13px<b>400<\/b>"},{"value":"Slabo 27px","text":"Slabo 27px<b>400<\/b>"},{"value":"Slackey","text":"Slackey<b>400<\/b>"},{"value":"Smokum","text":"Smokum<b>400<\/b>"},{"value":"Smythe","text":"Smythe<b>400<\/b>"},{"value":"Sniglet","text":"Sniglet<b>400,800<\/b>"},{"value":"Snippet","text":"Snippet<b>400<\/b>"},{"value":"Snowburst One","text":"Snowburst One<b>400<\/b>"},{"value":"Sofadi One","text":"Sofadi One<b>400<\/b>"},{"value":"Sofia","text":"Sofia<b>400<\/b>"},{"value":"Sonsie One","text":"Sonsie One<b>400<\/b>"},{"value":"Sorts Mill Goudy","text":"Sorts Mill Goudy<b>400<\/b>"},{"value":"Source Code Pro","text":"Source Code Pro<b>200,300,400,500,600,700,900<\/b>"},{"value":"Source Sans Pro","text":"Source Sans Pro<b>200,300,400,600,700,900<\/b>"},{"value":"Source Serif Pro","text":"Source Serif Pro<b>400,600,700<\/b>"},{"value":"Special Elite","text":"Special Elite<b>400<\/b>"},{"value":"Spicy Rice","text":"Spicy Rice<b>400<\/b>"},{"value":"Spinnaker","text":"Spinnaker<b>400<\/b>"},{"value":"Spirax","text":"Spirax<b>400<\/b>"},{"value":"Squada One","text":"Squada One<b>400<\/b>"},{"value":"Sree Krushnadevaraya","text":"Sree Krushnadevaraya<b>400<\/b>"},{"value":"Stalemate","text":"Stalemate<b>400<\/b>"},{"value":"Stalinist One","text":"Stalinist One<b>400<\/b>"},{"value":"Stardos Stencil","text":"Stardos Stencil<b>400,700<\/b>"},{"value":"Stint Ultra Condensed","text":"Stint Ultra Condensed<b>400<\/b>"},{"value":"Stint Ultra Expanded","text":"Stint Ultra Expanded<b>400<\/b>"},{"value":"Stoke","text":"Stoke<b>300,400<\/b>"},{"value":"Strait","text":"Strait<b>400<\/b>"},{"value":"Sue Ellen Francisco","text":"Sue Ellen Francisco<b>400<\/b>"},{"value":"Sumana","text":"Sumana<b>400,700<\/b>"},{"value":"Sunshiney","text":"Sunshiney<b>400<\/b>"},{"value":"Supermercado One","text":"Supermercado One<b>400<\/b>"},{"value":"Sura","text":"Sura<b>400,700<\/b>"},{"value":"Suranna","text":"Suranna<b>400<\/b>"},{"value":"Suravaram","text":"Suravaram<b>400<\/b>"},{"value":"Swanky and Moo Moo","text":"Swanky and Moo Moo<b>400<\/b>"},{"value":"Syncopate","text":"Syncopate<b>400,700<\/b>"},{"value":"Tangerine","text":"Tangerine<b>400,700<\/b>"},{"value":"Tauri","text":"Tauri<b>400<\/b>"},{"value":"Teko","text":"Teko<b>300,400,500,600,700<\/b>"},{"value":"Telex","text":"Telex<b>400<\/b>"},{"value":"Tenali Ramakrishna","text":"Tenali Ramakrishna<b>400<\/b>"},{"value":"Tenor Sans","text":"Tenor Sans<b>400<\/b>"},{"value":"Text Me One","text":"Text Me One<b>400<\/b>"},{"value":"The Girl Next Door","text":"The Girl Next Door<b>400<\/b>"},{"value":"Tienne","text":"Tienne<b>400,700,900<\/b>"},{"value":"Tillana","text":"Tillana<b>400,500,600,700,800<\/b>"},{"value":"Timmana","text":"Timmana<b>400<\/b>"},{"value":"Tinos","text":"Tinos<b>400,700<\/b>"},{"value":"Titan One","text":"Titan One<b>400<\/b>"},{"value":"Titillium Web","text":"Titillium Web<b>200,300,400,600,700,900<\/b>"},{"value":"Trade Winds","text":"Trade Winds<b>400<\/b>"},{"value":"Trocchi","text":"Trocchi<b>400<\/b>"},{"value":"Trochut","text":"Trochut<b>400,700<\/b>"},{"value":"Trykker","text":"Trykker<b>400<\/b>"},{"value":"Tulpen One","text":"Tulpen One<b>400<\/b>"},{"value":"Ubuntu","text":"Ubuntu<b>300,400,500,700<\/b>"},{"value":"Ubuntu Condensed","text":"Ubuntu Condensed<b>400<\/b>"},{"value":"Ubuntu Mono","text":"Ubuntu Mono<b>400,700<\/b>"},{"value":"Ultra","text":"Ultra<b>400<\/b>"},{"value":"Uncial Antiqua","text":"Uncial Antiqua<b>400<\/b>"},{"value":"Underdog","text":"Underdog<b>400<\/b>"},{"value":"Unica One","text":"Unica One<b>400<\/b>"},{"value":"UnifrakturCook","text":"UnifrakturCook<b>700<\/b>"},{"value":"UnifrakturMaguntia","text":"UnifrakturMaguntia<b>400<\/b>"},{"value":"Unkempt","text":"Unkempt<b>400,700<\/b>"},{"value":"Unlock","text":"Unlock<b>400<\/b>"},{"value":"Unna","text":"Unna<b>400<\/b>"},{"value":"VT323","text":"VT323<b>400<\/b>"},{"value":"Vampiro One","text":"Vampiro One<b>400<\/b>"},{"value":"Varela","text":"Varela<b>400<\/b>"},{"value":"Varela Round","text":"Varela Round<b>400<\/b>"},{"value":"Vast Shadow","text":"Vast Shadow<b>400<\/b>"},{"value":"Vesper Libre","text":"Vesper Libre<b>400,500,700,900<\/b>"},{"value":"Vibur","text":"Vibur<b>400<\/b>"},{"value":"Vidaloka","text":"Vidaloka<b>400<\/b>"},{"value":"Viga","text":"Viga<b>400<\/b>"},{"value":"Voces","text":"Voces<b>400<\/b>"},{"value":"Volkhov","text":"Volkhov<b>400,700<\/b>"},{"value":"Vollkorn","text":"Vollkorn<b>400,700<\/b>"},{"value":"Voltaire","text":"Voltaire<b>400<\/b>"},{"value":"Waiting for the Sunrise","text":"Waiting for the Sunrise<b>400<\/b>"},{"value":"Wallpoet","text":"Wallpoet<b>400<\/b>"},{"value":"Walter Turncoat","text":"Walter Turncoat<b>400<\/b>"},{"value":"Warnes","text":"Warnes<b>400<\/b>"},{"value":"Wellfleet","text":"Wellfleet<b>400<\/b>"},{"value":"Wendy One","text":"Wendy One<b>400<\/b>"},{"value":"Wire One","text":"Wire One<b>400<\/b>"},{"value":"Work Sans","text":"Work Sans<b>100,200,300,400,500,600,700,800,900<\/b>"},{"value":"Yanone Kaffeesatz","text":"Yanone Kaffeesatz<b>200,300,400,700<\/b>"},{"value":"Yantramanav","text":"Yantramanav<b>100,300,400,500,700,900<\/b>"},{"value":"Yellowtail","text":"Yellowtail<b>400<\/b>"},{"value":"Yeseva One","text":"Yeseva One<b>400<\/b>"},{"value":"Yesteryear","text":"Yesteryear<b>400<\/b>"},{"value":"Zeyada","text":"Zeyada<b>400<\/b>"}];
OfflajnFont_latin_ext = [{"value":"Abril Fatface","text":"Abril Fatface<b>400<\/b>"},{"value":"Advent Pro","text":"Advent Pro<b>100,200,300,400,500,600,700<\/b>"},{"value":"Aguafina Script","text":"Aguafina Script<b>400<\/b>"},{"value":"Akronim","text":"Akronim<b>400<\/b>"},{"value":"Aladin","text":"Aladin<b>400<\/b>"},{"value":"Alegreya","text":"Alegreya<b>400,700,900<\/b>"},{"value":"Alegreya SC","text":"Alegreya SC<b>400,700,900<\/b>"},{"value":"Alegreya Sans","text":"Alegreya Sans<b>100,300,400,500,700,800,900<\/b>"},{"value":"Alegreya Sans SC","text":"Alegreya Sans SC<b>100,300,400,500,700,800,900<\/b>"},{"value":"Alex Brush","text":"Alex Brush<b>400<\/b>"},{"value":"Allan","text":"Allan<b>400,700<\/b>"},{"value":"Allura","text":"Allura<b>400<\/b>"},{"value":"Almendra","text":"Almendra<b>400,700<\/b>"},{"value":"Almendra Display","text":"Almendra Display<b>400<\/b>"},{"value":"Amarante","text":"Amarante<b>400<\/b>"},{"value":"Amatic SC","text":"Amatic SC<b>400,700<\/b>"},{"value":"Amita","text":"Amita<b>400,700<\/b>"},{"value":"Anaheim","text":"Anaheim<b>400<\/b>"},{"value":"Andada","text":"Andada<b>400<\/b>"},{"value":"Andika","text":"Andika<b>400<\/b>"},{"value":"Anonymous Pro","text":"Anonymous Pro<b>400,700<\/b>"},{"value":"Anton","text":"Anton<b>400<\/b>"},{"value":"Arbutus","text":"Arbutus<b>400<\/b>"},{"value":"Arbutus Slab","text":"Arbutus Slab<b>400<\/b>"},{"value":"Archivo Black","text":"Archivo Black<b>400<\/b>"},{"value":"Archivo Narrow","text":"Archivo Narrow<b>400,700<\/b>"},{"value":"Arimo","text":"Arimo<b>400,700<\/b>"},{"value":"Arizonia","text":"Arizonia<b>400<\/b>"},{"value":"Armata","text":"Armata<b>400<\/b>"},{"value":"Arya","text":"Arya<b>400,700<\/b>"},{"value":"Asap","text":"Asap<b>400,700<\/b>"},{"value":"Asar","text":"Asar<b>400<\/b>"},{"value":"Audiowide","text":"Audiowide<b>400<\/b>"},{"value":"Autour One","text":"Autour One<b>400<\/b>"},{"value":"Average","text":"Average<b>400<\/b>"},{"value":"Average Sans","text":"Average Sans<b>400<\/b>"},{"value":"Averia Gruesa Libre","text":"Averia Gruesa Libre<b>400<\/b>"},{"value":"Basic","text":"Basic<b>400<\/b>"},{"value":"Belleza","text":"Belleza<b>400<\/b>"},{"value":"BenchNine","text":"BenchNine<b>300,400,700<\/b>"},{"value":"Berkshire Swash","text":"Berkshire Swash<b>400<\/b>"},{"value":"Bigelow Rules","text":"Bigelow Rules<b>400<\/b>"},{"value":"Bilbo","text":"Bilbo<b>400<\/b>"},{"value":"Bilbo Swash Caps","text":"Bilbo Swash Caps<b>400<\/b>"},{"value":"Biryani","text":"Biryani<b>200,300,400,600,700,800,900<\/b>"},{"value":"Bitter","text":"Bitter<b>400,700<\/b>"},{"value":"Black Ops One","text":"Black Ops One<b>400<\/b>"},{"value":"Bowlby One SC","text":"Bowlby One SC<b>400<\/b>"},{"value":"Bree Serif","text":"Bree Serif<b>400<\/b>"},{"value":"Bubblegum Sans","text":"Bubblegum Sans<b>400<\/b>"},{"value":"Bubbler One","text":"Bubbler One<b>400<\/b>"},{"value":"Buenard","text":"Buenard<b>400,700<\/b>"},{"value":"Butcherman","text":"Butcherman<b>400<\/b>"},{"value":"Butterfly Kids","text":"Butterfly Kids<b>400<\/b>"},{"value":"Cambay","text":"Cambay<b>400,700<\/b>"},{"value":"Cantata One","text":"Cantata One<b>400<\/b>"},{"value":"Cantora One","text":"Cantora One<b>400<\/b>"},{"value":"Capriola","text":"Capriola<b>400<\/b>"},{"value":"Cardo","text":"Cardo<b>400,700<\/b>"},{"value":"Catamaran","text":"Catamaran<b>100,200,300,400,500,600,700,800,900<\/b>"},{"value":"Caudex","text":"Caudex<b>400,700<\/b>"},{"value":"Caveat","text":"Caveat<b>400,700<\/b>"},{"value":"Caveat Brush","text":"Caveat Brush<b>400<\/b>"},{"value":"Chango","text":"Chango<b>400<\/b>"},{"value":"Chau Philomene One","text":"Chau Philomene One<b>400<\/b>"},{"value":"Chela One","text":"Chela One<b>400<\/b>"},{"value":"Chelsea Market","text":"Chelsea Market<b>400<\/b>"},{"value":"Cherry Swash","text":"Cherry Swash<b>400,700<\/b>"},{"value":"Chicle","text":"Chicle<b>400<\/b>"},{"value":"Chonburi","text":"Chonburi<b>400<\/b>"},{"value":"Clicker Script","text":"Clicker Script<b>400<\/b>"},{"value":"Coda","text":"Coda<b>400,800<\/b>"},{"value":"Coda Caption","text":"Coda Caption<b>800<\/b>"},{"value":"Codystar","text":"Codystar<b>300,400<\/b>"},{"value":"Combo","text":"Combo<b>400<\/b>"},{"value":"Comfortaa","text":"Comfortaa<b>300,400,700<\/b>"},{"value":"Concert One","text":"Concert One<b>400<\/b>"},{"value":"Condiment","text":"Condiment<b>400<\/b>"},{"value":"Corben","text":"Corben<b>400,700<\/b>"},{"value":"Courgette","text":"Courgette<b>400<\/b>"},{"value":"Cousine","text":"Cousine<b>400,700<\/b>"},{"value":"Crete Round","text":"Crete Round<b>400<\/b>"},{"value":"Croissant One","text":"Croissant One<b>400<\/b>"},{"value":"Cuprum","text":"Cuprum<b>400,700<\/b>"},{"value":"Cutive","text":"Cutive<b>400<\/b>"},{"value":"Cutive Mono","text":"Cutive Mono<b>400<\/b>"},{"value":"Dekko","text":"Dekko<b>400<\/b>"},{"value":"Denk One","text":"Denk One<b>400<\/b>"},{"value":"Devonshire","text":"Devonshire<b>400<\/b>"},{"value":"Didact Gothic","text":"Didact Gothic<b>400<\/b>"},{"value":"Diplomata","text":"Diplomata<b>400<\/b>"},{"value":"Diplomata SC","text":"Diplomata SC<b>400<\/b>"},{"value":"Domine","text":"Domine<b>400,700<\/b>"},{"value":"Donegal One","text":"Donegal One<b>400<\/b>"},{"value":"Doppio One","text":"Doppio One<b>400<\/b>"},{"value":"Dosis","text":"Dosis<b>200,300,400,500,600,700,800<\/b>"},{"value":"Dr Sugiyama","text":"Dr Sugiyama<b>400<\/b>"},{"value":"Duru Sans","text":"Duru Sans<b>400<\/b>"},{"value":"Dynalight","text":"Dynalight<b>400<\/b>"},{"value":"EB Garamond","text":"EB Garamond<b>400<\/b>"},{"value":"Eagle Lake","text":"Eagle Lake<b>400<\/b>"},{"value":"Eater","text":"Eater<b>400<\/b>"},{"value":"Economica","text":"Economica<b>400,700<\/b>"},{"value":"Eczar","text":"Eczar<b>400,500,600,700,800<\/b>"},{"value":"Ek Mukta","text":"Ek Mukta<b>200,300,400,500,600,700,800<\/b>"},{"value":"Elsie","text":"Elsie<b>400,900<\/b>"},{"value":"Elsie Swash Caps","text":"Elsie Swash Caps<b>400,900<\/b>"},{"value":"Emblema One","text":"Emblema One<b>400<\/b>"},{"value":"Emilys Candy","text":"Emilys Candy<b>400<\/b>"},{"value":"Englebert","text":"Englebert<b>400<\/b>"},{"value":"Enriqueta","text":"Enriqueta<b>400,700<\/b>"},{"value":"Esteban","text":"Esteban<b>400<\/b>"},{"value":"Euphoria Script","text":"Euphoria Script<b>400<\/b>"},{"value":"Ewert","text":"Ewert<b>400<\/b>"},{"value":"Exo","text":"Exo<b>100,200,300,400,500,600,700,800,900<\/b>"},{"value":"Exo 2","text":"Exo 2<b>100,200,300,400,500,600,700,800,900<\/b>"},{"value":"Fauna One","text":"Fauna One<b>400<\/b>"},{"value":"Felipa","text":"Felipa<b>400<\/b>"},{"value":"Fenix","text":"Fenix<b>400<\/b>"},{"value":"Fira Mono","text":"Fira Mono<b>400,700<\/b>"},{"value":"Fira Sans","text":"Fira Sans<b>300,400,500,700<\/b>"},{"value":"Fjalla One","text":"Fjalla One<b>400<\/b>"},{"value":"Fondamento","text":"Fondamento<b>400<\/b>"},{"value":"Forum","text":"Forum<b>400<\/b>"},{"value":"Francois One","text":"Francois One<b>400<\/b>"},{"value":"Freckle Face","text":"Freckle Face<b>400<\/b>"},{"value":"Fresca","text":"Fresca<b>400<\/b>"},{"value":"Fruktur","text":"Fruktur<b>400<\/b>"},{"value":"Gabriela","text":"Gabriela<b>400<\/b>"},{"value":"Gafata","text":"Gafata<b>400<\/b>"},{"value":"Galindo","text":"Galindo<b>400<\/b>"},{"value":"Gentium Basic","text":"Gentium Basic<b>400,700<\/b>"},{"value":"Gentium Book Basic","text":"Gentium Book Basic<b>400,700<\/b>"},{"value":"Gilda Display","text":"Gilda Display<b>400<\/b>"},{"value":"Glass Antiqua","text":"Glass Antiqua<b>400<\/b>"},{"value":"Glegoo","text":"Glegoo<b>400,700<\/b>"},{"value":"Grand Hotel","text":"Grand Hotel<b>400<\/b>"},{"value":"Great Vibes","text":"Great Vibes<b>400<\/b>"},{"value":"Griffy","text":"Griffy<b>400<\/b>"},{"value":"Gruppo","text":"Gruppo<b>400<\/b>"},{"value":"Gudea","text":"Gudea<b>400,700<\/b>"},{"value":"Habibi","text":"Habibi<b>400<\/b>"},{"value":"Halant","text":"Halant<b>300,400,500,600,700<\/b>"},{"value":"Hammersmith One","text":"Hammersmith One<b>400<\/b>"},{"value":"Hanalei","text":"Hanalei<b>400<\/b>"},{"value":"Hanalei Fill","text":"Hanalei Fill<b>400<\/b>"},{"value":"Happy Monkey","text":"Happy Monkey<b>400<\/b>"},{"value":"Headland One","text":"Headland One<b>400<\/b>"},{"value":"Herr Von Muellerhoff","text":"Herr Von Muellerhoff<b>400<\/b>"},{"value":"Hind","text":"Hind<b>300,400,500,600,700<\/b>"},{"value":"Hind Siliguri","text":"Hind Siliguri<b>300,400,500,600,700<\/b>"},{"value":"Hind Vadodara","text":"Hind Vadodara<b>300,400,500,600,700<\/b>"},{"value":"Homenaje","text":"Homenaje<b>400<\/b>"},{"value":"Imprima","text":"Imprima<b>400<\/b>"},{"value":"Inconsolata","text":"Inconsolata<b>400,700<\/b>"},{"value":"Inder","text":"Inder<b>400<\/b>"},{"value":"Inika","text":"Inika<b>400,700<\/b>"},{"value":"Inknut Antiqua","text":"Inknut Antiqua<b>300,400,500,600,700,800,900<\/b>"},{"value":"Istok Web","text":"Istok Web<b>400,700<\/b>"},{"value":"Italianno","text":"Italianno<b>400<\/b>"},{"value":"Itim","text":"Itim<b>400<\/b>"},{"value":"Jaldi","text":"Jaldi<b>400,700<\/b>"},{"value":"Jim Nightshade","text":"Jim Nightshade<b>400<\/b>"},{"value":"Jockey One","text":"Jockey One<b>400<\/b>"},{"value":"Jolly Lodger","text":"Jolly Lodger<b>400<\/b>"},{"value":"Josefin Sans","text":"Josefin Sans<b>100,300,400,600,700<\/b>"},{"value":"Joti One","text":"Joti One<b>400<\/b>"},{"value":"Judson","text":"Judson<b>400,700<\/b>"},{"value":"Julius Sans One","text":"Julius Sans One<b>400<\/b>"},{"value":"Jura","text":"Jura<b>300,400,500,600<\/b>"},{"value":"Just Me Again Down Here","text":"Just Me Again Down Here<b>400<\/b>"},{"value":"Kalam","text":"Kalam<b>300,400,700<\/b>"},{"value":"Kanit","text":"Kanit<b>100,200,300,400,500,600,700,800,900<\/b>"},{"value":"Karla","text":"Karla<b>400,700<\/b>"},{"value":"Karma","text":"Karma<b>300,400,500,600,700<\/b>"},{"value":"Kaushan Script","text":"Kaushan Script<b>400<\/b>"},{"value":"Kavoon","text":"Kavoon<b>400<\/b>"},{"value":"Keania One","text":"Keania One<b>400<\/b>"},{"value":"Kelly Slab","text":"Kelly Slab<b>400<\/b>"},{"value":"Khand","text":"Khand<b>300,400,500,600,700<\/b>"},{"value":"Khula","text":"Khula<b>300,400,600,700,800<\/b>"},{"value":"Knewave","text":"Knewave<b>400<\/b>"},{"value":"Kotta One","text":"Kotta One<b>400<\/b>"},{"value":"Krona One","text":"Krona One<b>400<\/b>"},{"value":"Kurale","text":"Kurale<b>400<\/b>"},{"value":"Laila","text":"Laila<b>300,400,500,600,700<\/b>"},{"value":"Lancelot","text":"Lancelot<b>400<\/b>"},{"value":"Lato","text":"Lato<b>100,300,400,700,900<\/b>"},{"value":"Ledger","text":"Ledger<b>400<\/b>"},{"value":"Lekton","text":"Lekton<b>400,700<\/b>"},{"value":"Libre Baskerville","text":"Libre Baskerville<b>400,700<\/b>"},{"value":"Life Savers","text":"Life Savers<b>400,700<\/b>"},{"value":"Lilita One","text":"Lilita One<b>400<\/b>"},{"value":"Lily Script One","text":"Lily Script One<b>400<\/b>"},{"value":"Limelight","text":"Limelight<b>400<\/b>"},{"value":"Lobster","text":"Lobster<b>400<\/b>"},{"value":"Lora","text":"Lora<b>400,700<\/b>"},{"value":"Lovers Quarrel","text":"Lovers Quarrel<b>400<\/b>"},{"value":"Magra","text":"Magra<b>400,700<\/b>"},{"value":"Marcellus","text":"Marcellus<b>400<\/b>"},{"value":"Marcellus SC","text":"Marcellus SC<b>400<\/b>"},{"value":"Marck Script","text":"Marck Script<b>400<\/b>"},{"value":"Margarine","text":"Margarine<b>400<\/b>"},{"value":"Marmelad","text":"Marmelad<b>400<\/b>"},{"value":"Martel","text":"Martel<b>200,300,400,600,700,800,900<\/b>"},{"value":"Martel Sans","text":"Martel Sans<b>200,300,400,600,700,800,900<\/b>"},{"value":"McLaren","text":"McLaren<b>400<\/b>"},{"value":"MedievalSharp","text":"MedievalSharp<b>400<\/b>"},{"value":"Meie Script","text":"Meie Script<b>400<\/b>"},{"value":"Merienda","text":"Merienda<b>400,700<\/b>"},{"value":"Merriweather","text":"Merriweather<b>300,400,700,900<\/b>"},{"value":"Merriweather Sans","text":"Merriweather Sans<b>300,400,700,800<\/b>"},{"value":"Metal Mania","text":"Metal Mania<b>400<\/b>"},{"value":"Metamorphous","text":"Metamorphous<b>400<\/b>"},{"value":"Milonga","text":"Milonga<b>400<\/b>"},{"value":"Miss Fajardose","text":"Miss Fajardose<b>400<\/b>"},{"value":"Modak","text":"Modak<b>400<\/b>"},{"value":"Modern Antiqua","text":"Modern Antiqua<b>400<\/b>"},{"value":"Molengo","text":"Molengo<b>400<\/b>"},{"value":"Molle","text":"Molle<b><\/b>"},{"value":"Monda","text":"Monda<b>400,700<\/b>"},{"value":"Monsieur La Doulaise","text":"Monsieur La Doulaise<b>400<\/b>"},{"value":"Mouse Memoirs","text":"Mouse Memoirs<b>400<\/b>"},{"value":"Mr Bedfort","text":"Mr Bedfort<b>400<\/b>"},{"value":"Mr Dafoe","text":"Mr Dafoe<b>400<\/b>"},{"value":"Mr De Haviland","text":"Mr De Haviland<b>400<\/b>"},{"value":"Mrs Saint Delafield","text":"Mrs Saint Delafield<b>400<\/b>"},{"value":"Mrs Sheppards","text":"Mrs Sheppards<b>400<\/b>"},{"value":"Mystery Quest","text":"Mystery Quest<b>400<\/b>"},{"value":"Neuton","text":"Neuton<b>200,300,400,700,800<\/b>"},{"value":"New Rocker","text":"New Rocker<b>400<\/b>"},{"value":"News Cycle","text":"News Cycle<b>400,700<\/b>"},{"value":"Niconne","text":"Niconne<b>400<\/b>"},{"value":"Norican","text":"Norican<b>400<\/b>"},{"value":"Nosifer","text":"Nosifer<b>400<\/b>"},{"value":"Noticia Text","text":"Noticia Text<b>400,700<\/b>"},{"value":"Noto Sans","text":"Noto Sans<b>400,700<\/b>"},{"value":"Noto Serif","text":"Noto Serif<b>400,700<\/b>"},{"value":"Oldenburg","text":"Oldenburg<b>400<\/b>"},{"value":"Oleo Script","text":"Oleo Script<b>400,700<\/b>"},{"value":"Oleo Script Swash Caps","text":"Oleo Script Swash Caps<b>400,700<\/b>"},{"value":"Open Sans","text":"Open Sans<b>300,400,600,700,800<\/b>"},{"value":"Open Sans Condensed","text":"Open Sans Condensed<b>300,700<\/b>"},{"value":"Oranienbaum","text":"Oranienbaum<b>400<\/b>"},{"value":"Oregano","text":"Oregano<b>400<\/b>"},{"value":"Orienta","text":"Orienta<b>400<\/b>"},{"value":"Oswald","text":"Oswald<b>300,400,700<\/b>"},{"value":"Overlock","text":"Overlock<b>400,700,900<\/b>"},{"value":"Overlock SC","text":"Overlock SC<b>400<\/b>"},{"value":"Oxygen","text":"Oxygen<b>300,400,700<\/b>"},{"value":"Oxygen Mono","text":"Oxygen Mono<b>400<\/b>"},{"value":"PT Mono","text":"PT Mono<b>400<\/b>"},{"value":"PT Sans","text":"PT Sans<b>400,700<\/b>"},{"value":"PT Sans Caption","text":"PT Sans Caption<b>400,700<\/b>"},{"value":"PT Sans Narrow","text":"PT Sans Narrow<b>400,700<\/b>"},{"value":"PT Serif","text":"PT Serif<b>400,700<\/b>"},{"value":"PT Serif Caption","text":"PT Serif Caption<b>400<\/b>"},{"value":"Palanquin","text":"Palanquin<b>100,200,300,400,500,600,700<\/b>"},{"value":"Palanquin Dark","text":"Palanquin Dark<b>400,500,600,700<\/b>"},{"value":"Parisienne","text":"Parisienne<b>400<\/b>"},{"value":"Passero One","text":"Passero One<b>400<\/b>"},{"value":"Passion One","text":"Passion One<b>400,700,900<\/b>"},{"value":"Pathway Gothic One","text":"Pathway Gothic One<b>400<\/b>"},{"value":"Patrick Hand","text":"Patrick Hand<b>400<\/b>"},{"value":"Patrick Hand SC","text":"Patrick Hand SC<b>400<\/b>"},{"value":"Peralta","text":"Peralta<b>400<\/b>"},{"value":"Petit Formal Script","text":"Petit Formal Script<b>400<\/b>"},{"value":"Piedra","text":"Piedra<b>400<\/b>"},{"value":"Pirata One","text":"Pirata One<b>400<\/b>"},{"value":"Plaster","text":"Plaster<b>400<\/b>"},{"value":"Play","text":"Play<b>400,700<\/b>"},{"value":"Playball","text":"Playball<b>400<\/b>"},{"value":"Playfair Display","text":"Playfair Display<b>400,700,900<\/b>"},{"value":"Playfair Display SC","text":"Playfair Display SC<b>400,700,900<\/b>"},{"value":"Poiret One","text":"Poiret One<b>400<\/b>"},{"value":"Pontano Sans","text":"Pontano Sans<b>400<\/b>"},{"value":"Poppins","text":"Poppins<b>300,400,500,600,700<\/b>"},{"value":"Pragati Narrow","text":"Pragati Narrow<b>400,700<\/b>"},{"value":"Press Start 2P","text":"Press Start 2P<b>400<\/b>"},{"value":"Princess Sofia","text":"Princess Sofia<b>400<\/b>"},{"value":"Prosto One","text":"Prosto One<b>400<\/b>"},{"value":"Purple Purse","text":"Purple Purse<b>400<\/b>"},{"value":"Quando","text":"Quando<b>400<\/b>"},{"value":"Quattrocento","text":"Quattrocento<b>400,700<\/b>"},{"value":"Quattrocento Sans","text":"Quattrocento Sans<b>400,700<\/b>"},{"value":"Quintessential","text":"Quintessential<b>400<\/b>"},{"value":"Qwigley","text":"Qwigley<b>400<\/b>"},{"value":"Racing Sans One","text":"Racing Sans One<b>400<\/b>"},{"value":"Radley","text":"Radley<b>400<\/b>"},{"value":"Rajdhani","text":"Rajdhani<b>300,400,500,600,700<\/b>"},{"value":"Raleway Dots","text":"Raleway Dots<b>400<\/b>"},{"value":"Rambla","text":"Rambla<b>400,700<\/b>"},{"value":"Rammetto One","text":"Rammetto One<b>400<\/b>"},{"value":"Ranchers","text":"Ranchers<b>400<\/b>"},{"value":"Ranga","text":"Ranga<b>400,700<\/b>"},{"value":"Revalia","text":"Revalia<b>400<\/b>"},{"value":"Rhodium Libre","text":"Rhodium Libre<b>400<\/b>"},{"value":"Ribeye","text":"Ribeye<b>400<\/b>"},{"value":"Ribeye Marrow","text":"Ribeye Marrow<b>400<\/b>"},{"value":"Righteous","text":"Righteous<b>400<\/b>"},{"value":"Risque","text":"Risque<b>400<\/b>"},{"value":"Roboto","text":"Roboto<b>100,300,400,500,700,900<\/b>"},{"value":"Roboto Condensed","text":"Roboto Condensed<b>300,400,700<\/b>"},{"value":"Roboto Mono","text":"Roboto Mono<b>100,300,400,500,700<\/b>"},{"value":"Roboto Slab","text":"Roboto Slab<b>100,300,400,700<\/b>"},{"value":"Romanesco","text":"Romanesco<b>400<\/b>"},{"value":"Ropa Sans","text":"Ropa Sans<b>400<\/b>"},{"value":"Rosarivo","text":"Rosarivo<b>400<\/b>"},{"value":"Rozha One","text":"Rozha One<b>400<\/b>"},{"value":"Rubik","text":"Rubik<b>300,400,500,700,900<\/b>"},{"value":"Rubik Mono One","text":"Rubik Mono One<b>400<\/b>"},{"value":"Rubik One","text":"Rubik One<b>400<\/b>"},{"value":"Ruda","text":"Ruda<b>400,700,900<\/b>"},{"value":"Rufina","text":"Rufina<b>400,700<\/b>"},{"value":"Ruge Boogie","text":"Ruge Boogie<b>400<\/b>"},{"value":"Ruluko","text":"Ruluko<b>400<\/b>"},{"value":"Rum Raisin","text":"Rum Raisin<b>400<\/b>"},{"value":"Ruslan Display","text":"Ruslan Display<b>400<\/b>"},{"value":"Russo One","text":"Russo One<b>400<\/b>"},{"value":"Ruthie","text":"Ruthie<b>400<\/b>"},{"value":"Rye","text":"Rye<b>400<\/b>"},{"value":"Sacramento","text":"Sacramento<b>400<\/b>"},{"value":"Sanchez","text":"Sanchez<b>400<\/b>"},{"value":"Sancreek","text":"Sancreek<b>400<\/b>"},{"value":"Sarala","text":"Sarala<b>400,700<\/b>"},{"value":"Sarina","text":"Sarina<b>400<\/b>"},{"value":"Sarpanch","text":"Sarpanch<b>400,500,600,700,800,900<\/b>"},{"value":"Scada","text":"Scada<b>400,700<\/b>"},{"value":"Seaweed Script","text":"Seaweed Script<b>400<\/b>"},{"value":"Sevillana","text":"Sevillana<b>400<\/b>"},{"value":"Seymour One","text":"Seymour One<b>400<\/b>"},{"value":"Shadows Into Light Two","text":"Shadows Into Light Two<b>400<\/b>"},{"value":"Share","text":"Share<b>400,700<\/b>"},{"value":"Shojumaru","text":"Shojumaru<b>400<\/b>"},{"value":"Signika","text":"Signika<b>300,400,600,700<\/b>"},{"value":"Signika Negative","text":"Signika Negative<b>300,400,600,700<\/b>"},{"value":"Simonetta","text":"Simonetta<b>400,900<\/b>"},{"value":"Sintony","text":"Sintony<b>400,700<\/b>"},{"value":"Skranji","text":"Skranji<b>400,700<\/b>"},{"value":"Slabo 13px","text":"Slabo 13px<b>400<\/b>"},{"value":"Slabo 27px","text":"Slabo 27px<b>400<\/b>"},{"value":"Sniglet","text":"Sniglet<b>400,800<\/b>"},{"value":"Snowburst One","text":"Snowburst One<b>400<\/b>"},{"value":"Sonsie One","text":"Sonsie One<b>400<\/b>"},{"value":"Sorts Mill Goudy","text":"Sorts Mill Goudy<b>400<\/b>"},{"value":"Source Code Pro","text":"Source Code Pro<b>200,300,400,500,600,700,900<\/b>"},{"value":"Source Sans Pro","text":"Source Sans Pro<b>200,300,400,600,700,900<\/b>"},{"value":"Source Serif Pro","text":"Source Serif Pro<b>400,600,700<\/b>"},{"value":"Spinnaker","text":"Spinnaker<b>400<\/b>"},{"value":"Stalemate","text":"Stalemate<b>400<\/b>"},{"value":"Stalinist One","text":"Stalinist One<b>400<\/b>"},{"value":"Stint Ultra Condensed","text":"Stint Ultra Condensed<b>400<\/b>"},{"value":"Stint Ultra Expanded","text":"Stint Ultra Expanded<b>400<\/b>"},{"value":"Stoke","text":"Stoke<b>300,400<\/b>"},{"value":"Sumana","text":"Sumana<b>400,700<\/b>"},{"value":"Sura","text":"Sura<b>400,700<\/b>"},{"value":"Tauri","text":"Tauri<b>400<\/b>"},{"value":"Teko","text":"Teko<b>300,400,500,600,700<\/b>"},{"value":"Tenor Sans","text":"Tenor Sans<b>400<\/b>"},{"value":"Text Me One","text":"Text Me One<b>400<\/b>"},{"value":"Tillana","text":"Tillana<b>400,500,600,700,800<\/b>"},{"value":"Tinos","text":"Tinos<b>400,700<\/b>"},{"value":"Titan One","text":"Titan One<b>400<\/b>"},{"value":"Titillium Web","text":"Titillium Web<b>200,300,400,600,700,900<\/b>"},{"value":"Trocchi","text":"Trocchi<b>400<\/b>"},{"value":"Trykker","text":"Trykker<b>400<\/b>"},{"value":"Ubuntu","text":"Ubuntu<b>300,400,500,700<\/b>"},{"value":"Ubuntu Condensed","text":"Ubuntu Condensed<b>400<\/b>"},{"value":"Ubuntu Mono","text":"Ubuntu Mono<b>400,700<\/b>"},{"value":"Underdog","text":"Underdog<b>400<\/b>"},{"value":"Unica One","text":"Unica One<b>400<\/b>"},{"value":"Vampiro One","text":"Vampiro One<b>400<\/b>"},{"value":"Varela","text":"Varela<b>400<\/b>"},{"value":"Vesper Libre","text":"Vesper Libre<b>400,500,700,900<\/b>"},{"value":"Viga","text":"Viga<b>400<\/b>"},{"value":"Voces","text":"Voces<b>400<\/b>"},{"value":"Warnes","text":"Warnes<b>400<\/b>"},{"value":"Wellfleet","text":"Wellfleet<b>400<\/b>"},{"value":"Wendy One","text":"Wendy One<b>400<\/b>"},{"value":"Work Sans","text":"Work Sans<b>100,200,300,400,500,600,700,800,900<\/b>"},{"value":"Yanone Kaffeesatz","text":"Yanone Kaffeesatz<b>200,300,400,700<\/b>"},{"value":"Yantramanav","text":"Yantramanav<b>100,300,400,500,700,900<\/b>"},{"value":"Yeseva One","text":"Yeseva One<b>400<\/b>"}];
OfflajnFont_tamil = [{"value":"Catamaran","text":"Catamaran<b>100,200,300,400,500,600,700,800,900<\/b>"}];
OfflajnFont_telugu = [{"value":"Dhurjati","text":"Dhurjati<b>400<\/b>"},{"value":"Gidugu","text":"Gidugu<b>400<\/b>"},{"value":"Gurajada","text":"Gurajada<b>400<\/b>"},{"value":"Lakki Reddy","text":"Lakki Reddy<b>400<\/b>"},{"value":"Mallanna","text":"Mallanna<b>400<\/b>"},{"value":"Mandali","text":"Mandali<b>400<\/b>"},{"value":"NTR","text":"NTR<b>400<\/b>"},{"value":"Peddana","text":"Peddana<b>400<\/b>"},{"value":"Ramabhadra","text":"Ramabhadra<b>400<\/b>"},{"value":"Ramaraja","text":"Ramaraja<b>400<\/b>"},{"value":"Ravi Prakash","text":"Ravi Prakash<b>400<\/b>"},{"value":"Sree Krushnadevaraya","text":"Sree Krushnadevaraya<b>400<\/b>"},{"value":"Suranna","text":"Suranna<b>400<\/b>"},{"value":"Suravaram","text":"Suravaram<b>400<\/b>"},{"value":"Tenali Ramakrishna","text":"Tenali Ramakrishna<b>400<\/b>"},{"value":"Timmana","text":"Timmana<b>400<\/b>"}];
OfflajnFont_thai = [{"value":"Chonburi","text":"Chonburi<b>400<\/b>"},{"value":"Itim","text":"Itim<b>400<\/b>"},{"value":"Kanit","text":"Kanit<b>100,200,300,400,500,600,700,800,900<\/b>"}];
OfflajnFont_vietnamese = [{"value":"Alegreya Sans","text":"Alegreya Sans<b>100,300,400,500,700,800,900<\/b>"},{"value":"Alegreya Sans SC","text":"Alegreya Sans SC<b>100,300,400,500,700,800,900<\/b>"},{"value":"Arimo","text":"Arimo<b>400,700<\/b>"},{"value":"Chonburi","text":"Chonburi<b>400<\/b>"},{"value":"Cousine","text":"Cousine<b>400,700<\/b>"},{"value":"EB Garamond","text":"EB Garamond<b>400<\/b>"},{"value":"Itim","text":"Itim<b>400<\/b>"},{"value":"Judson","text":"Judson<b>400,700<\/b>"},{"value":"Kanit","text":"Kanit<b>100,200,300,400,500,600,700,800,900<\/b>"},{"value":"Lobster","text":"Lobster<b>400<\/b>"},{"value":"Noticia Text","text":"Noticia Text<b>400,700<\/b>"},{"value":"Noto Sans","text":"Noto Sans<b>400,700<\/b>"},{"value":"Noto Serif","text":"Noto Serif<b>400,700<\/b>"},{"value":"Open Sans","text":"Open Sans<b>300,400,600,700,800<\/b>"},{"value":"Open Sans Condensed","text":"Open Sans Condensed<b>300,700<\/b>"},{"value":"Patrick Hand","text":"Patrick Hand<b>400<\/b>"},{"value":"Patrick Hand SC","text":"Patrick Hand SC<b>400<\/b>"},{"value":"Roboto","text":"Roboto<b>100,300,400,500,700,900<\/b>"},{"value":"Roboto Condensed","text":"Roboto Condensed<b>300,400,700<\/b>"},{"value":"Roboto Mono","text":"Roboto Mono<b>100,300,400,500,700<\/b>"},{"value":"Roboto Slab","text":"Roboto Slab<b>100,300,400,700<\/b>"},{"value":"Source Sans Pro","text":"Source Sans Pro<b>200,300,400,600,700,900<\/b>"},{"value":"Tinos","text":"Tinos<b>400,700<\/b>"}];