<?php
/**
 * @package	HikaShop for Joomla!
 * @version	4.4.4
 * @author	hikashop.com
 * @copyright	(C) 2010-2021 HIKARI SOFTWARE. All rights reserved.
 * @license	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */
defined('_JEXEC') or die('Restricted access');
?><?php

class plgHikashopMyuserfield extends JPlugin 
{
	// public function __construct(&$subject, $config) {
		// parent::__construct($subject, $config);

		// $this->loadLanguage('plg_hikashop_myuserfield', JPATH_ADMINISTRATOR );
	// }
	public function onFieldsLoad(&$fields, &$options) {
		$me = new stdClass();
		$me->name = 'myuserfield';
		$me->text = JText::_('MY_USER');
		$me->options = array('required', 'default', 'columnname', '', '', 'myuser_options');

		$fields[] = $me;

		$opt = new stdClass();
		$opt->name = 'myuser_options';
		$opt->text = JText::_('MY_USER_OPTIONS');
		$opt->own_block = true;
		$opt->obj = 'fieldOpt_myuser_options';

		$options[$opt->name] = $opt;

	}
	
	
	public function onAfterOrderUpdate($order, $send_email)
	{
		// dump('here4', 'here4');
		// dump($order->order_status, 'status');
		// dump($order, 'order');
		if(!isset($params)){
			$plugin = JPluginHelper::getPlugin('hikashop', 'myuserfield');
			$params = new JRegistry(@$plugin->params);
		}
		if($params->get('customfield', 0))
		{
			if(empty($order->cart->products))
			{
				$customfield = $params->get('customfield', 0);
				$db = JFactory::getDbo();
				$query = $db->getQuery(true);
				$query->select(array('p.*', 'op.' . $customfield));
				$query->from($db->quoteName('#__hikashop_order_product', 'op'));
				$query->join('INNER', $db->quoteName('#__hikashop_order', 'o') . ' ON ' . $db->quoteName('o.order_id') . ' = ' . $db->quoteName('op.order_id'));
				$query->join('INNER', $db->quoteName('#__hikashop_product', 'p') . ' ON ' . $db->quoteName('p.product_id') . ' = ' . $db->quoteName('op.product_id'));
				$query->where($db->quoteName('o.order_id') . ' = ' . $db->quote($order->order_id));
				$db->setQuery($query);
				if(!isset($order->cart))
					$order->cart = new stdClass;
				$order->cart->products = $db->loadObjectList();
			}
			if($order->order_status == "confirmed" && !empty($order->cart->products))
			{
				// dump($order->order_status, 'order_status');
				foreach($order->cart->products as $product)
				{
					// dump('here2', 'here2');

					$cando = false;
					if($product->product_code)
					{
						$productcode = $product->product_code;
						$cando = true;
					}
					else if($product->product_parent_id)
					{
						$db = JFactory::getDbo();
						$query = $db->getQuery(true);
						$query->select('product_code');
						$query->from($db->quoteName('#__hikashop_product'));
						$query->where($db->quoteName('product_id') . ' = ' . $db->quote($product->product_parent_id));
						$db->setQuery($query);
						$productcode = $db->loadResult();
						$cando = true;
					}
					// dump('here1', 'here1');
					// dump($cando, 'cando');
					if($cando)
					{
						$customfield = $params->get('customfield', 0);
						// dump($customfield, 'customfield');
						$childids = $product->$customfield;
						if($childids)
							$userids = explode(',', $childids);
						else
						{
							$userids = array();
						}
						
						$db = JFactory::getDbo();
						
						$query = $db->getQuery(true);
						$query->select('course_group');
						$query->from($db->quoteName('#__moojla_course_group_map'));
						$query->where($db->quoteName('moojlacourse') . ' = ' . $db->quote($productcode));
						$query->where($db->quoteName('role') . ' = 5');
						$db->setQuery($query);
						$group = $db->loadResult();
						// dump($product, 'product');
						// dump($group, 'group');
						// dump($userids, 'userids');
						
						JPluginHelper::importPlugin("moojlaevents");
						$dispatcher = JEventDispatcher::getInstance();
						
						
						// $db = JFactory::getDbo();
						// $query = $db->getQuery(true);
						// $query->select($db->quoteName(array('mid')));
						// $query->from($db->quoteName('#__moojla_user_map'));
						// $query->where($db->quoteName('jid') . ' IN (' . $product->$customfield . ')' );
						// $db->setQuery($query);
						// $muserids = $db->loadColumn();
						
						// dump($muserids, 'muserids');
						// foreach($muserids as $user_id)
						// {
							// $results		= $dispatcher->trigger("addGroupMember", array($productcode, $user_id, 5));
							
							// dump($results, 'results');
						// }
						
						foreach($userids as $userid)
						{
							$user = JFactory::getUser($userid);
							$user->groups[] = $group;
							$user->save();
							
							if ( ( ! file_exists( JPATH_SITE . '/libraries/CBLib/CBLib/Core/CBLib.php' ) ) || ( ! file_exists( JPATH_ADMINISTRATOR . '/components/com_comprofiler/plugin.foundation.php' ) ) ) {
								echo 'CB not installed';
								return;
							}
							include_once( JPATH_ADMINISTRATOR . '/components/com_comprofiler/plugin.foundation.php' );
							cbimport( 'cb.html' );
							global $_CB_framework, $_PLUGINS, $ueConfig;
							global $cbUser;
							$cbUser =& CBuser::getInstance( $userid, false);
							$cuser =& $cbUser->getUserData();
							$oldUserComplete		=	new \CB\Database\Table\UserTable();
							$_PLUGINS->loadPluginGroup($user->username); // for using cb trigering
							$_PLUGINS->loadPluginGroup( 'user' );
							foreach ( array_keys( get_object_vars( $cuser ) ) as $k ) {
								if ( substr( $k, 0, 1 ) != '_' ) {
									$oldUserComplete->set( $k, $cuser->get( $k ) );
								}
							}
							$_PLUGINS->trigger( 'onBeforeUserUpdate', array( &$cuser, &$cuser, &$oldUserComplete, &$oldUserComplete ) );
							$cuser->set( 'params', array() ); 
							$_PLUGINS->trigger( 'onAfterUserUpdate', array( &$cuser, &$cuser, $oldUserComplete ) );
						}
						// $url="index.php?Itemid=337";
						// JFactory::getApplication()->redirect(JRoute::_($url, false));
					}
				}
			}
		}
	}
}

if(defined('HIKASHOP_COMPONENT')) {
	require_once( dirname(__FILE__).DS.'myuserfield_class.php' );
}

if(!function_exists('hikashop_product_price_for_quantity_in_cart') && !function_exists('hikashop_product_price_for_quantity_in_order')) {
	function hikashop_product_price_for_quantity_in_cart(&$product){
		if(!isset($params)) {
			$plugin = JPluginHelper::getPlugin('hikashop', 'myuserfield');
			$params = new JRegistry(@$plugin->params);
		}
		$currencyClass = hikashop_get('class.currency');
		$quantity = @$product->cart_product_quantity;
		if($params->get('customfield', 0))
		{
			$customfield = $params->get('customfield', 0);
			if(!empty($product->$customfield)){
				$user_selected = explode(',', $product->$customfield);
				$quantity = $quantity*count($user_selected);
			}
		}
			
		
		$currencyClass->quantityPrices($product->prices,$quantity,$product->cart_product_total_quantity);
	}

	function hikashop_product_price_for_quantity_in_order(&$product){
		$quantity = $product->order_product_quantity;
		if(!isset($params)) {
			$plugin = JPluginHelper::getPlugin('hikashop', 'myuserfield');
			$params = new JRegistry(@$plugin->params);
		}
		if($params->get('customfield', 0))
		{
			$customfield = $params->get('customfield', 0);
			if(!empty($product->$customfield)){
				$user_selected = explode(',', $product->$customfield);
				$quantity = $quantity*count($user_selected);
			}
		}
		$product->order_product_total_price_no_vat = $product->order_product_price*$quantity;
		$product->order_product_total_price = ($product->order_product_price+$product->order_product_tax)*$quantity;
	}
}