<?php
/**
 * @package	HikaShop for Joomla!
 * @version	4.4.4
 * @author	hikashop.com
 * @copyright	(C) 2010-2021 HIKARI SOFTWARE. All rights reserved.
 * @license	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */
defined('_JEXEC') or die('Restricted access');
use Joomla\CMS\HTML\HTMLHelper;
?><?php
class fieldOpt_myuser_options
{
    public function show($value)
    {
        $input = JFactory::getApplication()->input;
        $cid = $input->get('cid', array());
            
        if (!empty($cid))
            $fieldid = $cid[0];
        else
            $fieldid = 0;

        $db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $query->select($db->quoteName(array(
            'field_options'
        )));
        $query->from($db->quoteName('#__hikashop_field'));
        $query->where($db->quoteName('field_id') . ' = ' . $db->quote($fieldid));
        $db->setQuery($query);
        $value = $db->loadResult();

        // dump(debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS), 'deb');
        if (!empty($value))
        {
            if (is_string($value)) $value = hikashop_unserialize($value);
        }
        else
        {
            $value = array();
        }
        $html = '';
        $db = JFactory::getDbo();
        $query = 'SHOW TABLES;';
        $db->setQuery($query);
        $tables = $db->loadColumn();
        $tables = array_combine(array_values($tables) , $tables);
        $cmp = JComponentHelper::getComponent('com_hilation');

        if(!isset($value['parenttables']) || $value['parenttables'] == '' )
        {
            $flag = false;
            foreach($tables as $table)
            {
                if(substr($table, -17) == 'hilation_relation' && $cmp->id) // check table exist an componenet installed and enabled
                {
                    $value['parenttables'] = $table;
                    $value['parentcol'] = 'parent';
                    $value['childcol'] = 'userid';
                    $flag = true;
                }
            }
            if(!$flag)
            {
                $html .= '<div class="alert alert-warning">The <strong>"hilation"</strong> component is not installed or not active on your Joomla. This plugin is completed with this component. But you can also use other tables from the database. For example, you might want to implement the parent-child model using the Community Builder and its additional fields.</div>'; 
            }
        }
        // dump($tables, 'tables');
        $html .= '<dl class="hika_options large"><dt>Select table: </dt><dd>' . JHTML::_('select.genericlist', $tables, "field_options[parenttables]", 'class="custom-select" required', 'value', 'text', @$value['parenttables']) . '</dd>';
        $html .= '<dt><label for="parentcol">Parent column: </label></dt><dd class="input_small"><input name="field_options[parentcol]" id="parentcol" value="' . @$value['parentcol'] . '" class="inputbox" required></dd>';
        $html .= '<dt><label for="childcol">Child column: </label></dt><dd class="input_small"><input name="field_options[childcol]" id="childcol" value="' . @$value['childcol'] . '" class="inputbox" required></dd></dl>';

        // $x = JHTML::_('string');
        // StringHelper
        

        return $html;
    }

    public function save(&$options)
    {
        // if(!empty($options['myuser_options']))
        // $options['myuser_options']['excludes'] = hikaInput::get()->getRaw('field_options__myuser_options__excludes', '');
        
    }
}
require_once JPATH_ADMINISTRATOR . "/components/com_hikashop/classes/field.php";
//
class hikashopMyuserfield extends hikashopFieldMultipledropdown
{

    public $prefix = null;
    public $suffix = null;
    public $excludeValue = null;
    public $report = null;
    public $parent = null;
    public $displayFor = false;
    protected $params = null;

    public function __construct(&$obj)
    {
        $this->prefix = $obj->prefix;
        $this->suffix = $obj->suffix;
        $this->excludeValue = & $obj->excludeValue;
        $this->report = @$obj->report;
        $this->parent = & $obj;

        $timeoffset = 0;
        $jconfig = JFactory::getConfig();
        if (!HIKASHOP_J30)
        {
            $timeoffset = $jconfig->getValue('config.offset');
        }
        else
        {
            $timeoffset = $jconfig->get('offset');
        }
        $dateC = JFactory::getDate(time() , $timeoffset);
        $timeoffset = $dateC->getOffsetFromGMT(true);
        $this->timeoffset = $timeoffset * 60 * 60 + date('Z');
    }

    public function show(&$field, $value)
    {
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $query->select('CONCAT(name, " (", username, ")") as u');
        $query->from($db->quoteName('#__users'));
        $query->where($db->quoteName('id') . ' IN (' . $value . ')');
        $db->setQuery($query);
        $usernames = $db->loadColumn();
        return implode(', ', $usernames);

    }
    function display($field, $value, $map, $inside, $options = '', $test = false, $allFields = null, $allValues = null)
    {
        $thisuser = JFactory::getUser();
        // dump($map, 'map');
        // dump($inside, 'inside');
        // dump($options, 'options');
        // dump($test, 'test');
        // dump($allFields, 'allFields');
        // dump($allValues, 'allValues');
        

        $document = JFactory::getDocument();
        $document->addStyleSheet('/media/jui/css/chosen.css?88b10fdcf6c05253943557533fb6dc28');
        $document->addScript('/media/jui/js/chosen.jquery.min.js?88b10fdcf6c05253943557533fb6dc28');

        $db = JFactory::getDbo();
        // $query = $db->getQuery(true);
        // $query->select('u.id AS id, CONCAT(u.username, " - ", u.name) AS value');
        // $query->from($db->quoteName('#__users', 'u'));
        // $query->join('INNER', $db->quoteName($field->field_options['parenttables'], 't'). ' ON ' . $db->quoteName('u.id') . ' = ' . $db->quoteName('t.'.$field->field_options['childcol']));
        // $query->where($db->quoteName('t.'.$field->field_options['parentcol']) . ' = ' . $db->quote($thisuser->id));
        $condition = "";

        if (property_exists($field, "product_id") && property_exists($field, "field_options"))
        {
            $fo = $field->field_options;
            if (isset($fo['childcol']) && isset($fo['parentcol']) && isset($fo['parenttables']))
            {

                $condition = "WHERE p.product_id = " . $field->product_id;
                $query = "SELECT u.id AS id, CONCAT(u.username, ' - ', u.name) AS value FROM `#__users` AS u INNER JOIN `" . $fo['parenttables'] . "` AS t ON u.id = t." . $fo['childcol'] . " WHERE t." . $fo['parentcol'] . " = " . $thisuser->id . " AND u.id NOT IN (SELECT e.jid AS id FROM `#__moojla_enrolment` AS e INNER JOIN `#__hikashop_product` AS p ON p.product_code = e.moojlacourse $condition);";
                $db->setQuery($query);
                // dump($value, 'value');
                $results = $db->loadObjectList('id');
                // dump($field, 'field');
                $fieldid = $field->field_namekey;
                $field->field_value = $results;

                // $field->field_value = array();
                $document->addScriptDeclaration("
                    jQuery(window).load(function(){
                        jQuery('#$fieldid').chosen();
                    });
                ");
            }
        }
        return parent::display($field, $value, $map, $inside, $options, $test, $allFields, $allValues);
    }
}

