<?php
/**
 * @package     Joomla.Plugin
 * @subpackage  Content.joomla
 *
 * @copyright   Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;
use \Akeeba\Subscriptions\Admin\Model\Subscriptions;
use FOF30\Container\Container;

JLoader::register('NotiflyMessageHelper', JPATH_ADMINISTRATOR . '/components/com_notifly/helpers/message.php');
jimport('joomla.filesystem.file');

/**
 * Example Content Plugin
 *
 * @since  1.6
 */
class PlgNotiflyAkeebaSubs extends JPlugin
{
	public function __construct(&$subject , $params)
	{
		if (!$this->exists()) {
			return;
		}
		
		$input = JFactory::getApplication()->input;
		$this->extension = $input->get('option');
		$this->view = $input->get('view');

		// Load language file for use throughout the plugin
		JFactory::getLanguage()->load('com_akeebasubs', JPATH_ROOT);

		parent::__construct($subject, $params);
	}

	/**
	 * Tests if EasyBlog exists
	 *
	 * @since	4.0
	 * @access	private
	 */
	private function exists()
	{
		static $exists = null;

		if (is_null($exists)) {
			$file = JPATH_ADMINISTRATOR . '/components/com_akeebasubs/akeebasubs.php';
			$exists = JFile::exists($file);

			if ($exists) {
				return true;
			}
		}

		return false;
	}

	/**
	 * Called whenever a subscription is modified. Namely, when its enabled status,
	 * payment status or valid from/to dates are changed.
	 *
	 * @param   Subscriptions  $row
	 * @param   array		   $info
	 */
	public function onAKPaymentNew($paymentmethod, $user, $level, $subscription)
	{
		// check if event is enabled
		if(!$this->params->get('enable_subscription', 0))
		{
			return false;
		}

		// If the user id appears invalid then bail out just in case
		if (empty($user->id) or !$user->id)
		{
			return false;
		}

		// register purchase/subscription event
		$this->logPurchaseEvent($user, $level);
		    	
		return true;
	}

	public function logPurchaseEvent($customer, $level)
	{
		$plugin = $this->getPluginInfo();
		
		$extension_id = $plugin->extension_id;
		$template = 'new_akeebasubs_subs';
		$template = $this->getTemplateInfo($extension_id);

		$table = $this->getTable();
		$table->template_id = $template->id;
		$table->extension_id = $extension_id;

		// process the event url
		$link = JRoute::_('index.php?option=com_akeebasubs&view=level&slug='.$level->slug.'&format=html&layout=default');
		$table->url = $link;

		if(!$template->image_disable)
		{
			if($template->avatar){
				$table->image_url = NotiflyMessageHelper::getGravater($customer->email);
			}
			else
			{
				$table->image_url =  $template->image_url;
			}
		}
		
		// get location from helper
		$ip = NotiflyMessageHelper::getRealIpAddr();
		$location = NotiflyMessageHelper::getLocation($ip);
		
		$table->title 	= $level->title;
		$table->name 	= $customer->name;
		$table->email 	= $customer->email;
		$table->ip 		= $ip;

		$table->city = $location['city'];
		$table->state = $location['region_name'];
		$table->country = $location['country_name'];
		
		$table->created = JHtml::date('now', 'Y-m-d H:i:s');
		$table->published = 1;
		
		$table->store();

		return true;
	}

	public function getPluginInfo(){
		$db = JFactory::getDBO();
		$sql = "SELECT * from `#__extensions` WHERE `type` = 'plugin' AND `folder` = 'notifly' AND `element` = 'akeebasubs'";
		$db->setQuery($sql);
		return $db->loadObject();
	}
	public function getTemplateInfo($extension_id){
		$db = JFactory::getDBO();
		$sql = "SELECT * from `#__notifly_templates` WHERE `extension_id` = '".$extension_id."' AND `alias` = 'new_akeebasubs_subs'";
		$db->setQuery($sql);
		return $db->loadObject();
	}

	public function getTable()
	{
		JTable::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_notifly/tables');
		return JTable::getInstance('Event', 'NotiflyTable', array());
	}

}
