<?php
/**
 * @package     Joomla.Plugin
 * @subpackage  Content.joomla
 *
 * @copyright   Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;
JLoader::register('NotiflyMessageHelper', JPATH_ADMINISTRATOR . '/components/com_notifly/helpers/message.php');
JLoader::discover('DigiComSiteHelper', JPATH_SITE . '/components/com_digicom/helpers');
jimport('joomla.filesystem.file');

/**
 * Example Content Plugin
 *
 * @since  1.6
 */
class PlgNotiflyDigicom extends JPlugin
{
	public function __construct(&$subject , $params)
	{
		if (!$this->exists()) {
			return;
		}
		
		$input = JFactory::getApplication()->input;
		$this->extension = $input->get('option');
		$this->view = $input->get('view');

		// Load language file for use throughout the plugin
		JFactory::getLanguage()->load('com_digicom', JPATH_ROOT);

		parent::__construct($subject, $params);
	}

	/**
	 * Tests if EasyBlog exists
	 *
	 * @since	4.0
	 * @access	private
	 */
	private function exists()
	{
		static $exists = null;

		if (is_null($exists)) {
			$file = JPATH_ADMINISTRATOR . '/components/com_digicom/helpers/digicom.php';
			$exists = JFile::exists($file);

			if ($exists) {
				return true;
			}
		}

		return false;
	}

	/**
	 * Utility method to act on a user after it has been saved.
	 *
	 * This method creates a contact for the saved user
	 *
	 * @param   array    $user     Holds the new user data.
	 * @param   boolean  $isnew    True if a new user is stored.
	 * @param   boolean  $success  True if user was succesfully stored in the database.
	 * @param   string   $msg      Message.
	 *
	 * @return  boolean
	 *
	 * @since   1.6
	 */
	public function onDigicomAfterPlaceOrder($order_id, $items, $tax, $customerInfo)
	{
		// check if event is enabled
		if(!$this->params->get('enable_purchase', 0))
		{
			return false;
		}

		$customer = $customerInfo->_customer;
		// Ensure the user id is really an int
		$user_id = (int) $customer->id;

		// If the user id appears invalid then bail out just in case
		if (empty($user_id))
		{
			return false;
		}

		// we have items
    	foreach ($items as $key => $item) {
			// register users registration event
			$this->logPurchaseEvent($customer, $item);
    	}

		// JError::raiseWarning('', JText::_('PLG_NOTIFLY_JOOMLA_ERR_FAILED_CREATING_CONTACT'));

		return true;
	}

	public function logPurchaseEvent($customer, $item)
	{
		$images = json_decode($item->images, true);
		$imageIntro = $images['image_intro'];
		$plugin = $this->getPluginInfo();
		
		$extension_id = $plugin->extension_id;
		$template = 'new_product_purchase';
		$template = $this->getTemplateInfo($extension_id);

		$table = $this->getTable();
		$table->template_id = $template->id;
		$table->extension_id = $extension_id;

		// process the event url
		$link = DigiComSiteHelperRoute::getProductRoute($item->id, $item->catid, $item->language);
		$table->url = $link;

		if(!$template->image_disable)
		{
			if($imageIntro){
				$table->image_url = Juri::root() . $imageIntro;
			}
			else
			{
				$table->image_url =  $template->image_url;
			}
		}
		
		// get location from helper
		$ip = NotiflyMessageHelper::getRealIpAddr();
		$location = NotiflyMessageHelper::getLocation($ip);
		
		$table->title 	= $item->name;
		$table->name 	= $customer->name;
		$table->email 	= $customer->email;
		$table->ip 		= $ip;

		$table->city = $location['city'];
		$table->state = $location['region_name'];
		$table->country = $location['country_name'];
		
		$table->created = JHtml::date('now', 'Y-m-d H:i:s');
		$table->published = 1;
		
		$table->store();

		// if(JFactory::getUser()->authorise('core.delete', 'com_notifly.event')){
			// print_r($table->created);die;
		// }

		return true;
	}

	public function getPluginInfo(){
		$db = JFactory::getDBO();
		$sql = "SELECT * from `#__extensions` WHERE `type` = 'plugin' AND `folder` = 'notifly' AND `element` = 'digicom'";
		$db->setQuery($sql);
		return $db->loadObject();
	}
	public function getTemplateInfo($extension_id){
		$db = JFactory::getDBO();
		$sql = "SELECT * from `#__notifly_templates` WHERE `extension_id` = '".$extension_id."' AND `alias` = 'new_product_purchase'";
		$db->setQuery($sql);
		return $db->loadObject();
	}

	public function getTable()
	{
		JTable::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_notifly/tables');
		return JTable::getInstance('Event', 'NotiflyTable', array());
	}

}
