<?php
/**
 * @package     OSL
 * @subpackage  Provider
 *
 * @copyright   Copyright (C) 2016 Ossolution Team, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE
 */
namespace OSL\Provider;

use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use JFactory, JEventDispatcher, JComponentHelper;
use OSL\Input\Input;

class SystemProvider implements ServiceProviderInterface
{
	public function register(Container $container)
	{
		// Joomla Application
		$container->share(
			'app',
			function ()
			{
				return JFactory::getApplication();
			},
			true
		);

		// Joomla Application Configuration
		$container->share(
			'appConfig',
			function ()
			{
				return JFactory::getConfig();
			},
			true
		);

		// Database
		$container->share(
			'db',
			function ()
			{
				return JFactory::getDbo();
			},
			true
		);

		// Session
		$container->share(
			'session',
			function ()
			{
				return JFactory::getSession();
			},
			true
		);

		// Language
		$container->share(
			'language',
			function ()
			{
				return JFactory::getLanguage();
			},
			true
		);

		if (version_compare(JVERSION, '4.0.0-dev', '<'))
		{
			// Joomla Event Dispatcher
			$container->share(
				'eventDispatcher',
				function ()
				{
					return JEventDispatcher::getInstance();
				},
				true
			);
		}

		// Joomla Mailer
		$container->share(
			'mailer',
			function ()
			{
				return JFactory::getMailer();
			},
			true
		);

		// String Inflector
		$container->share(
			'inflector',
			function ()
			{
				return new \OSL\Inflector\Inflector();
			},
			true
		);

		// Component params
		$container->share(
			'params',
			function (Container $container)
			{
				return JComponentHelper::getParams($container->get('option'));
			},
			true
		);

		// Joomla Document
		$container->share(
			'document',
			function ()
			{
				return JFactory::getDocument();
			},
			true
		);

		// Current Joomla User
		$container->share(
			'user',
			function ()
			{
				return JFactory::getUser();
			},
			true
		);

		// Joomla Input
		$container->share(
			'input',
			function ()
			{
				if (version_compare(JVERSION, '4.0.0-dev', 'ge'))
				{
					$source = JFactory::getApplication()->input;
				}
				else
				{
					$source = null;
				}

				return new Input($source);
			}
		);

		// OSL Factory
		$container->share('factory',
			function (Container $container)
			{
				return new \OSL\Factory\Factory($container);
			}
		);

		// Current template
		$container->share('template',
			function (Container $container)
			{
				return $container->get('app')->getTemplate();
			}
		);
	}
}