<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2012 - 2016 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

class Pkg_HelpdeskproInstallerScript
{
	/**
	 * Perform basic system requirements check before installing the package
	 *
	 * @param string   $type
	 * @param JAdapter $parent
	 *
	 * @return bool
	 */
	public function preflight($type, $parent)
	{
		if (version_compare(JVERSION, '3.9.0', '<'))
		{
			JError::raiseWarning(null, 'Cannot install Helpdesk Pro in a Joomla! release prior to 3.9.0');

			return false;
		}

		if (version_compare(PHP_VERSION, '5.4.0', '<'))
		{
			JError::raiseWarning(null, 'Helpdesk Pro requires PHP 5.4.0+ to work. Please contact your hosting provider, ask them to update PHP version for your hosting account.');

			return false;
		}
	}
}