<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Uri\Uri;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskproHelper;

class plgHelpdeskProPrereply extends CMSPlugin
{
	public function onViewTicket($row)
	{
		$role = HelpdeskproHelper::getUserRole();

		if ($role == 'user')
		{
			return;
		}

		$db    = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select("id AS value, title AS text")
			->from("#__helpdeskpro_replies")
			->where("published = 1")
			->order("ordering");
		$db->setQuery($query);
		$rowReplies = $db->loadObjectList();

		if (!count($rowReplies))
		{
			return;
		}

		$document = JFactory::getDocument();
		$document->addScript(Uri::root(true) . '/media/com_helpdeskpro/js/plug_helpdeskpro_prereply.js');
		$document->addScriptOptions('siteUrl', Uri::root(true));
		$document->addScriptOptions('ticket_id', $row->id);

		ob_start();
		?>
        <tr>
            <th colspan="2"><?php echo Text::_('HDP_PRE_REPLIES'); ?></th>
        </tr>
		<?php
		?>
        <tr>
            <td colspan="2">
				<?php
				echo HTMLHelper::_('select.genericlist', $rowReplies, 'replies_id', 'class="chosen" ', 'value', 'text', '');
				?>
                <input type="button" class="btn btn-primary" id="ajaxAssign"
                       value="<?php echo Text::_('HDP_ADD_REPLY') ?>" />
            </td>
        </tr>
		<?php
		return ob_get_clean();
	}
}	