<?php
/**
 * ------------------------------------------------------------------------
 * JA Filter Plugin - Reservationcat
 * ------------------------------------------------------------------------
 * Copyright (C) 2004-2016 J.O.O.M Solutions Co., Ltd. All Rights Reserved.
 * @license - GNU/GPL, http://www.gnu.org/licenses/gpl.html
 * Author: J.O.O.M Solutions Co., Ltd
 * Websites: http://www.joomlart.com - http://www.joomlancers.com
 * This file may not be redistributed in whole or significant part.
 * ------------------------------------------------------------------------
 */

// no direct access
defined('_JEXEC') or die ('Restricted access');

// Initiate class to hold plugin events
class plgJamegafilterReservation extends JPlugin {

	// Some params
	var $pluginName = 'jamegafilterreservation';

	function __construct( &$subject, $params) {
		parent::__construct($subject, $params);
	}

	function onBeforeSaveReservationItems( &$params ) {
		require_once __DIR__ . '/helper.php';
		$helper = new ReservationFilterHelper($params);
		$order = $params['filterfields']['filter_order']['order'];
		foreach ($order as $key => $value) {
			if (!$helper->checkPublished($key)) {
				unset($order[$key]);
			}
		}

		$custom_order = $this->getCustomOrdering($helper, $order);
		$params['filterfields']['filter_order']['custom_order'] = $custom_order;
	}
	
	function onAfterSaveReservationItems($item) {
		require_once (__DIR__.'/helper.php');
		$params = $item->params;
		$helper = new ReservationFilterHelper($params);
		$objectList = $helper->getFilterItems($params['reservationcat']);
		return $objectList;
	}
	
	function onBeforeDisplayReservationItems( $jstemplate, $filter_config, $item )
	{
		$this->jstemplate = $jstemplate;
		$this->config = $filter_config;
		$this->item = $item;
		$input = JFactory::getApplication()->input;
		$jalayout = $input->get('jalayout', 'default');
		$path = JPluginHelper::getLayoutPath('jamegafilter', 'reservation', $jalayout);
		
		ob_start();
		include $path;
		$output = ob_get_clean();
		echo $output;
	}

	function getCustomOrdering($helper, $config ) {
		$ordering = array();
		
		foreach ($config as $key => $value) {
			if ($key === 'attr.cat.value') {
				$catid = $helper->_params->get('reservationcat', 0);

				$catid = $catid ? $catid : 1;
				$childOrder = 'rgt ASC';
				switch ($value) {
					case 'name_asc':
						$childOrder = 'title ASC';
						break;
					case 'name_desc':
						$childOrder = 'title DESC';
						break;
					case 'ordering_asc':
						$childOrder = 'rgt ASC';
						break;
					case 'ordering_desc':
						$childOrder = 'rgt DESC';
						break;
				}

				$catList = $helper->getCatList($catid, $childOrder);
				$catList = array_map(function ($id) {
					return (string) $id;
				}, $catList);
				$ordering[$key] = $catList;
				
				continue;
			}

			// if (!in_array($value, array('ordering_asc', 'ordering_desc'))) {
				// continue;
			// }

			// preg_match('/ct(\d+)/', $key, $matches);
			// if (!count($matches)) {
				// continue;
			// }

			// $id = +$matches[1];

			// $db = JFactory::getDbo();
			// $query = "SELECT `fieldparams` 
					// FROM `#__fields` 
					// WHERE id = $id
					// AND state = 1";
			// $row = $db->setQuery($query)->loadResult();
			
			// $params = new JRegistry($row);
			// $options = (array) $params->get('options');

			// $fieldOrder = array();
			// foreach ($options as $opt) {
				// $fieldOrder[] = $opt->value;
			// }

			// if ($value === 'ordering_desc') {
				// $fieldOrder = array_reverse($fieldOrder);
			// }

			// $ordering[$key] = $fieldOrder;
		}

		return $ordering;
	}
}