<?php
/**
 * @package    Joomla.Component.Builder
 *
 * @created    4th September, 2022
 * @author     Llewellyn van der Merwe <https://dev.vdm.io>
 * @git        Joomla Component Builder <https://git.vdm.dev/joomla/Component-Builder>
 * @copyright  Copyright (C) 2015 Vast Development Method. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace VDM\Joomla\Componentbuilder;


use VDM\Joomla\Interfaces\Tableinterface;
use VDM\Joomla\Abstraction\BaseTable;


/**
 * Componentbuilder Tables
 * 
 * @since 3.2.0
 */
final class Table extends BaseTable implements Tableinterface
{
	/**
	 * All areas/views/tables with their field details
	 *
	 * @var     array
	 * @since 3.2.0
	 **/
	protected array $tables = [
		'joomla_component' => [
			'system_name' => [
				'name' => 'system_name',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_SYSTEM_NAME_LABEL',
				'type' => 'text',
				'title' => true,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'name_code' => [
				'name' => 'name_code',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_NAME_CODE_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'short_description' => [
				'name' => 'short_description',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_SHORT_DESCRIPTION_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'companyname' => [
				'name' => 'companyname',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_COMPANYNAME_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'CHAR(64)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'created' => [
				'name' => 'created',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_CREATED_LABEL',
				'type' => 'calendar',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'publishing',
				'db' => [
					'type' => 'DATETIME',
					'default' => '0000-00-00 00:00:00',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'crowdin_project_identifier' => [
				'name' => 'crowdin_project_identifier',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_CROWDIN_PROJECT_IDENTIFIER_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Dynamic Integration',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'backup_folder_path' => [
				'name' => 'backup_folder_path',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_BACKUP_FOLDER_PATH_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Dynamic Integration',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'sql_uninstall' => [
				'name' => 'sql_uninstall',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_SQL_UNINSTALL_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'joomla_components',
				'store' => 'base64',
				'tab_name' => 'MySQL',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_postflight_update' => [
				'name' => 'php_postflight_update',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_PHP_POSTFLIGHT_UPDATE_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_components',
				'store' => 'base64',
				'tab_name' => 'Dash & Install',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'css_site' => [
				'name' => 'css_site',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_CSS_SITE_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_components',
				'store' => 'base64',
				'tab_name' => 'Libs & Helpers',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'mvc_versiondate' => [
				'name' => 'mvc_versiondate',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_MVC_VERSIONDATE_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'remove_line_breaks' => [
				'name' => 'remove_line_breaks',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_REMOVE_LINE_BREAKS_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '1',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_placeholders' => [
				'name' => 'add_placeholders',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_ADD_PLACEHOLDERS_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'php_helper_site' => [
				'name' => 'php_helper_site',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_PHP_HELPER_SITE_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_components',
				'store' => 'base64',
				'tab_name' => 'Libs & Helpers',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'javascript' => [
				'name' => 'javascript',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_JAVASCRIPT_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_components',
				'store' => 'base64',
				'tab_name' => 'Libs & Helpers',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'description' => [
				'name' => 'description',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_DESCRIPTION_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'debug_linenr' => [
				'name' => 'debug_linenr',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_DEBUG_LINENR_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'author' => [
				'name' => 'author',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_AUTHOR_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_method_install' => [
				'name' => 'php_method_install',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_PHP_METHOD_INSTALL_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_components',
				'store' => 'base64',
				'tab_name' => 'Dash & Install',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'email' => [
				'name' => 'email',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_EMAIL_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'website' => [
				'name' => 'website',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_WEBSITE_LABEL',
				'type' => 'url',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'CHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_sales_server' => [
				'name' => 'add_sales_server',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_ADD_SALES_SERVER_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Dynamic Integration',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'license' => [
				'name' => 'license',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_LICENSE_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_jcb_powers_path' => [
				'name' => 'add_jcb_powers_path',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_ADD_JCB_POWERS_PATH_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Dynamic Integration',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'bom' => [
				'name' => 'bom',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_BOM_LABEL',
				'type' => 'filelist',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'CHAR(64)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'image' => [
				'name' => 'image',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_IMAGE_LABEL',
				'type' => 'media',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_admin_event' => [
				'name' => 'php_admin_event',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_PHP_ADMIN_EVENT_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_components',
				'store' => 'base64',
				'tab_name' => 'Libs & Helpers',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'copyright' => [
				'name' => 'copyright',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_COPYRIGHT_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_site_event' => [
				'name' => 'php_site_event',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_PHP_SITE_EVENT_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_components',
				'store' => 'base64',
				'tab_name' => 'Libs & Helpers',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'css_admin' => [
				'name' => 'css_admin',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_CSS_ADMIN_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_components',
				'store' => 'base64',
				'tab_name' => 'Libs & Helpers',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_preflight_update' => [
				'name' => 'php_preflight_update',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_PHP_PREFLIGHT_UPDATE_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_components',
				'store' => 'base64',
				'tab_name' => 'Dash & Install',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'component_version' => [
				'name' => 'component_version',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_COMPONENT_VERSION_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'CHAR(64)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_preflight_install' => [
				'name' => 'php_preflight_install',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_PHP_PREFLIGHT_INSTALL_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_components',
				'store' => 'base64',
				'tab_name' => 'Dash & Install',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'preferred_joomla_version' => [
				'name' => 'preferred_joomla_version',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_PREFERRED_JOOMLA_VERSION_LABEL',
				'type' => 'number',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'INT(11)',
					'default' => '3',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_postflight_install' => [
				'name' => 'php_postflight_install',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_PHP_POSTFLIGHT_INSTALL_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_components',
				'store' => 'base64',
				'tab_name' => 'Dash & Install',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_powers' => [
				'name' => 'add_powers',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_ADD_POWERS_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '1',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'php_method_uninstall' => [
				'name' => 'php_method_uninstall',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_PHP_METHOD_UNINSTALL_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_components',
				'store' => 'base64',
				'tab_name' => 'Dash & Install',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'sql' => [
				'name' => 'sql',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_SQL_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'joomla_components',
				'store' => 'base64',
				'tab_name' => 'MySQL',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'addreadme' => [
				'name' => 'addreadme',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_ADDREADME_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Readme',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'update_server_url' => [
				'name' => 'update_server_url',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_UPDATE_SERVER_URL_LABEL',
				'type' => 'url',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Dynamic Integration',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_backup_folder_path' => [
				'name' => 'add_backup_folder_path',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_ADD_BACKUP_FOLDER_PATH_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Dynamic Integration',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'translation_tool' => [
				'name' => 'translation_tool',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_TRANSLATION_TOOL_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Dynamic Integration',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'crowdin_username' => [
				'name' => 'crowdin_username',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_CROWDIN_USERNAME_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'joomla_components',
				'store' => 'basic_encryption',
				'tab_name' => 'Dynamic Integration',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'buildcompsql' => [
				'name' => 'buildcompsql',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_BUILDCOMPSQL_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'joomla_components',
				'store' => 'base64',
				'tab_name' => 'Dynamic Build',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_namespace_prefix' => [
				'name' => 'add_namespace_prefix',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_ADD_NAMESPACE_PREFIX_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Settings',
				'db' => [
					'type' => 'CHAR(1)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'namespace_prefix' => [
				'name' => 'namespace_prefix',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_NAMESPACE_PREFIX_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Settings',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_php_helper_site' => [
				'name' => 'add_php_helper_site',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_ADD_PHP_HELPER_SITE_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Libs & Helpers',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_site_event' => [
				'name' => 'add_site_event',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_ADD_SITE_EVENT_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Libs & Helpers',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_menu_prefix' => [
				'name' => 'add_menu_prefix',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_ADD_MENU_PREFIX_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Settings',
				'db' => [
					'type' => 'CHAR(1)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_javascript' => [
				'name' => 'add_javascript',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_ADD_JAVASCRIPT_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Libs & Helpers',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'menu_prefix' => [
				'name' => 'menu_prefix',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_MENU_PREFIX_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Settings',
				'db' => [
					'type' => 'VARCHAR(100)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_css_admin' => [
				'name' => 'add_css_admin',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_ADD_CSS_ADMIN_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Libs & Helpers',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_css_site' => [
				'name' => 'add_css_site',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_ADD_CSS_SITE_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Libs & Helpers',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'dashboard_type' => [
				'name' => 'dashboard_type',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_DASHBOARD_TYPE_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Dash & Install',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '1',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'toignore' => [
				'name' => 'toignore',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_TOIGNORE_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Settings',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'dashboard' => [
				'name' => 'dashboard',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_DASHBOARD_LABEL',
				'type' => 'dynamicdashboard',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Dash & Install',
				'db' => [
					'type' => 'VARCHAR(64)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_php_preflight_install' => [
				'name' => 'add_php_preflight_install',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_ADD_PHP_PREFLIGHT_INSTALL_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Dash & Install',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_php_preflight_update' => [
				'name' => 'add_php_preflight_update',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_ADD_PHP_PREFLIGHT_UPDATE_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Dash & Install',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'export_key' => [
				'name' => 'export_key',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_EXPORT_KEY_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'joomla_components',
				'store' => 'basic_encryption',
				'tab_name' => 'Settings',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_php_postflight_install' => [
				'name' => 'add_php_postflight_install',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_ADD_PHP_POSTFLIGHT_INSTALL_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Dash & Install',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'joomla_source_link' => [
				'name' => 'joomla_source_link',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_JOOMLA_SOURCE_LINK_LABEL',
				'type' => 'url',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Settings',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_php_postflight_update' => [
				'name' => 'add_php_postflight_update',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_ADD_PHP_POSTFLIGHT_UPDATE_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Dash & Install',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'export_buy_link' => [
				'name' => 'export_buy_link',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_EXPORT_BUY_LINK_LABEL',
				'type' => 'url',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Settings',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_php_method_uninstall' => [
				'name' => 'add_php_method_uninstall',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_ADD_PHP_METHOD_UNINSTALL_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Dash & Install',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_php_method_install' => [
				'name' => 'add_php_method_install',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_ADD_PHP_METHOD_INSTALL_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Dash & Install',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_sql' => [
				'name' => 'add_sql',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_ADD_SQL_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'MySQL',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'addcontributors' => [
				'name' => 'addcontributors',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_ADDCONTRIBUTORS_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'joomla_components',
				'store' => 'json',
				'tab_name' => 'Settings',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_sql_uninstall' => [
				'name' => 'add_sql_uninstall',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_ADD_SQL_UNINSTALL_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'MySQL',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'emptycontributors' => [
				'name' => 'emptycontributors',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_EMPTYCONTRIBUTORS_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Settings',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'assets_table_fix' => [
				'name' => 'assets_table_fix',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_ASSETS_TABLE_FIX_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'MySQL',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '3',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'number' => [
				'name' => 'number',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_NUMBER_LABEL',
				'type' => 'number',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Settings',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'readme' => [
				'name' => 'readme',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_README_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_components',
				'store' => 'base64',
				'tab_name' => 'Readme',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_update_server' => [
				'name' => 'add_update_server',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_ADD_UPDATE_SERVER_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Dynamic Integration',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'update_server_target' => [
				'name' => 'update_server_target',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_UPDATE_SERVER_TARGET_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Dynamic Integration',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'update_server' => [
				'name' => 'update_server',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_UPDATE_SERVER_LABEL',
				'type' => 'servers',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Dynamic Integration',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'sales_server' => [
				'name' => 'sales_server',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_SALES_SERVER_LABEL',
				'type' => 'servers',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Dynamic Integration',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'creatuserhelper' => [
				'name' => 'creatuserhelper',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_CREATUSERHELPER_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Libs & Helpers',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_git_folder_path' => [
				'name' => 'add_git_folder_path',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_ADD_GIT_FOLDER_PATH_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Dynamic Integration',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'adduikit' => [
				'name' => 'adduikit',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_ADDUIKIT_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Libs & Helpers',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'git_folder_path' => [
				'name' => 'git_folder_path',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_GIT_FOLDER_PATH_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Dynamic Integration',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'addfootable' => [
				'name' => 'addfootable',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_ADDFOOTABLE_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Libs & Helpers',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'jcb_powers_path' => [
				'name' => 'jcb_powers_path',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_JCB_POWERS_PATH_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Dynamic Integration',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_email_helper' => [
				'name' => 'add_email_helper',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_ADD_EMAIL_HELPER_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Libs & Helpers',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_php_helper_both' => [
				'name' => 'add_php_helper_both',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_ADD_PHP_HELPER_BOTH_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Libs & Helpers',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'crowdin_project_api_key' => [
				'name' => 'crowdin_project_api_key',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_CROWDIN_PROJECT_API_KEY_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'joomla_components',
				'store' => 'basic_encryption',
				'tab_name' => 'Dynamic Integration',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_helper_both' => [
				'name' => 'php_helper_both',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_PHP_HELPER_BOTH_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_components',
				'store' => 'base64',
				'tab_name' => 'Libs & Helpers',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'crowdin_account_api_key' => [
				'name' => 'crowdin_account_api_key',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_CROWDIN_ACCOUNT_API_KEY_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'joomla_components',
				'store' => 'basic_encryption',
				'tab_name' => 'Dynamic Integration',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_php_helper_admin' => [
				'name' => 'add_php_helper_admin',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_ADD_PHP_HELPER_ADMIN_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Libs & Helpers',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'buildcomp' => [
				'name' => 'buildcomp',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_BUILDCOMP_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Dynamic Build',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_helper_admin' => [
				'name' => 'php_helper_admin',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_PHP_HELPER_ADMIN_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_components',
				'store' => 'base64',
				'tab_name' => 'Libs & Helpers',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'guid' => [
				'name' => 'guid',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_GUID_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'publishing',
				'db' => [
					'type' => 'VARCHAR(36)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_admin_event' => [
				'name' => 'add_admin_event',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_ADD_ADMIN_EVENT_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Libs & Helpers',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'modified' => [
				'name' => 'modified',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_MODIFIED_LABEL',
				'type' => 'calendar',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'publishing',
				'db' => [
					'type' => 'DATETIME',
					'default' => '0000-00-00 00:00:00',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'name' => [
				'name' => 'name',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_COMPONENT_NAME_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'joomla_components',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'CHAR(64)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
			'metakey' => [
				'name' => 'metakey',
				'label' => 'Meta Keywords',
				'type' => 'textarea',
				'title' => false,
				'store' => NULL,
				'tab_name' => 'publishing',
				'db' => [
					'type' => 'TEXT',
				],
			],
			'metadesc' => [
				'name' => 'metadesc',
				'label' => 'Meta Description',
				'type' => 'textarea',
				'title' => false,
				'store' => NULL,
				'tab_name' => 'publishing',
				'db' => [
					'type' => 'TEXT',
				],
			],
			'metadata' => [
				'name' => 'metadata',
				'label' => 'Meta Data',
				'type' => NULL,
				'title' => false,
				'store' => 'json',
				'tab_name' => 'publishing',
				'db' => [
					'type' => 'TEXT',
				],
			],
		],
		'joomla_module' => [
			'system_name' => [
				'name' => 'system_name',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_SYSTEM_NAME_LABEL',
				'type' => 'text',
				'title' => true,
				'list' => 'joomla_modules',
				'store' => NULL,
				'tab_name' => 'HTML',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'target' => [
				'name' => 'target',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_TARGET_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => NULL,
				'tab_name' => 'HTML',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'description' => [
				'name' => 'description',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_DESCRIPTION_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => NULL,
				'tab_name' => 'HTML',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_php_method_uninstall' => [
				'name' => 'add_php_method_uninstall',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_ADD_PHP_METHOD_UNINSTALL_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => NULL,
				'tab_name' => 'Script File',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_php_postflight_update' => [
				'name' => 'add_php_postflight_update',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_ADD_PHP_POSTFLIGHT_UPDATE_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => NULL,
				'tab_name' => 'Script File',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_php_postflight_install' => [
				'name' => 'add_php_postflight_install',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_ADD_PHP_POSTFLIGHT_INSTALL_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => NULL,
				'tab_name' => 'Script File',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_php_preflight_uninstall' => [
				'name' => 'add_php_preflight_uninstall',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_ADD_PHP_PREFLIGHT_UNINSTALL_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => NULL,
				'tab_name' => 'Script File',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'addreadme' => [
				'name' => 'addreadme',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_ADDREADME_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => NULL,
				'tab_name' => 'Readme',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'default' => [
				'name' => 'default',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_DEFAULT_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => 'base64',
				'tab_name' => 'HTML',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'snippet' => [
				'name' => 'snippet',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_SNIPPET_LABEL',
				'type' => 'snippets',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => NULL,
				'tab_name' => 'HTML',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_sql' => [
				'name' => 'add_sql',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_ADD_SQL_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => NULL,
				'tab_name' => 'MySQL',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'update_server_target' => [
				'name' => 'update_server_target',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_UPDATE_SERVER_TARGET_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => NULL,
				'tab_name' => 'Dynamic Integration',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_sql_uninstall' => [
				'name' => 'add_sql_uninstall',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_ADD_SQL_UNINSTALL_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => NULL,
				'tab_name' => 'MySQL',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'update_server' => [
				'name' => 'update_server',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_UPDATE_SERVER_LABEL',
				'type' => 'servers',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => NULL,
				'tab_name' => 'Dynamic Integration',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_update_server' => [
				'name' => 'add_update_server',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_ADD_UPDATE_SERVER_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => NULL,
				'tab_name' => 'Dynamic Integration',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'libraries' => [
				'name' => 'libraries',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_LIBRARIES_LABEL',
				'type' => 'libraries',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => 'json',
				'tab_name' => 'HTML',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'module_version' => [
				'name' => 'module_version',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_MODULE_VERSION_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => NULL,
				'tab_name' => 'HTML',
				'db' => [
					'type' => 'CHAR(64)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'sales_server' => [
				'name' => 'sales_server',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_SALES_SERVER_LABEL',
				'type' => 'servers',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => NULL,
				'tab_name' => 'Dynamic Integration',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'custom_get' => [
				'name' => 'custom_get',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_CUSTOM_GET_LABEL',
				'type' => 'customgets',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => 'json',
				'tab_name' => 'Code',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_preflight_update' => [
				'name' => 'php_preflight_update',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_PHP_PREFLIGHT_UPDATE_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => 'base64',
				'tab_name' => 'Script File',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_preflight_uninstall' => [
				'name' => 'php_preflight_uninstall',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_PHP_PREFLIGHT_UNINSTALL_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => 'base64',
				'tab_name' => 'Script File',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'mod_code' => [
				'name' => 'mod_code',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_MOD_CODE_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => 'base64',
				'tab_name' => 'Code',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_postflight_install' => [
				'name' => 'php_postflight_install',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_PHP_POSTFLIGHT_INSTALL_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => 'base64',
				'tab_name' => 'Script File',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_class_helper' => [
				'name' => 'add_class_helper',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_ADD_CLASS_HELPER_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => NULL,
				'tab_name' => 'Helper',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_postflight_update' => [
				'name' => 'php_postflight_update',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_PHP_POSTFLIGHT_UPDATE_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => 'base64',
				'tab_name' => 'Script File',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_class_helper_header' => [
				'name' => 'add_class_helper_header',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_ADD_CLASS_HELPER_HEADER_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => NULL,
				'tab_name' => 'Helper',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_method_uninstall' => [
				'name' => 'php_method_uninstall',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_PHP_METHOD_UNINSTALL_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => 'base64',
				'tab_name' => 'Script File',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'class_helper_header' => [
				'name' => 'class_helper_header',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_CLASS_HELPER_HEADER_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => 'base64',
				'tab_name' => 'Helper',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'sql' => [
				'name' => 'sql',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_SQL_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => 'base64',
				'tab_name' => 'MySQL',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'class_helper_code' => [
				'name' => 'class_helper_code',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_CLASS_HELPER_CODE_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => 'base64',
				'tab_name' => 'Helper',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'sql_uninstall' => [
				'name' => 'sql_uninstall',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_SQL_UNINSTALL_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => 'base64',
				'tab_name' => 'MySQL',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'fields' => [
				'name' => 'fields',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_FIELDS_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => 'json',
				'tab_name' => 'Forms & Fields',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'readme' => [
				'name' => 'readme',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_README_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => 'base64',
				'tab_name' => 'Readme',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_php_script_construct' => [
				'name' => 'add_php_script_construct',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_ADD_PHP_SCRIPT_CONSTRUCT_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => NULL,
				'tab_name' => 'Script File',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'update_server_url' => [
				'name' => 'update_server_url',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_UPDATE_SERVER_URL_LABEL',
				'type' => 'url',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => NULL,
				'tab_name' => 'Dynamic Integration',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_script_construct' => [
				'name' => 'php_script_construct',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_PHP_SCRIPT_CONSTRUCT_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => 'base64',
				'tab_name' => 'Script File',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_php_preflight_install' => [
				'name' => 'add_php_preflight_install',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_ADD_PHP_PREFLIGHT_INSTALL_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => NULL,
				'tab_name' => 'Script File',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'php_preflight_install' => [
				'name' => 'php_preflight_install',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_PHP_PREFLIGHT_INSTALL_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => 'base64',
				'tab_name' => 'Script File',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_sales_server' => [
				'name' => 'add_sales_server',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_ADD_SALES_SERVER_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => NULL,
				'tab_name' => 'Dynamic Integration',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_php_preflight_update' => [
				'name' => 'add_php_preflight_update',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_ADD_PHP_PREFLIGHT_UPDATE_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => NULL,
				'tab_name' => 'Script File',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'guid' => [
				'name' => 'guid',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_GUID_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => NULL,
				'tab_name' => 'publishing',
				'db' => [
					'type' => 'VARCHAR(36)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'name' => [
				'name' => 'name',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_NAME_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'joomla_modules',
				'store' => NULL,
				'tab_name' => 'HTML',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'joomla_plugin' => [
			'system_name' => [
				'name' => 'system_name',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_SYSTEM_NAME_LABEL',
				'type' => 'text',
				'title' => true,
				'list' => 'joomla_plugins',
				'store' => NULL,
				'tab_name' => 'Code',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'class_extends' => [
				'name' => 'class_extends',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_CLASS_EXTENDS_LABEL',
				'type' => 'classextends',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => NULL,
				'tab_name' => 'Code',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'joomla_plugin_group' => [
				'name' => 'joomla_plugin_group',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_JOOMLA_PLUGIN_GROUP_LABEL',
				'type' => 'joomlaplugingroups',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => NULL,
				'tab_name' => 'Code',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_sql' => [
				'name' => 'add_sql',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_ADD_SQL_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => NULL,
				'tab_name' => 'MySQL',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_php_method_uninstall' => [
				'name' => 'add_php_method_uninstall',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_ADD_PHP_METHOD_UNINSTALL_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => NULL,
				'tab_name' => 'Script File',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_php_postflight_update' => [
				'name' => 'add_php_postflight_update',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_ADD_PHP_POSTFLIGHT_UPDATE_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => NULL,
				'tab_name' => 'Script File',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_php_postflight_install' => [
				'name' => 'add_php_postflight_install',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_ADD_PHP_POSTFLIGHT_INSTALL_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => NULL,
				'tab_name' => 'Script File',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'sales_server' => [
				'name' => 'sales_server',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_SALES_SERVER_LABEL',
				'type' => 'servers',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => NULL,
				'tab_name' => 'Dynamic Integration',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_update_server' => [
				'name' => 'add_update_server',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_ADD_UPDATE_SERVER_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => NULL,
				'tab_name' => 'Dynamic Integration',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'method_selection' => [
				'name' => 'method_selection',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_METHOD_SELECTION_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => 'json',
				'tab_name' => 'Code',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'property_selection' => [
				'name' => 'property_selection',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_PROPERTY_SELECTION_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => 'json',
				'tab_name' => 'Code',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_head' => [
				'name' => 'add_head',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_ADD_HEAD_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => NULL,
				'tab_name' => 'Code',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_sql_uninstall' => [
				'name' => 'add_sql_uninstall',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_ADD_SQL_UNINSTALL_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => NULL,
				'tab_name' => 'MySQL',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'addreadme' => [
				'name' => 'addreadme',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_ADDREADME_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => NULL,
				'tab_name' => 'Readme',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'head' => [
				'name' => 'head',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_HEAD_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => 'base64',
				'tab_name' => 'Code',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'update_server_target' => [
				'name' => 'update_server_target',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_UPDATE_SERVER_TARGET_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => NULL,
				'tab_name' => 'Dynamic Integration',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'main_class_code' => [
				'name' => 'main_class_code',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_MAIN_CLASS_CODE_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => 'base64',
				'tab_name' => 'Code',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'update_server' => [
				'name' => 'update_server',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_UPDATE_SERVER_LABEL',
				'type' => 'servers',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => NULL,
				'tab_name' => 'Dynamic Integration',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'description' => [
				'name' => 'description',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_DESCRIPTION_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => NULL,
				'tab_name' => 'Code',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_postflight_install' => [
				'name' => 'php_postflight_install',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_PHP_POSTFLIGHT_INSTALL_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => 'base64',
				'tab_name' => 'Script File',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'plugin_version' => [
				'name' => 'plugin_version',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_PLUGIN_VERSION_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => NULL,
				'tab_name' => 'Code',
				'db' => [
					'type' => 'CHAR(64)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_postflight_update' => [
				'name' => 'php_postflight_update',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_PHP_POSTFLIGHT_UPDATE_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => 'base64',
				'tab_name' => 'Script File',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'fields' => [
				'name' => 'fields',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_FIELDS_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => 'json',
				'tab_name' => 'Forms & Fields',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_method_uninstall' => [
				'name' => 'php_method_uninstall',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_PHP_METHOD_UNINSTALL_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => 'base64',
				'tab_name' => 'Script File',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_php_script_construct' => [
				'name' => 'add_php_script_construct',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_ADD_PHP_SCRIPT_CONSTRUCT_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => NULL,
				'tab_name' => 'Script File',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'sql' => [
				'name' => 'sql',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_SQL_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => 'base64',
				'tab_name' => 'MySQL',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_script_construct' => [
				'name' => 'php_script_construct',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_PHP_SCRIPT_CONSTRUCT_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => 'base64',
				'tab_name' => 'Script File',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'sql_uninstall' => [
				'name' => 'sql_uninstall',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_SQL_UNINSTALL_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => 'base64',
				'tab_name' => 'MySQL',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_php_preflight_install' => [
				'name' => 'add_php_preflight_install',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_ADD_PHP_PREFLIGHT_INSTALL_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => NULL,
				'tab_name' => 'Script File',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'readme' => [
				'name' => 'readme',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_README_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => 'base64',
				'tab_name' => 'Readme',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_preflight_install' => [
				'name' => 'php_preflight_install',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_PHP_PREFLIGHT_INSTALL_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => 'base64',
				'tab_name' => 'Script File',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'update_server_url' => [
				'name' => 'update_server_url',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_UPDATE_SERVER_URL_LABEL',
				'type' => 'url',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => NULL,
				'tab_name' => 'Dynamic Integration',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_php_preflight_update' => [
				'name' => 'add_php_preflight_update',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_ADD_PHP_PREFLIGHT_UPDATE_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => NULL,
				'tab_name' => 'Script File',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'php_preflight_update' => [
				'name' => 'php_preflight_update',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_PHP_PREFLIGHT_UPDATE_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => 'base64',
				'tab_name' => 'Script File',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_php_preflight_uninstall' => [
				'name' => 'add_php_preflight_uninstall',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_ADD_PHP_PREFLIGHT_UNINSTALL_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => NULL,
				'tab_name' => 'Script File',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_sales_server' => [
				'name' => 'add_sales_server',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_ADD_SALES_SERVER_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => NULL,
				'tab_name' => 'Dynamic Integration',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'php_preflight_uninstall' => [
				'name' => 'php_preflight_uninstall',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_PHP_PREFLIGHT_UNINSTALL_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => 'base64',
				'tab_name' => 'Script File',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'guid' => [
				'name' => 'guid',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_GUID_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => NULL,
				'tab_name' => 'publishing',
				'db' => [
					'type' => 'VARCHAR(36)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'name' => [
				'name' => 'name',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_NAME_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'joomla_plugins',
				'store' => NULL,
				'tab_name' => 'Code',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'joomla_power' => [
			'system_name' => [
				'name' => 'system_name',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_POWER_SYSTEM_NAME_LABEL',
				'type' => 'text',
				'title' => true,
				'list' => 'joomla_powers',
				'store' => NULL,
				'tab_name' => 'Joomla Power',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'settings' => [
				'name' => 'settings',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_POWER_SETTINGS_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'joomla_powers',
				'store' => 'json',
				'tab_name' => 'Joomla Power',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'guid' => [
				'name' => 'guid',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_POWER_GUID_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'joomla_powers',
				'store' => NULL,
				'tab_name' => 'publishing',
				'db' => [
					'type' => 'VARCHAR(36)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'description' => [
				'name' => 'description',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_POWER_DESCRIPTION_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'joomla_powers',
				'store' => NULL,
				'tab_name' => 'Joomla Power',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'power' => [
			'system_name' => [
				'name' => 'system_name',
				'label' => 'COM_COMPONENTBUILDER_POWER_SYSTEM_NAME_LABEL',
				'type' => 'text',
				'title' => true,
				'list' => 'powers',
				'store' => NULL,
				'tab_name' => 'Code',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'namespace' => [
				'name' => 'namespace',
				'label' => 'COM_COMPONENTBUILDER_POWER_NAMESPACE_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'powers',
				'store' => NULL,
				'tab_name' => 'Code',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'type' => [
				'name' => 'type',
				'label' => 'COM_COMPONENTBUILDER_POWER_TYPE_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'powers',
				'store' => NULL,
				'tab_name' => 'Code',
				'db' => [
					'type' => 'VARCHAR(64)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'power_version' => [
				'name' => 'power_version',
				'label' => 'COM_COMPONENTBUILDER_POWER_POWER_VERSION_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'powers',
				'store' => NULL,
				'tab_name' => 'Code',
				'db' => [
					'type' => 'CHAR(64)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'load_selection' => [
				'name' => 'load_selection',
				'label' => 'COM_COMPONENTBUILDER_POWER_LOAD_SELECTION_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'powers',
				'store' => 'json',
				'tab_name' => 'Code',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'description' => [
				'name' => 'description',
				'label' => 'COM_COMPONENTBUILDER_POWER_DESCRIPTION_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'powers',
				'store' => NULL,
				'tab_name' => 'Code',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'composer' => [
				'name' => 'composer',
				'label' => 'COM_COMPONENTBUILDER_POWER_COMPOSER_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'powers',
				'store' => 'json',
				'tab_name' => 'Composer',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'licensing_template' => [
				'name' => 'licensing_template',
				'label' => 'COM_COMPONENTBUILDER_POWER_LICENSING_TEMPLATE_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'powers',
				'store' => 'base64',
				'tab_name' => 'Licensing',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'approved' => [
				'name' => 'approved',
				'label' => 'COM_COMPONENTBUILDER_POWER_APPROVED_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'powers',
				'store' => NULL,
				'tab_name' => 'Super Power',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'extendsinterfaces_custom' => [
				'name' => 'extendsinterfaces_custom',
				'label' => 'COM_COMPONENTBUILDER_POWER_EXTENDSINTERFACES_CUSTOM_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'powers',
				'store' => NULL,
				'tab_name' => 'Code',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_head' => [
				'name' => 'add_head',
				'label' => 'COM_COMPONENTBUILDER_POWER_ADD_HEAD_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'powers',
				'store' => NULL,
				'tab_name' => 'Code',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'extends' => [
				'name' => 'extends',
				'label' => 'COM_COMPONENTBUILDER_POWER_EXTENDS_LABEL',
				'type' => 'classpowers',
				'title' => false,
				'list' => 'powers',
				'store' => NULL,
				'tab_name' => 'Code',
				'db' => [
					'type' => 'VARCHAR(36)',
					'default' => '',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'extends_custom' => [
				'name' => 'extends_custom',
				'label' => 'COM_COMPONENTBUILDER_POWER_EXTENDS_CUSTOM_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'powers',
				'store' => NULL,
				'tab_name' => 'Code',
				'db' => [
					'type' => 'VARCHAR(64)',
					'default' => '',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'implements_custom' => [
				'name' => 'implements_custom',
				'label' => 'COM_COMPONENTBUILDER_POWER_IMPLEMENTS_CUSTOM_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'powers',
				'store' => NULL,
				'tab_name' => 'Code',
				'db' => [
					'type' => 'VARCHAR(1024)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'implements' => [
				'name' => 'implements',
				'label' => 'COM_COMPONENTBUILDER_POWER_IMPLEMENTS_LABEL',
				'type' => 'interfacepowers',
				'title' => false,
				'list' => 'powers',
				'store' => 'json',
				'tab_name' => 'Code',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'property_selection' => [
				'name' => 'property_selection',
				'label' => 'COM_COMPONENTBUILDER_POWER_PROPERTY_SELECTION_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'powers',
				'store' => 'json',
				'tab_name' => 'Code',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'extendsinterfaces' => [
				'name' => 'extendsinterfaces',
				'label' => 'COM_COMPONENTBUILDER_POWER_EXTENDSINTERFACES_LABEL',
				'type' => 'interfacepowers',
				'title' => false,
				'list' => 'powers',
				'store' => 'json',
				'tab_name' => 'Code',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'method_selection' => [
				'name' => 'method_selection',
				'label' => 'COM_COMPONENTBUILDER_POWER_METHOD_SELECTION_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'powers',
				'store' => 'json',
				'tab_name' => 'Code',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'approved_paths' => [
				'name' => 'approved_paths',
				'label' => 'COM_COMPONENTBUILDER_POWER_APPROVED_PATHS_LABEL',
				'type' => 'superpowerpaths',
				'title' => false,
				'list' => 'powers',
				'store' => 'json',
				'tab_name' => 'Super Power',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'head' => [
				'name' => 'head',
				'label' => 'COM_COMPONENTBUILDER_POWER_HEAD_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'powers',
				'store' => 'base64',
				'tab_name' => 'Code',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'use_selection' => [
				'name' => 'use_selection',
				'label' => 'COM_COMPONENTBUILDER_POWER_USE_SELECTION_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'powers',
				'store' => 'json',
				'tab_name' => 'Code',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_licensing_template' => [
				'name' => 'add_licensing_template',
				'label' => 'COM_COMPONENTBUILDER_POWER_ADD_LICENSING_TEMPLATE_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'powers',
				'store' => NULL,
				'tab_name' => 'Licensing',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '1',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'main_class_code' => [
				'name' => 'main_class_code',
				'label' => 'COM_COMPONENTBUILDER_POWER_MAIN_CLASS_CODE_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'powers',
				'store' => 'base64',
				'tab_name' => 'Code',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'guid' => [
				'name' => 'guid',
				'label' => 'COM_COMPONENTBUILDER_POWER_GUID_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'powers',
				'store' => NULL,
				'tab_name' => 'publishing',
				'db' => [
					'type' => 'VARCHAR(36)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'name' => [
				'name' => 'name',
				'label' => 'COM_COMPONENTBUILDER_POWER_NAME_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'powers',
				'store' => NULL,
				'tab_name' => 'Code',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'admin_view' => [
			'system_name' => [
				'name' => 'system_name',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_SYSTEM_NAME_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'name_single' => [
				'name' => 'name_single',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_NAME_SINGLE_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'CHAR(64)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'short_description' => [
				'name' => 'short_description',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_SHORT_DESCRIPTION_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_allowedit' => [
				'name' => 'php_allowedit',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_PHP_ALLOWEDIT_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_postsavehook' => [
				'name' => 'php_postsavehook',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_PHP_POSTSAVEHOOK_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_before_save' => [
				'name' => 'php_before_save',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_PHP_BEFORE_SAVE_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_getlistquery' => [
				'name' => 'php_getlistquery',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_PHP_GETLISTQUERY_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_import_ext' => [
				'name' => 'php_import_ext',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_PHP_IMPORT_EXT_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'Custom Import',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'icon' => [
				'name' => 'icon',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ICON_LABEL',
				'type' => 'media',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_after_publish' => [
				'name' => 'php_after_publish',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_PHP_AFTER_PUBLISH_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_fadein' => [
				'name' => 'add_fadein',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADD_FADEIN_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'description' => [
				'name' => 'description',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_DESCRIPTION_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'icon_category' => [
				'name' => 'icon_category',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ICON_CATEGORY_LABEL',
				'type' => 'media',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'icon_add' => [
				'name' => 'icon_add',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ICON_ADD_LABEL',
				'type' => 'media',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_after_cancel' => [
				'name' => 'php_after_cancel',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_PHP_AFTER_CANCEL_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'mysql_table_charset' => [
				'name' => 'mysql_table_charset',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_MYSQL_TABLE_CHARSET_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'MySQL',
				'db' => [
					'type' => 'VARCHAR(64)',
					'default' => '1',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'php_batchmove' => [
				'name' => 'php_batchmove',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_PHP_BATCHMOVE_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'type' => [
				'name' => 'type',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_TYPE_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'php_after_delete' => [
				'name' => 'php_after_delete',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_PHP_AFTER_DELETE_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'source' => [
				'name' => 'source',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_SOURCE_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'MySQL',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'php_import' => [
				'name' => 'php_import',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_PHP_IMPORT_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'Custom Import',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'addpermissions' => [
				'name' => 'addpermissions',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADDPERMISSIONS_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'json',
				'tab_name' => 'Settings',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_getitems_after_all' => [
				'name' => 'php_getitems_after_all',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_PHP_GETITEMS_AFTER_ALL_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_getform' => [
				'name' => 'php_getform',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_PHP_GETFORM_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'addtabs' => [
				'name' => 'addtabs',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADDTABS_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'json',
				'tab_name' => 'Settings',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_save' => [
				'name' => 'php_save',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_PHP_SAVE_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_allowadd' => [
				'name' => 'php_allowadd',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_PHP_ALLOWADD_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_before_cancel' => [
				'name' => 'php_before_cancel',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_PHP_BEFORE_CANCEL_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'addlinked_views' => [
				'name' => 'addlinked_views',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADDLINKED_VIEWS_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'json',
				'tab_name' => 'Settings',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_batchcopy' => [
				'name' => 'php_batchcopy',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_PHP_BATCHCOPY_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_before_publish' => [
				'name' => 'php_before_publish',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_PHP_BEFORE_PUBLISH_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'alias_builder_type' => [
				'name' => 'alias_builder_type',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ALIAS_BUILDER_TYPE_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'Fields',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_before_delete' => [
				'name' => 'php_before_delete',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_PHP_BEFORE_DELETE_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_document' => [
				'name' => 'php_document',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_PHP_DOCUMENT_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'mysql_table_row_format' => [
				'name' => 'mysql_table_row_format',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_MYSQL_TABLE_ROW_FORMAT_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'MySQL',
				'db' => [
					'type' => 'VARCHAR(64)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'alias_builder' => [
				'name' => 'alias_builder',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ALIAS_BUILDER_LABEL',
				'type' => 'aliasbuilder',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'json',
				'tab_name' => 'Fields',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'sql' => [
				'name' => 'sql',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_SQL_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'MySQL',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_import_display' => [
				'name' => 'php_import_display',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_PHP_IMPORT_DISPLAY_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'Custom Import',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_category_submenu' => [
				'name' => 'add_category_submenu',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADD_CATEGORY_SUBMENU_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'Fields',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '1',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'php_import_setdata' => [
				'name' => 'php_import_setdata',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_PHP_IMPORT_SETDATA_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'Custom Import',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'name_list' => [
				'name' => 'name_list',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_NAME_LIST_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'CHAR(64)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_php_getlistquery' => [
				'name' => 'add_php_getlistquery',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADD_PHP_GETLISTQUERY_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_css_view' => [
				'name' => 'add_css_view',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADD_CSS_VIEW_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'CSS',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_php_getform' => [
				'name' => 'add_php_getform',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADD_PHP_GETFORM_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'css_view' => [
				'name' => 'css_view',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_CSS_VIEW_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'CSS',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_php_before_save' => [
				'name' => 'add_php_before_save',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADD_PHP_BEFORE_SAVE_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_css_views' => [
				'name' => 'add_css_views',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADD_CSS_VIEWS_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'CSS',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_php_save' => [
				'name' => 'add_php_save',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADD_PHP_SAVE_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'css_views' => [
				'name' => 'css_views',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_CSS_VIEWS_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'CSS',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_php_postsavehook' => [
				'name' => 'add_php_postsavehook',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADD_PHP_POSTSAVEHOOK_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_javascript_view_file' => [
				'name' => 'add_javascript_view_file',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADD_JAVASCRIPT_VIEW_FILE_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'JavaScript',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_php_allowadd' => [
				'name' => 'add_php_allowadd',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADD_PHP_ALLOWADD_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'javascript_view_file' => [
				'name' => 'javascript_view_file',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_JAVASCRIPT_VIEW_FILE_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'JavaScript',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_php_allowedit' => [
				'name' => 'add_php_allowedit',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADD_PHP_ALLOWEDIT_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_javascript_view_footer' => [
				'name' => 'add_javascript_view_footer',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADD_JAVASCRIPT_VIEW_FOOTER_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'JavaScript',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_php_before_cancel' => [
				'name' => 'add_php_before_cancel',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADD_PHP_BEFORE_CANCEL_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'javascript_view_footer' => [
				'name' => 'javascript_view_footer',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_JAVASCRIPT_VIEW_FOOTER_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'JavaScript',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_php_after_cancel' => [
				'name' => 'add_php_after_cancel',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADD_PHP_AFTER_CANCEL_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_javascript_views_file' => [
				'name' => 'add_javascript_views_file',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADD_JAVASCRIPT_VIEWS_FILE_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'JavaScript',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_php_batchcopy' => [
				'name' => 'add_php_batchcopy',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADD_PHP_BATCHCOPY_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'javascript_views_file' => [
				'name' => 'javascript_views_file',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_JAVASCRIPT_VIEWS_FILE_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'JavaScript',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_php_batchmove' => [
				'name' => 'add_php_batchmove',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADD_PHP_BATCHMOVE_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_javascript_views_footer' => [
				'name' => 'add_javascript_views_footer',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADD_JAVASCRIPT_VIEWS_FOOTER_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'JavaScript',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_php_before_publish' => [
				'name' => 'add_php_before_publish',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADD_PHP_BEFORE_PUBLISH_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'javascript_views_footer' => [
				'name' => 'javascript_views_footer',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_JAVASCRIPT_VIEWS_FOOTER_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'JavaScript',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_php_after_publish' => [
				'name' => 'add_php_after_publish',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADD_PHP_AFTER_PUBLISH_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_custom_button' => [
				'name' => 'add_custom_button',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADD_CUSTOM_BUTTON_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'Custom Buttons',
				'db' => [
					'type' => 'INT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_php_before_delete' => [
				'name' => 'add_php_before_delete',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADD_PHP_BEFORE_DELETE_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'custom_button' => [
				'name' => 'custom_button',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_CUSTOM_BUTTON_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'json',
				'tab_name' => 'Custom Buttons',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_php_after_delete' => [
				'name' => 'add_php_after_delete',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADD_PHP_AFTER_DELETE_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'php_controller' => [
				'name' => 'php_controller',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_PHP_CONTROLLER_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'Custom Buttons',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_php_document' => [
				'name' => 'add_php_document',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADD_PHP_DOCUMENT_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'php_model' => [
				'name' => 'php_model',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_PHP_MODEL_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'Custom Buttons',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'mysql_table_engine' => [
				'name' => 'mysql_table_engine',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_MYSQL_TABLE_ENGINE_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'MySQL',
				'db' => [
					'type' => 'VARCHAR(64)',
					'default' => '1',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'php_controller_list' => [
				'name' => 'php_controller_list',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_PHP_CONTROLLER_LIST_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'Custom Buttons',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'mysql_table_collate' => [
				'name' => 'mysql_table_collate',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_MYSQL_TABLE_COLLATE_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'MySQL',
				'db' => [
					'type' => 'VARCHAR(64)',
					'default' => '1',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'php_model_list' => [
				'name' => 'php_model_list',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_PHP_MODEL_LIST_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'Custom Buttons',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_sql' => [
				'name' => 'add_sql',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADD_SQL_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'MySQL',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_php_ajax' => [
				'name' => 'add_php_ajax',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADD_PHP_AJAX_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'addtables' => [
				'name' => 'addtables',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADDTABLES_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'json',
				'tab_name' => 'MySQL',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_ajaxmethod' => [
				'name' => 'php_ajaxmethod',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_PHP_AJAXMETHOD_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'ajax_input' => [
				'name' => 'ajax_input',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_AJAX_INPUT_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'json',
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_custom_import' => [
				'name' => 'add_custom_import',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADD_CUSTOM_IMPORT_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'Custom Import',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_php_getitem' => [
				'name' => 'add_php_getitem',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADD_PHP_GETITEM_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'html_import_view' => [
				'name' => 'html_import_view',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_HTML_IMPORT_VIEW_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'Custom Import',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_getitem' => [
				'name' => 'php_getitem',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_PHP_GETITEM_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_import_headers' => [
				'name' => 'php_import_headers',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_PHP_IMPORT_HEADERS_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'Custom Import',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_php_getitems' => [
				'name' => 'add_php_getitems',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADD_PHP_GETITEMS_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'php_import_save' => [
				'name' => 'php_import_save',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_PHP_IMPORT_SAVE_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'Custom Import',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_getitems' => [
				'name' => 'php_getitems',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_PHP_GETITEMS_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'admin_views',
				'store' => 'base64',
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'guid' => [
				'name' => 'guid',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_GUID_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'publishing',
				'db' => [
					'type' => 'VARCHAR(36)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_php_getitems_after_all' => [
				'name' => 'add_php_getitems_after_all',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_VIEW_ADD_PHP_GETITEMS_AFTER_ALL_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'admin_views',
				'store' => NULL,
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'custom_admin_view' => [
			'system_name' => [
				'name' => 'system_name',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_SYSTEM_NAME_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'name' => [
				'name' => 'name',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_NAME_LABEL',
				'type' => 'text',
				'title' => true,
				'list' => 'custom_admin_views',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'description' => [
				'name' => 'description',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_DESCRIPTION_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'main_get' => [
				'name' => 'main_get',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_MAIN_GET_LABEL',
				'type' => 'maingets',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_php_jview_display' => [
				'name' => 'add_php_jview_display',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_ADD_PHP_JVIEW_DISPLAY_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => NULL,
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'css_document' => [
				'name' => 'css_document',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_CSS_DOCUMENT_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => 'base64',
				'tab_name' => 'JavaScript & CSS',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'css' => [
				'name' => 'css',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_CSS_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => 'base64',
				'tab_name' => 'JavaScript & CSS',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'js_document' => [
				'name' => 'js_document',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_JS_DOCUMENT_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => 'base64',
				'tab_name' => 'JavaScript & CSS',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'javascript_file' => [
				'name' => 'javascript_file',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_JAVASCRIPT_FILE_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => 'base64',
				'tab_name' => 'JavaScript & CSS',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'codename' => [
				'name' => 'codename',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_CODENAME_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'default' => [
				'name' => 'default',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_DEFAULT_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => 'base64',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'snippet' => [
				'name' => 'snippet',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_SNIPPET_LABEL',
				'type' => 'snippets',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'icon' => [
				'name' => 'icon',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_ICON_LABEL',
				'type' => 'media',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_php_jview' => [
				'name' => 'add_php_jview',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_ADD_PHP_JVIEW_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => NULL,
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'context' => [
				'name' => 'context',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_CONTEXT_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_js_document' => [
				'name' => 'add_js_document',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_ADD_JS_DOCUMENT_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => NULL,
				'tab_name' => 'JavaScript & CSS',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'custom_get' => [
				'name' => 'custom_get',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_CUSTOM_GET_LABEL',
				'type' => 'customgets',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => 'json',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_javascript_file' => [
				'name' => 'add_javascript_file',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_ADD_JAVASCRIPT_FILE_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => NULL,
				'tab_name' => 'JavaScript & CSS',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'php_ajaxmethod' => [
				'name' => 'php_ajaxmethod',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_PHP_AJAXMETHOD_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => 'base64',
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_css_document' => [
				'name' => 'add_css_document',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_ADD_CSS_DOCUMENT_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => NULL,
				'tab_name' => 'JavaScript & CSS',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_php_document' => [
				'name' => 'add_php_document',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_ADD_PHP_DOCUMENT_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => NULL,
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_css' => [
				'name' => 'add_css',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_ADD_CSS_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => NULL,
				'tab_name' => 'JavaScript & CSS',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_php_view' => [
				'name' => 'add_php_view',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_ADD_PHP_VIEW_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => NULL,
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_php_ajax' => [
				'name' => 'add_php_ajax',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_ADD_PHP_AJAX_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => NULL,
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'libraries' => [
				'name' => 'libraries',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_LIBRARIES_LABEL',
				'type' => 'libraries',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => 'json',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'ajax_input' => [
				'name' => 'ajax_input',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_AJAX_INPUT_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => 'json',
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'dynamic_get' => [
				'name' => 'dynamic_get',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_DYNAMIC_GET_LABEL',
				'type' => 'dynamicgets',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'php_document' => [
				'name' => 'php_document',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_PHP_DOCUMENT_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => 'base64',
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_view' => [
				'name' => 'php_view',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_PHP_VIEW_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => 'base64',
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_custom_button' => [
				'name' => 'add_custom_button',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_ADD_CUSTOM_BUTTON_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => NULL,
				'tab_name' => 'Custom Buttons',
				'db' => [
					'type' => 'INT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'php_jview_display' => [
				'name' => 'php_jview_display',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_PHP_JVIEW_DISPLAY_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => 'base64',
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'custom_button' => [
				'name' => 'custom_button',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_CUSTOM_BUTTON_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => 'json',
				'tab_name' => 'Custom Buttons',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_jview' => [
				'name' => 'php_jview',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_PHP_JVIEW_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => 'base64',
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_controller' => [
				'name' => 'php_controller',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_PHP_CONTROLLER_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => 'base64',
				'tab_name' => 'Custom Buttons',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'guid' => [
				'name' => 'guid',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_GUID_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => NULL,
				'tab_name' => 'publishing',
				'db' => [
					'type' => 'VARCHAR(36)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'php_model' => [
				'name' => 'php_model',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_ADMIN_VIEW_PHP_MODEL_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'custom_admin_views',
				'store' => 'base64',
				'tab_name' => 'Custom Buttons',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'site_view' => [
			'system_name' => [
				'name' => 'system_name',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_SYSTEM_NAME_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'site_views',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'name' => [
				'name' => 'name',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_NAME_LABEL',
				'type' => 'text',
				'title' => true,
				'list' => 'site_views',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'description' => [
				'name' => 'description',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_DESCRIPTION_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'site_views',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'main_get' => [
				'name' => 'main_get',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_MAIN_GET_LABEL',
				'type' => 'maingets',
				'title' => false,
				'list' => 'site_views',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_php_jview_display' => [
				'name' => 'add_php_jview_display',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_ADD_PHP_JVIEW_DISPLAY_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'site_views',
				'store' => NULL,
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_php_document' => [
				'name' => 'add_php_document',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_ADD_PHP_DOCUMENT_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'site_views',
				'store' => NULL,
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_php_view' => [
				'name' => 'add_php_view',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_ADD_PHP_VIEW_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'site_views',
				'store' => NULL,
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'js_document' => [
				'name' => 'js_document',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_JS_DOCUMENT_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'site_views',
				'store' => 'base64',
				'tab_name' => 'JavaScript & CSS',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'codename' => [
				'name' => 'codename',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_CODENAME_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'site_views',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'javascript_file' => [
				'name' => 'javascript_file',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_JAVASCRIPT_FILE_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'site_views',
				'store' => 'base64',
				'tab_name' => 'JavaScript & CSS',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'context' => [
				'name' => 'context',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_CONTEXT_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'site_views',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'default' => [
				'name' => 'default',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_DEFAULT_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'site_views',
				'store' => 'base64',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'snippet' => [
				'name' => 'snippet',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_SNIPPET_LABEL',
				'type' => 'snippets',
				'title' => false,
				'list' => 'site_views',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_php_jview' => [
				'name' => 'add_php_jview',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_ADD_PHP_JVIEW_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'site_views',
				'store' => NULL,
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'custom_get' => [
				'name' => 'custom_get',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_CUSTOM_GET_LABEL',
				'type' => 'customgets',
				'title' => false,
				'list' => 'site_views',
				'store' => 'json',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'css_document' => [
				'name' => 'css_document',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_CSS_DOCUMENT_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'site_views',
				'store' => 'base64',
				'tab_name' => 'JavaScript & CSS',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_javascript_file' => [
				'name' => 'add_javascript_file',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_ADD_JAVASCRIPT_FILE_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'site_views',
				'store' => NULL,
				'tab_name' => 'JavaScript & CSS',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'css' => [
				'name' => 'css',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_CSS_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'site_views',
				'store' => 'base64',
				'tab_name' => 'JavaScript & CSS',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_js_document' => [
				'name' => 'add_js_document',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_ADD_JS_DOCUMENT_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'site_views',
				'store' => NULL,
				'tab_name' => 'JavaScript & CSS',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'php_ajaxmethod' => [
				'name' => 'php_ajaxmethod',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_PHP_AJAXMETHOD_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'site_views',
				'store' => 'base64',
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_css_document' => [
				'name' => 'add_css_document',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_ADD_CSS_DOCUMENT_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'site_views',
				'store' => NULL,
				'tab_name' => 'JavaScript & CSS',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'libraries' => [
				'name' => 'libraries',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_LIBRARIES_LABEL',
				'type' => 'libraries',
				'title' => false,
				'list' => 'site_views',
				'store' => 'json',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_css' => [
				'name' => 'add_css',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_ADD_CSS_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'site_views',
				'store' => NULL,
				'tab_name' => 'JavaScript & CSS',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'dynamic_get' => [
				'name' => 'dynamic_get',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_DYNAMIC_GET_LABEL',
				'type' => 'dynamicgets',
				'title' => false,
				'list' => 'site_views',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_php_ajax' => [
				'name' => 'add_php_ajax',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_ADD_PHP_AJAX_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'site_views',
				'store' => NULL,
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'ajax_input' => [
				'name' => 'ajax_input',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_AJAX_INPUT_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'site_views',
				'store' => 'json',
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_custom_button' => [
				'name' => 'add_custom_button',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_ADD_CUSTOM_BUTTON_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'site_views',
				'store' => NULL,
				'tab_name' => 'Custom Buttons',
				'db' => [
					'type' => 'INT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'php_document' => [
				'name' => 'php_document',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_PHP_DOCUMENT_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'site_views',
				'store' => 'base64',
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'button_position' => [
				'name' => 'button_position',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_BUTTON_POSITION_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'site_views',
				'store' => NULL,
				'tab_name' => 'Custom Buttons',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '1',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'php_view' => [
				'name' => 'php_view',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_PHP_VIEW_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'site_views',
				'store' => 'base64',
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_jview_display' => [
				'name' => 'php_jview_display',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_PHP_JVIEW_DISPLAY_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'site_views',
				'store' => 'base64',
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'custom_button' => [
				'name' => 'custom_button',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_CUSTOM_BUTTON_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'site_views',
				'store' => 'json',
				'tab_name' => 'Custom Buttons',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_jview' => [
				'name' => 'php_jview',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_PHP_JVIEW_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'site_views',
				'store' => 'base64',
				'tab_name' => 'PHP',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_controller' => [
				'name' => 'php_controller',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_PHP_CONTROLLER_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'site_views',
				'store' => 'base64',
				'tab_name' => 'Custom Buttons',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'guid' => [
				'name' => 'guid',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_GUID_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'site_views',
				'store' => NULL,
				'tab_name' => 'publishing',
				'db' => [
					'type' => 'VARCHAR(36)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'php_model' => [
				'name' => 'php_model',
				'label' => 'COM_COMPONENTBUILDER_SITE_VIEW_PHP_MODEL_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'site_views',
				'store' => 'base64',
				'tab_name' => 'Custom Buttons',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'template' => [
			'name' => [
				'name' => 'name',
				'label' => 'COM_COMPONENTBUILDER_TEMPLATE_NAME_LABEL',
				'type' => 'text',
				'title' => true,
				'list' => 'templates',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'description' => [
				'name' => 'description',
				'label' => 'COM_COMPONENTBUILDER_TEMPLATE_DESCRIPTION_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'templates',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'dynamic_get' => [
				'name' => 'dynamic_get',
				'label' => 'COM_COMPONENTBUILDER_TEMPLATE_DYNAMIC_GET_LABEL',
				'type' => 'dynamicget',
				'title' => false,
				'list' => 'templates',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'php_view' => [
				'name' => 'php_view',
				'label' => 'COM_COMPONENTBUILDER_TEMPLATE_PHP_VIEW_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'templates',
				'store' => 'base64',
				'tab_name' => 'Custom Script',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_php_view' => [
				'name' => 'add_php_view',
				'label' => 'COM_COMPONENTBUILDER_TEMPLATE_ADD_PHP_VIEW_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'templates',
				'store' => NULL,
				'tab_name' => 'Custom Script',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'template' => [
				'name' => 'template',
				'label' => 'COM_COMPONENTBUILDER_TEMPLATE_TEMPLATE_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'templates',
				'store' => 'base64',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'snippet' => [
				'name' => 'snippet',
				'label' => 'COM_COMPONENTBUILDER_TEMPLATE_SNIPPET_LABEL',
				'type' => 'snippets',
				'title' => false,
				'list' => 'templates',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'libraries' => [
				'name' => 'libraries',
				'label' => 'COM_COMPONENTBUILDER_TEMPLATE_LIBRARIES_LABEL',
				'type' => 'libraries',
				'title' => false,
				'list' => 'templates',
				'store' => 'json',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'alias' => [
				'name' => 'alias',
				'label' => 'COM_COMPONENTBUILDER_TEMPLATE_ALIAS_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'templates',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'layout' => [
			'name' => [
				'name' => 'name',
				'label' => 'COM_COMPONENTBUILDER_LAYOUT_NAME_LABEL',
				'type' => 'text',
				'title' => true,
				'list' => 'layouts',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'description' => [
				'name' => 'description',
				'label' => 'COM_COMPONENTBUILDER_LAYOUT_DESCRIPTION_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'layouts',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'dynamic_get' => [
				'name' => 'dynamic_get',
				'label' => 'COM_COMPONENTBUILDER_LAYOUT_DYNAMIC_GET_LABEL',
				'type' => 'dynamicget',
				'title' => false,
				'list' => 'layouts',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'snippet' => [
				'name' => 'snippet',
				'label' => 'COM_COMPONENTBUILDER_LAYOUT_SNIPPET_LABEL',
				'type' => 'snippets',
				'title' => false,
				'list' => 'layouts',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_view' => [
				'name' => 'php_view',
				'label' => 'COM_COMPONENTBUILDER_LAYOUT_PHP_VIEW_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'layouts',
				'store' => 'base64',
				'tab_name' => 'Custom Script',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_php_view' => [
				'name' => 'add_php_view',
				'label' => 'COM_COMPONENTBUILDER_LAYOUT_ADD_PHP_VIEW_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'layouts',
				'store' => NULL,
				'tab_name' => 'Custom Script',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'layout' => [
				'name' => 'layout',
				'label' => 'COM_COMPONENTBUILDER_LAYOUT_LAYOUT_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'layouts',
				'store' => 'base64',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'libraries' => [
				'name' => 'libraries',
				'label' => 'COM_COMPONENTBUILDER_LAYOUT_LIBRARIES_LABEL',
				'type' => 'libraries',
				'title' => false,
				'list' => 'layouts',
				'store' => 'json',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'alias' => [
				'name' => 'alias',
				'label' => 'COM_COMPONENTBUILDER_LAYOUT_ALIAS_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'layouts',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'dynamic_get' => [
			'name' => [
				'name' => 'name',
				'label' => 'COM_COMPONENTBUILDER_DYNAMIC_GET_NAME_LABEL',
				'type' => 'text',
				'title' => true,
				'list' => 'dynamic_gets',
				'store' => NULL,
				'tab_name' => 'Main',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'main_source' => [
				'name' => 'main_source',
				'label' => 'COM_COMPONENTBUILDER_DYNAMIC_GET_MAIN_SOURCE_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'dynamic_gets',
				'store' => NULL,
				'tab_name' => 'Main',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'gettype' => [
				'name' => 'gettype',
				'label' => 'COM_COMPONENTBUILDER_DYNAMIC_GET_GETTYPE_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'dynamic_gets',
				'store' => NULL,
				'tab_name' => 'Main',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'php_calculation' => [
				'name' => 'php_calculation',
				'label' => 'COM_COMPONENTBUILDER_DYNAMIC_GET_PHP_CALCULATION_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'dynamic_gets',
				'store' => 'base64',
				'tab_name' => 'Abacus',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_router_parse' => [
				'name' => 'php_router_parse',
				'label' => 'COM_COMPONENTBUILDER_DYNAMIC_GET_PHP_ROUTER_PARSE_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'dynamic_gets',
				'store' => 'base64',
				'tab_name' => 'Custom Script',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_php_after_getitems' => [
				'name' => 'add_php_after_getitems',
				'label' => 'COM_COMPONENTBUILDER_DYNAMIC_GET_ADD_PHP_AFTER_GETITEMS_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'dynamic_gets',
				'store' => NULL,
				'tab_name' => 'Custom Script',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_php_router_parse' => [
				'name' => 'add_php_router_parse',
				'label' => 'COM_COMPONENTBUILDER_DYNAMIC_GET_ADD_PHP_ROUTER_PARSE_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'dynamic_gets',
				'store' => NULL,
				'tab_name' => 'Custom Script',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'view_selection' => [
				'name' => 'view_selection',
				'label' => 'COM_COMPONENTBUILDER_DYNAMIC_GET_VIEW_SELECTION_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'dynamic_gets',
				'store' => NULL,
				'tab_name' => 'Main',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_php_before_getitems' => [
				'name' => 'add_php_before_getitems',
				'label' => 'COM_COMPONENTBUILDER_DYNAMIC_GET_ADD_PHP_BEFORE_GETITEMS_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'dynamic_gets',
				'store' => NULL,
				'tab_name' => 'Custom Script',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_php_before_getitem' => [
				'name' => 'add_php_before_getitem',
				'label' => 'COM_COMPONENTBUILDER_DYNAMIC_GET_ADD_PHP_BEFORE_GETITEM_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'dynamic_gets',
				'store' => NULL,
				'tab_name' => 'Custom Script',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_php_after_getitem' => [
				'name' => 'add_php_after_getitem',
				'label' => 'COM_COMPONENTBUILDER_DYNAMIC_GET_ADD_PHP_AFTER_GETITEM_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'dynamic_gets',
				'store' => NULL,
				'tab_name' => 'Custom Script',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'db_table_main' => [
				'name' => 'db_table_main',
				'label' => 'COM_COMPONENTBUILDER_DYNAMIC_GET_DB_TABLE_MAIN_LABEL',
				'type' => 'dbtables',
				'title' => false,
				'list' => 'dynamic_gets',
				'store' => NULL,
				'tab_name' => 'Main',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_custom_get' => [
				'name' => 'php_custom_get',
				'label' => 'COM_COMPONENTBUILDER_DYNAMIC_GET_PHP_CUSTOM_GET_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'dynamic_gets',
				'store' => 'base64',
				'tab_name' => 'Main',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'plugin_events' => [
				'name' => 'plugin_events',
				'label' => 'COM_COMPONENTBUILDER_DYNAMIC_GET_PLUGIN_EVENTS_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'dynamic_gets',
				'store' => 'json',
				'tab_name' => 'Main',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'db_selection' => [
				'name' => 'db_selection',
				'label' => 'COM_COMPONENTBUILDER_DYNAMIC_GET_DB_SELECTION_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'dynamic_gets',
				'store' => NULL,
				'tab_name' => 'Main',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'view_table_main' => [
				'name' => 'view_table_main',
				'label' => 'COM_COMPONENTBUILDER_DYNAMIC_GET_VIEW_TABLE_MAIN_LABEL',
				'type' => 'adminviews',
				'title' => false,
				'list' => 'dynamic_gets',
				'store' => NULL,
				'tab_name' => 'Main',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_php_getlistquery' => [
				'name' => 'add_php_getlistquery',
				'label' => 'COM_COMPONENTBUILDER_DYNAMIC_GET_ADD_PHP_GETLISTQUERY_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'dynamic_gets',
				'store' => NULL,
				'tab_name' => 'Custom Script',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'join_db_table' => [
				'name' => 'join_db_table',
				'label' => 'COM_COMPONENTBUILDER_DYNAMIC_GET_JOIN_DB_TABLE_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'dynamic_gets',
				'store' => 'json',
				'tab_name' => 'Joint',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'select_all' => [
				'name' => 'select_all',
				'label' => 'COM_COMPONENTBUILDER_DYNAMIC_GET_SELECT_ALL_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'dynamic_gets',
				'store' => NULL,
				'tab_name' => 'Main',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'php_before_getitem' => [
				'name' => 'php_before_getitem',
				'label' => 'COM_COMPONENTBUILDER_DYNAMIC_GET_PHP_BEFORE_GETITEM_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'dynamic_gets',
				'store' => 'base64',
				'tab_name' => 'Custom Script',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'getcustom' => [
				'name' => 'getcustom',
				'label' => 'COM_COMPONENTBUILDER_DYNAMIC_GET_GETCUSTOM_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'dynamic_gets',
				'store' => NULL,
				'tab_name' => 'Main',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'php_after_getitem' => [
				'name' => 'php_after_getitem',
				'label' => 'COM_COMPONENTBUILDER_DYNAMIC_GET_PHP_AFTER_GETITEM_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'dynamic_gets',
				'store' => 'base64',
				'tab_name' => 'Custom Script',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'pagination' => [
				'name' => 'pagination',
				'label' => 'COM_COMPONENTBUILDER_DYNAMIC_GET_PAGINATION_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'dynamic_gets',
				'store' => NULL,
				'tab_name' => 'Main',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '1',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'php_getlistquery' => [
				'name' => 'php_getlistquery',
				'label' => 'COM_COMPONENTBUILDER_DYNAMIC_GET_PHP_GETLISTQUERY_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'dynamic_gets',
				'store' => 'base64',
				'tab_name' => 'Custom Script',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_before_getitems' => [
				'name' => 'php_before_getitems',
				'label' => 'COM_COMPONENTBUILDER_DYNAMIC_GET_PHP_BEFORE_GETITEMS_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'dynamic_gets',
				'store' => 'base64',
				'tab_name' => 'Custom Script',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'filter' => [
				'name' => 'filter',
				'label' => 'COM_COMPONENTBUILDER_DYNAMIC_GET_FILTER_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'dynamic_gets',
				'store' => 'json',
				'tab_name' => 'Tweak',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_after_getitems' => [
				'name' => 'php_after_getitems',
				'label' => 'COM_COMPONENTBUILDER_DYNAMIC_GET_PHP_AFTER_GETITEMS_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'dynamic_gets',
				'store' => 'base64',
				'tab_name' => 'Custom Script',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'where' => [
				'name' => 'where',
				'label' => 'COM_COMPONENTBUILDER_DYNAMIC_GET_WHERE_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'dynamic_gets',
				'store' => 'json',
				'tab_name' => 'Tweak',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'order' => [
				'name' => 'order',
				'label' => 'COM_COMPONENTBUILDER_DYNAMIC_GET_ORDER_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'dynamic_gets',
				'store' => 'json',
				'tab_name' => 'Tweak',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'addcalculation' => [
				'name' => 'addcalculation',
				'label' => 'COM_COMPONENTBUILDER_DYNAMIC_GET_ADDCALCULATION_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'dynamic_gets',
				'store' => NULL,
				'tab_name' => 'Abacus',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'group' => [
				'name' => 'group',
				'label' => 'COM_COMPONENTBUILDER_DYNAMIC_GET_GROUP_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'dynamic_gets',
				'store' => 'json',
				'tab_name' => 'Tweak',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'global' => [
				'name' => 'global',
				'label' => 'COM_COMPONENTBUILDER_DYNAMIC_GET_GLOBAL_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'dynamic_gets',
				'store' => 'json',
				'tab_name' => 'Tweak',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'guid' => [
				'name' => 'guid',
				'label' => 'COM_COMPONENTBUILDER_DYNAMIC_GET_GUID_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'dynamic_gets',
				'store' => NULL,
				'tab_name' => 'publishing',
				'db' => [
					'type' => 'VARCHAR(36)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'join_view_table' => [
				'name' => 'join_view_table',
				'label' => 'COM_COMPONENTBUILDER_DYNAMIC_GET_JOIN_VIEW_TABLE_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'dynamic_gets',
				'store' => 'json',
				'tab_name' => 'Joint',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'custom_code' => [
			'component' => [
				'name' => 'component',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_CODE_COMPONENT_LABEL',
				'type' => 'joomlacomponent',
				'title' => true,
				'list' => 'custom_codes',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'path' => [
				'name' => 'path',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_CODE_PATH_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'custom_codes',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'target' => [
				'name' => 'target',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_CODE_TARGET_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'custom_codes',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'type' => [
				'name' => 'type',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_CODE_TYPE_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'custom_codes',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'comment_type' => [
				'name' => 'comment_type',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_CODE_COMMENT_TYPE_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'custom_codes',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '1',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'joomla_version' => [
				'name' => 'joomla_version',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_CODE_JOOMLA_VERSION_LABEL',
				'type' => 'number',
				'title' => false,
				'list' => 'custom_codes',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'INT(11)',
					'default' => '3',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'function_name' => [
				'name' => 'function_name',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_CODE_FUNCTION_NAME_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'custom_codes',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'system_name' => [
				'name' => 'system_name',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_CODE_SYSTEM_NAME_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'custom_codes',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'code' => [
				'name' => 'code',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_CODE_CODE_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'custom_codes',
				'store' => 'base64',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'hashendtarget' => [
				'name' => 'hashendtarget',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_CODE_HASHENDTARGET_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'custom_codes',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(64)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'to_line' => [
				'name' => 'to_line',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_CODE_TO_LINE_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'custom_codes',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(100)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'from_line' => [
				'name' => 'from_line',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_CODE_FROM_LINE_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'custom_codes',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(100)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'hashtarget' => [
				'name' => 'hashtarget',
				'label' => 'COM_COMPONENTBUILDER_CUSTOM_CODE_HASHTARGET_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'custom_codes',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(64)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'class_property' => [
			'name' => [
				'name' => 'name',
				'label' => 'COM_COMPONENTBUILDER_CLASS_PROPERTY_NAME_LABEL',
				'type' => 'text',
				'title' => true,
				'list' => 'class_properties',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'visibility' => [
				'name' => 'visibility',
				'label' => 'COM_COMPONENTBUILDER_CLASS_PROPERTY_VISIBILITY_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'class_properties',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'extension_type' => [
				'name' => 'extension_type',
				'label' => 'COM_COMPONENTBUILDER_CLASS_PROPERTY_EXTENSION_TYPE_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'class_properties',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(64)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'guid' => [
				'name' => 'guid',
				'label' => 'COM_COMPONENTBUILDER_CLASS_PROPERTY_GUID_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'class_properties',
				'store' => NULL,
				'tab_name' => 'publishing',
				'db' => [
					'type' => 'VARCHAR(36)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'comment' => [
				'name' => 'comment',
				'label' => 'COM_COMPONENTBUILDER_CLASS_PROPERTY_COMMENT_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'class_properties',
				'store' => 'base64',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'joomla_plugin_group' => [
				'name' => 'joomla_plugin_group',
				'label' => 'COM_COMPONENTBUILDER_CLASS_PROPERTY_JOOMLA_PLUGIN_GROUP_LABEL',
				'type' => 'joomlaplugingroups',
				'title' => false,
				'list' => 'class_properties',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'default' => [
				'name' => 'default',
				'label' => 'COM_COMPONENTBUILDER_CLASS_PROPERTY_DEFAULT_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'class_properties',
				'store' => 'base64',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'class_method' => [
			'name' => [
				'name' => 'name',
				'label' => 'COM_COMPONENTBUILDER_CLASS_METHOD_NAME_LABEL',
				'type' => 'text',
				'title' => true,
				'list' => 'class_methods',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'visibility' => [
				'name' => 'visibility',
				'label' => 'COM_COMPONENTBUILDER_CLASS_METHOD_VISIBILITY_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'class_methods',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'extension_type' => [
				'name' => 'extension_type',
				'label' => 'COM_COMPONENTBUILDER_CLASS_METHOD_EXTENSION_TYPE_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'class_methods',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(64)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'guid' => [
				'name' => 'guid',
				'label' => 'COM_COMPONENTBUILDER_CLASS_METHOD_GUID_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'class_methods',
				'store' => NULL,
				'tab_name' => 'publishing',
				'db' => [
					'type' => 'VARCHAR(36)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'code' => [
				'name' => 'code',
				'label' => 'COM_COMPONENTBUILDER_CLASS_METHOD_CODE_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'class_methods',
				'store' => 'base64',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'comment' => [
				'name' => 'comment',
				'label' => 'COM_COMPONENTBUILDER_CLASS_METHOD_COMMENT_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'class_methods',
				'store' => 'base64',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'joomla_plugin_group' => [
				'name' => 'joomla_plugin_group',
				'label' => 'COM_COMPONENTBUILDER_CLASS_METHOD_JOOMLA_PLUGIN_GROUP_LABEL',
				'type' => 'joomlaplugingroups',
				'title' => false,
				'list' => 'class_methods',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'arguments' => [
				'name' => 'arguments',
				'label' => 'COM_COMPONENTBUILDER_CLASS_METHOD_ARGUMENTS_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'class_methods',
				'store' => 'base64',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'placeholder' => [
			'target' => [
				'name' => 'target',
				'label' => 'COM_COMPONENTBUILDER_PLACEHOLDER_TARGET_LABEL',
				'type' => 'text',
				'title' => true,
				'list' => 'placeholders',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'value' => [
				'name' => 'value',
				'label' => 'COM_COMPONENTBUILDER_PLACEHOLDER_VALUE_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'placeholders',
				'store' => 'base64',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'library' => [
			'name' => [
				'name' => 'name',
				'label' => 'COM_COMPONENTBUILDER_LIBRARY_NAME_LABEL',
				'type' => 'text',
				'title' => true,
				'list' => 'libraries',
				'store' => NULL,
				'tab_name' => 'Behaviour',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'target' => [
				'name' => 'target',
				'label' => 'COM_COMPONENTBUILDER_LIBRARY_TARGET_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'libraries',
				'store' => NULL,
				'tab_name' => 'Behaviour',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '1',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'how' => [
				'name' => 'how',
				'label' => 'COM_COMPONENTBUILDER_LIBRARY_HOW_LABEL',
				'type' => 'filebehaviour',
				'title' => false,
				'list' => 'libraries',
				'store' => NULL,
				'tab_name' => 'Behaviour',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '1',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'type' => [
				'name' => 'type',
				'label' => 'COM_COMPONENTBUILDER_LIBRARY_TYPE_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'libraries',
				'store' => NULL,
				'tab_name' => 'Behaviour',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'description' => [
				'name' => 'description',
				'label' => 'COM_COMPONENTBUILDER_LIBRARY_DESCRIPTION_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'libraries',
				'store' => NULL,
				'tab_name' => 'Behaviour',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'libraries' => [
				'name' => 'libraries',
				'label' => 'COM_COMPONENTBUILDER_LIBRARY_LIBRARIES_LABEL',
				'type' => 'librariesx',
				'title' => false,
				'list' => 'libraries',
				'store' => 'json',
				'tab_name' => 'Behaviour',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_setdocument' => [
				'name' => 'php_setdocument',
				'label' => 'COM_COMPONENTBUILDER_LIBRARY_PHP_SETDOCUMENT_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'libraries',
				'store' => 'base64',
				'tab_name' => 'Behaviour',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'addconditions' => [
				'name' => 'addconditions',
				'label' => 'COM_COMPONENTBUILDER_LIBRARY_ADDCONDITIONS_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'libraries',
				'store' => 'json',
				'tab_name' => 'Behaviour',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'guid' => [
				'name' => 'guid',
				'label' => 'COM_COMPONENTBUILDER_LIBRARY_GUID_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'libraries',
				'store' => NULL,
				'tab_name' => 'publishing',
				'db' => [
					'type' => 'VARCHAR(36)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'snippet' => [
			'name' => [
				'name' => 'name',
				'label' => 'COM_COMPONENTBUILDER_SNIPPET_NAME_LABEL',
				'type' => 'text',
				'title' => true,
				'list' => 'snippets',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'url' => [
				'name' => 'url',
				'label' => 'COM_COMPONENTBUILDER_SNIPPET_URL_LABEL',
				'type' => 'url',
				'title' => false,
				'list' => 'snippets',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'type' => [
				'name' => 'type',
				'label' => 'COM_COMPONENTBUILDER_SNIPPET_TYPE_LABEL',
				'type' => 'snippettype',
				'title' => false,
				'list' => 'snippets',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'heading' => [
				'name' => 'heading',
				'label' => 'COM_COMPONENTBUILDER_SNIPPET_HEADING_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'snippets',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'library' => [
				'name' => 'library',
				'label' => 'COM_COMPONENTBUILDER_SNIPPET_LIBRARY_LABEL',
				'type' => 'library',
				'title' => false,
				'list' => 'snippets',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'guid' => [
				'name' => 'guid',
				'label' => 'COM_COMPONENTBUILDER_SNIPPET_GUID_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'snippets',
				'store' => NULL,
				'tab_name' => 'publishing',
				'db' => [
					'type' => 'VARCHAR(36)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'contributor_email' => [
				'name' => 'contributor_email',
				'label' => 'COM_COMPONENTBUILDER_SNIPPET_CONTRIBUTOR_EMAIL_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'snippets',
				'store' => NULL,
				'tab_name' => 'Contributor',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'contributor_name' => [
				'name' => 'contributor_name',
				'label' => 'COM_COMPONENTBUILDER_SNIPPET_CONTRIBUTOR_NAME_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'snippets',
				'store' => NULL,
				'tab_name' => 'Contributor',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'contributor_website' => [
				'name' => 'contributor_website',
				'label' => 'COM_COMPONENTBUILDER_SNIPPET_CONTRIBUTOR_WEBSITE_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'snippets',
				'store' => NULL,
				'tab_name' => 'Contributor',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'contributor_company' => [
				'name' => 'contributor_company',
				'label' => 'COM_COMPONENTBUILDER_SNIPPET_CONTRIBUTOR_COMPANY_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'snippets',
				'store' => NULL,
				'tab_name' => 'Contributor',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'snippet' => [
				'name' => 'snippet',
				'label' => 'COM_COMPONENTBUILDER_SNIPPET_SNIPPET_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'snippets',
				'store' => 'base64',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'usage' => [
				'name' => 'usage',
				'label' => 'COM_COMPONENTBUILDER_SNIPPET_USAGE_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'snippets',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'description' => [
				'name' => 'description',
				'label' => 'COM_COMPONENTBUILDER_SNIPPET_DESCRIPTION_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'snippets',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'validation_rule' => [
			'name' => [
				'name' => 'name',
				'label' => 'COM_COMPONENTBUILDER_VALIDATION_RULE_NAME_LABEL',
				'type' => 'text',
				'title' => true,
				'list' => 'validation_rules',
				'store' => NULL,
				'tab_name' => 'Extends FormRule',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'short_description' => [
				'name' => 'short_description',
				'label' => 'COM_COMPONENTBUILDER_VALIDATION_RULE_SHORT_DESCRIPTION_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'validation_rules',
				'store' => NULL,
				'tab_name' => 'Extends FormRule',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'inherit' => [
				'name' => 'inherit',
				'label' => 'COM_COMPONENTBUILDER_VALIDATION_RULE_INHERIT_LABEL',
				'type' => 'existingvalidationrules',
				'title' => false,
				'list' => 'validation_rules',
				'store' => NULL,
				'tab_name' => 'Extends FormRule',
				'db' => [
					'type' => 'CHAR(64)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php' => [
				'name' => 'php',
				'label' => 'COM_COMPONENTBUILDER_VALIDATION_RULE_PHP_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'validation_rules',
				'store' => 'base64',
				'tab_name' => 'Extends FormRule',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'field' => [
			'name' => [
				'name' => 'name',
				'label' => 'COM_COMPONENTBUILDER_FIELD_NAME_LABEL',
				'type' => 'text',
				'title' => true,
				'list' => 'fields',
				'store' => NULL,
				'tab_name' => 'Set Properties',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'fieldtype' => [
				'name' => 'fieldtype',
				'label' => 'COM_COMPONENTBUILDER_FIELD_FIELDTYPE_LABEL',
				'type' => 'fieldtypes',
				'title' => false,
				'list' => 'fields',
				'store' => NULL,
				'tab_name' => 'Set Properties',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'datatype' => [
				'name' => 'datatype',
				'label' => 'COM_COMPONENTBUILDER_FIELD_DATATYPE_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'fields',
				'store' => NULL,
				'tab_name' => 'Database',
				'db' => [
					'type' => 'CHAR(64)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'indexes' => [
				'name' => 'indexes',
				'label' => 'COM_COMPONENTBUILDER_FIELD_INDEXES_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'fields',
				'store' => NULL,
				'tab_name' => 'Database',
				'db' => [
					'type' => 'CHAR(64)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'null_switch' => [
				'name' => 'null_switch',
				'label' => 'COM_COMPONENTBUILDER_FIELD_NULL_SWITCH_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'fields',
				'store' => NULL,
				'tab_name' => 'Database',
				'db' => [
					'type' => 'CHAR(64)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'store' => [
				'name' => 'store',
				'label' => 'COM_COMPONENTBUILDER_FIELD_STORE_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'fields',
				'store' => NULL,
				'tab_name' => 'Database',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'catid' => [
				'name' => 'catid',
				'label' => 'COM_COMPONENTBUILDER_FIELD_CATID_LABEL',
				'type' => 'category',
				'title' => false,
				'list' => 'fields',
				'store' => NULL,
				'tab_name' => 'Set Properties',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'on_get_model_field' => [
				'name' => 'on_get_model_field',
				'label' => 'COM_COMPONENTBUILDER_FIELD_ON_GET_MODEL_FIELD_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'fields',
				'store' => 'base64',
				'tab_name' => 'Database',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'on_save_model_field' => [
				'name' => 'on_save_model_field',
				'label' => 'COM_COMPONENTBUILDER_FIELD_ON_SAVE_MODEL_FIELD_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'fields',
				'store' => 'base64',
				'tab_name' => 'Database',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'initiator_on_get_model' => [
				'name' => 'initiator_on_get_model',
				'label' => 'COM_COMPONENTBUILDER_FIELD_INITIATOR_ON_GET_MODEL_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'fields',
				'store' => 'base64',
				'tab_name' => 'Database',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'xml' => [
				'name' => 'xml',
				'label' => '',
				'type' => 'hidden',
				'title' => false,
				'list' => 'fields',
				'store' => 'json',
				'tab_name' => 'Type Info',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'datalenght' => [
				'name' => 'datalenght',
				'label' => 'COM_COMPONENTBUILDER_FIELD_DATALENGHT_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'fields',
				'store' => NULL,
				'tab_name' => 'Database',
				'db' => [
					'type' => 'CHAR(64)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'javascript_view_footer' => [
				'name' => 'javascript_view_footer',
				'label' => 'COM_COMPONENTBUILDER_FIELD_JAVASCRIPT_VIEW_FOOTER_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'fields',
				'store' => 'base64',
				'tab_name' => 'Scripts',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'css_views' => [
				'name' => 'css_views',
				'label' => 'COM_COMPONENTBUILDER_FIELD_CSS_VIEWS_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'fields',
				'store' => 'base64',
				'tab_name' => 'Scripts',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'css_view' => [
				'name' => 'css_view',
				'label' => 'COM_COMPONENTBUILDER_FIELD_CSS_VIEW_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'fields',
				'store' => 'base64',
				'tab_name' => 'Scripts',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'datadefault_other' => [
				'name' => 'datadefault_other',
				'label' => 'COM_COMPONENTBUILDER_FIELD_DATADEFAULT_OTHER_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'fields',
				'store' => NULL,
				'tab_name' => 'Database',
				'db' => [
					'type' => 'CHAR(64)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'datadefault' => [
				'name' => 'datadefault',
				'label' => 'COM_COMPONENTBUILDER_FIELD_DATADEFAULT_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'fields',
				'store' => NULL,
				'tab_name' => 'Database',
				'db' => [
					'type' => 'CHAR(64)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'datalenght_other' => [
				'name' => 'datalenght_other',
				'label' => 'COM_COMPONENTBUILDER_FIELD_DATALENGHT_OTHER_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'fields',
				'store' => NULL,
				'tab_name' => 'Database',
				'db' => [
					'type' => 'CHAR(64)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'javascript_views_footer' => [
				'name' => 'javascript_views_footer',
				'label' => 'COM_COMPONENTBUILDER_FIELD_JAVASCRIPT_VIEWS_FOOTER_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'fields',
				'store' => 'base64',
				'tab_name' => 'Scripts',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'add_css_view' => [
				'name' => 'add_css_view',
				'label' => 'COM_COMPONENTBUILDER_FIELD_ADD_CSS_VIEW_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'fields',
				'store' => NULL,
				'tab_name' => 'Scripts',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_css_views' => [
				'name' => 'add_css_views',
				'label' => 'COM_COMPONENTBUILDER_FIELD_ADD_CSS_VIEWS_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'fields',
				'store' => NULL,
				'tab_name' => 'Scripts',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_javascript_view_footer' => [
				'name' => 'add_javascript_view_footer',
				'label' => 'COM_COMPONENTBUILDER_FIELD_ADD_JAVASCRIPT_VIEW_FOOTER_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'fields',
				'store' => NULL,
				'tab_name' => 'Scripts',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'add_javascript_views_footer' => [
				'name' => 'add_javascript_views_footer',
				'label' => 'COM_COMPONENTBUILDER_FIELD_ADD_JAVASCRIPT_VIEWS_FOOTER_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'fields',
				'store' => NULL,
				'tab_name' => 'Scripts',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'initiator_on_save_model' => [
				'name' => 'initiator_on_save_model',
				'label' => 'COM_COMPONENTBUILDER_FIELD_INITIATOR_ON_SAVE_MODEL_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'fields',
				'store' => 'base64',
				'tab_name' => 'Database',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'guid' => [
				'name' => 'guid',
				'label' => 'COM_COMPONENTBUILDER_FIELD_GUID_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'fields',
				'store' => NULL,
				'tab_name' => 'publishing',
				'db' => [
					'type' => 'VARCHAR(36)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'fieldtype' => [
			'name' => [
				'name' => 'name',
				'label' => 'COM_COMPONENTBUILDER_FIELDTYPE_NAME_LABEL',
				'type' => 'text',
				'title' => true,
				'list' => 'fieldtypes',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'store' => [
				'name' => 'store',
				'label' => 'COM_COMPONENTBUILDER_FIELDTYPE_STORE_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'fieldtypes',
				'store' => NULL,
				'tab_name' => 'Database (defaults)',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'null_switch' => [
				'name' => 'null_switch',
				'label' => 'COM_COMPONENTBUILDER_FIELDTYPE_NULL_SWITCH_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'fieldtypes',
				'store' => NULL,
				'tab_name' => 'Database (defaults)',
				'db' => [
					'type' => 'CHAR(64)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'indexes' => [
				'name' => 'indexes',
				'label' => 'COM_COMPONENTBUILDER_FIELDTYPE_INDEXES_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'fieldtypes',
				'store' => NULL,
				'tab_name' => 'Database (defaults)',
				'db' => [
					'type' => 'CHAR(64)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'datadefault_other' => [
				'name' => 'datadefault_other',
				'label' => 'COM_COMPONENTBUILDER_FIELDTYPE_DATADEFAULT_OTHER_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'fieldtypes',
				'store' => NULL,
				'tab_name' => 'Database (defaults)',
				'db' => [
					'type' => 'CHAR(64)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'datadefault' => [
				'name' => 'datadefault',
				'label' => 'COM_COMPONENTBUILDER_FIELDTYPE_DATADEFAULT_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'fieldtypes',
				'store' => NULL,
				'tab_name' => 'Database (defaults)',
				'db' => [
					'type' => 'CHAR(64)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'short_description' => [
				'name' => 'short_description',
				'label' => 'COM_COMPONENTBUILDER_FIELDTYPE_SHORT_DESCRIPTION_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'fieldtypes',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'datatype' => [
				'name' => 'datatype',
				'label' => 'COM_COMPONENTBUILDER_FIELDTYPE_DATATYPE_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'fieldtypes',
				'store' => NULL,
				'tab_name' => 'Database (defaults)',
				'db' => [
					'type' => 'CHAR(64)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'has_defaults' => [
				'name' => 'has_defaults',
				'label' => 'COM_COMPONENTBUILDER_FIELDTYPE_HAS_DEFAULTS_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'fieldtypes',
				'store' => NULL,
				'tab_name' => 'Database (defaults)',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'properties' => [
				'name' => 'properties',
				'label' => 'COM_COMPONENTBUILDER_FIELDTYPE_PROPERTIES_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'fieldtypes',
				'store' => 'json',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'description' => [
				'name' => 'description',
				'label' => 'COM_COMPONENTBUILDER_FIELDTYPE_DESCRIPTION_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'fieldtypes',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'datalenght' => [
				'name' => 'datalenght',
				'label' => 'COM_COMPONENTBUILDER_FIELDTYPE_DATALENGHT_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'fieldtypes',
				'store' => NULL,
				'tab_name' => 'Database (defaults)',
				'db' => [
					'type' => 'CHAR(64)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'datalenght_other' => [
				'name' => 'datalenght_other',
				'label' => 'COM_COMPONENTBUILDER_FIELDTYPE_DATALENGHT_OTHER_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'fieldtypes',
				'store' => NULL,
				'tab_name' => 'Database (defaults)',
				'db' => [
					'type' => 'CHAR(64)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'guid' => [
				'name' => 'guid',
				'label' => 'COM_COMPONENTBUILDER_FIELDTYPE_GUID_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'fieldtypes',
				'store' => NULL,
				'tab_name' => 'publishing',
				'db' => [
					'type' => 'VARCHAR(36)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'catid' => [
				'name' => 'catid',
				'label' => 'COM_COMPONENTBUILDER_FIELDTYPE_CATID_LABEL',
				'type' => 'category',
				'title' => false,
				'list' => 'fieldtypes',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'language_translation' => [
			'source' => [
				'name' => 'source',
				'label' => 'COM_COMPONENTBUILDER_LANGUAGE_TRANSLATION_SOURCE_LABEL',
				'type' => 'textarea',
				'title' => true,
				'list' => 'language_translations',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'plugins' => [
				'name' => 'plugins',
				'label' => 'COM_COMPONENTBUILDER_LANGUAGE_TRANSLATION_PLUGINS_LABEL',
				'type' => 'joomlaplugins',
				'title' => false,
				'list' => 'language_translations',
				'store' => 'json',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'modules' => [
				'name' => 'modules',
				'label' => 'COM_COMPONENTBUILDER_LANGUAGE_TRANSLATION_MODULES_LABEL',
				'type' => 'joomlamodules',
				'title' => false,
				'list' => 'language_translations',
				'store' => 'json',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'components' => [
				'name' => 'components',
				'label' => 'COM_COMPONENTBUILDER_LANGUAGE_TRANSLATION_COMPONENTS_LABEL',
				'type' => 'joomlacomponents',
				'title' => false,
				'list' => 'language_translations',
				'store' => 'json',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'translation' => [
				'name' => 'translation',
				'label' => 'COM_COMPONENTBUILDER_LANGUAGE_TRANSLATION_TRANSLATION_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'language_translations',
				'store' => 'json',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'language' => [
			'name' => [
				'name' => 'name',
				'label' => 'COM_COMPONENTBUILDER_LANGUAGE_NAME_LABEL',
				'type' => 'text',
				'title' => true,
				'list' => 'languages',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'langtag' => [
				'name' => 'langtag',
				'label' => 'COM_COMPONENTBUILDER_LANGUAGE_LANGTAG_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'languages',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(64)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'server' => [
			'name' => [
				'name' => 'name',
				'label' => 'COM_COMPONENTBUILDER_SERVER_NAME_LABEL',
				'type' => 'text',
				'title' => true,
				'list' => 'servers',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'protocol' => [
				'name' => 'protocol',
				'label' => 'COM_COMPONENTBUILDER_SERVER_PROTOCOL_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'servers',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'signature' => [
				'name' => 'signature',
				'label' => 'COM_COMPONENTBUILDER_SERVER_SIGNATURE_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'servers',
				'store' => 'basic_encryption',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'private_key' => [
				'name' => 'private_key',
				'label' => 'COM_COMPONENTBUILDER_SERVER_PRIVATE_KEY_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'servers',
				'store' => 'basic_encryption',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'secret' => [
				'name' => 'secret',
				'label' => 'COM_COMPONENTBUILDER_SERVER_SECRET_LABEL',
				'type' => 'password',
				'title' => false,
				'list' => 'servers',
				'store' => 'basic_encryption',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'password' => [
				'name' => 'password',
				'label' => 'COM_COMPONENTBUILDER_SERVER_PASSWORD_LABEL',
				'type' => 'password',
				'title' => false,
				'list' => 'servers',
				'store' => 'basic_encryption',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'private' => [
				'name' => 'private',
				'label' => 'COM_COMPONENTBUILDER_SERVER_PRIVATE_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'servers',
				'store' => 'basic_encryption',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'authentication' => [
				'name' => 'authentication',
				'label' => 'COM_COMPONENTBUILDER_SERVER_AUTHENTICATION_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'servers',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'path' => [
				'name' => 'path',
				'label' => 'COM_COMPONENTBUILDER_SERVER_PATH_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'servers',
				'store' => 'basic_encryption',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'port' => [
				'name' => 'port',
				'label' => 'COM_COMPONENTBUILDER_SERVER_PORT_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'servers',
				'store' => 'basic_encryption',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'host' => [
				'name' => 'host',
				'label' => 'COM_COMPONENTBUILDER_SERVER_HOST_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'servers',
				'store' => 'basic_encryption',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'username' => [
				'name' => 'username',
				'label' => 'COM_COMPONENTBUILDER_SERVER_USERNAME_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'servers',
				'store' => 'basic_encryption',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'repository' => [
			'system_name' => [
				'name' => 'system_name',
				'label' => 'COM_COMPONENTBUILDER_REPOSITORY_SYSTEM_NAME_LABEL',
				'type' => 'text',
				'title' => true,
				'list' => 'repositories',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'organisation' => [
				'name' => 'organisation',
				'label' => 'COM_COMPONENTBUILDER_REPOSITORY_ORGANISATION_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'repositories',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'repository' => [
				'name' => 'repository',
				'label' => 'COM_COMPONENTBUILDER_REPOSITORY_REPOSITORY_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'repositories',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'target' => [
				'name' => 'target',
				'label' => 'COM_COMPONENTBUILDER_REPOSITORY_TARGET_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'repositories',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TINYINT(7)',
					'default' => '1',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'type' => [
				'name' => 'type',
				'label' => 'COM_COMPONENTBUILDER_REPOSITORY_TYPE_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'repositories',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '1',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'base' => [
				'name' => 'base',
				'label' => 'COM_COMPONENTBUILDER_REPOSITORY_BASE_LABEL',
				'type' => 'url',
				'title' => false,
				'list' => 'repositories',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'guid' => [
				'name' => 'guid',
				'label' => 'COM_COMPONENTBUILDER_REPOSITORY_GUID_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'repositories',
				'store' => NULL,
				'tab_name' => 'publishing',
				'db' => [
					'type' => 'VARCHAR(36)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'addplaceholders' => [
				'name' => 'addplaceholders',
				'label' => 'COM_COMPONENTBUILDER_REPOSITORY_ADDPLACEHOLDERS_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'repositories',
				'store' => 'json',
				'tab_name' => 'Placeholders',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access_repo' => [
				'name' => 'access_repo',
				'label' => 'COM_COMPONENTBUILDER_REPOSITORY_ACCESS_REPO_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'repositories',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'write_branch' => [
				'name' => 'write_branch',
				'label' => 'COM_COMPONENTBUILDER_REPOSITORY_WRITE_BRANCH_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'repositories',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'read_branch' => [
				'name' => 'read_branch',
				'label' => 'COM_COMPONENTBUILDER_REPOSITORY_READ_BRANCH_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'repositories',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'token' => [
				'name' => 'token',
				'label' => 'COM_COMPONENTBUILDER_REPOSITORY_TOKEN_LABEL',
				'type' => 'password',
				'title' => false,
				'list' => 'repositories',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'username' => [
				'name' => 'username',
				'label' => 'COM_COMPONENTBUILDER_REPOSITORY_USERNAME_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'repositories',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'help_document' => [
			'title' => [
				'name' => 'title',
				'label' => 'COM_COMPONENTBUILDER_HELP_DOCUMENT_TITLE_LABEL',
				'type' => 'text',
				'title' => true,
				'list' => 'help_documents',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'CHAR(64)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'type' => [
				'name' => 'type',
				'label' => 'COM_COMPONENTBUILDER_HELP_DOCUMENT_TYPE_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'help_documents',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'groups' => [
				'name' => 'groups',
				'label' => 'COM_COMPONENTBUILDER_HELP_DOCUMENT_GROUPS_LABEL',
				'type' => 'usergrouplist',
				'title' => false,
				'list' => 'help_documents',
				'store' => 'json',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'location' => [
				'name' => 'location',
				'label' => 'COM_COMPONENTBUILDER_HELP_DOCUMENT_LOCATION_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'help_documents',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'admin_view' => [
				'name' => 'admin_view',
				'label' => 'COM_COMPONENTBUILDER_HELP_DOCUMENT_ADMIN_VIEW_LABEL',
				'type' => 'adminviewfolderlist',
				'title' => false,
				'list' => 'help_documents',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'CHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'site_view' => [
				'name' => 'site_view',
				'label' => 'COM_COMPONENTBUILDER_HELP_DOCUMENT_SITE_VIEW_LABEL',
				'type' => 'siteviewfolderlist',
				'title' => false,
				'list' => 'help_documents',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'CHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'alias' => [
				'name' => 'alias',
				'label' => 'COM_COMPONENTBUILDER_HELP_DOCUMENT_ALIAS_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'help_documents',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'CHAR(64)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'content' => [
				'name' => 'content',
				'label' => 'COM_COMPONENTBUILDER_HELP_DOCUMENT_CONTENT_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'help_documents',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'article' => [
				'name' => 'article',
				'label' => 'COM_COMPONENTBUILDER_HELP_DOCUMENT_ARTICLE_LABEL',
				'type' => 'articles',
				'title' => false,
				'list' => 'help_documents',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'url' => [
				'name' => 'url',
				'label' => 'COM_COMPONENTBUILDER_HELP_DOCUMENT_URL_LABEL',
				'type' => 'url',
				'title' => false,
				'list' => 'help_documents',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'target' => [
				'name' => 'target',
				'label' => 'COM_COMPONENTBUILDER_HELP_DOCUMENT_TARGET_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'help_documents',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
		],
		'admin_fields' => [
			'admin_view' => [
				'name' => 'admin_view',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_FIELDS_ADMIN_VIEW_LABEL',
				'type' => 'adminviewsreadonly',
				'title' => true,
				'list' => 'admins_fields',
				'store' => NULL,
				'tab_name' => 'Fields',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'addfields' => [
				'name' => 'addfields',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_FIELDS_ADDFIELDS_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'admins_fields',
				'store' => 'json',
				'tab_name' => 'Fields',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'admin_fields_conditions' => [
			'admin_view' => [
				'name' => 'admin_view',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_FIELDS_CONDITIONS_ADMIN_VIEW_LABEL',
				'type' => 'adminviewsreadonly',
				'title' => true,
				'list' => 'admins_fields_conditions',
				'store' => NULL,
				'tab_name' => 'Conditions',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'addconditions' => [
				'name' => 'addconditions',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_FIELDS_CONDITIONS_ADDCONDITIONS_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'admins_fields_conditions',
				'store' => 'json',
				'tab_name' => 'Conditions',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'admin_fields_relations' => [
			'admin_view' => [
				'name' => 'admin_view',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_FIELDS_RELATIONS_ADMIN_VIEW_LABEL',
				'type' => 'adminviewsreadonly',
				'title' => true,
				'list' => 'admins_fields_relations',
				'store' => NULL,
				'tab_name' => 'Relations',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'addrelations' => [
				'name' => 'addrelations',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_FIELDS_RELATIONS_ADDRELATIONS_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'admins_fields_relations',
				'store' => 'json',
				'tab_name' => 'Relations',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'admin_custom_tabs' => [
			'admin_view' => [
				'name' => 'admin_view',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_CUSTOM_TABS_ADMIN_VIEW_LABEL',
				'type' => 'adminviewsreadonly',
				'title' => true,
				'list' => 'admins_custom_tabs',
				'store' => NULL,
				'tab_name' => 'Tabs',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'tabs' => [
				'name' => 'tabs',
				'label' => 'COM_COMPONENTBUILDER_ADMIN_CUSTOM_TABS_TABS_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'admins_custom_tabs',
				'store' => 'json',
				'tab_name' => 'Tabs',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'component_admin_views' => [
			'joomla_component' => [
				'name' => 'joomla_component',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_ADMIN_VIEWS_JOOMLA_COMPONENT_LABEL',
				'type' => 'joomlacomponents',
				'title' => true,
				'list' => 'components_admin_views',
				'store' => NULL,
				'tab_name' => 'Views',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'addadmin_views' => [
				'name' => 'addadmin_views',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_ADMIN_VIEWS_ADDADMIN_VIEWS_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'components_admin_views',
				'store' => 'json',
				'tab_name' => 'Views',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'component_site_views' => [
			'joomla_component' => [
				'name' => 'joomla_component',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_SITE_VIEWS_JOOMLA_COMPONENT_LABEL',
				'type' => 'joomlacomponents',
				'title' => true,
				'list' => 'components_site_views',
				'store' => NULL,
				'tab_name' => 'Views',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'addsite_views' => [
				'name' => 'addsite_views',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_SITE_VIEWS_ADDSITE_VIEWS_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'components_site_views',
				'store' => 'json',
				'tab_name' => 'Views',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'component_custom_admin_views' => [
			'joomla_component' => [
				'name' => 'joomla_component',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_CUSTOM_ADMIN_VIEWS_JOOMLA_COMPONENT_LABEL',
				'type' => 'joomlacomponents',
				'title' => true,
				'list' => 'components_custom_admin_views',
				'store' => NULL,
				'tab_name' => 'Views',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'addcustom_admin_views' => [
				'name' => 'addcustom_admin_views',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_CUSTOM_ADMIN_VIEWS_ADDCUSTOM_ADMIN_VIEWS_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'components_custom_admin_views',
				'store' => 'json',
				'tab_name' => 'Views',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'component_updates' => [
			'joomla_component' => [
				'name' => 'joomla_component',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_UPDATES_JOOMLA_COMPONENT_LABEL',
				'type' => 'joomlacomponents',
				'title' => true,
				'list' => 'components_updates',
				'store' => NULL,
				'tab_name' => 'Updates',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'version_update' => [
				'name' => 'version_update',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_UPDATES_VERSION_UPDATE_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'components_updates',
				'store' => 'json',
				'tab_name' => 'Updates',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'component_mysql_tweaks' => [
			'joomla_component' => [
				'name' => 'joomla_component',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_MYSQL_TWEAKS_JOOMLA_COMPONENT_LABEL',
				'type' => 'joomlacomponents',
				'title' => true,
				'list' => 'components_mysql_tweaks',
				'store' => NULL,
				'tab_name' => 'Mysql Tweaks',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'sql_tweak' => [
				'name' => 'sql_tweak',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_MYSQL_TWEAKS_SQL_TWEAK_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'components_mysql_tweaks',
				'store' => 'json',
				'tab_name' => 'Mysql Tweaks',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'component_custom_admin_menus' => [
			'joomla_component' => [
				'name' => 'joomla_component',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_CUSTOM_ADMIN_MENUS_JOOMLA_COMPONENT_LABEL',
				'type' => 'joomlacomponents',
				'title' => true,
				'list' => 'components_custom_admin_menus',
				'store' => NULL,
				'tab_name' => 'Menus',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'addcustommenus' => [
				'name' => 'addcustommenus',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_CUSTOM_ADMIN_MENUS_ADDCUSTOMMENUS_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'components_custom_admin_menus',
				'store' => 'json',
				'tab_name' => 'Menus',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'component_router' => [
			'joomla_component' => [
				'name' => 'joomla_component',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_ROUTER_JOOMLA_COMPONENT_LABEL',
				'type' => 'joomlacomponents',
				'title' => true,
				'list' => 'components_routers',
				'store' => NULL,
				'tab_name' => 'Settings',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'mode_constructor_before_parent' => [
				'name' => 'mode_constructor_before_parent',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_ROUTER_MODE_CONSTRUCTOR_BEFORE_PARENT_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'components_routers',
				'store' => NULL,
				'tab_name' => 'Settings',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'mode_constructor_after_parent' => [
				'name' => 'mode_constructor_after_parent',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_ROUTER_MODE_CONSTRUCTOR_AFTER_PARENT_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'components_routers',
				'store' => NULL,
				'tab_name' => 'Settings',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'mode_methods' => [
				'name' => 'mode_methods',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_ROUTER_MODE_METHODS_LABEL',
				'type' => 'radio',
				'title' => false,
				'list' => 'components_routers',
				'store' => NULL,
				'tab_name' => 'Settings',
				'db' => [
					'type' => 'TINYINT(1)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'methods_code' => [
				'name' => 'methods_code',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_ROUTER_METHODS_CODE_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'components_routers',
				'store' => 'base64',
				'tab_name' => 'Settings',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'constructor_after_parent_code' => [
				'name' => 'constructor_after_parent_code',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_ROUTER_CONSTRUCTOR_AFTER_PARENT_CODE_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'components_routers',
				'store' => 'base64',
				'tab_name' => 'Settings',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'constructor_before_parent_manual' => [
				'name' => 'constructor_before_parent_manual',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_ROUTER_CONSTRUCTOR_BEFORE_PARENT_MANUAL_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'components_routers',
				'store' => 'json',
				'tab_name' => 'Settings',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'constructor_before_parent_code' => [
				'name' => 'constructor_before_parent_code',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_ROUTER_CONSTRUCTOR_BEFORE_PARENT_CODE_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'components_routers',
				'store' => 'base64',
				'tab_name' => 'Settings',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'component_config' => [
			'joomla_component' => [
				'name' => 'joomla_component',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_CONFIG_JOOMLA_COMPONENT_LABEL',
				'type' => 'joomlacomponents',
				'title' => true,
				'list' => 'components_config',
				'store' => NULL,
				'tab_name' => 'Options',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'addconfig' => [
				'name' => 'addconfig',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_CONFIG_ADDCONFIG_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'components_config',
				'store' => 'json',
				'tab_name' => 'Options',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'component_dashboard' => [
			'joomla_component' => [
				'name' => 'joomla_component',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_DASHBOARD_JOOMLA_COMPONENT_LABEL',
				'type' => 'joomlacomponents',
				'title' => true,
				'list' => 'components_dashboard',
				'store' => NULL,
				'tab_name' => 'Dashboard',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'dashboard_tab' => [
				'name' => 'dashboard_tab',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_DASHBOARD_DASHBOARD_TAB_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'components_dashboard',
				'store' => 'json',
				'tab_name' => 'Dashboard',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'php_dashboard_methods' => [
				'name' => 'php_dashboard_methods',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_DASHBOARD_PHP_DASHBOARD_METHODS_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'components_dashboard',
				'store' => 'base64',
				'tab_name' => 'Dashboard',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'component_files_folders' => [
			'joomla_component' => [
				'name' => 'joomla_component',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_FILES_FOLDERS_JOOMLA_COMPONENT_LABEL',
				'type' => 'joomlacomponents',
				'title' => true,
				'list' => 'components_files_folders',
				'store' => NULL,
				'tab_name' => 'Basic',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'addfoldersfullpath' => [
				'name' => 'addfoldersfullpath',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_FILES_FOLDERS_ADDFOLDERSFULLPATH_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'components_files_folders',
				'store' => 'json',
				'tab_name' => 'Advance',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'addfilesfullpath' => [
				'name' => 'addfilesfullpath',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_FILES_FOLDERS_ADDFILESFULLPATH_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'components_files_folders',
				'store' => 'json',
				'tab_name' => 'Advance',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'addfolders' => [
				'name' => 'addfolders',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_FILES_FOLDERS_ADDFOLDERS_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'components_files_folders',
				'store' => 'json',
				'tab_name' => 'Basic',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'addfiles' => [
				'name' => 'addfiles',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_FILES_FOLDERS_ADDFILES_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'components_files_folders',
				'store' => 'json',
				'tab_name' => 'Basic',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'component_placeholders' => [
			'joomla_component' => [
				'name' => 'joomla_component',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_PLACEHOLDERS_JOOMLA_COMPONENT_LABEL',
				'type' => 'joomlacomponents',
				'title' => true,
				'list' => 'components_placeholders',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'addplaceholders' => [
				'name' => 'addplaceholders',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_PLACEHOLDERS_ADDPLACEHOLDERS_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'components_placeholders',
				'store' => 'json',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'component_plugins' => [
			'joomla_component' => [
				'name' => 'joomla_component',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_PLUGINS_JOOMLA_COMPONENT_LABEL',
				'type' => 'joomlacomponents',
				'title' => true,
				'list' => 'components_plugins',
				'store' => NULL,
				'tab_name' => 'Plugins',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'addjoomla_plugins' => [
				'name' => 'addjoomla_plugins',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_PLUGINS_ADDJOOMLA_PLUGINS_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'components_plugins',
				'store' => 'json',
				'tab_name' => 'Plugins',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'component_modules' => [
			'joomla_component' => [
				'name' => 'joomla_component',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_MODULES_JOOMLA_COMPONENT_LABEL',
				'type' => 'joomlacomponents',
				'title' => true,
				'list' => 'components_modules',
				'store' => NULL,
				'tab_name' => 'Modules',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'addjoomla_modules' => [
				'name' => 'addjoomla_modules',
				'label' => 'COM_COMPONENTBUILDER_COMPONENT_MODULES_ADDJOOMLA_MODULES_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'components_modules',
				'store' => 'json',
				'tab_name' => 'Modules',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'snippet_type' => [
			'name' => [
				'name' => 'name',
				'label' => 'COM_COMPONENTBUILDER_SNIPPET_TYPE_NAME_LABEL',
				'type' => 'text',
				'title' => true,
				'list' => 'snippet_types',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'description' => [
				'name' => 'description',
				'label' => 'COM_COMPONENTBUILDER_SNIPPET_TYPE_DESCRIPTION_LABEL',
				'type' => 'text',
				'title' => false,
				'list' => 'snippet_types',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'library_config' => [
			'library' => [
				'name' => 'library',
				'label' => 'COM_COMPONENTBUILDER_LIBRARY_CONFIG_LIBRARY_LABEL',
				'type' => 'libraryreadonly',
				'title' => true,
				'list' => 'libraries_config',
				'store' => NULL,
				'tab_name' => 'Tweaks',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'addconfig' => [
				'name' => 'addconfig',
				'label' => 'COM_COMPONENTBUILDER_LIBRARY_CONFIG_ADDCONFIG_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'libraries_config',
				'store' => 'json',
				'tab_name' => 'Tweaks',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'library_files_folders_urls' => [
			'library' => [
				'name' => 'library',
				'label' => 'COM_COMPONENTBUILDER_LIBRARY_FILES_FOLDERS_URLS_LIBRARY_LABEL',
				'type' => 'libraryreadonly',
				'title' => true,
				'list' => 'libraries_files_folders_urls',
				'store' => NULL,
				'tab_name' => 'Basic',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'addfoldersfullpath' => [
				'name' => 'addfoldersfullpath',
				'label' => 'COM_COMPONENTBUILDER_LIBRARY_FILES_FOLDERS_URLS_ADDFOLDERSFULLPATH_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'libraries_files_folders_urls',
				'store' => 'json',
				'tab_name' => 'Advance',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'addfilesfullpath' => [
				'name' => 'addfilesfullpath',
				'label' => 'COM_COMPONENTBUILDER_LIBRARY_FILES_FOLDERS_URLS_ADDFILESFULLPATH_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'libraries_files_folders_urls',
				'store' => 'json',
				'tab_name' => 'Advance',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'addfolders' => [
				'name' => 'addfolders',
				'label' => 'COM_COMPONENTBUILDER_LIBRARY_FILES_FOLDERS_URLS_ADDFOLDERS_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'libraries_files_folders_urls',
				'store' => 'json',
				'tab_name' => 'Basic',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'addfiles' => [
				'name' => 'addfiles',
				'label' => 'COM_COMPONENTBUILDER_LIBRARY_FILES_FOLDERS_URLS_ADDFILES_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'libraries_files_folders_urls',
				'store' => 'json',
				'tab_name' => 'Basic',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'addurls' => [
				'name' => 'addurls',
				'label' => 'COM_COMPONENTBUILDER_LIBRARY_FILES_FOLDERS_URLS_ADDURLS_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'libraries_files_folders_urls',
				'store' => 'json',
				'tab_name' => 'Basic',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'class_extends' => [
			'name' => [
				'name' => 'name',
				'label' => 'COM_COMPONENTBUILDER_CLASS_EXTENDS_NAME_LABEL',
				'type' => 'text',
				'title' => true,
				'list' => 'class_extendings',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'extension_type' => [
				'name' => 'extension_type',
				'label' => 'COM_COMPONENTBUILDER_CLASS_EXTENDS_EXTENSION_TYPE_LABEL',
				'type' => 'list',
				'title' => false,
				'list' => 'class_extendings',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(64)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'head' => [
				'name' => 'head',
				'label' => 'COM_COMPONENTBUILDER_CLASS_EXTENDS_HEAD_LABEL',
				'type' => 'editor',
				'title' => false,
				'list' => 'class_extendings',
				'store' => 'base64',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'comment' => [
				'name' => 'comment',
				'label' => 'COM_COMPONENTBUILDER_CLASS_EXTENDS_COMMENT_LABEL',
				'type' => 'textarea',
				'title' => false,
				'list' => 'class_extendings',
				'store' => 'base64',
				'tab_name' => 'Details',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'joomla_module_updates' => [
			'joomla_module' => [
				'name' => 'joomla_module',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_UPDATES_JOOMLA_MODULE_LABEL',
				'type' => 'joomlamodules',
				'title' => true,
				'list' => 'joomla_modules_updates',
				'store' => NULL,
				'tab_name' => 'Updates',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'version_update' => [
				'name' => 'version_update',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_UPDATES_VERSION_UPDATE_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'joomla_modules_updates',
				'store' => 'json',
				'tab_name' => 'Updates',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'joomla_module_files_folders_urls' => [
			'joomla_module' => [
				'name' => 'joomla_module',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_FILES_FOLDERS_URLS_JOOMLA_MODULE_LABEL',
				'type' => 'joomlamodules',
				'title' => true,
				'list' => 'joomla_modules_files_folders_urls',
				'store' => NULL,
				'tab_name' => 'Basic',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'addfoldersfullpath' => [
				'name' => 'addfoldersfullpath',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_FILES_FOLDERS_URLS_ADDFOLDERSFULLPATH_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'joomla_modules_files_folders_urls',
				'store' => 'json',
				'tab_name' => 'Advance',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'addfilesfullpath' => [
				'name' => 'addfilesfullpath',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_FILES_FOLDERS_URLS_ADDFILESFULLPATH_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'joomla_modules_files_folders_urls',
				'store' => 'json',
				'tab_name' => 'Advance',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'addfolders' => [
				'name' => 'addfolders',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_FILES_FOLDERS_URLS_ADDFOLDERS_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'joomla_modules_files_folders_urls',
				'store' => 'json',
				'tab_name' => 'Basic',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'addfiles' => [
				'name' => 'addfiles',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_FILES_FOLDERS_URLS_ADDFILES_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'joomla_modules_files_folders_urls',
				'store' => 'json',
				'tab_name' => 'Basic',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'addurls' => [
				'name' => 'addurls',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_MODULE_FILES_FOLDERS_URLS_ADDURLS_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'joomla_modules_files_folders_urls',
				'store' => 'json',
				'tab_name' => 'Basic',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'joomla_plugin_group' => [
			'name' => [
				'name' => 'name',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_GROUP_NAME_LABEL',
				'type' => 'text',
				'title' => true,
				'list' => 'joomla_plugin_groups',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'VARCHAR(255)',
					'default' => '',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'class_extends' => [
				'name' => 'class_extends',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_GROUP_CLASS_EXTENDS_LABEL',
				'type' => 'classextends',
				'title' => false,
				'list' => 'joomla_plugin_groups',
				'store' => NULL,
				'tab_name' => 'Details',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'joomla_plugin_updates' => [
			'joomla_plugin' => [
				'name' => 'joomla_plugin',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_UPDATES_JOOMLA_PLUGIN_LABEL',
				'type' => 'joomlaplugins',
				'title' => true,
				'list' => 'joomla_plugins_updates',
				'store' => NULL,
				'tab_name' => 'Updates',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'version_update' => [
				'name' => 'version_update',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_UPDATES_VERSION_UPDATE_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'joomla_plugins_updates',
				'store' => 'json',
				'tab_name' => 'Updates',
				'db' => [
					'type' => 'MEDIUMTEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
		'joomla_plugin_files_folders_urls' => [
			'joomla_plugin' => [
				'name' => 'joomla_plugin',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_FILES_FOLDERS_URLS_JOOMLA_PLUGIN_LABEL',
				'type' => 'joomlaplugins',
				'title' => true,
				'list' => 'joomla_plugins_files_folders_urls',
				'store' => NULL,
				'tab_name' => 'Basic',
				'db' => [
					'type' => 'INT(11)',
					'default' => '0',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => true,
				],
			],
			'addfoldersfullpath' => [
				'name' => 'addfoldersfullpath',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_FILES_FOLDERS_URLS_ADDFOLDERSFULLPATH_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'joomla_plugins_files_folders_urls',
				'store' => 'json',
				'tab_name' => 'Advance',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'addfilesfullpath' => [
				'name' => 'addfilesfullpath',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_FILES_FOLDERS_URLS_ADDFILESFULLPATH_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'joomla_plugins_files_folders_urls',
				'store' => 'json',
				'tab_name' => 'Advance',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'addfolders' => [
				'name' => 'addfolders',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_FILES_FOLDERS_URLS_ADDFOLDERS_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'joomla_plugins_files_folders_urls',
				'store' => 'json',
				'tab_name' => 'Basic',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'addfiles' => [
				'name' => 'addfiles',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_FILES_FOLDERS_URLS_ADDFILES_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'joomla_plugins_files_folders_urls',
				'store' => 'json',
				'tab_name' => 'Basic',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'addurls' => [
				'name' => 'addurls',
				'label' => 'COM_COMPONENTBUILDER_JOOMLA_PLUGIN_FILES_FOLDERS_URLS_ADDURLS_LABEL',
				'type' => 'subform',
				'title' => false,
				'list' => 'joomla_plugins_files_folders_urls',
				'store' => 'json',
				'tab_name' => 'Basic',
				'db' => [
					'type' => 'TEXT',
					'default' => 'EMPTY',
					'null_switch' => 'NOT NULL',
					'unique_key' => false,
					'key' => false,
				],
			],
			'access' => [
				'name' => 'access',
				'label' => 'Access',
				'type' => 'accesslevel',
				'title' => false,
				'store' => NULL,
				'tab_name' => NULL,
				'db' => [
					'type' => 'INT(10) unsigned',
					'default' => '0',
					'key' => true,
					'null_switch' => 'NULL',
				],
			],
		],
	];
}

