 @since   1.3.0
	 */
	public function stream_seek($offset, $whence)
	{
		// $whence: SEEK_SET, SEEK_CUR, SEEK_END
		if ($offset > $this->len)
		{
			// We can't seek beyond our len.
			return false;
		}

		switch ($whence)
		{
			case \SEEK_SET:
				$this->pos = $offset;

				break;

			case \SEEK_CUR:
				if (($this->pos + $offset) > $this->len)
				{
					return false;
				}

				$this->pos += $offset;

				break;

			case \SEEK_END:
				$this->pos = $this->len - $offset;

				break;
		}

		return true;
	}

	/**
	 * Stream flush, always returns true.
	 *
	 * @return  boolean
	 *
	 * @since   1.3.0
	 * @note    Data storage is not supported
	 */
	public function stream_flush()
	{
		// We don't store data.
		return true;
	}
}

if (!stream_wrapper_register('string', '\\Joomla\\Filesystem\\Stream\\StringWrapper'))
{
	die('\\Joomla\\Filesystem\\Stream\\StringWrapper Wrapper Registration Failed');
}
PK     [y͒    
  Stream.phpnu [        <?php
/**
 * Part of the Joomla Framework Filesystem Package
 *
 * @copyright  Copyright (C) 2005 - 2020 Open Source Matters, Inc. 