<?php

namespace Nextend\SmartSlider3Pro\Generator\Joomla\Redshop;

use Nextend\Framework\Filesystem\Filesystem;
use Nextend\SmartSlider3\Generator\AbstractGeneratorGroup;
use Nextend\SmartSlider3\Generator\GeneratorFactory;
use Nextend\SmartSlider3Pro\Generator\Joomla\Redshop\Sources\RedshopProducts;

class GeneratorGroupRedshop extends AbstractGeneratorGroup {

    protected $name = 'redshop';

    protected $url = 'https://extensions.joomla.org/extensions/extension/e-commerce/shopping-cart/redshop/';

    public function getLabel() {
        return 'redSHOP';
    }

    public function getDescription() {
        return sprintf(n2_('Creates slides from %1$s content.'), 'redSHOP');
    }

    public function isInstalled() {
        return Filesystem::existsFile(JPATH_ADMINISTRATOR . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_redshop' . DIRECTORY_SEPARATOR . 'redshop.php');
    }

    protected function loadSources() {
        new RedshopProducts($this, 'products', n2_('Products'));
    }


}

GeneratorFactory::addGenerator(new GeneratorGroupRedshop);
