var jQueryWeb357LoginAsUserHikashop = jQuery.noConflict();
jQueryWeb357LoginAsUserHikashop(function ($) {
    // Users
    $('#hikashop_user_listing')
        .find('tr')
        .each(function () {
            var name = $(this).find('td').eq(3).text();
            var username = $(this).find('td').eq(4).text();
            var email = $(this).find('td').eq(5).text();
            var build_login_as_user_url = login_as_user_url.replace(
                '{{email}}',
                email
            );

            $(this).find('th').eq(5).after('<th>Login as User</th>'); // 5 = the fifth column which is the E-mail table column
            if (name.length > 0 && username.length > 0) {
                $(this)
                    .find('td')
                    .eq(5)
                    .after(
                        '<td><a target="_blank" class="btn" href="' +
                            build_login_as_user_url +
                            '">Login as <span class="loginasuser-username" style="font-weight:bold">' +
                            name +
                            ' (' +
                            username +
                            ')' +
                            '</span></td>'
                    );
            } else {
                $(this).find('td').eq(5).after('<td>No user exists</td>');
            }
        });

    // Orders
    $('#hikashop_order_listing')
        .find('tbody tr')
        .each(function (i) {
            var username = $('td.hikashop_order_customer_value')
                .find('br')
                .get(i).previousSibling.nodeValue;
            var userExists = /[\(\)]/.test(username);

            var email = $('td.hikashop_order_customer_value').find('br').get(i)
                .nextSibling.nodeValue;
            var build_login_as_user_url = login_as_user_url.replace(
                '{{email}}',
                $.trim(email)
            );

            $(this)
                .find('th.hikashop_order_customer_title')
                .after('<th>Login as User</th>'); // 5 = the fifth column which is the E-mail table column

            if (userExists) {
                $(this)
                    .find('td.hikashop_order_customer_value')
                    .after(
                        '<td><a target="_blank" class="btn" href="' +
                            build_login_as_user_url +
                            '">Login as <span class="loginasuser-username" style="font-weight:bold">' +
                            username +
                            '</span></td>'
                    );
            } else {
                $(this)
                    .find('td.hikashop_order_customer_value')
                    .after('<td>No user exists.</td>');
            }
        });
});
