<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Plugin\CMSPlugin;

class plgSystemTicketFromContactForm extends CMSPlugin
{

	public function onAfterRoute()
	{
		$app = JFactory::getApplication();

		if ($app->isClient('administrator'))
		{
			return;
		}

		if (!file_exists(JPATH_ROOT . '/components/com_helpdeskpro/Helper/Helper.php'))
		{
			return;
		}

		$option = $app->input->getCmd('option');
		$task   = $app->input->getCmd('task');
		if ($option == 'com_contact' && $task == 'contact.submit')
		{
			// Bootstrap the component
			require_once JPATH_ADMINISTRATOR . '/components/com_helpdeskpro/init.php';

			// Get component config data
			$config = require JPATH_ADMINISTRATOR . '/components/com_helpdeskpro/config.php';

			// Creating component container, register auto-loader
			$container = OSL\Container\Container::getInstance('com_helpdeskpro', $config);

			$config              = OSSolution\HelpdeskPro\Site\Helper\Helper::getConfig();
			$contactData         = $app->input->get('jform', array(), 'array');
			$data                = array();
			$data['name']        = $contactData['contact_name'];
			$data['email']       = $contactData['contact_email'];
			$data['subject']     = $contactData['contact_subject'];
			$data['message']     = nl2br($contactData['contact_message']);
			$data['category_id'] = $this->params->get('category_id');
			$data['priority_id'] = $config->default_ticket_priority_id;

			if (!empty($data['name']) && !empty($data['email']) && !empty($data['subject']) && !empty($data['message']))
			{
				OSSolution\HelpdeskPro\Site\Helper\Helper::storeTicket($data);
			}
		}
	}
}