<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_notifly
 *
 * @copyright   Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');

JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
JHtml::_('formbehavior.chosen', '.multipleAccessLevels', null, array('placeholder_text_multiple' => JText::_('JOPTION_SELECT_ACCESS')));
JHtml::_('formbehavior.chosen', '.multipleAuthors', null, array('placeholder_text_multiple' => JText::_('JOPTION_SELECT_AUTHOR')));
JHtml::_('formbehavior.chosen', '.multipleCategories', null, array('placeholder_text_multiple' => JText::_('JOPTION_SELECT_CATEGORY')));
JHtml::_('formbehavior.chosen', '.multipleTags', null, array('placeholder_text_multiple' => JText::_('JOPTION_SELECT_TAG')));
JHtml::_('formbehavior.chosen', 'select');

$user      = JFactory::getUser();
$userId    = $user->get('id');
?>

<form action="<?php echo JRoute::_('index.php?option=com_notifly&view=design'); ?>" method="post" name="adminForm" id="adminForm" class="form-horizontal">
	<div id="cf" class="design tx-flex">
		<?php if (!empty( $this->sidebar)) : ?>
		<div class="tx-sidebar">
			<?php echo $this->sidebar; ?>
		</div>
		<div class="tx-main">
		<?php else : ?>
		<div class="tx-main">
		<?php endif; ?>
			<div class="page-header">
			  <h1>Design</h1>
			  <!-- Nav tabs -->
			  <ul class="nav nav-tabs" role="tablist">
			    <li class="active"><a href="#design" aria-controls="home" role="tab" data-toggle="tab">Design</a></li>
			    <!-- <li><a href="#theme" aria-controls="profile" role="tab" data-toggle="tab">Theme</a></li> -->
			  </ul>
			</div>

			<div class="page-content">
				<?php echo NotiflyHelper::showWarning(); ?>
				<div class="tab-content">
					<div class="tab-pane active" id="design">
						<div class="row">
							<div class="col-md-6">
								<div class="panel panel-default">
									<div class="panel-heading">Design</div>
									<div class="panel-body">
										<?php 
										$fieldSets = $this->form->getFieldsets();
										foreach ($fieldSets as $name => $fieldSet) :
											if($name != 'design') continue;
											foreach ($this->form->getFieldset($name) as $field):
									    		echo $field->getControlGroup();
										  	endforeach;
										endforeach;
										 ?>
									</div>
								</div>
							</div>
							<div class="col-md-6">
								<div class="panel panel-default">
									<div class="panel-heading">Behavior</div>
									<div class="panel-body">
										<?php 
										$fieldSets = $this->form->getFieldsets();
										foreach ($fieldSets as $name => $fieldSet) :
											if($name != 'behavior') continue;
											foreach ($this->form->getFieldset($name) as $field):
									    		echo $field->getControlGroup();
										  	endforeach;
										endforeach;
										 ?>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="tab-pane" id="theme">
						<div class="panel panel-default">
							<div class="panel-body">Theme</div>
						</div>
					</div>
				</div>
			</div>

			<input type="hidden" name="id" value="<?php echo $this->component->id; ?>" />
			<input type="hidden" name="option" value="<?php echo $this->component->option; ?>" />
			<input type="hidden" name="view" value="design" />
			<input type="hidden" name="task" value="" />

			<?php echo JHtml::_('form.token'); ?>
		</div>
	</div> <!-- cf end -->
</form>
